

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setEncryptedEntityProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_setEncryptedEntityProp.sp,v $ $Id: QS_setEncryptedEntityProp.sp,v 1.4.48.2 2018/03/22 03:01:48 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_setEncryptedEntityProp <<<'

IF EXISTS (select * from sysobjects where name='QS_setEncryptedEntityProp')
	drop procedure QS_setEncryptedEntityProp
IF EXISTS (select * from GxQscripts where name='QS_setEncryptedEntityProp')
	delete from GxQscripts where name = 'QS_setEncryptedEntityProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setEncryptedEntityProp')
	delete from GXDBVersions where aliasname = 'QS_setEncryptedEntityProp'
GO
print '... Creating Procedure: QS_setEncryptedEntityProp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_setEncryptedEntityProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = '',
  @PARAM3 varchar(1024) = '',
  @PARAM4 varchar(1024) = '',
  @PARAM5 varchar(1024) = ''
AS
Set NOCOUNT ON
/*Input variables*/
 DECLARE @i_Name VARCHAR(512)
 DECLARE @EncryptedString varchar(5000)
 DECLARE @i_Value varchar(1000)
 DECLARE @i_Authenticte INT
 DECLARE @i_EntityType INT
 DECLARE @i_EntityId INT
 /*Locale variables*/
 DECLARE @l_commCellNumber INT
 DECLARE @l_EntityType		INT
 DECLARE @l_EntityId		INT
 DECLARE @DecryptedString varchar(1000)
 DECLARE @ErrorString	VARCHAR(1000) = ''
 DECLARE @ErrorCode		INT = 0
/************Queries to generate Authentication code***************
--please copy this commented code and run in sql studio
 DECLARE @i_Name VARCHAR(512)
 DECLARE @i_Value VARCHAR(1000)
 DECLARE @i_Authenticte INT
 DECLARE @i_EntityType INT = 0
 DECLARE @i_EntityId INT = 0
 DECLARE @l_commCellNumber INT
SELECT @l_commCellNumber = number from APP_CommCell where id = 2
--Auth code to change/insert GxGlobalParam encrypted value (i.e used to generate Authcode).
select
(checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><'+@i_Name+'><'+@i_Value+'><COMMVAULT>')) & 2147483646) + 1
--Auth code to change/insert GxGlobalParam encrypted value (commserve independent authcode)
select
(checksum(HASHBYTES('SHA1','<COMMVAULT><'+@i_Name+'><'+@i_Value+'>')) & 2147483646)
--Auth code to change value for Encrypted properties at Entity Level. (commserve independent authcode)
select
(checksum(HASHBYTES('SHA1','<'+@i_Name
			+'><'+@i_Value
			+'><'+CAST(@i_EntityType AS VARCHAR(100))
			+'><'+CAST(@i_EntityId AS VARCHAR(100))
			+'><COMMVAULT>')) & 2147483646)
--Auth code to change value for Encrypted properties at Entity Level. (commserve dependent authcode).
select
(checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))
								+'><'+@i_Name
								+'><'+@i_Value
								+'><'+CAST(@i_EntityType AS VARCHAR(100))
								+'><'+CAST(@i_EntityId AS VARCHAR(100))
								+'><COMMVAULT>')) & 2147483646)+1
*/
  ---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'setEncryptedEntityProp'
DECLARE @lastError				integer
SET		@lastError				= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
 IF(
	(@PARAM1 = @NoParameter OR @PARAM2 = @NoParameter OR @PARAM3 = @NoParameter) --Requires minimum 3 params
	OR (@PARAM4 <> @NoParameter AND @PARAM5 = @NoParameter)
	OR (@PARAM5 <> @NoParameter AND @PARAM4 = @NoParameter) --Requires both EntityType and EntityId to update entity
   )
 BEGIN
		SET @ErrorString	=	'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
		SET	@ErrorCode		=	1
		GOTO SCRIPT_EXIT
 END
 SELECT @l_commCellNumber = number from APP_CommCell where id = 2
 SET @i_Name = @PARAM1
 SET @i_Value = @PARAM2
SET @i_Authenticte = convert(INT, @PARAM3)
SET @i_EntityType = convert(INT, @PARAM4)
SET @i_EntityId  = convert(INT, @PARAM5)
IF(@i_EntityType = 1)
BEGIN
SET @DecryptedString = CAST(@i_EntityId as VARCHAR) + '_' + @i_Value
END
ELSE
BEGIN
SET @DecryptedString = @i_Value
END
 EXEC pswEncryptionManaged @DecryptedString, @EncryptedString OUTPUT
 IF @EncryptedString IS NULL OR LEN(@EncryptedString) = 0
 BEGIN
	SET @ErrorString	=	'Error: Value Encryption Failed'
	SET	@ErrorCode		=	1
	GOTO SCRIPT_EXIT
 END
/*
 -- Remove comments to test
 SET @PARAM3 = CAST((checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><'+@i_Name+'><'+@i_Value+'><COMMVAULT>')) & 2147483646) AS VARCHAR)
*/
 IF(((@PARAM4 = @NoParameter) AND (@PARAM5 = @NoParameter))
	OR ((@i_EntityType = 0) AND (@i_EntityId = 0)))--Insert New EntityProp or update all columns if property exist already
 BEGIN
	IF( (
			@i_Authenticte = (checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><'+@i_Name+'><'+@i_Value+'><COMMVAULT>')) & 2147483646)  + 1
		)
		OR
		(
			@i_Authenticte = (checksum(HASHBYTES('SHA1','<COMMVAULT><'+@i_Name+'><'+@i_Value+'>')) & 2147483646)
		)
		OR
		(
			@i_Authenticte = (checksum(HASHBYTES('SHA1','<'+@i_Name
			+'><'+@i_Value
			+'><0><0><COMMVAULT>')) & 2147483646)
		)
		OR
		(
			@i_Authenticte = (checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))
								+'><'+@i_Name
								+'><'+@i_Value
								+'><0><0><COMMVAULT>')) & 2147483646)+1
		)
	  )
	BEGIN
		IF NOT EXISTS(SELECT 1
						FROM GxGlobalParam
					  WHERE name = @i_Name
					 )
		BEGIN
			INSERT INTO	GxGlobalParam(name, value, created, modified)
			VALUES(	@i_Name,
					@EncryptedString,
					dbo.getunixtime(GETUTCDATE()),
					0
				)
		END
		ELSE --update row if param already exists
		BEGIN
			UPDATE GxGlobalParam
				SET value		= @EncryptedString,
					modified		= dbo.getunixtime(GETUTCDATE())
			WHERE name = @i_Name
		END
	END
	ELSE --IF Auth code is worng
	BEGIN
		SET @ErrorString	=	'Error: Failed to change/add new param. Wrong auth code supplied'
		SET	@ErrorCode		=	1
	END
	GOTO SCRIPT_EXIT --exit after insertion	or updation of param row
 END
 ELSE IF(@PARAM3 = @NoParameter) --IF Authentication code is not passed
 	BEGIN
		SET @ErrorString	=	'Error: No Authentication code passed'
		SET	@ErrorCode		=	1
		GOTO SCRIPT_EXIT
	END
 ELSE
	BEGIN
		IF(
			(	(checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))
						+'><'+@i_Name
						+'><'+@i_Value
						+'><'+CAST(@i_EntityType AS VARCHAR(100))
						+'><'+CAST(@i_EntityId AS VARCHAR(100))
						+'><COMMVAULT>')) & 2147483646)+1 = @i_Authenticte
			)	OR
			(	(checksum(HASHBYTES('SHA1','<'+@i_Name
						+'><'+@i_Value
						+'><'+CAST(@i_EntityType AS VARCHAR(100))
						+'><'+CAST(@i_EntityId AS VARCHAR(100))
						+'><COMMVAULT>')) & 2147483646) = @i_Authenticte
			)
		)
		BEGIN
			IF  (@i_EntityType = 1 AND @i_Name = 'SubclientExtensionTimeStamp')
			BEGIN
			--Update value for archGroup
			UPDATE archGroup
			SET SubclientExtensionTimeStampEncrypted = @EncryptedString
			WHERE id = @i_EntityId
			END
			ELSE --Add else ifs here if we want for other entities
			BEGIN
			SET @ErrorString	=	'Error: Unsupported Entity Type. Only Entity Type 1 (archGroup) is supported.'
			SET	@ErrorCode		=	1
			END
			GOTO SCRIPT_EXIT
		END
		ELSE
		BEGIN
		SET @ErrorString	=	'Error: Incorrect Authentication code passed '
		SET	@ErrorCode		=	1
		GOTO SCRIPT_EXIT
		END
	END
SCRIPT_EXIT:
if @ErrorCode <> 0
	Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
else
	exec MMS2SyncDDBConfigValues
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_setEncryptedEntityProp')
	delete from GxQscripts where name = 'QS_setEncryptedEntityProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setEncryptedEntityProp')
	delete from GXDBVersions where aliasname = 'QS_setEncryptedEntityProp'
GO

insert into GXDBVersions values(2, 'QS_setEncryptedEntityProp',  '00010004004800020000', 'QS_setEncryptedEntityProp', '00010004004800020000')
GO

insert into GxQscripts values(2,'QS_setEncryptedEntityProp',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		With AuthCode for any entity:-'
 + CHAR(10) + '-- 			qoperation execscript -sn setEncryptedEntityProp -si <PARAM_NAME> -si <VALUE> -si <authentication_code> '
 + CHAR(10) + '-- 		Change encrypted value for specific entity (Authentication code required) :-'
 + CHAR(10) + '-- 			qoperation execscript -sn setEncryptedEntityProp -si <PARAM_NAME> -si <VALUE> -si <authentication_code> -si <EntityType> -si <EntityId>'
)
GO

