

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setClientLimit.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_setClientLimit')
BEGIN
	print '>>> Drop Stored Procedure: QS_setClientLimit <<<'
	drop procedure QS_setClientLimit
END
IF EXISTS (select * from GxQscripts where name='QS_setClientLimit')
	delete from GxQscripts where name = 'QS_setClientLimit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setClientLimit')
	delete from GXDBVersions where aliasname = 'QS_setClientLimit'
GO
print '... Creating Procedure: QS_setClientLimit'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_setClientLimit
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @AuthenticationCode int,
  @CommCellId int,
  @ClientLimit int,
  @ForceUpdate int=0
AS
Set NOCOUNT ON
/*Input variables*/
 DECLARE @i_CommCellId INT
 DECLARE @i_ClientLimit INT
 DECLARE @i_Authentcode INT
 DECLARE @i_ForceUpdate INT
 /*LocalVariable*/
 DECLARE @l_commCellNumber INT
 DECLARE @i_ExistingClientLimit INT =0
 DECLARE @ErrorNumber     INTEGER = 0
 DECLARE @ErrorMessage    NVARCHAR(MAX) = N''
 DECLARE @scriptName NVARCHAR(50)
 SET     @scriptName = N'QS_SetClientLimit'
 SELECT @l_commCellNumber = number from APP_CommCell where id = 2
 SELECT @i_ExistingClientLimit = CAST(CAST(value AS nvarchar(MAX)) AS int) from GXGlobalParam where name = '16777216'
 SET @i_CommCellId 	=  @CommCellId
 SET @i_ClientLimit =  @ClientLimit
 SET @i_Authentcode =  @AuthenticationCode
 SET @i_ForceUpdate =  @ForceUpdate
 /******** Validation start **********************/
 /* Validation for the CommCellId..*/
 IF	(@l_commCellNumber != @i_CommCellId)
 BEGIN
		SET @ErrorNumber = 1
		SET @ErrorMessage ='Incorrect CommCell ID.'
 END
 /*Validation for the Enterprise CS.. */
 IF NOT EXISTS (select * from LicCSL L JOIN simOEM O ON O.OEMId = L.OemId and O.ExpressFlag = 0)
 BEGIN
		SET @ErrorNumber = 1
		if (@ErrorMessage!='')
			SET @ErrorMessage = @ErrorMessage + ', Client Limit can be updated only for enterprise OEM.'
		ELSE
			SET @ErrorMessage = 'Client Limit can be updated for only for enterprise OEM.'
 END
 /* Validation for the AuthCode */
 IF(	(   (checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))
								+'><'+CAST(@i_ClientLimit AS VARCHAR(100))
								+'><COMMVAULT>')) & 2147483646)+1 != @i_Authentcode
		)
	)
BEGIN
		SET @ErrorNumber = 1
		if (@ErrorMessage!='')
			SET @ErrorMessage = @ErrorMessage + ', Incorrect Authentication code'
		ELSE
			SET @ErrorMessage = 'Incorrect Authentication code.'
END
/* If sp input validation failed return the error..*/
IF (@ErrorNumber >0)
	GOTO QS_ERROR
/* If input validation succeed then check the DB validation.*/
/* Check the existing client limit with the new client limit if matchs no need to update.*/
IF (@i_ExistingClientLimit = @i_ClientLimit)
BEGIN
	SET @ErrorNumber = 1
	SET @ErrorMessage = 'Existing client limit is same as new client limit.'
END
/* If the existing client limit greater then the new new client limit needs to be forece update. should expect force update param.*/
IF ((@i_ExistingClientLimit > @i_ClientLimit) and (@i_ForceUpdate <= 0))
BEGIN
	SET @ErrorNumber = 1
	SET @ErrorMessage = 'Existing client limit is greater than the new client limit. If you want to override the exising client limit please execute the script with  ForceUpdate= 1'
END
/* If validation failed return*/
IF (@ErrorNumber >0)
	GOTO QS_ERROR
/******** Validation end **********************/
if (@i_ExistingClientLimit >0)
	UPDATE GXGlobalParam SET value = CAST(@i_ClientLimit AS nvarchar(MAX)) where name = '16777216'
else
	INSERT INTO GXGlobalParam(name,value,created,modified) VALUES ('16777216', CAST(@i_ClientLimit AS nvarchar(MAX)),dbo.GetUNIXTime(GetDate()),0)
IF (@@ERROR >0)
	BEGIN
		SET @ErrorNumber =1
		SET @ErrorMessage = N'Error in updating client limit: ['+ CAST(@i_ClientLimit AS nvarchar(MAX))  + ']'
		GOTO    QS_ERROR
	END
ELSE
	BEGIN
		SET @ErrorMessage  ='Updated client limit with ' + CAST(@i_ClientLimit AS nvarchar(MAX))
		GOTO QS_ERROR
END
-- clear cached client responses which are failed with client limit error so that those saved requests can be reprocessed
CREATE TABLE #tempXMLRequest (t_id int , t_responseXML XML, t_errorCode BIGINT, t_errorStr VARCHAR(MAX))
CREATE CLUSTERED INDEX t_Id_Idx ON #tempXMLRequest(t_id)
INSERT INTO #tempXMLRequest
SELECT	id, xmlResponse , 0, ''
FROM	simxmlrequest (NOLOCK)
WHERE	clientID = 0 and xmlResponse is NOT NULL
;WITH ListOfRequestXML AS
(	SELECT
		ReqId = t_id, errorCode = XProp.value('@ErrorCode', 'BIGINT'), errorStr = ISNULL(XProp.value('@ErrorString', 'VARCHAR(MAX)'), '')
    	FROM
		( SELECT t_id, t_responseXML FROM #tempXMLRequest) T
    	CROSS APPLY
		T.t_responseXML.nodes('CVInstallManager_ClientSetup/clientComposition/clientError') AS XTbl(XProp)
)
UPDATE #tempXMLRequest
SET t_errorCode = errorCode, t_errorStr = errorStr
FROM ListOfRequestXML T
WHERE t_id = T.ReqId
DELETE SImXMLRequest where id in (select t_id from #tempXMLRequest where t_errorCode = 16777625)
drop table #tempXMLRequest
QS_ERROR:
	PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + ' with Parameters:[' + cast(@AuthenticationCode as nvarchar(MAX))  + ', ' + cast(@CommCellId as varchar(max)) + ', '+ cast(@ClientLimit as varchar(max)) + ',' + cast(@ForceUpdate as varchar(max)) + ' ].'
    IF @ErrorNumber =0
		PRINT  @ErrorMessage
	IF @ErrorNumber <> 0
		Raiserror(@ErrorMessage,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_setClientLimit')
	delete from GxQscripts where name = 'QS_setClientLimit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setClientLimit')
	delete from GXDBVersions where aliasname = 'QS_setClientLimit'
GO

insert into GXDBVersions values(2, 'QS_setClientLimit',  '00000000000000000000', 'QS_setClientLimit', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_setClientLimit',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '		With AuthCode:-
'
 + CHAR(10) + '		qoperation execscript -sn setClientLimit -si <AuthenticationCode> -si <CommCellId> -si <ClientLimit> -si <ForceUpdate> 
'
 + CHAR(10) + '
'
 + CHAR(10) + '        Example: qoperation execscript -sn setClientLimit -si 1234567890 -si 6543214 -si 4000 -si 1
'
 + CHAR(10) + '
'
 + CHAR(10) + '		qoperation execscript -sn setClientLimit -si <AuthenticationCode> -si <CommCellId> -si <ClientLimit> 
'
 + CHAR(10) + '
'
 + CHAR(10) + '        Example: qoperation execscript -sn setClientLimit -si 1234567890 -si 6543214 -si 4000
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --    AuthenticationCode      - AuthenticationCode
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --    CommCellId      		- CommCell Id
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --    ClientLimit      		- ClientLimit 
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --    ForceUpdate				- ForceUpdate (optional)
'
)
GO

