

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setCleaningMediaReuseNumber.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_setCleaningMediaReuseNumber <<<'

IF EXISTS (select * from sysobjects where name='QS_setCleaningMediaReuseNumber')
	drop procedure QS_setCleaningMediaReuseNumber
IF EXISTS (select * from GxQscripts where name='QS_setCleaningMediaReuseNumber')
	delete from GxQscripts where name = 'QS_setCleaningMediaReuseNumber'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setCleaningMediaReuseNumber')
	delete from GXDBVersions where aliasname = 'QS_setCleaningMediaReuseNumber'
GO
print '... Creating Procedure: QS_setCleaningMediaReuseNumber'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_setCleaningMediaReuseNumber
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
--Stored procedure inputs
  @barcode varchar(256) = '',
  @reuseNumber int = -1
AS
SET NOCOUNT ON
set @barcode=LTRIM(RTRIM(@barcode))
declare @mediatypeid int
declare @errCode int=0
declare @errStr varchar(100)=''
if ((@barcode='') or (@reuseNumber < 0))
BEGIN
	set @errStr= 'Incorrect usage. Please provide Barcode and usage count'
	set @errCode=-1
	GOTO ERROR_EXIT
END
ELSE
BEGIN
	select @mediatypeid=mm.MediaTypeId
	from MMMedia mm,MMMediaSide ms,MMMediaType mt
	where mm.MediaId=ms.mediaid
	and mm.MediaTypeId=mt.MediaTypeId
	and mm.BarCode=@barcode
	IF(@mediatypeid is null)
	BEGIN
		set @errStr='No media found with this Barcode'
		set @errCode=-1
		GOTO ERROR_EXIT
	END
	ELSE
	BEGIN
		if @mediatypeid in (select mediatypeid from mmmediatype where iscleaningmedia=1)
		BEGIN
			update ms
			set ms.numberofreuses=@reuseNumber
			from mmmedia mm,MMMediaSide ms
			where mm.MediaId=ms.MediaId
			and mm.barcode=@barcode
			set @errCode=@@ERROR
			GOTO ERROR_EXIT
		END
		ELSE
			set @errStr= 'This is not a cleaning media'
			set @errCode=-1
			GOTO ERROR_EXIT
		END
	END
ERROR_EXIT:
IF @errCode= 0
	print 'Script to set cleaning media reuse count executed Successfully'
if @errCode <> 0
	Raiserror(@errStr,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_setCleaningMediaReuseNumber')
	delete from GxQscripts where name = 'QS_setCleaningMediaReuseNumber'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setCleaningMediaReuseNumber')
	delete from GXDBVersions where aliasname = 'QS_setCleaningMediaReuseNumber'
GO

insert into GXDBVersions values(2, 'QS_setCleaningMediaReuseNumber',  '00000000000000000000', 'QS_setCleaningMediaReuseNumber', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_setCleaningMediaReuseNumber',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '--   qoperation execscript -sn QS_setCleaningMediaReuseNumber -si <Media_Barcode> -si <Usage_Count>'
)
GO

