

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setAlertSNMPnotification.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_setAlertSNMPnotification <<<'

IF EXISTS (select * from sysobjects where name='QS_setAlertSNMPnotification')
	drop procedure QS_setAlertSNMPnotification
IF EXISTS (select * from GxQscripts where name='QS_setAlertSNMPnotification')
	delete from GxQscripts where name = 'QS_setAlertSNMPnotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setAlertSNMPnotification')
	delete from GXDBVersions where aliasname = 'QS_setAlertSNMPnotification'
GO
print '... Creating Procedure: QS_setAlertSNMPnotification'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_setAlertSNMPnotification
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @ACTION varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER (DELETE IF NOT NEEDED)				 --
-------------------------------------------
--DECLARE @ACTION     	varchar(512)
--SET @ACTION = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'setAlertSNMPnotification'
DECLARE @NT_ALERTTYPE_SRM_ADVISORY		integer
SET     @NT_ALERTTYPE_SRM_ADVISORY		= 49
DECLARE @NT_SNMP_ALERTNOTIF			    integer
SET     @NT_SNMP_ALERTNOTIF				= 4
--DECLARE @SC_STATUS_BITS        integer
--SET		@SC_STATUS_BITS        =  2+4+16					-- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DUMMY
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
--DECLARE @appTypeId				integer
--DECLARE @instanceId				integer
--DECLARE @backupSetId			integer
--DECLARE	@subClientId			integer
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @ACTION =  'enable'
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF @ACTION = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter not specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
------------------------------------------------
--- CHECK IF A PROPER REQUEST WAS MADE		 ---
------------------------------------------------
IF @ACTION <> 'enable' AND @ACTION <> 'disable'							-- Case Insensitive Check
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter specified incorrectly as ['+@action +'].'
	SET @lastError = 1
	GOTO   ARGS_ERROR
END
-- DONE PROCESSING CMD ARGS, START THINGS GOING: ------
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameter: @ACTION = ['
         + @ACTION
         + ']'
BEGIN TRAN
--
IF @ACTION = 'disable'
BEGIN
	UPDATE NTnotificationRule SET NotifType = NotifType & ~@NT_SNMP_ALERTNOTIF
	SET @lastError = @@error
	GOTO ALL_DONE
END
ELSE
BEGIN
	--------------------------------------------------------------------------
	-- ENABLE THE SNMP TRAP NOTIFICATION :									--
	--------------------------------------------------------------------------
	UPDATE NTnotificationRule SET NotifType = NotifType | @NT_SNMP_ALERTNOTIF
		WHERE alertTypeid <> @NT_ALERTTYPE_SRM_ADVISORY
	SET @lastError = @@error
	IF @lastError <> 0
		GOTO ALL_DONE
	--------------------------------------------------------------------------
	-- IF We are adding SNMP For the 1st Time, then There won't 00 be		--
	-- format strings in NTmessageFormat.  We will have to add them now		--
	--------------------------------------------------------------------------
--  THIS IS FOR ALL ALERT TYPES, THE NON-ESCALATED CASE:
	INSERT NTMessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage, SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen,
								mfOptions, baseDir, userName, password, rssID)
		SELECT  NRULE.id, TEMPLATE.messageType, 1, TEMPLATE.defaultFormatString, '', 0, 0, 0, 0,
								0, N'', N'', N'', 0
		FROM NTNotificationRule as NRULE, NTnotificationTemplate as TEMPLATE
		WHERE NRULE.alertTypeId = TEMPLATE.NTalertTypeId
		  AND NRULE.locale     = TEMPLATE.locale
		  AND TEMPLATE.messageType = @NT_SNMP_ALERTNOTIF
		  AND NOT EXISTS (Select * from NTMessageFormat where NTnotificationId = NRULE.id AND messageType = @NT_SNMP_ALERTNOTIF AND escalationLevel = 1)
	SET @lastError = @@error
	IF @lastError <> 0
		GOTO ALL_DONE
--	THIS IS FOR !ONLY! THOSE ALERT TYPES THAT CAN BE ESCALATED:
	INSERT NTMessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage, SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen,
								mfOptions, baseDir, userName, password, rssID)
		SELECT  NRULE.id, TEMPLATE.messageType, 2, TEMPLATE.defaultFormatString, '', 0, 0, 0, 0,
								0, N'', N'', N'', 0
		FROM NTNotificationRule as NRULE, NTnotificationTemplate as TEMPLATE
		WHERE NRULE.alertTypeId = TEMPLATE.NTalertTypeId
		  AND NRULE.locale     = TEMPLATE.locale
		  AND TEMPLATE.messageType = @NT_SNMP_ALERTNOTIF
		  AND EXISTS (Select * from NTavailcriteria WHERE alertTypeId = TEMPLATE.NTalertTypeId and escReportingOptions <> 0)
		  AND NOT EXISTS (Select * from NTMessageFormat where NTnotificationId = NRULE.id AND messageType = @NT_SNMP_ALERTNOTIF AND escalationLevel = 2)
	SET @lastError = @@error
	IF @lastError <> 0
		GOTO ALL_DONE
END
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
/* Following Lines were used for debugging:
select * from NTnotificationRule Where alertTypeid <> @NT_ALERTTYPE_SRM_ADVISORY
select * from NTMessageFormat WHERE messageType in (1,4)
	order by NTnotificationId, messageType
*/
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: PARAM_01 = ['
         + @ACTION
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_setAlertSNMPnotification')
	delete from GxQscripts where name = 'QS_setAlertSNMPnotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setAlertSNMPnotification')
	delete from GXDBVersions where aliasname = 'QS_setAlertSNMPnotification'
GO

insert into GXDBVersions values(2, 'QS_setAlertSNMPnotification',  '00000000000000000000', 'QS_setAlertSNMPnotification', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_setAlertSNMPnotification',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qscript -f setAlertSNMPnotification.sql -i enable | disable 
'
 + CHAR(10) + '--   script_name : setAlertSNMPnotification'
)
GO

