

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_sealAllActiveStores.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_sealAllActiveStores')
BEGIN
	print '>>> Drop Stored Procedure: QS_sealAllActiveStores <<<'
	drop procedure QS_sealAllActiveStores
END
IF EXISTS (select * from GxQscripts where name='QS_sealAllActiveStores')
	delete from GxQscripts where name = 'QS_sealAllActiveStores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_sealAllActiveStores')
	delete from GXDBVersions where aliasname = 'QS_sealAllActiveStores'
GO
print '... Creating Procedure: QS_sealAllActiveStores'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_sealAllActiveStores
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
AS
DECLARE @lastError	integer
DECLARE @errorString	varchar(512)
SET		@errorString	='Error Encountered when running script.'
DECLARE @dummySelectTable TABLE
								(
										errorNo				INTEGER,
										newSidbStoreId		INTEGER,
										newSidbStoreName		varchar(256),
										oldSidbStoreId	INTEGER,
										oldSidbStoreName		varchar(256),
										hasPartialAf 	INTEGER,
										sealereason			INTEGER
								)
set @lastError=0
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
if exists (select * from archGroupCopy AGC where ((AGC.dedupeFlags & 262144) > 0))
BEGIN
	insert into @dummySelectTable EXEC archCopyStartNewSIDBStore 0,3
	set @lastError=isnull((select top 1 errorNo from @dummySelectTable where errorNo < 0),0)
END
ELSE
	set @lastError=0
GOTO SCRIPT_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @errorString = 'Failed to seal store. ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE: '+ERROR_MESSAGE()
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@errorString,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
		SELECT 'seal all active stores operation  failed'
	END
	ELSE
	BEGIN
		COMMIT TRAN
		SELECT 'Successful'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_sealAllActiveStores')
	delete from GxQscripts where name = 'QS_sealAllActiveStores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_sealAllActiveStores')
	delete from GXDBVersions where aliasname = 'QS_sealAllActiveStores'
GO

insert into GXDBVersions values(2, 'QS_sealAllActiveStores',  '00000000000000000000', 'QS_sealAllActiveStores', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_sealAllActiveStores',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn QS_sealAllActiveStores  '
)
GO

