

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_scalereport_mounts_streams_reservations_perma.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_scalereport_mounts_streams_reservations_perma.sp,v $ $Id: QS_scalereport_mounts_streams_reservations_perma.sp,v 1.3.272.2 2018/03/20 00:15:06 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_scalereport_mounts_streams_reservations_perma <<<'

IF EXISTS (select * from sysobjects where name='QS_scalereport_mounts_streams_reservations_perma')
	drop procedure QS_scalereport_mounts_streams_reservations_perma
IF EXISTS (select * from GxQscripts where name='QS_scalereport_mounts_streams_reservations_perma')
	delete from GxQscripts where name = 'QS_scalereport_mounts_streams_reservations_perma'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_mounts_streams_reservations_perma')
	delete from GXDBVersions where aliasname = 'QS_scalereport_mounts_streams_reservations_perma'
GO
print '... Creating Procedure: QS_scalereport_mounts_streams_reservations_perma'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_scalereport_mounts_streams_reservations_perma
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
AS
SET NOCOUNT ON
CREATE TABLE #perMA ( MediaAgent VARCHAR(50),
					 average_no_of_mounts_hr FLOAT(5), average_no_of_mounts_per24hr FLOAT(5),
					 Max_streams_perhr FLOAT(5),Max_streams_per24hr FLOAT(5),
					 Reservations_hr FLOAT(5),Reservations_24hr FLOAT(5)
				   )
DECLARE @CUR_TIME INT
SET @CUR_TIME = dbo.GetUnixTime(GetUTCDate())
/*
  Report Format:
  ---------------------------------------------------------------------------------------
		MAgent, AMnts/h, AMnts/h, MxStms/h, MxStms/h, Res/h, Res/h
 ----------------------------------------------------------------------------------------
*/
/*************************** C.  No. of mounts/hour per commcell ************************
*
*		The table MMDriveHistory contains the number of times a drive has been mounted.
*		Using the above table this query gives the overall count of mounts  per hour
*		extended over a period of the last one hour and twenty four hours.
*
****************************************************************************************/
/**************** D.	Highest number of streams transferring data *********************
*
*		A data stream can be defined  as a data channel that connects the client file
*		system or database to the storage media. Multiple streams provide for multiple
*		channels through which data can flow.
*
*		In this query first we identify the count of distinct stream ids in an interval
*		of five minutes extending over a period of one hour. Then we indetify the maximum
*		of those counts to get the desired output.
*
*		The same procedure is repeated to find the maximum during the last twenty four
*		hours within the intervals of one hour duration instead of five minutes.
*
*****************************************************************************************/
/********************** E. Number of Reservations per hour ******************************
*
*		Reservation Time is the time between a job phase starts and acquires resources.
*
****************************************************************************************/
INSERT INTO #perMA
SELECT DISTINCT COALESCE(C.MediaAgent,D.MediaAgent,E.MediaAgent),
	   C.mounts_hr,C.mounts_24hr,
	   D.max_streamshr,D.max_streams24hr,
	   E.reservations_hr,E.reservations_24hr
FROM
(
/*** This gives the count of number of mounts in the last one and twenty four hours ****/
	SELECT query2.MediaAgent AS MediaAgent,query1.mounts_hr AS mounts_hr,query2.mounts_24hr AS mounts_24hr
	FROM
	(
		SELECT ac.name AS MediaAgent,SUM(NumberOfMounts)/1.0 AS mounts_hr
		FROM MMDriveHistory d,App_Client ac WITH (READUNCOMMITTED)
		WHERE (@CUR_TIME-dbo.GetUnixTime(TimeStart))<60*60 AND d.ClientId = ac.id
		GROUP BY ac.name
	)query1 RIGHT JOIN
	(
		SELECT ac.name as MediaAgent,SUM(NumberOfMounts)/24.0 AS mounts_24hr
		FROM MMDriveHistory d,App_Client ac  WITH (READUNCOMMITTED)
		WHERE (@CUR_TIME-dbo.GetUnixTime(TimeStart))<24*60*60 and d.ClientId = ac.id
		GROUP BY ac.name
	)query2 ON query1.MediaAgent = query2.MediaAgent
)C  FULL OUTER JOIN
(
/****************** To obtain the maximum number of streams transferred ****************/
	SELECT MAX(isnull(query1.counthr_ids,0))as max_streamshr,MAX(isnull(query.counthr_ids,0)) AS max_streams24hr,query.MediaAgent AS MediaAgent
	FROM
	(
		SELECT RMTimeStamp/300 AS times,COUNT(DISTINCT h.StreamId) AS counthr_ids,a.Name AS MediaAgent
		FROM jmjobresourcehistory AS h,app_client AS a
		WHERE ((@CUR_TIME-RMTimeStamp) <24*60*60) AND h.clientId = a.Id
		GROUP BY a.Name,RMTimeStamp/300
	) query LEFT JOIN
	(
		SELECT RMTimeStamp/300 AS times,COUNT(distinct h.StreamId) AS counthr_ids,a.Name AS MediaAgent
		FROM jmjobresourcehistory  AS h,app_client AS a  WITH (READUNCOMMITTED)
		WHERE ((@CUR_TIME-RMTimeStamp) <60*60) AND h.clientId = a.Id
		GROUP BY a.Name,RMTimeStamp/300
	)query1 ON query.MediaAgent = query1.MediaAgent
	GROUP BY query.MediaAgent
)D ON C.MediaAgent = D.MediaAgent FULL OUTER JOIN
(
	/****** This query helps in obtaining the the number of reservations in per MA *****/
	SELECT query3.MediaAgent, query2.noofreservations_hr AS reservations_hr, query3.noofreservations_24hr AS reservations_24hr
	FROM
	(
		SELECT a.Name AS MediaAgent,query.noofreservations_hr AS noofreservations_hr
		FROM
		(
			SELECT clientid,COUNT(*) AS noofreservations_hr
			FROM jmjobresourcehistory
			WHERE((@CUR_TIME-ReservationTime)<60*60)
			GROUP BY clientid
		)query,app_client a  WITH (READUNCOMMITTED)
		WHERE a.id = query.clientId
	)query2 RIGHT JOIN
	(
		SELECT a.Name AS MediaAgent,query.noofreservations_24hr AS noofreservations_24hr
		FROM
		(
			SELECT clientid,COUNT(*)/24.0 AS noofreservations_24hr
			FROM jmjobresourcehistory
			WHERE((@CUR_TIME-ReservationTime)<24*60*60)
			GROUP BY clientid
		)query,app_client a  WITH (READUNCOMMITTED)
		where a.id = query.clientId
	) query3 ON query2.MediaAgent = query3.MediaAgent
)E ON E.MediaAgent = D.MediaAgent
ORDER BY  COALESCE(C.MediaAgent,D.MediaAgent,E.MediaAgent)
/******************************** GENERAL REMARKS: **************************************
*
*		In the above script we have used the LEFT and RIGHT joins to combine tables in
*		which there may be chances of the first table to be empty in case of LEFT JOIN
*		and the second TABLE may be empty for RIGHT JOIN cases. The FULL OUTER JOINS are
*		used when there may be chances that any or both the tables can empty.
*
***************************************************************************************/
DECLARE @MA VARCHAR(50)
DECLARE @AMNTHR FLOAT(5)
DECLARE @AMNT24HR FLOAT(5)
DECLARE @MSTRHR FLOAT(5)
DECLARE @MSTR24HR FLOAT(5)
DECLARE @RHR FLOAT(5)
DECLARE @R24HR FLOAT(5)
DECLARE TableCursor CURSOR FOR
SELECT * FROM #perma;
PRINT 'Name'+char(9)+'1hour'+char(9)+'24hours'+char(9)+'1hour'+char(9)+char(9)+'24hours'+char(9)+char(9)+'1hour'+char(9)+'24hours'
PRINT ' '
PRINT 'MAgent'+char(9)+'Mnts/h'+char(9)+'Mnts/h'+char(9)+'MxStms/h'+char(9)+'MxStms/h'+char(9)+'Res/h'+char(9)+'Res/h'
OPEN TableCursor
FETCH NEXT FROM TableCursor INTO @MA,@AMNTHR, @AMNT24HR, @MSTRHR,@MSTR24HR,@RHR,@R24HR
WHILE @@FETCH_STATUS = 0
BEGIN
--CAST( convert(float,round(ISNULL(@TBHR,0),2)) AS VARCHAR)
PRINT @MA +char(9)+CAST( convert(float,round(ISNULL(@AMNTHR,0),2)) AS VARCHAR) +char(9)+CAST( convert(float,round(ISNULL(@AMNT24HR,0),2)) AS VARCHAR)+char(9)+CAST( convert(float,round(ISNULL(@MSTRHR,0),2)) AS VARCHAR) +char(9)+char(9)+CAST( convert(float,round(ISNULL(@MSTR24HR,0),2)) AS VARCHAR)+char(9)+char(9)+CAST( convert(float,round(ISNULL(@RHR,0),2)) AS VARCHAR)+char(9)+CAST( convert(float,round(ISNULL(@R24HR,0),2)) AS VARCHAR)
FETCH NEXT FROM TableCursor INTO @MA,@AMNTHR, @AMNT24HR, @MSTRHR,@MSTR24HR,@RHR,@R24HR
END
CLOSE TableCursor
DEALLOCATE TableCursor
/***************************************************************************************/
--SELECT * FROM perma;
DROP TABLE #perma;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_scalereport_mounts_streams_reservations_perma')
	delete from GxQscripts where name = 'QS_scalereport_mounts_streams_reservations_perma'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_mounts_streams_reservations_perma')
	delete from GXDBVersions where aliasname = 'QS_scalereport_mounts_streams_reservations_perma'
GO

insert into GXDBVersions values(2, 'QS_scalereport_mounts_streams_reservations_perma',  '00010003027200020000', 'QS_scalereport_mounts_streams_reservations_perma', '00010003027200020000')
GO

insert into GxQscripts values(2,'QS_scalereport_mounts_streams_reservations_perma',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		QOperation execscript -sn scalereport_commcell_status.sql'
)
GO

