

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_scalereport_drive_usage_throughput_perdrive.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_scalereport_drive_usage_throughput_perdrive.sp,v $ $Id: QS_scalereport_drive_usage_throughput_perdrive.sp,v 1.2.200.3 2018/03/20 00:18:24 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_scalereport_drive_usage_throughput_perdrive <<<'

IF EXISTS (select * from sysobjects where name='QS_scalereport_drive_usage_throughput_perdrive')
	drop procedure QS_scalereport_drive_usage_throughput_perdrive
IF EXISTS (select * from GxQscripts where name='QS_scalereport_drive_usage_throughput_perdrive')
	delete from GxQscripts where name = 'QS_scalereport_drive_usage_throughput_perdrive'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_drive_usage_throughput_perdrive')
	delete from GXDBVersions where aliasname = 'QS_scalereport_drive_usage_throughput_perdrive'
GO
print '... Creating Procedure: QS_scalereport_drive_usage_throughput_perdrive'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_scalereport_drive_usage_throughput_perdrive
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
AS
SET NOCOUNT ON;
CREATE TABLE #perDrive ( LibraryName VARCHAR(50),
						DriveName  VARCHAR(50),
					    DriveUsage_hr FLOAT(53),
						DriveUsage_24hr FLOAT(53),
						ThroughputGB_hr FLOAT(53),
						ThroughputGB_24hr FLOAT(53))
DECLARE @CUR_TIME INT
SET @CUR_TIME = dbo.GetUnixTime(GetUTCDate())
/*
  Report Format:
  ---------------------------------------------------------------------------------------
		LibraryName, DriveName, DriveUsage_hr, DriveUsage_24hr,
		ThroughputGB_hr, ThroughputGB_24hr
  ---------------------------------------------------------------------------------------
*/
/********************************** Drive Usage Per Hour ********************************
*
*		The drive usage is given by the amount of time a drive is used for either
*		writing or for reading purposes. These details can be obtained from the
*		MMDriveHistory table. The time at which a write or a read operation has
*		started is given by TimeStart column. Hence we can obtain the amount of time
*		a drive is in use by summing up the DataWriteDurationSec+DataReadDurationSec
*		grouping by the DriveId. Using the above sum we can find the percentage of
*		time the drive is in use over one hour and twenty four hours duration.
*
****************************************************************************************/
/************************* Throughput of the Drive in GB/Hr *****************************
*
*		The throughput of a drive is calculated based on the amount of data has been
*		read or written to a drive in an hour. The columns DataWritten and DataRead in
*		the same table as above gives the required data. This sum DataWritten+DataRead
*		is again averaged for the last one hour and for twenty four hours.
*
****************************************************************************************/
INSERT INTO #perDrive
SELECT 	COALESCE(A.LibName,B.LibName),
        COALESCE(A.DrName,B.DrName),
		A.usage_hr,A.usage_24hr,
		B.Throughput_per_hr,B.Throughput_per_24hr
FROM
(
/***** This query give percentage of drive usage per hour and for twenty four hours ****/
	SELECT l.LibraryName AS LibName,d.DriveName AS DrName,
		   query3.id AS DriveId,query3.per_usage AS usage_24hr,
		   query4.per_usage AS usage_hr
	FROM
	(
		SELECT query1.DId AS id,
			   (query1.usage*100.0)/(24*3600) AS per_usage
		FROM
		(
			SELECT h.DriveId AS Did,
				   SUM(cast(DataWriteDurationSec as bigint) + cast(DataReadDurationSec as bigint)) AS usage
			FROM MMDriveHistory h
			WHERE (( @CUR_TIME-dbo.GetUnixTime(TimeStart)) < 24*60*60)
			GROUP BY h.DriveId
		) query1, MMDrive d WITH (READUNCOMMITTED)
		WHERE query1.DId = d.DriveId
	)query3 LEFT JOIN
	(
		SELECT query2.DId AS id,
			   (query2.usage*100.0)/3600 AS per_usage
		FROM
		(
			SELECT h.DriveId AS Did,
					SUM(cast(DataWriteDurationSec as bigint) + cast(DataReadDurationSec as bigint)) AS usage
			FROM MMDriveHistory h
			WHERE (( @CUR_TIME-dbo.GetUnixTime(TimeStart)) < 60*60)
			GROUP BY h.DriveId
		) query2, MMDrive d WITH (READUNCOMMITTED)
		WHERE query2.DId = d.DriveId
	)query4 ON query3.id = query4.id,MMDrive d WITH (READUNCOMMITTED),MMMasterPool m WITH (READUNCOMMITTED),MMLibrary l WITH (READUNCOMMITTED)
	WHERE query3.id = d.DriveId AND d.MasterPoolid = m.MasterPoolId AND m.Libraryid = l.LibraryId
)A FULL OUTER JOIN
(
/************ This gives the throughput of the drive in Giga Bytes Per Hour ************/
	SELECT l.LibraryName AS LibName,d.DriveName AS DrName, query3.Drid AS DriveId,
		   query3.Throughput AS Throughput_per_24hr,
		   query4.Throughput AS Throughput_per_hr
	FROM
	(
		SELECT query1.Did AS Drid, (query1.total/(1024.0*24)) AS Throughput
		FROM
		(
			SELECT Driveid AS Did ,SUM(DataWritten+DataRead) AS total
			FROM mmdrivehistory
			WHERE (( @CUR_TIME-dbo.GetUnixTime(TimeStart))< 24*60*60)
			GROUP BY driveId
		)query1, MMDrive d WITH (READUNCOMMITTED)
		WHERE query1.Did = d.DriveId
	) query3 LEFT JOIN
	(
		SELECT query2.Did AS Drid, (query2.total/1024.0) AS Throughput
		FROM
		(
			SELECT Driveid AS Did,SUM(DataWritten+DataRead) AS total
			FROM mmdrivehistory
			WHERE (( @CUR_TIME-dbo.GetUnixTime(TimeStart))< 60*60)
			GROUP BY driveId
		) query2, MMDrive d WITH (READUNCOMMITTED)
		WHERE query2.Did = d.DriveId
	)query4 ON query3.Drid = query4.Drid ,MMDrive d WITH (READUNCOMMITTED),MMMasterPool m WITH (READUNCOMMITTED),MMLibrary l WITH (READUNCOMMITTED)
	WHERE d.DriveId =query3.Drid  AND d.MasterPoolid = m.MasterPoolId AND m.Libraryid = l.LibraryId
)B ON A.DriveId = B.DriveId
ORDER BY COALESCE(A.LibName,B.LibName),
        COALESCE(A.DrName,B.DrName)
/******************************** GENERAL REMARKS: **************************************
*
*		In the above script we have used the LEFT and RIGHT joins to combine tables in
*		which there may be chances of the first table to be empty in case of LEFT JOIN
*		and the second TABLE may be empty for RIGHT JOIN cases. The FULL OUTER JOINS are
*		used when there may be chances that any or both the tables can empty.
*
***************************************************************************************/
DECLARE @LN VARCHAR(50)
DECLARE	@DN VARCHAR(50)
DECLARE @DUhr FLOAT(53)
DECLARE @DU24hr FLOAT(53)
DECLARE	@THGBhr FLOAT(53)
DECLARE @THGB24hr FLOAT(53)
DECLARE TableCursor CURSOR FOR SELECT * FROM #PERDRIVE
PRINT 'Name'+char(9)+char(9)+'Name'+char(9)+char(9)+'1hour'+char(9)+char(9)+'24hours'+char(9)+char(9)+'1hour'+char(9)+'24hours';
PRINT ' ';
PRINT 'Library'+char(9)+char(9)+'Drive'+char(9)+char(9)+'%Usage/h'+char(9)+'%Usage/h'+char(9)+'GB/h'+char(9)+'GB/h';
PRINT ' ';
OPEN TableCursor
FETCH NEXT FROM TableCursor INTO @LN,@DN, @DUhr, @DU24hr,@THGBhr,@THgb24hr
WHILE @@FETCH_STATUS = 0
BEGIN
PRINT @LN +char(9)+@DN+char(9)+CAST( convert(float,round(ISNULL(@DUHR,0),2)) AS VARCHAR)+char(9) +char(9)+CAST( convert(float,round(ISNULL(@DU24HR,0),2)) AS VARCHAR) +char(9)+ char(9)+CAST( convert(float,round(ISNULL(@THGBHR,0),2)) AS VARCHAR) +char(9)+CAST( convert(float,round(ISNULL(@THGB24HR,0),2)) AS VARCHAR)
FETCH NEXT FROM TableCursor INTO @LN,@DN, @DUhr, @DU24hr,@THGBhr,@THgb24hr
END
CLOSE TableCursor
DEALLOCATE TableCursor
/***************************************************************************************/
--SELECT * FROM perdrive
DROP TABLE #perdrive
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_scalereport_drive_usage_throughput_perdrive')
	delete from GxQscripts where name = 'QS_scalereport_drive_usage_throughput_perdrive'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_drive_usage_throughput_perdrive')
	delete from GXDBVersions where aliasname = 'QS_scalereport_drive_usage_throughput_perdrive'
GO

insert into GXDBVersions values(2, 'QS_scalereport_drive_usage_throughput_perdrive',  '00010002020000030000', 'QS_scalereport_drive_usage_throughput_perdrive', '00010002020000030000')
GO

insert into GxQscripts values(2,'QS_scalereport_drive_usage_throughput_perdrive',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	QOperation execscript -sn scalereport_drive_usage_throughput_perdrive.sql'
)
GO

