

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_scalereport_commcell_status.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_scalereport_commcell_status.sp,v $ $Id: QS_scalereport_commcell_status.sp,v 1.5.78.2 2018/03/20 00:08:28 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_scalereport_commcell_status <<<'

IF EXISTS (select * from sysobjects where name='QS_scalereport_commcell_status')
	drop procedure QS_scalereport_commcell_status
IF EXISTS (select * from GxQscripts where name='QS_scalereport_commcell_status')
	delete from GxQscripts where name = 'QS_scalereport_commcell_status'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_commcell_status')
	delete from GXDBVersions where aliasname = 'QS_scalereport_commcell_status'
GO
print '... Creating Procedure: QS_scalereport_commcell_status'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_scalereport_commcell_status
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
AS
SET NOCOUNT ON
SET ANSI_WARNINGS OFF
--CREATE TABLE #unitRowTable ( Query VARCHAR(255), LastHour FLOAT NULL , Last24Hours FLOAT NULL, Unit VARCHAR(30))
DECLARE @VAR_HR INT
DECLARE @VAR_24HR INT
DECLARE @VARF_HR FLOAT
DECLARE @VARF_24HR FLOAT
DECLARE @AVGF_HR FLOAT
DECLARE @AVGF_24HR FLOAT
DECLARE @TEMP1 INT
DECLARE @TEMP2 INT
DECLARE @TEMPF1 FLOAT
DECLARE @TEMPF2 FLOAT
DECLARE @JOBS_COMPLETED_LAST_HR INT
DECLARE @JOBS_COMPLETED_LAST_24HR INT
DECLARE @CUR_TIME INT
SET @CUR_TIME = dbo.GetUnixTime(GetUTCDate())
print 'Query'+char(9)+char(9)+char(9)+char(9)+'LastHour'+char(9)+'Last24Hours'+char(9)+'Units';
print ' ';
/*
  Report Format:
  ---------------------------------------------------------------------------------------
		Query, LastHour, Last24Hours, Unit
  ---------------------------------------------------------------------------------------
*/
/************* 1.	Number of chunks closed per hour ************************************
*		A chunk is the smallest unit of backup data kept in the commcell.When a
*		chunk is created, it is said to be opened and when the writing is done
*		on the storage it is closed. A chunk opening time is specified by the
*		ctime. How long it took between open and close is specified by the writetime.
*		So we take the sum of create time and the write time to obtain the chunk
*		closing time.
*
****************************************************************************************/
SET @VAR_HR = (SELECT COUNT(*) AS chunks_per_hr
					FROM ArchChunk WITH (READUNCOMMITTED)
					WHERE  (((@CUR_TIME-(createTime + writeTime))< 60*60)));
SET @VARF_24HR = (SELECT COUNT(*)/24.0 AS chunks_per_hr
					FROM ArchChunk WITH (READUNCOMMITTED)
					WHERE  (((@CUR_TIME-(createTime + writeTime))< 24*60*60))
				);
print 'CHUNKS CLOSED'+char(9)+char(9)+char(9)+CAST(ISNULL(@VAR_HR,0) AS VARCHAR)+char(9)+char(9)+CAST( convert(float,round(ISNULL(@VARF_24HR,0),2)) AS VARCHAR)+char(9)+char(9)+'CNT/HR';
--INSERT INTO #unitRowTable VALUES('CHUNKS CLOSED',@VAR_HR,@VARF_24HR,'CNT/HR');
/************* 2.   Number of Reservations per hour *************************************
*
*		It gives the number of reservations made.
*
****************************************************************************************/
/*
SET @VAR_HR = (SELECT COUNT(*)
			   FROM jmjobresourcehistory
			   WHERE ((@CUR_TIME-ReservationTime)<60*60));
SET @VARF_24HR = (SELECT COUNT(*)/24.0 FROM jmjobresourcehistory
				 WHERE((@CUR_TIME-ReservationTime)<60*60*24));
*/
SET @VAR_HR =  (select count(distinct reservationid) from jmjobresourcehistory
 WHERE ((@CUR_TIME-ReservationTime)<60*60))
SET @VARF_24HR = (select count(distinct reservationid) from jmjobresourcehistory
 WHERE((@CUR_TIME-ReservationTime)<60*60*24))
 print 'NO. OF RESERVATIONS'+char(9)+char(9)+CAST( @VAR_HR AS VARCHAR)+char(9)+char(9)+CAST( convert(float,round(ISNULL(@VARF_24HR,0),2)) AS VARCHAR)+char(9)+char(9)+'CNT/HR';
--INSERT INTO #unitRowTable VALUES('NO. OF RESERVATIONS',@VAR_HR,@VARF_24HR,'CNT/HR');
/*************** 3.	Total number of jobs ************************************************
*
*		It gives the count of number of jobs completed in the last one hour
*		and the last twenty four hours.
*
****************************************************************************************/
SET @JOBS_COMPLETED_LAST_HR =(SELECT COUNT(jobId)
							  FROM JmBkpStats WITH (READUNCOMMITTED)
							  WHERE ((@CUR_TIME- servEndDate) < 60*60));
SET @JOBS_COMPLETED_LAST_24HR = (SELECT COUNT(jobId)
								 FROM JmBkpStats WITH (READUNCOMMITTED)
								 WHERE ((@CUR_TIME- servEndDate) < 24*60*60));
print 'JOBS COMPLETED'+char(9)+char(9)+char(9)+CAST( @JOBS_COMPLETED_LAST_HR AS VARCHAR)+char(9)+char(9)+CAST( @JOBS_COMPLETED_LAST_24HR AS VARCHAR)+char(9)+char(9)+'CNT';
--INSERT INTO #unitRowTable VALUES('JOBS COMPLETED'  ,@JOBS_COMPLETED_LAST_HR,@JOBS_COMPLETED_LAST_24HR,'CNT');
/*************** 4.  Number of jobs completing in a single attempt **********************
*
*		A job can have different phases depending on its nature. Each phase
*		may take more than one attempt based on the available resources, network
*		connections and many others reasons. Now this record gives the percentage
*		of jobs which were successful in their first attempt in all the phases.
*
****************************************************************************************/
SET @VAR_HR = (SELECT count(*)
			   FROM
			   (
					SELECT sum(q.phaseattempts)-count(*) as att, q.commcellid as commcellid,q.jobid as jobid
					FROM
					(
						SELECT commcellid, jobid, phase, COUNT(STATUS) phaseAttempts
						FROM jmbkpatmptstats WITH (READUNCOMMITTED)
						WHERE ((dbo.GetUnixTime(GetUTCDate())-servstartDate) < 60*60)
						GROUP BY commcellid, jobid, phase
					)q
					GROUP BY q.commcellid,q.jobid
				)q1 WHERE att = 0);
SET @VAR_24HR = (SELECT count(*)
				 FROM
				 (
					SELECT sum(q.phaseattempts)-count(*) as att, q.commcellid as commcellid,q.jobid as jobid
					FROM
					(
						SELECT commcellid, jobid, phase, COUNT(STATUS) phaseAttempts
						FROM jmbkpatmptstats WITH (READUNCOMMITTED)
						WHERE ((dbo.GetUnixTime(GetUTCDate())-servstartDate) < 24*60*60)
						GROUP BY commcellid, jobid, phase
					)q
					GROUP BY q.commcellid,q.jobid
				)q1 WHERE att = 0);
SET @TEMPF1 = ISNULL((@VAR_HR*100.0)/nullif(@JOBS_COMPLETED_LAST_HR,0),0)
SET @TEMPF2 = ISNULL((@VAR_24HR*100.0)/nullif(@JOBS_COMPLETED_LAST_24HR,0),0)
	print 'JOBS COMPLETED IN ONE ATMPT'+char(9)+CAST( convert(float,round(@TEMPF1,2)) AS VARCHAR)+char(9)+char(9)+CAST( convert(float,round(@TEMPF2,2)) AS VARCHAR)+char(9)+char(9)+'% OF JOBS';
--	INSERT INTO #unitRowTable VALUES('JOBS COMPLETED IN ONE ATMPT',@TEMPF1,@TEMPF2,'% OF JOBS')
/**************** 5. Average number of attempts for a job to complete *******************
*
*		It gives the average number of attempts a job has taken to complete.
*
****************************************************************************************/
SET @VARF_HR =(SELECT SUM(query.total_attempts)*1.0/COUNT(*)
			  FROM
			  (
					SELECT query1.commcellid,query1.jobid AS jobid,(SUM(phaseAttempts)-COUNT(*)+1) total_attempts
					FROM
					(
						SELECT commcellid,jobid, phase, COUNT(STATUS) AS phaseAttempts
						FROM jmbkpatmptstats WITH (READUNCOMMITTED)
						WHERE ((@CUR_TIME-servstartDate) < 60*60)
						GROUP BY commcellid,jobid, phase
					)query1
					GROUP BY query1.commcellid,query1.jobid
				)query)
SET @VARF_24HR =(SELECT SUM(query.total_attempts)*1.0/COUNT(*)
				FROM
				(
					SELECT query1.commcellid,query1.jobid AS jobid,(SUM(phaseAttempts)-COUNT(*)+1) total_attempts
					FROM
					(
						SELECT commcellid,jobid, phase, COUNT(STATUS) AS phaseAttempts
						FROM jmbkpatmptstats WITH (READUNCOMMITTED)
						WHERE ((@CUR_TIME-servstartDate) < 24*60*60)
						GROUP BY commcellid,jobid, phase
					)query1
					GROUP BY query1.commcellid,query1.jobid
				)query)
SET @TEMPF1 = ISNULL(@VARF_HR,0)
SET @TEMPF2 = ISNULL(@VARF_24HR,0)
print 'AVG NO. OF ATMPTS PER JOB'+char(9)+CAST( convert(float,round(@TEMPF1,2)) AS VARCHAR)+char(9)+char(9)+CAST( convert(float,round(@TEMPF2,2)) AS VARCHAR)+char(9)+char(9)+'ATMPTS/JOB';
--INSERT INTO #unitRowTable VALUES('AVG NO. OF ATMPTS PER JOB',@TEMPF1,@TEMPF2,'ATMPTS/JOB');
/******************  6.	Number of jobs in queue *********************************
*
*		Jobs present in the queue for varied reasons have their states as following
*		which can be obtained from the JMJobInfo table.
*
****************************************************************************************/
/*** STATE 15 INDICATES QUEUED ****/
SET @VAR_HR = (SELECT COUNT(*)
			   FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 15)
print 'JOBS IN QUEUE(QUEUED)'+char(9)+char(9)+CAST(@VAR_HR AS varchar)+char(9)+char(9)+'N/A'+char(9)+char(9)+'CNT OF JOBS ';
/*** STATE 2 INDICATES PENDING ****/
SET @VAR_HR = (SELECT COUNT(*)
			   FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state =2 )
print 'JOBS IN QUEUE(PENDING)'+char(9)+char(9)+CAST(@VAR_HR AS varchar)+char(9)+char(9)+'N/A'+char(9)+char(9)+'CNT OF JOBS ';
/*** STATE 3 INDICATES WAITING ****/
SET @VAR_HR = (SELECT COUNT(*)
			   FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 3)
print 'JOBS IN QUEUE(WAITING)'+char(9)+char(9)+CAST(@VAR_HR AS varchar)+char(9)+char(9)+'N/A'+char(9)+char(9)+'CNT OF JOBS ';
/*** STATE 5 INDICATES SUSPENDED ****/
SET @VAR_HR = (SELECT COUNT(*)
			   FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 5)
print 'JOBS IN QUEUE(SUSPENDED)'+char(9)+CAST(@VAR_HR AS varchar)+char(9)+char(9)+'N/A'+char(9)+char(9)+'CNT OF JOBS ';
--INSERT INTO #unitRowTable VALUES('NO. OF JOBS IN QUEUE',@VAR_HR,NULL,'CNT OF JOBS ');
/*******************  7. Number of Jobs currently running *******************************
*
*		The jobs currently running have their entries in JMJobInfo table with state =1.
*
****************************************************************************************/
SET @VAR_HR = (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED) WHERE state = 1 )
print 'JOBS IN QUEUE(RUNNING)'+char(9)+CAST(@VAR_HR AS varchar)+char(9)+char(9)+'N/A'+char(9)+char(9)+'CNT OF JOBS ';
--INSERT INTO #unitRowTable VALUES('N0. OF JOBS CRNTLY RUNNING',@VAR_HR,NULL,'CNT ');
/*****************  8.  No of mounts/hour per commcell **********************************
*
*		The table MMDriveHistory contains the number of times a drive has been mounted.
*		Using the above table this query gives the overall count of mounts  per hour
*		extended over a period of the last one hour and twenty four hours.
*
****************************************************************************************/
SET @VARF_24HR = (SELECT SUM(NumberOfMounts)/24.0
				 FROM MMDriveHistory d
				 WHERE (@CUR_TIME-dbo.GetUnixTime(TimeStart))<24*60*60
				 )
SET @VAR_HR = (SELECT SUM(NumberOfMounts)
			   FROM MMDriveHistory d
			   WHERE (@CUR_TIME-dbo.GetUnixTime(TimeStart))<60*60
			   )
SET @TEMP1 = ISNULL(@VAR_HR,0)
SET @TEMP2 = ISNULL(@VARF_24HR,0)
print 'NO. OF MOUNTS/HOUR'+char(9)+char(9)+CAST(@TEMP1 AS varchar)+char(9)+char(9)+CAST( convert(float,round(@TEMP2,2)) AS VARCHAR)+char(9)+char(9)+'MNTS/HOUR ';
--INSERT INTO #unitRowTable VALUES('NO. OF MOUNTS/HOUR',@VAR_HR,@VARF_24HR,'MNTS/HOUR ');
/**************   9.	Highest number of streams transferring data *********************
*
*		A data stream can be defined  as a data channel that connects the client file
*		system or database to the storage media. Multiple streams provide for multiple
*		channels through which data can flow.
*
*		In this query first we identify the count of distinct stream ids in an interval
*		of five minutes extending over a period of one hour. Then we indetify the maximum
*		of those counts to get the desired output.
*
*		The same procedure is repeated to find the maximum during the last twenty four
*		hours with the same interval of five minutes.
*
****************************************************************************************/
 SELECT @VAR_HR = MAX(query.counthr_ids),@AVGF_HR =(AVG(query.counthr_ids)*1.0)
 FROM
(
	SELECT RMTimeStamp/300 AS times,COUNT(distinct h.StreamId) AS counthr_ids
	FROM jmjobresourcehistory AS h
	WHERE((@CUR_TIME-RMTimeStamp) <60*60)
	GROUP BY RMTimeStamp/300
) query
SELECT @VAR_24HR = MAX(query.count24hr_ids),@AVGF_24HR =(AVG(query.count24hr_ids)*1.0)
FROM
(
	SELECT RMTimeStamp/300 AS times,COUNT(DISTINCT h.StreamId) AS count24hr_ids
	FROM jmjobresourcehistory AS h
	WHERE((@CUR_TIME-RMTimeStamp) <24*60*60)
	GROUP BY RMTimeStamp/300
)query
SET @TEMP1 = ISNULL(@VAR_HR,0)
SET @TEMP2 = ISNULL(@VAR_24HR,0)
print 'MAX NO. OF STRMS TRANSF. DATA'+char(9)+CAST(@TEMP1 AS varchar)+char(9)+char(9)+CAST(@TEMP2 AS varchar)+char(9)+char(9)+'MAX CNT';
--INSERT INTO #unitRowTable VALUES('MAX NO. OF STRMS TRANSF. DATA',@VAR_HR,@VAR_24HR,'MAX CNT ');
/*************** 10.	Average number of streams for the past 24 hours *****************
*
*		This query does the same as above but obtains the Average of the count instead
*		of the maximum of StreamId counts.
*
****************************************************************************************/
SET @TEMPF1 = ISNULL(@VARF_HR,0)
SET @TEMPF2 = ISNULL(@VARF_24HR,0)
print 'AVG NO. OF STRMS TRANSF. DATA'+char(9)+CAST( convert(float,round(@TEMPF1,2)) AS VARCHAR)+char(9)+char(9)+CAST( convert(float,round(@TEMPF2,2)) AS VARCHAR)+char(9)+char(9)+'AVG CNT';
--INSERT INTO #unitRowTable VALUES('AVG NO. OF STRMS TRANSF. DATA',@AVGF_HR,@AVGF_24HR,'AVG CNT ');
/****** 11.	Average throughput per job in the commcell *******************
*
*		The total number of Giga Bytes transferred by a job is given by totalUncompBytes
*		column present in the JMBkpStats table. Doing an INNER JOIN JMBkpStats with
*		JMJobResourceHistory gives all the required details like the Job Id, amount
*		of data it has transferred, time it took for transfer and the time at which
*		a job has ended. Since the units of column totalUncompBytes is in Bytes, we
*		divide it with 1024*1024 to get the output in Mega Bytes.
*
****************************************************************************************/
SET @VARF_HR = (SELECT (SUM(b.totalUncompBytes)*60.0*60.0/(SUM(b.totalWriteTime)*1024.0*1024.0) )/(1024.0*nullif(count(*),0))
			   FROM jmbkpstats b WITH (READUNCOMMITTED)
			   WHERE b.totalWriteTime > 0 AND (b.servStartDate > ( @CUR_TIME-60*60))
			   )
SET @VARF_24HR = (SELECT (SUM(b.totalUncompBytes)*60.0*60.0/(SUM(b.totalWriteTime)*24.0*1024.0*1024.0))/(1024.0*nullif(count(*),0))
			     FROM jmbkpstats b WITH (READUNCOMMITTED)
			     WHERE b.totalWriteTime > 0 AND (b.servStartDate > ( @CUR_TIME-24*60*60))
			      )
SET @TEMPF1 = ISNULL(@VARF_HR,0)
SET @TEMPF2 = ISNULL(@VARF_24HR,0)
print 'AVG JOB THROUGHPUT '+char(9)+char(9)+
CASE
	WHEN @VARF_HR is null then 'N/A'
	ELSE CAST( convert(float,round(@TEMPF1,2)) AS VARCHAR)
END
+char(9)+char(9)+
CASE
	WHEN @VARF_24HR is null then 'N/A'
	ELSE CAST( convert(float,round(@TEMPF2,2)) AS VARCHAR)
END
+char(9)+char(9)+'GB/HR/JOB';
--INSERT INTO #unitRowTable VALUES('NO. OF BYTES TRANSFRED',@TEMPF1,@TEMPF2,'MB/HR');
/******************* 12. Size of total Chunks Written perh hour**************************
*
*		This query gives the total size of chunks written per hour on to the storage in
*		last one and twenty four hours respectively.
*
****************************************************************************************/
SET @VARF_HR = (SELECT SUM(logicalSize)/(1024.0*1024.0*1024.0)/(60*60.0)
			     FROM archchunk WITH (READUNCOMMITTED)
			     WHERE ( createTime >=  @CUR_TIME - 60*60))
SET @VARF_24HR = (SELECT SUM(logicalSize)/(1024.0*1024.0*1024.0)/(60*60.0*24)
			     FROM archchunk WITH (READUNCOMMITTED)
			     WHERE ( createTime >= @CUR_TIME - 24*60*60))
SET @TEMPF1 = ISNULL(@VARF_HR,0)
SET @TEMPF2 = ISNULL(@VARF_24HR,0)
print 'SIZE OF CHUNKS'+char(9)+char(9)+char(9)+CAST( convert(float,round(@TEMPF1,2)) AS VARCHAR)+char(9)+char(9)+CAST( convert(float,round(@TEMPF2,2)) AS VARCHAR)+char(9)+char(9)+'GB/HR';
--INSERT INTO #unitRowTable VALUES('SIZE OF CHUNKS',@VARF_HR,@VARF_24HR,'GB/HR');
/***************************************************************************************/
--SELECT * FROM #unitRowTable
--DROP TABLE #unitRowTable
/***************************************************************************************/
-- print current database size
SELECT @VARF_HR = SUM(size)*8/1024 --AS CurrentDBSizeInMB
      FROM sys.database_files
SET @TEMPF1 = ISNULL(@VARF_HR,0)
	  print 'Current Database Size : '+ char(9)+char(9)+char(9)+CAST( convert(float,round(@TEMPF1,2)) AS VARCHAR);
-- current tempdb and log file sizes
SELECT @VARF_HR = SUM(size)*8/1024 --AS TempDBSizeInMB
      FROM sys.master_files
      WHERE name IN ('tempdev', 'templog')
SET @TEMPF1 = ISNULL(@VARF_HR,0)
	  print 'Current tempDB Size : '+ char(9)+char(9)+char(9)+CAST( convert(float,round(@TEMPF1,2)) AS VARCHAR);
	  ---
DECLARE @dbname NVARCHAR(MAX)
DECLARE @logfilesize NVARCHAR(MAX)
DECLARE print_row CURSOR
FOR SELECT DB_NAME(database_id) AS DatabaseName, CONVERT(NVARCHAR,SUM(size)*8/1024) AS LogFileSizeInMB
      FROM sys.master_files
      WHERE type = 1 --log
      GROUP BY database_id
      ORDER BY DatabaseName
PRINT 'DatabaseName' + SPACE(38) + 'LogFileSizeInMB'
PRINT SPACE(136)
OPEN print_row
FETCH NEXT FROM print_row
INTO @dbname , @logfilesize
WHILE @@FETCH_STATUS = 0
BEGIN
  PRINT  @dbname +SPACE(50 - LEN(@dbname)) + @logfilesize
FETCH NEXT FROM print_row
INTO @dbname , @logfilesize
END
CLOSE print_row;
DEALLOCATE print_row
PRINT SPACE(136)
PRINT SPACE(136)
-- top 10 tables ordered by total size
-- top 10 tables ordered by row count
IF OBJECT_ID('tempdb..#TableSize') IS NOT NULL
      DROP TABLE #TableSize
CREATE TABLE #TableSize
      (
      name nvarchar(128),
      rows char(11),
      reserved varchar(18),
      data varchar(18),
      index_size varchar(18),
      unused varchar(18)
      )
DECLARE @object_id INT
DECLARE GetObjectId CURSOR LOCAL FORWARD_ONLY FOR
      SELECT object_id
      FROM sys.objects
      WHERE type = 'U'
OPEN GetObjectId
FETCH NEXT FROM GetObjectId INTO @object_id
WHILE @@FETCH_STATUS = 0
BEGIN
      DECLARE @object_name VARCHAR(128) = OBJECT_NAME(@Object_id)
      INSERT INTO #TableSize
            EXEC sp_spaceused @object_name
      FETCH NEXT FROM GetObjectId INTO @object_id
END
CLOSE GetObjectId
DEALLOCATE GetObjectId
--c) top 10 tables ordered by total size
DECLARE @tbname NVARCHAR(MAX)
DECLARE @sizeinKb INT
DECLARE print_row CURSOR
FOR SELECT TOP(10) name  , CONVERT(INT, SUBSTRING(B.data, 0, LEN(B.data)-2))+CONVERT(INT, SUBSTRING(B.index_size, 0, LEN(B.index_size)-2))+CONVERT(INT, SUBSTRING(B.reserved, 0, LEN(B.reserved)-2))+CONVERT(INT, SUBSTRING(B.unused, 0, LEN(B.unused)-2)) AS 'SizeinKB'
      FROM #TableSize B
      ORDER BY SizeInKB DESC
PRINT 'Table' + SPACE(45) + 'SizeinKB'
PRINT SPACE(136)
OPEN print_row
FETCH NEXT FROM print_row
INTO @tbname , @sizeinKB
WHILE @@FETCH_STATUS = 0
BEGIN
  PRINT  @tbname +SPACE(50 - LEN(@tbname)) + CONVERT(NVARCHAR,@sizeinKB)
FETCH NEXT FROM print_row
INTO @tbname ,@sizeinKB
END
CLOSE print_row;
DEALLOCATE print_row
PRINT SPACE(136)
PRINT SPACE(136)
--d) top 10 tables ordered by row count
--DECLARE @tbname NVARCHAR(MAX) already declared
DECLARE @rowcount INT
DECLARE print_row CURSOR
FOR SELECT TOP 10 name as [Table] , CONVERT(INT, B.rows) AS [RowCount]
      from #TableSize B
      order by [RowCount] DESC
PRINT 'Table' + SPACE(45) + 'RowCount'
PRINT SPACE(136)
OPEN print_row
FETCH NEXT FROM print_row
INTO @tbname ,@rowcount
WHILE @@FETCH_STATUS = 0
BEGIN
  PRINT  @tbname +SPACE(50 - LEN(@tbname)) + CONVERT(NVARCHAR, @rowcount)
FETCH NEXT FROM print_row
INTO @tbname ,@rowcount
END
CLOSE print_row;
DEALLOCATE print_row
DROP TABLE #TableSize
/***************************************************************************************/
--- Criteria for Auxiliary Copy Fallen Behind is 90 days old OR 1 TB data
print 'Auxiliary Copy Fallen Behind : '+ char(13)
DECLARE @tblAGC1 TABLE (archCopyId INT, archGroupId INT, commCellId INT, sourceCopyId INT)
DECLARE @tblAGC2 TABLE (archGrpId INT, archGrpCopyId INT, numOfJobs INT, oldestJobEndTime INT, OldestJob INT, toBeCopiedBytes BIGINT)
DECLARE @tblJob            TABLE(jobId INT, commCellId INT, archGrpId INT, archGrpCopyId INT, status INT, jobEndTime INT,  toBeCopiedBytes BIGINT, appId INT
                                                                                UNIQUE CLUSTERED (jobId, commCellId, archGrpId, archGrpCopyId))
IF (OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL) DROP TABLE #tmpJobSizeInfo
CREATE TABLE #tmpJobSizeInfo (
    JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
    PRIMARY KEY (JobId, CommCellId))
DECLARE @l_now            INT
SET @l_now = dbo.GetUnixTime(GETDATE())
DECLARE @l_real  FLOAT = 1.0
INSERT INTO @tblAGC1 (archCopyid, archGroupId, commCellId, sourceCopyId)
SELECT AGC.Id, AGC.archGroupid, CASE WHEN AGC.origCCcommCellId > 0  THEN AGC.origCCcommCellId ELSE 2 END,  CASE WHEN AGC.sourceCopyId = 0 THEN AG.defaultCopy ELSE AGC.sourceCopyId END
FROM archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
                WHERE AG.id = AGC.archGroupId
                AND AGC.type <> 5
                AND AG.defaultCopy <> AGC.id        -- Primary Classic
                AND AG.defaultSnapCopy <> AGC.id   -- Primary Snap
                AND AGC.flags & 524288 = 0      -- Silo copy
INSERT  INTO @tblJob
SELECT  J1.jobId, J1.commCellId, J1.archGrpId, J1.archGrpCopyId, MAX(J1.status), 0, 0, J1.appId
FROM   JMJobDataStats J1 WITH (NOLOCK), JMJobDataStats J2 WITH (NOLOCK), @tblAGC1 T
WHERE J1.archGrpCopyId = T.archCopyid
                AND J2.archGrpCopyId = T.sourceCopyId
                AND J1.archGrpId = J2.archGrpId
                AND J1.status IN (101, 102, 103)
                AND J1.jobId = J2.jobId
                AND ((J1.disabled & (1  + 256) = 0)
                                OR (J1.disabled & (1 + 512) = (1 + 512)))
                AND (J2.disabled & (1  + 256) = 0)
GROUP BY J1.commCellId, J1.archGrpId, J1.archGrpCopyId, J1.jobId, J1.appId
HAVING  MAX(J2.status) = 100
INSERT #tmpJobSizeInfo
SELECT DISTINCT jobId, commCellId, 0, 0, 0 FROM  @tblJob
EXEC archGetJobSizeInfo 0
UPDATE               @tblJob
SET                         jobEndTime = B.servstartDate, toBeCopiedBytes = B.totalUncompBytes
FROM   @tblJob J, JMBkpStats B WITH (NOLOCK)
WHERE J.jobId = B.jobId AND J.commCellId = B.commCellId
UPDATE               @tblJob
SET                         jobEndTime = B.servStart, toBeCopiedBytes = B.uncompBytes
FROM   @tblJob J, JMAdminJobStatsTable B WITH (NOLOCK)
WHERE J.jobId = B.jobId AND J.commCellId = B.commCellId
UPDATE  @tblJob
SET toBeCopiedBytes = (CASE WHEN (T.toBeCopiedBytes > 0 AND J.totalBackupSize > 0 ) THEN (T.toBeCopiedBytes - ((J.totalAppSize + J.totalIndexSize)*@l_real*S.copiedBytes/J.totalBackupSize)) ELSE T.toBeCopiedBytes END)
FROM    @tblJob T, #tmpJobSizeInfo J,
        (SELECT J.JobId, J.commCellId, J.archGrpCopyId, SUM(AFC.physicalSize) AS copiedBytes
        FROM    @tblJob J,  archfile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
        WHERE J.jobId = AF.jobId AND J.status <> 101
        AND AFC.archFileId = AF.Id AND AFC.commCellId = AF.commCellId
        AND AFC.archCopyId = J.archGrpCopyId AND AFC.commCellId = J.commCellId
        GROUP BY J.JobId, J.commCellId, J.archGrpCopyId) S
WHERE   T.jobId = S.jobId AND T.commCellId = S.commCellId AND T.archGrpCopyId = S.archGrpCopyId
        AND T.jobId = J.JobId AND T.commCellId = J.CommCellId
INSERT INTO @tblAGC2
SELECT J.archGrpId, J.archGrpCopyId, J.numofToBeCopiedJobs, J.jobEndTime, J.OldestJob, J.toBeCopiedBytes
FROM @tblAGC1 AG
JOIN (SELECT archGrpId, archGrpCopyId, COUNT(jobId) as numofToBeCopiedJobs, MIN(jobEndTime) as jobEndTime, MIN(jobId) as OldestJob, SUM(toBeCopiedBytes) as toBeCopiedBytes, commCellId
                FROM @tblJob GROUP BY archGrpId , archGrpCopyId, commCellId) J
ON AG.archCopyid = J.archGrpCopyId AND AG.commCellId = J.commCellId
DELETE  @tblAGC2
FROM    @tblAGC2 AGC2
WHERE (@l_now - AGC2.oldestJobEndTime)/24/3600 < 90    --- 90 Days Old by start Time of Job
      AND AGC2.toBeCopiedBytes/1024/1024/1024/1024 < 1     ---- 1 TB Data
DECLARE @spname NVARCHAR(MAX)
DECLARE @cpname NVARCHAR(MAX)
DECLARE @datatobecopied        NVARCHAR(MAX)
DECLARE @njobs NVARCHAR(MAX)
DECLARE @oldjobid NVARCHAR(MAX)
DECLARE @oldjobtime NVARCHAR(MAX)
DECLARE @maxspwidth INT
DECLARE @maxcpwidth INT
SELECT @maxspwidth = MAX(LEN(name))
FROM archGroup
SELECT @maxcpwidth =  MAX(LEN(name))
FROM archGroupCopy
IF @maxspwidth < 15
SET @maxspwidth = 45
IF @maxcpwidth < 5
SET @maxcpwidth = 45
DECLARE print_row CURSOR
FOR SELECT         AG.name, AGC.name, (CONVERT(NVARCHAR,CONVERT(DECIMAL(20,2),T.toBeCopiedBytes*@l_real/1024/1024/1024/1024))) ToBeCopiedData, CONVERT(NVARCHAR,T.numOfJobs), CONVERT(NVARCHAR,T.OldestJob) , CONVERT(NVARCHAR,dbo.GetDateTime(T.oldestJobEndTime))
FROM   @tblAGC2 T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE T.archGrpCopyId = AGC.id  AND AG.id = T.archGrpId
ORDER BY AG.name, AGC.name
PRINT 'Storage Policy Name'+ SPACE(@maxspwidth + 4 - 19)+ 'Copy Name' +SPACE(@maxcpwidth + 4 - 9) +'ToBeCopiedData(in TB)'+SPACE(2) + 'No.ofJobs' + SPACE(2) + 'OldestJobId'+SPACE(1)+  'OldestJobTime'
PRINT SPACE(136)
OPEN print_row
FETCH NEXT FROM print_row
INTO @spname ,@cpname, @datatobecopied, @njobs, @oldjobid,@oldjobtime
WHILE @@FETCH_STATUS = 0
BEGIN
PRINT @spname +SPACE(@maxspwidth + 4 - LEN(@spname)) +  @cpname +SPACE(@maxcpwidth + 4 - LEN(@cpname)) + @datatobecopied +SPACE(23 - LEN(@datatobecopied)) + @njobs +SPACE(11-LEN(@njobs))
  +  @oldjobid +SPACE(12- LEN(@oldjobId)) + @oldjobtime
FETCH NEXT FROM print_row
INTO @spname ,@cpname, @datatobecopied, @njobs, @oldjobid,@oldjobtime
END
CLOSE print_row;
DEALLOCATE print_row
IF (OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL) DROP TABLE #tmpJobSizeInfo
/***************************************************************************************/
SET ANSI_WARNINGS OFF
print 'Dedupe Store Information : '+char(13)
IF object_id('tempdb.dbo.#tmpDDBInfo') is not null DROP TABLE #tmpDDBInfo
CREATE TABLE #tmpDDBInfo
(
	spId				INTEGER,
	spName				VARCHAR(MAX),
	copyId				INTEGER,
	copyName			VARCHAR(MAX),
	SIDBStoreId			INTEGER,
	SIDBStoreName		VARCHAR(MAX),
	avgQITime			INTEGER,
	deletedAFCount		INTEGER,
	primaryEntryCount	BIGINT,
	secondaryEntryCount BIGINT,
	zeroRefCount		BIGINT
)
IF object_id('tempdb.dbo.#temp') is not null DROP TABLE #temp
CREATE TABLE #temp
(
	SIDBStoreId			INTEGER,
	substoreid			INTEGER,
	avgQITime			INTEGER,
	primaryEntryCount	BIGINT,
	secondaryEntryCount BIGINT,
	zeroRefCount		BIGINT
)
declare @tblLatestStoreInfo table (SIDBStoreId int, ModifiedTime int)
--Get most recent modified time for each Dedupe Store
insert into @tblLatestStoreInfo
select U.SIDBStoreId, max(U.ModifiedTime)
from IdxSIDBUsageHistory U WITH (NOLOCK)
inner join archCopySIDBStore agcStore WITH (NOLOCK) ON U.SIDBStoreId = agcStore.SIDBStoreId
--where U.HistoryType = 1
group by U.SIDBStoreId
INSERT INTO #temp(SIDBStoreId,substoreid,avgQITime,primaryEntryCount,secondaryEntryCount,zeroRefCount)
SELECT iuh.SIDBStoreId, iuh.SubStoreId, AVG(iuh.AvgQITime),AVG(iuh.PrimaryEntries),AVG(iuh.SecondaryEntries),AVG(iuh.ZeroRefCount)
FROM IdxSIDBUsageHistory iuh WITH (NOLOCK)
	INNER JOIN @tblLatestStoreInfo lastInfo ON iuh.SIDBStoreId = lastInfo.SIDBStoreId
WHERE iuh.ModifiedTime > (lastInfo.ModifiedTime-(24*60*60))
GROUP BY iuh.SIDBStoreId, iuh.SubStoreId
HAVING AVG(iuh.AvgQITime) > 1
INSERT INTO #tmpDDBInfo (SIDBStoreId,avgQITime,primaryEntryCount,secondaryEntryCount,zeroRefCount)
SELECT t.SIDBStoreId, AVG(t.AvgQITime),SUM(t.primaryEntryCount),SUM(t.secondaryEntryCount),SUM(t.ZeroRefCount)
FROM #temp t WITH (NOLOCK)
GROUP BY t.SIDBStoreId
DROP TABLE #temp
UPDATE T
SET T.deletedAFCount = ISNULL(tmp.DAFCount, 0)
FROM #tmpDDBInfo T
	LEFT OUTER JOIN (SELECT SIDBStoreId, count(*) DAFCount FROM MMDeletedAF mdaf WITH (NOLOCK) WHERE SIDBStoreId > 0 GROUP BY SIDBStoreId) tmp on T.SIDBStoreId = tmp.SIDBStoreId
UPDATE T
SET T.copyId = agc.id,
T.copyName = agc.name,
T.spId = agc.archGroupId
FROM #tmpDDBInfo T
	INNER JOIN archCopySIDBStore agcStore WITH (NOLOCK) ON T.SIDBStoreId = agcStore.SIDBStoreId
	INNER JOIN archGroupCopy agc WITH (NOLOCK) ON agcStore.copyId = agc.id
WHERE (agc.dedupeFlags & 134217728) = 0 -- CVA_USE_GLOBAL_DEDUP_STORE_FLAG
UPDATE T
SET spname = ag.name
FROM #tmpDDBInfo T
inner join archGroup ag WITH (NOLOCK) ON T.spid = ag.id
UPDATE T
SET SIDBStoreName = iss.SIDBStoreAliasName
FROM #tmpDDBInfo T
inner join IdxSIDBStore iss WITH (NOLOCK) ON T.SIDBStoreId = iss.SIDBStoreId
DECLARE @spolicyName VARCHAR(MAX), @copyName VARCHAR(MAX), @storeId INT, @storeName VARCHAR(MAX), @avgQI INT, @deletedAFCount INT, @primaryCount BIGINT, @secondaryCount BIGINT , @zeroRefCount INT
DECLARE @maxspnamewidth INT
DECLARE @maxcpnamewidth INT
DECLARE @maxstorenamewidth INT
SELECT @maxspnamewidth = MAX(LEN(spName))
FROM #tmpDDBInfo
SELECT @maxcpnamewidth =  MAX(LEN(copyName))
FROM #tmpDDBInfo
SELECT @maxstorenamewidth =  MAX(LEN(SIDBStoreName))
FROM #tmpDDBInfo
IF @maxspnamewidth < 15
SET @maxspnamewidth = 45
IF @maxcpnamewidth < 5
SET @maxcpnamewidth = 45
IF @maxstorenamewidth < 5
SET @maxstorenamewidth = 45
DECLARE print_row CURSOR
FOR SELECT TOP 10 spName, copyName, SIDBStoreId, SIDBStoreName, avgQITime, deletedAFCount, primaryEntryCount, secondaryEntryCount, zeroRefCount  FROM #tmpDDBInfo
ORDER BY avgQITime DESC
print 'Storage Policy Name'+space(@maxspnamewidth + 4 - 19)+'Copy Name'+space(@maxcpnamewidth + 4 - 9)+'Store Id'+space(20)+'Store Name'+space(@maxstorenamewidth + 4 - 10)+'Avg Q&I Time'+space(17)+'Deleted AF Count'+space(21)+'Primary Entry Count'+space(24)+
'Secondary Entry Count'+space(26)+'Zero Ref Count'
print '-------------------'+space(@maxspnamewidth + 4 - 19)+'---------'+space(@maxcpnamewidth + 4 - 9)+'--------'+space(20)+'----------'+space(@maxstorenamewidth + 4 - 10)+'------------'+space(17)+'----------------'+space(21)+'-------------------'+space(24)+
'---------------------'+space(26)+'--------------'
OPEN print_row
FETCH NEXT FROM print_row
INTO @spolicyName, @copyName, @storeId, @storeName, @avgQI, @deletedAFCount, @primaryCount, @secondaryCount, @zeroRefCount
WHILE @@FETCH_STATUS = 0
BEGIN
print @spolicyName+space(@maxspnamewidth + 4 - LEN(@spolicyName))+@copyName+space(@maxcpnamewidth + 4 - LEN(@copyName))+CAST( @storeId AS VARCHAR)
+space(21 - LEN(@storeId))+@storeName+space(@maxstorenamewidth + 4 - LEN(@storeName))+CAST( @avgQI AS VARCHAR)+space(29 - LEN(@avgQI))+CAST( @deletedAFCount AS VARCHAR)
+space(37 - LEN(@deletedAFCount))+CAST( @primaryCount AS VARCHAR)+space(43 - LEN(@primaryCount))+CAST( @secondaryCount AS VARCHAR)+space(47 - LEN(@secondaryCount))+CAST( @zeroRefCount AS VARCHAR)
  FETCH NEXT FROM print_row
    INTO @spolicyName, @copyName, @storeId, @storeName, @avgQI, @deletedAFCount, @primaryCount, @secondaryCount, @zeroRefCount
END
CLOSE print_row;
DEALLOCATE print_row;
IF (OBJECT_ID('tempdb.dbo.#tmpDDBInfo') IS NOT NULL) DROP TABLE #tmpDDBInfo
/***************************************************************************************/
GO

IF EXISTS (select * from GxQscripts where name = 'QS_scalereport_commcell_status')
	delete from GxQscripts where name = 'QS_scalereport_commcell_status'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_commcell_status')
	delete from GXDBVersions where aliasname = 'QS_scalereport_commcell_status'
GO

insert into GXDBVersions values(2, 'QS_scalereport_commcell_status',  '00010005007800020000', 'QS_scalereport_commcell_status', '00010005007800020000')
GO

insert into GxQscripts values(2,'QS_scalereport_commcell_status',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		This script outputs the status of a commcell reporting various parameters like   jobs completed, bytes transferred, jobs in the queue etc.'
)
GO

