

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_scalereport_backups_restores_errors_perdrive.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_scalereport_backups_restores_errors_perdrive.sp,v $ $Id: QS_scalereport_backups_restores_errors_perdrive.sp,v 1.3.272.2 2018/03/20 00:05:09 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_scalereport_backups_restores_errors_perdrive <<<'

IF EXISTS (select * from sysobjects where name='QS_scalereport_backups_restores_errors_perdrive')
	drop procedure QS_scalereport_backups_restores_errors_perdrive
IF EXISTS (select * from GxQscripts where name='QS_scalereport_backups_restores_errors_perdrive')
	delete from GxQscripts where name = 'QS_scalereport_backups_restores_errors_perdrive'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_backups_restores_errors_perdrive')
	delete from GXDBVersions where aliasname = 'QS_scalereport_backups_restores_errors_perdrive'
GO
print '... Creating Procedure: QS_scalereport_backups_restores_errors_perdrive'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_scalereport_backups_restores_errors_perdrive
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
AS
SET NOCOUNT ON
CREATE TABLE #perDrive ( LibraryName VARCHAR(50),
						DriveName  VARCHAR(50),
						Totalbackups_hr FLOAT null,
						Totalbackups_24hr FLOAT null,
						Totalrestores_hr FLOAT null,
						Totalrestores_24hr FLOAT null,
						Totalerrors_hr FLOAT null,
						Totalerrors_24hr FLOAT null)
DECLARE @CUR_TIME INT
SET @CUR_TIME = dbo.GetUnixTime(GetUTCDate())
INSERT INTO #perDrive
SELECT 	C.LibName,
        C.DrName,
		C.Totalbackups_hr, C.Totalbackups_24hr,
		C.Totalrestores_hr,C.Totalrestores_24hr,
		C.Totalerrors_hr,C.Totalerrors_24hr
FROM
(
/* This query gives various other details like the total backups,restores and errors on a drive*/
	SELECT l.LibraryName AS LibName,d.DriveName AS DrName,query1.DriveId,
		   query1.Totalbackups_24hr,query2.Totalbackups_hr,
		   query1.Totalrestores_24hr,query2.Totalrestores_hr,
		   query1.Totalerrors_24hr,query2.Totalerrors_hr
	FROM
	(
		SELECT DriveId,SUM(NumberOfBackups) AS Totalbackups_24hr,
			           SUM(NumberOfRestores) AS Totalrestores_24hr,
					   SUM(NumberOfSoftErrors+NumberOfHardErrors) AS Totalerrors_24hr
		FROM mmdrivehistory
		WHERE ( @CUR_TIME-dbo.GetUnixTime(TimeStart)< 24*60*60)
		GROUP BY DriveId
	)query1 LEFT JOIN
	(
		SELECT DriveId,SUM(NumberOfBackups) AS Totalbackups_hr,
			           SUM(NumberOfRestores) AS Totalrestores_hr,
					   SUM(NumberOfSoftErrors+NumberOfHardErrors) AS Totalerrors_hr
		FROM mmdrivehistory
		WHERE ( @CUR_TIME-dbo.GetUnixTime(TimeStart)< 60*60)
		GROUP BY DriveId
	)query2 ON query1.DriveId = query2.DriveId,
	MMDrive d WITH (READUNCOMMITTED) ,MMMasterPool m WITH (READUNCOMMITTED) ,MMLibrary l WITH (READUNCOMMITTED)
	WHERE d.DriveId =query1.DriveId  AND d.MasterPoolid = m.MasterPoolId AND m.Libraryid = l.LibraryId
) C
ORDER BY C.LibName,C.DrName
/******************************** GENERAL REMARKS: **************************************
*
*		In the above script we have used the LEFT and RIGHT joins to combine tables in
*		which there may be chances of the first table to be empty in case of LEFT JOIN
*		and the second TABLE may be empty for RIGHT JOIN cases. The FULL OUTER JOINS are
*		used when there may be chances that any or both the tables can empty.
*
***************************************************************************************/
DECLARE @LN VARCHAR(50)
DECLARE	@DN VARCHAR(50)
DECLARE @TBHR FLOAT
DECLARE @TB24HR FLOAT
DECLARE @TRHR FLOAT
DECLARE @TR24HR FLOAT
DECLARE @TEHR FLOAT
DECLARE @TE24HR FLOAT
DECLARE TableCursor CURSOR FOR SELECT * FROM #PERDRIVE
PRINT 'Name'+char(9)+char(9)+'Name'+char(9)+char(9)+'1hour'+char(9)+'24hours'+char(9)+'1hour'+char(9)+'24hours'+char(9)+'1hour'+char(9)+'24hours'
PRINT ' '
PRINT 'Library'+char(9)+char(9)+'Drive'+char(9)+char(9)+'#Bkps'+char(9)+'#Bkps'+char(9)+'#Rsts'+char(9)+'#Rsts'+char(9)+'#Errs'+char(9)+'#Errs'
PRINT ' '
OPEN TableCursor
FETCH NEXT FROM TableCursor INTO @LN,@DN, @TBhr, @TB24HR,@TRHR,@TR24HR,@TEHR,@TE24HR
WHILE @@FETCH_STATUS = 0
BEGIN
--convert(float,round(null,2))
--CAST( convert(float,round(ISNULL(@TBHR,0),2)) AS VARCHAR)
PRINT @LN +char(9)+@DN+char(9)+CAST( convert(float,round(ISNULL(@TBHR,0),2)) AS VARCHAR) +char(9)+CAST( convert(float,round(ISNULL(@TB24HR,0),2)) AS VARCHAR) + char(9)+CAST( convert(float,round(ISNULL(@TRHR,0),2)) AS VARCHAR) +char(9)+CAST( convert(float,round(ISNULL(@TR24HR,0),2)) AS VARCHAR)+char(9)+CAST( convert(float,round(ISNULL(@TEHR,0),2)) AS VARCHAR)+char(9)+CAST( convert(float,round(ISNULL(@TE24HR,0),2)) AS VARCHAR)
FETCH NEXT FROM TableCursor INTO @LN,@DN, @TBhr, @TB24HR,@TRHR,@TR24HR,@TEHR,@TE24HR
END
CLOSE TableCursor
DEALLOCATE TableCursor
/***************************************************************************************/
--SELECT * FROM perdrive
DROP TABLE #perdrive
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_scalereport_backups_restores_errors_perdrive')
	delete from GxQscripts where name = 'QS_scalereport_backups_restores_errors_perdrive'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_backups_restores_errors_perdrive')
	delete from GXDBVersions where aliasname = 'QS_scalereport_backups_restores_errors_perdrive'
GO

insert into GXDBVersions values(2, 'QS_scalereport_backups_restores_errors_perdrive',  '00010003027200020000', 'QS_scalereport_backups_restores_errors_perdrive', '00010003027200020000')
GO

insert into GxQscripts values(2,'QS_scalereport_backups_restores_errors_perdrive',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		Qoperation execscript -sn scalereport_backups_restores_errors_perdrive.sql'
)
GO

