

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_scalereportJobsCompletedBytesXferred.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_scalereportJobsCompletedBytesXferred.sp,v $ $Id: QS_scalereportJobsCompletedBytesXferred.sp,v 1.1.210.2 2018/03/20 00:01:12 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_scalereportJobsCompletedBytesXferred <<<'

IF EXISTS (select * from sysobjects where name='QS_scalereportJobsCompletedBytesXferred')
	drop procedure QS_scalereportJobsCompletedBytesXferred
IF EXISTS (select * from GxQscripts where name='QS_scalereportJobsCompletedBytesXferred')
	delete from GxQscripts where name = 'QS_scalereportJobsCompletedBytesXferred'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereportJobsCompletedBytesXferred')
	delete from GXDBVersions where aliasname = 'QS_scalereportJobsCompletedBytesXferred'
GO
print '... Creating Procedure: QS_scalereportJobsCompletedBytesXferred'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_scalereportJobsCompletedBytesXferred
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
AS
SET NOCOUNT ON;
CREATE TABLE #perMA ( MediaAgent VARCHAR(50),
					 avg_of_jobsprhr FLOAT(5) null,avg_jobspr24hr FLOAT(5) null,
					 B_perhr FLOAT(5) null, B_per24hr FLOAT(5) null,
				   )
DECLARE @CUR_TIME INT
SET @CUR_TIME = dbo.GetUnixTime(GetUTCDate())
/*
  Report Format:
  ---------------------------------------------------------------------------------------
		MediaAgent, AvgJobs/h, AvgJobs/h, GB/h, GB/h
 ----------------------------------------------------------------------------------------
*/
/*************************A. Count of Jobs completed per hour ***************************
*
*		The table JMBkpStats consists of all the jobs which are completed along with the
*		time at which the job has finished. The table JMJobResourceHistory has a mapping
*		of JobId to the Media Agent Id. Hence applying INNER JOIN over these tables along
*		with the App_Client table gives the name of the MediaAgent along with the jobIds.
*		These are counted over a period of last one hour and twenty four hours to obtain
*		the desired result.
*
****************************************************************************************/
/****************************B. Bytes Transferred per hour ******************************
*
*		The total number of bytes transferred by a job is given by totalUncompBytes
*		column present in the JMBkpStats table. Doing an INNER JOIN JMBkpStats with
*		JMJobResourceHistory gives all the required details like the Job Id, amount
*		of data it has transferred, time it took for transfer and the time at which
*		a job has ended. Since the units of column totalUncompBytes is in Bytes, we
*		divide it with 1024*1024*1024 to get the output in Giga Bytes.The output is
*		grouped by MediaAgent to get the output per Media Agent.
*
****************************************************************************************/
INSERT INTO #perMA
SELECT DISTINCT COALESCE(A.MediaAgent,B.MediaAgent),
	   A.count_of_jobs_hr,A.count_of_jobs_24hr,
	   B.gbytes_per_hr,B.gbytes_per_24hr
FROM
(
/** This Select statement gets the count of jobs/hour in the last one and twenty four hours**/
	SELECT  ab.name AS MediaAgent,
			query1.count_of_jobs_24hr AS count_of_jobs_24hr ,
			query2.count_of_jobs_1hr AS count_of_jobs_hr
	FROM
	(
		SELECT COUNT(DISTINCT b.JobId)/24.0 AS count_of_jobs_24hr, r.ClientId AS client1
    	FROM JMJobResourceHistory r INNER JOIN JMBkpStats b
		ON b.JobId = r.JobId AND b.CommcellId = r.CommcellId
		WHERE (b.servEndDate > ( @CUR_TIME-24*60*60))
		GROUP BY r.ClientId
	) query1 LEFT JOIN
    (
		SELECT COUNT(DISTINCT b.JobId) AS count_of_jobs_1hr, r.ClientId AS client2
    	FROM JMJobResourceHistory r INNER JOIN JMBkpStats b
		ON b.JobId = r.JobId AND b.CommcellId = r.CommcellId
		WHERE (b.servEndDate > ( @CUR_TIME-60*60))
		GROUP BY r.ClientId
	 ) query2 ON query1.client1 = query2.client2,
	 app_client ab
	WHERE ab.id = query1.client1
) A FULL OUTER JOIN
(
/************ This Select is for obtaining the amount of GB transferred *************/
	SELECT ad.name AS MediaAgent,
		   query1.gbytes_per_24hr AS gbytes_per_24hr,
		   query2.gbytes_per_hr AS gbytes_per_hr
	FROM
    (
		SELECT ClientId, SUM(totalUncompBytes)/(1024.0*1024*1024*24) AS gbytes_per_24hr
		FROM JMJobResourceHistory
		WHERE (ReservationTime > ( @CUR_TIME-24*60*60))
		group by ClientId
	) query1 LEFT JOIN
	(
		SELECT ClientId,SUM(totalUncompBytes)/(1024.0*1024*1024) AS gbytes_per_hr
		FROM JMJobResourceHistory
		WHERE (ReservationTime > ( @CUR_TIME-60*60))
		group by ClientId
	) query2 ON query1.clientid = query2.clientid ,
	app_client ad
	WHERE ad.id = query1.clientid
) B ON A.MediaAgent = B.MediaAgent,
app_client ae
ORDER BY  COALESCE(A.MediaAgent,B.MediaAgent)
/******************************** GENERAL REMARKS: **************************************
*
*		In the above script we have used the LEFT and RIGHT joins to combine tables in
*		which there may be chances of the first table to be empty in case of LEFT JOIN
*		and the second TABLE may be empty for RIGHT JOIN cases. The FULL OUTER JOINS are
*		used when there may be chances that any or both the tables can be empty.
*
***************************************************************************************/
DECLARE @MA VARCHAR(50)
DECLARE @JAVGHR FLOAT(5)
DECLARE @JAVG24HR FLOAT(5)
DECLARE @BHR FLOAT(5)
DECLARE @B24HR FLOAT(5)
DECLARE TableCursor CURSOR FOR
SELECT * FROM #perma;
PRINT 'Name'+char(9)+char(9)+'1hour'+char(9)+char(9)+'24hours'+char(9)+char(9)+char(9)+'1hour'+char(9)+char(9)+'24hours'
PRINT ' ';
PRINT 'MAgent'+char(9)+char(9)+'AvgJobs/h'+char(9)+'AvgJobs/h'+char(9)+char(9)+'GB/h'+char(9)+char(9)+'GB/h'
PRINT ' ';
OPEN TableCursor
FETCH NEXT FROM TableCursor INTO @MA, @JAVGHR, @JAVG24HR,@BHR,@B24HR
WHILE @@FETCH_STATUS = 0
BEGIN
PRINT @MA +char(9)+char(9)+CAST( convert(float,round(ISNULL(@JAVGHR,0),2)) AS VARCHAR) + char(9)+char(9)+ CAST( convert(float,round(ISNULL(@JAVG24HR,0),2)) AS VARCHAR) + char(9)+char(9)+char(9)+CAST( convert(float,round(ISNULL(@BHR,0),2)) AS VARCHAR)+ char(9)+char(9)+CAST( convert(float,round(ISNULL(@B24HR,0),2)) AS VARCHAR)
FETCH NEXT FROM TableCursor INTO @MA, @JAVGHR, @JAVG24HR,@BHR,@B24HR
END
CLOSE TableCursor
DEALLOCATE TableCursor
/***************************************************************************************/
--SELECT * FROM perma;
DROP TABLE #perma;
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_scalereportJobsCompletedBytesXferred')
	delete from GxQscripts where name = 'QS_scalereportJobsCompletedBytesXferred'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereportJobsCompletedBytesXferred')
	delete from GXDBVersions where aliasname = 'QS_scalereportJobsCompletedBytesXferred'
GO

insert into GXDBVersions values(2, 'QS_scalereportJobsCompletedBytesXferred',  '00010001021000020000', 'QS_scalereportJobsCompletedBytesXferred', '00010001021000020000')
GO

insert into GxQscripts values(2,'QS_scalereportJobsCompletedBytesXferred',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	QOperation execscript -sn scalereportJobsCompletedBytesXferred.sql'
)
GO

