

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_modifysubclientpolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_modifysubclientpolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_modifysubclientpolicy')
	drop procedure QS_modifysubclientpolicy
IF EXISTS (select * from GxQscripts where name='QS_modifysubclientpolicy')
	delete from GxQscripts where name = 'QS_modifysubclientpolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_modifysubclientpolicy')
	delete from GXDBVersions where aliasname = 'QS_modifysubclientpolicy'
GO
print '... Creating Procedure: QS_modifysubclientpolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_modifysubclientpolicy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @param1 AS NVARCHAR(512) = '',
  @param2 AS NVARCHAR(512) = '',
  @param3 AS NVARCHAR(512) = '',
  @param4 AS NVARCHAR(512) = ''
AS
--convenient defs--
declare @clientgroupid as int
declare @clientgroupname as nvarchar(100)
declare @clientid as int
declare @clientname as nvarchar(100)
declare @apptypeid as int
declare @backupsetid as int
declare @scpid as int
declare @subclientpolicyname as nvarchar(100)
declare @scptype as nvarchar(10)
declare @apptype as int
declare @errorcode as int = 0
declare @errorstring as nvarchar(1000) = 'Successful'
declare @currenttime as int = [dbo].getunixtime(GetUTCDate())
declare @backupsetname as  nvarchar(100)
declare @subclientid as int
declare @instanceid as int
declare @appnumberid as int
declare @dataarchid as int
declare @logarchid as int
declare @reftime as int
declare @modifiedtime as int
declare @scname as nvarchar(100)
declare @scstatus as int
declare @createdtime as int
declare @tempclients table ( clientid int)
declare @tempbackupsets table ( backupsetid int)
--input parameters verification--
if @param1 = '' or @param1 not in (N'associate',N'disassociate')
begin
	set @errorcode = 1
	set @errorstring = 'Error. First Parameter must be associate/disassociate'
	goto args_exit
end
if @param1 = 'associate'
begin
	--1. associate, cg=client group, scp=subclientpolicyname
	--2. associate, c=client, scp=subclientpolicyname
	--3. associate, c=client, b=backupset, scp=subclientpolicyname
	if @param2 not like 'cg=%' and @param2 not like 'c=%'
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Second parameter must be cg= client group name or c=client name'
		goto args_exit
	end
	if(@param2 like 'cg=%' and @param3 not like 'scp=%')
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Second param is client group. Third param must be scp=subclient policy name'
		goto args_exit
	end
	if(@param2 like 'c=%' and @param3 not like 'scp=%' and @param3 not like 'b=%')
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Second param is client. Third param must be scp=subclient policy name or b=backupsetname'
		goto args_exit
	end
	if(@param3 not like 'scp=%' and @param4 not like 'scp=%')
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Subclient policy name must be specified as scp=subclient policy name'
		goto args_exit
	end
	--subclient policy
	if @param3 like 'scp=%'
		set @subclientpolicyname = SUBSTRING(@param3,(LEN('scp=')+1),(LEN(@param3)-LEN('scp=')))
	else
		set @subclientpolicyname = SUBSTRING(@param4,(LEN('scp=')+1),(LEN(@param4)-LEN('scp=')))
	select @scpid = bn.id, @scptype =
		case bp.attrVal
			when '2' then 'Windows'
			when '3' then 'Unix'
			when '4' then 'Netware'
		end
	from app_backupsetname bn inner join APP_BackupSetProp bp
	on bn.id = bp.componentNameId
	where bn.name = @subclientpolicyname and bp.attrName = 'Associated subclient Policy Ida Type' and bp.modified = 0
	if @scpid is null
	begin
		set @errorcode = 1
		set @errorstring = 'Error. subclient policy name ['+@subclientpolicyname +'] not valid'
		goto args_exit
	end
end
else
begin
	--disassociate,c=clientname,b=backupsetname
	if (@param2 not like 'c=%' or @param3 not like 'b=%')
	begin
		set @errorcode = 1
		set @errorstring = 'Error. c=Client name and b=backupset name must be specified'
		goto args_exit
	end
end
if @param2 like 'c=%'
begin
		set @clientname = SUBSTRING(@param2,(LEN('c=')+1),(LEN(@param2)-LEN('c=')))
		set @clientid = ISNULL((select id from APP_Client where name = @CLIENTNAME),0)
		if @clientid = 0
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Invalid client [' + @CLIENTNAME +'] passed'
			goto args_exit
		end
end
if @param3 like 'b=%'
begin
		--a. Filesystem bakcupset
		set @backupsetname = SUBSTRING(@param3,(LEN('b=')+1),LEN(@param3)-LEN('b='))
		set @backupsetid =  isnull((select distinct apl.backupSet
										from app_application apl inner join APP_BackupSetName bnm on bnm.id = apl.backupSet
										where apl.clientid = @clientid and bnm.name = @backupsetname and
										apl.appTypeId IN ( select apptypeid from app_idaname where clientid = @clientid and apptypeid in (select appTypeId  from APP_AppTypeGroupAssoc where appGroupId = 35))),0)
		if @backupsetid = 0
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Invalid backupset [' + @backupsetname +'] passed'
			goto args_exit
		end
end
if @param1 = 'associate'
begin
	--validation of input params--
	--2. Client group name/client name validity
	if @param2 like 'cg=%'
	begin
		set @CLIENTGROUPNAME = SUBSTRING(@param2,(LEN('cg=')+1),(LEN(@param2)-LEN('cg=')))
		set @clientgroupid = ISNULL((select id from APP_ClientGroup where name = @CLIENTGROUPNAME),0)
		if @clientgroupid = 0
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Invalid client group [' + @CLIENTGROUPNAME +'] passed'
			goto args_exit
		end
		--populate tempclients table with clients of this group
		insert into @tempclients (clientid)
				(select distinct clientid
				 from APP_ClientGroupAssoc
				 where clientGroupId = @clientgroupid)
	end
	else
		insert into @tempclients(clientid) values (@clientid)
	if not exists (select * from @tempclients)
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Client group ['+ @clientgroupname +'] has no clients'
		goto args_exit
	end
	--Now in @tempclients table, delete all the clients for which the operatingsystemid is different from the @scptype
	declare clientcursor cursor static for
		select clientid from @tempclients
	open clientcursor
	fetch next from clientcursor into @clientid
	while @@FETCH_STATUS = 0
	begin
		if @scptype <> (select type from simOperatingSystem where id = (select simOperatingSystemId from APP_Client where id= @clientid))
			delete @tempclients where clientid = @clientid
		fetch next from clientcursor into @clientid
	end
	close clientcursor
	deallocate clientcursor
	if not exists (select * from @tempclients)
	begin
		if @param2 like 'c=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Client IDA does not match with subclient Policy type'
			goto args_exit
		end
		else
		begin
			set @errorcode = 1
			set @errorstring = 'Error. No client in the group specified has IDA same as that of subclient policy'
			goto args_exit
		end
	end
	--3. backupset name validity
	declare ccursor cursor static for
		select clientid from @tempclients
	open ccursor
	fetch next from ccursor into @clientid
	while @@FETCH_STATUS = 0
	begin
		if @param3 not like 'b=%'
		begin
			--Insert all the file system backupsets
			insert into @tempbackupsets (backupsetid)
				(select distinct apl.backupSet
				 from app_application apl inner join APP_BackupSetName bnm on bnm.id = apl.backupSet
				 where apl.clientid = @clientid and
					   apl.appTypeId IN ( select apptypeid from app_idaname where clientid = @clientid and apptypeid in (select appTypeId  from APP_AppTypeGroupAssoc where appGroupId = 35)))
		end
		else
			insert into @tempbackupsets (backupsetid) values (@backupsetid)
		fetch next from ccursor into @clientid
	end
	close ccursor
	deallocate ccursor
	if not exists (select * from @tempbackupsets)
	begin
		if @param2 like 'c=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Client has no file system backupsets'
			goto args_exit
		end
		if @param2 like 'cg=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Client group has no client with file system backupsets'
			goto args_exit
		end
	end
	--now form @tempbackupsets table, delete the invalid backupsets,i.e., those with subclient policy associated or those with user defined subclients
	declare bcursor cursor static for
		select backupsetid from @tempbackupsets
	open bcursor
	fetch next from bcursor into @backupsetid
	while @@FETCH_STATUS =0
	begin
		if exists (select * from APP_BackupSetProp where attrName = 'Associated subclient Policy' and componentNameId = @backupsetid and modified = 0) or
		exists (select * from APP_Application where backupSet = @backupsetid and subclientStatus = 0) or
		exists (select * from APP_BackupSetName where id = @backupsetid and ((status & 2 = 2) or (status & 128 = 128) or (status & 16 = 16))) or
		exists (select * from APP_BackupSetProp where componentNameId = @backupsetid and attrName = N'OnDemand Backupset' and attrVal = N'1' and modified = 0)
			delete @tempbackupsets where backupsetid = @backupsetid
		fetch next from bcursor into @backupsetid
	end
	close bcursor
	deallocate bcursor
	if not exists (select * from @tempbackupsets)
	begin
		if @param3 like 'b=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Backupset is either associated with a subclient policy or has user defined subclients or is deconfigured'
			goto args_exit
		end
		if @param2 like 'c=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error.All backupsets of this client are associated with either a subclient policy or has user defined subclients or deconfigured'
			goto args_exit
		end
		if @param2 like 'cg=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. All backupsets of all clients in this group are associated with either a subclient policy or has user defined subclients or deconfigured'
			goto args_exit
		end
	end
	declare backupsetcursor cursor static for
		select backupsetid from @tempbackupsets
	open backupsetcursor
	fetch next from backupsetcursor into @backupsetid
	while @@FETCH_STATUS = 0
	begin
		exec AppAssocSubClientPolicy @backupsetid,@scpid,@currenttime
		set @backupsetname = (select name from app_backupsetname where id = @backupsetid)
		set @clientname = (select name from app_client where id = (select distinct clientid from app_application where backupset = @backupsetid))
		PRINT 'Associated backupset[' + @backupsetname
				+ '] of the client [' + @clientname
				+'] to the subclient policy [' + @subclientpolicyname +']'
		fetch next from backupsetcursor into @backupsetid
	end
end
--disassociation
else
begin
		set @scpid = isnull((select convert(int,attrval) from APP_BackupSetProp where componentNameId = @backupsetid and attrName = N'Associated Subclient Policy' and modified = 0),0)
		if @scpid = 0
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Backupset [' + @backupsetname +']is not associated with any subclient policy'
			goto args_exit
		end
		set @subclientpolicyname = (select name from APP_BackupSetName where id = @scpid )
		--Create the subclient underneath the backupset
		DECLARE	GetSubclientsCursor CURSOR FOR
		SELECT id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus
		FROM APP_Application where backupset = @backupsetId
		OPEN GetSubclientsCursor
		FETCH next from GetSubclientsCursor INTO @subclientId, @ClientId, @AppTypeId ,@instanceId, @backupsetId, @appNumberId, @dataArchId,
									@logArchId, @refTime,   @modifiedTime, @scName, @scStatus
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			set @SCPId = 0
			set @createdTime  = 0
			Select @SCPId = convert(int,attrVal),  @createdTime = created from APP_SubClientProp where componentnameId = @subclientId and attrName = N'Associated subclient Policy' and modified = 0
			if (@SCPId > 0)
			BEGIN
					DECLARE @insertSCfile TABLE (type INTEGER, filename NVarChar(1024), created INTEGER, modified integer)
					DELETE @insertSCfile
					----Insert the subclient content into the associated subclient
 					Insert into @insertSCfile SELECT distinct  type, filename, created, modified from APP_scfilterfile where componentnameId = @SCPId and (modified = 0 OR created > @createdTime)
					update @insertSCfile set created = @createdTime where modified = 0 and created < @createdTime
					----Insert the subclient content into the associated subclient
 					INSERT into App_scfilterFile (componentNameId,type,fileName,created,modified)
						SELECT distinct @subclientId, type, filename, created, modified from @insertSCfile
					DECLARE @insertSCProp TABLE (attrName NVarChar(256), attrTYpe integer,  attrVal nvarchar(1024), created INTEGER, modified integer)
                    DELETE @insertSCProp
 					----Insert the subclient properties into the associated subclient
 					INSERT into @insertSCProp (attrName, attrType, attrVal, created, modified)
						SELECT distinct  attrName, attrType, attrVal, created, modified from APP_subclientprop where componentnameId = @SCPId  and (modified = 0 OR created > @createdTime)
					update @insertSCProp set created = @createdTime where modified = 0 and created < @createdTime
					/*****************************************************************************************************************
					If the properties are transferred to a 9.0 client, check for the property - Use VSS Options and Use VSS Enabled
					Based on these set the value Use Shadow Copy - Need to be removed once 9.0 is obsoleted'
					If Use VSS Enabled is 1 then set Use Shadow Copy to 1
					******************************************************************************************************************/
					IF (SELECT releaseId FROM APP_Client WHERE id = @ClientId) < 15
					BEGIN
						/*IF EXISTS (SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Enabled' AND modified = 0 AND attrVal = '0')
						BEGIN
							--Use VSS check box property is disabled. So 'Use shadow copy' is off irrespective of the 'Use VSS Options'
							UPDATE @insertSCProp
							SET attrName = 'Use Shadow Copy', attrType = '2', attrVal = '0'
							WHERE attrName = 'Use VSS Enabled' AND modified = 0
						END
						IF EXISTS (SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Enabled' AND modified = 0 AND attrVal = '1')
						BEGIN
							IF EXISTS (SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Options' AND modified = 0 AND attrVal = '1')
							BEGIN
								--Use Shadow Copy has been selected explicitly
								UPDATE @insertSCProp
								SET attrName = 'Use Shadow Copy', attrType = '2', attrVal = '1'
								WHERE attrName = 'Use VSS Options' AND modified = 0
							END
							ELSE IF NOT EXISTS(SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Options')
							BEGIN
								--By default also, if 'Use VSS Enabled' then 'Use For all files' is ON, meaning 'Use Shadow Copy' is ON
								UPDATE @insertSCProp
								SET attrName = 'Use Shadow Copy', attrType = '2', attrVal = '1'
								WHERE attrName = 'Use VSS Enabled' AND modified = 0
							END
							ELSE IF EXISTS (SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Options' AND modified = 0 AND attrVal <> '1')
							BEGIN
								--Some other value has been selected, with 'Use VSS Enabled' on, so Use shadow copy is off
								UPDATE @insertSCProp
								SET attrName = 'Use Shadow Copy', attrType = '2', attrVal = '0'
								WHERE attrName = 'Use VSS Options' AND modified = 0
							END
						END*/
						UPDATE @insertSCProp
						SET attrName = 'Use Shadow Copy'
						WHERE attrName = 'Use VSS Enabled' AND modified = 0
						--If Use VSS Enabled does not exist, then no need to do any change. Use Shadow Copy will be OFF by default.
						DELETE FROM @insertSCProp
						WHERE (attrName = 'Use VSS Enabled' OR attrName = 'Use VSS Options')
					END
					/***********************************************************************************************************************************/
 					Insert into APP_subclientProp(componentNameId,attrName,attrType,attrVal,created,modified)
						SELECT distinct @subclientId, attrName, attrType, attrVal, created, modified from @insertSCProp
					Update APP_SubClientProp set modified = @currenttime where componentnameId = @subclientid  and attrName = N'Associated subclient Policy' and modified = 0
			END
			FETCH next from GetSubclientsCursor INTO @subclientId, @ClientId, @AppTypeId ,@instanceId, @backupsetId, @appNumberId, @dataArchId,
									@logArchId, @refTime,   @modifiedTime, @scName, @scStatus
		END
		CLOSE GetSubclientsCursor
		DEALLOCATE GetSubclientsCursor
		--Remove the association in backupset prop
		Update APP_BackupSetProp set modified = @currenttime where componentnameId = @backupsetid  and attrName = N'Associated subclient Policy' and modified = 0
		PRINT 'Disassociated backupset ['+ @backupsetname +'] of client [' + @clientname + '] from subclient policy [' + @subclientpolicyname +'].'
END
args_exit:
delete @tempclients
delete @tempbackupsets
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_modifysubclientpolicy')
	delete from GxQscripts where name = 'QS_modifysubclientpolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_modifysubclientpolicy')
	delete from GXDBVersions where aliasname = 'QS_modifysubclientpolicy'
GO

insert into GXDBVersions values(2, 'QS_modifysubclientpolicy',  '00000000000000000000', 'QS_modifysubclientpolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_modifysubclientpolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	For Association
'
 + CHAR(10) + '	qoperation execscript -sn modifysubclientpolicy -si associate -si cg=client_group_name -si scp=subclient_policy_name
'
 + CHAR(10) + '	qoperation execscript -sn modifysubclientpolicy -si associate -si c=client_name -si scp=subclient_policy_name
'
 + CHAR(10) + '	qoperation execscript -sn modifysubclientpolicy -si associate -si c=client_name -si b=backupsetname -si scp=subclient_policy_name
'
 + CHAR(10) + '	For disassociation
'
 + CHAR(10) + '	qoperation execscript -sn modifysubclientpolicy -si disassociate -si c=client_name -si b=backupsetname 
'
 + CHAR(10) + '-- 	script_name: modifysubclientpolicy'
 + CHAR(10) + '-- 	Associate or disassociate a subclient policy to backupset(s)'
)
GO

