

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_modifySubclientAssociationsForCopy.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_modifySubclientAssociationsForCopy')
BEGIN
	print '>>> Drop Stored Procedure: QS_modifySubclientAssociationsForCopy <<<'
	drop procedure QS_modifySubclientAssociationsForCopy
END
IF EXISTS (select * from GxQscripts where name='QS_modifySubclientAssociationsForCopy')
	delete from GxQscripts where name = 'QS_modifySubclientAssociationsForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_modifySubclientAssociationsForCopy')
	delete from GXDBVersions where aliasname = 'QS_modifySubclientAssociationsForCopy'
GO
print '... Creating Procedure: QS_modifySubclientAssociationsForCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_modifySubclientAssociationsForCopy
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
-- Stored Procedure Inputs
  @enableParam Nvarchar(1024) ='',
  @spParam Nvarchar(1024) ='',
  @copyParam Nvarchar(1024) = '',
  @clientParam Nvarchar(1024) = '',
  @appTypeParam Nvarchar(1024) = '',
  @instanceParam Nvarchar(1024) = '',
  @backupSetParam Nvarchar(1024) = '',
  @subClientParam Nvarchar(1024) = ''
AS
DECLARE @enableOption			AS VARCHAR(10) ='e='
DECLARE @spOption AS VARCHAR(10) ='sp='
DECLARE @copyOption			AS VARCHAR(10) ='c='
DECLARE @clientOption			AS VARCHAR(10) ='cl='
DECLARE @clientGroupOption			AS VARCHAR(10) ='cg='
DECLARE @apptypeOption			AS VARCHAR(32) ='a='
DECLARE @instanceOption			AS VARCHAR(32) ='i='
DECLARE @backupsetOption		AS VARCHAR(32) ='b='
DECLARE @subclientOption		AS VARCHAR(32) ='s='
--INput variables
DECLARE @i_enablestring VARCHAR(1024)
DECLARE @i_enableOption SMALLINT
DECLARE @i_copyName NVARCHAR(1024)
DECLARE @i_copyId INT
DECLARE @l_sourceCopyId INT
DECLARE @i_spName NVARCHAR(1024)
DECLARE @i_spId INT
DECLARE @i_clientGroupName NVARCHAR(1024)
DECLARE @i_clientGroupId INT
DECLARE @i_clientName NVARCHAR(1024)
DECLARE @i_clientId INT
DECLARE @i_appTypeName NVARCHAR(1024)
DECLARE @i_appTypeId INT
DECLARE @i_instanceName NVARCHAR(1024)
DECLARE @i_instanceId INT
DECLARE @i_backupSetName NVARCHAR(1024)
DECLARE @i_backupSetId INT
DECLARE @i_subClientName NVARCHAR(1024)
DECLARE @i_subClientId INT
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'QS_modifySubclientAssociationsForCopy'
DECLARE @errorString	varchar(512)
SET		@errorString	='Error Encountered when running script.'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @countRows INT
SET @countRows=0
DECLARE @noOfclientsToArchGroup INT
declare @noOfAppTypesToArchGroup INT
declare @noOfInstancesToArchGroup INT
declare @noOfBackupsetsToArchGroup INT
declare @noOfSubclientsToArchGroup INT
DECLARE @retCode	integer = 0
set @noOfclientsToArchGroup=0
set @noOfAppTypesToArchGroup =0
set @noOfInstancesToArchGroup =0
set @noOfBackupsetsToArchGroup=0
set @noOfSubclientsToArchGroup=0
set @i_enableOption=0
set @i_copyId=0
set @i_spId=0
set @i_clientGroupId = 0
set @i_clientId=0
set @i_appTypeId =-1
set @i_instanceId =-1
set @i_backupSetId =-1
set @i_subClientId =-1
set @i_appTypeName=''
set @i_clientName=''
set @i_copyName=''
set @i_spName=''
set @i_instanceName=''
set @i_backupSetName=''
set @i_subClientName=''
set @i_clientGroupName = ''
BEGIN TRAN
--Enable param
IF (@enableParam= @NoParameter)
				BEGIN
						SET @lastError = 1
	SET @errorString = 'Error: Missing parameter, please provide an operation to perform -si "e=enable|e=disable"'
						GOTO SCRIPT_EXIT
				END
ELSE IF (SUBSTRING(@enableParam, 1, 2)= @enableOption )
BEGIN
	SET @i_enablestring= (SELECT SUBSTRING(@enableParam, 3, LEN(@enableParam)-2))
	if (@i_enablestring='enable' )
		BEGIN
		set @i_enableOption=1
		END
	else if (@i_enablestring='disable')
		BEGIN
		set @i_enableOption=2
		END
	else if (@i_enablestring='exclude')
		BEGIN
		set @i_enableOption=4
		END
	else
		BEGIN
		SET @lastError = 1
		SET @errorString = 'Error: Invalid option [' + @enableParam + '], please provide an operation to perform -si "e=enable|e=disable"'
						GOTO SCRIPT_EXIT
		END
END
ELSE
	BEGIN
		SET @lastError = 1
	SET @errorString = 'Error: Invalid option [' + @enableParam + '], please provide an operation to perform -si "e=enable|e=disable"'
						GOTO SCRIPT_EXIT
	END
--Storage Policy Param
if (@spParam	=@NoParameter)
	BEGIN
						SET @lastError = 1
	SET @errorString = 'Error: Missing parameter, please provide storage policy name -si "sp=storagepolicyname"'
						GOTO SCRIPT_EXIT
	END
ELSE IF (SUBSTRING(@spParam, 1, 3) = @spOption )
	BEGIN
		SET @i_spName  = (SELECT SUBSTRING(@spParam, 4, LEN(@spParam)-3))
		IF  EXISTS (select top 1  id from archGroup where  name = @i_spName )
									BEGIN
									set @i_spId =(select top 1  id from archGroup where name =@i_spName )
									END
		ELSE
			BEGIN
		SET @lastError = 2
		SET @errorString = 'Error: Invalid storage policy ['+ case when @i_spName is not null and len(@i_spName)>0 then @i_spName else '' end + ']'
						GOTO SCRIPT_EXIT
			END
	END
ELSE
	BEGIN
		SET @lastError = 1
	SET @errorString = 'Error: Invalid option [' + @spParam + '], please provide storage policy name -si "sp=storagepolicyname"'
						GOTO SCRIPT_EXIT
	END
--Copy Param
IF (@copyParam= @NoParameter)
BEGIN
						SET @lastError = 1
	SET @errorString = 'Error: Missing parameter, please provide copy name -si "c=copy name"'
						GOTO SCRIPT_EXIT
END
ELSE IF (SUBSTRING(@copyParam, 1, 2) = @copyOption )
BEGIN
	SET @i_copyName  = (SELECT SUBSTRING(@copyParam, 3, LEN(@copyParam)-2))
	IF EXISTS(select top 1 id from archGroupCopy where name=@i_copyName and archGroupId = @i_spId )
	BEGIN
			set @i_copyId =(select top 1 id from archGroupCopy where name=@i_copyName and archGroupId = @i_spId )
			IF EXISTS(select top  1 defaultCopy from archgroup where @i_copyId =defaultCopy)
			BEGIN
				SET @lastError = 2
				SET @errorString = 'Error: This operation is not supported for primary copy, please provide another copy'
				GOTO SCRIPT_EXIT
			END
	END
	ELSE
	BEGIN
		SET @lastError = 2
		SET @errorString = 'Error: Invalid storage policy copy ['+case when @i_copyName is not null and len (@i_copyName)>0 then @i_copyName else '' end +']'
		GOTO SCRIPT_EXIT
	END
END
ELSE
BEGIN
	SET @lastError = 1
	SET @errorString = 'Error: Order of inputs is invalid, please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
CHECK_CLIENT:
--SELECT @extendedFlags = extendedFlags FROM archGroupCopy where id = @i_copyId
IF (@clientParam= @NoParameter)
BEGIN
		GOTO START_MODIFYING_ROWS
END
IF (SUBSTRING(@clientParam, 1, 3) = @clientGroupOption )
BEGIN
	SET @i_clientGroupName= (SELECT SUBSTRING(@clientParam, 4, LEN(@clientParam)-3))
	IF  EXISTS (select top 1  id from APP_ClientGroup where name = @i_clientGroupName )
	BEGIN
		set @i_clientGroupId =(select top 1  id from APP_ClientGroup where name = @i_clientGroupName)
		GOTO CHECK_APP
	END
	ELSE
	BEGIN
		SET @lastError = 2
		SET @errorString = 'Error: Invalid client group ['+case when @i_clientGroupName is not null and len(@i_clientGroupName)>0 then @i_clientGroupName else '' end +']'
		GOTO SCRIPT_EXIT
	END
END
ELSE IF (SUBSTRING(@clientParam, 1, 3) = @clientOption )
BEGIN
	SET @i_clientName  = (SELECT SUBSTRING(@clientParam, 4, LEN(@clientParam)-3))
	IF  EXISTS (select top 1  id from APP_Client where name = @i_clientName )
	BEGIN
		set @i_clientId =(select top 1  id from APP_Client where name = @i_clientName)
		GOTO CHECK_APP
	END
	ELSE
	BEGIN
		SET @lastError = 2
		SET @errorString = 'Error: Invalid client ['+case when @i_clientName is not null and len(@i_clientName)>0 then @i_clientName else '' end +']'
		GOTO SCRIPT_EXIT
	END
END
ELSE
BEGIN
	SET @lastError = 1
	SET @errorString = 'Error: Order of inputs is invalid, please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
CHECK_APP:
IF (@appTypeParam= @NoParameter)
BEGIN
		GOTO START_MODIFYING_ROWS
END
IF (SUBSTRING(@appTypeParam, 1, 3) = @clientOption )
BEGIN
	SET @i_clientName  = (SELECT SUBSTRING(@appTypeParam, 4, LEN(@appTypeParam)-3))
	IF  EXISTS (select top 1  id from APP_Client where name = @i_clientName )
	BEGIN
		set @i_clientId =(select top 1  id from APP_Client where name = @i_clientName)
	END
	ELSE
	BEGIN
		SET @lastError = 2
		SET @errorString = 'Error: Invalid client ['+case when @i_clientName is not null and len(@i_clientName)>0 then @i_clientName else '' end +']'
		GOTO SCRIPT_EXIT
	END
	IF NOT EXISTS (SELECT 1 FROM app_ClientGroupAssoc WHERE @i_clientGroupId = clientGroupID AND @i_clientID = clientId)
	BEGIN
		SET @lastError = 2
		SET @errorString = 'Error: client ['+case when @i_clientName is not null and len(@i_clientName)>0 then @i_clientName else '' end +'] is not a part of clientGroup ['+case when @i_clientGroupName is not null and len(@i_clientGroupName)>0 then @i_clientGroupName else '' end +']'
		GOTO SCRIPT_EXIT
	END
	GOTO START_MODIFYING_ROWS
END
ELSE IF (SUBSTRING(@appTypeParam, 1, 2) = @apptypeOption )
BEGIN
	SET @i_appTypeName = (SELECT SUBSTRING(@appTypeParam, 3, LEN(@appTypeParam)-2))
	-- Some apptype macros are removed so need to update this one
	select @i_appTypeId  =CASE @i_appTypeName
WHEN 'Q_WINDOWS_FS'THEN 33
WHEN 'Q_WINDOWS_FS_64'THEN 34
WHEN 'Q_WINNET_FS'THEN 42
WHEN 'Q_WINNET_FS_64'THEN 43
WHEN 'Q_SHAREPOINT_SERVER'THEN 78
WHEN 'Q_SHAREPOINT_SERVER'THEN 69
WHEN 'Q_MSEXCH_MB'THEN 54
WHEN 'Q_MSEXCH_DB'THEN 53
WHEN 'Q_MSEX_WEB'THEN 55
WHEN 'Q_MSEX_MIG'THEN 56
WHEN 'Q_MSEX_PUB'THEN 35
WHEN 'Q_FS'THEN 1
WHEN 'Q_WIN2K_FS'THEN 11
WHEN 'Q_NETWARE_FS'THEN 12
WHEN 'Q_HPUX64_FS'THEN 18
WHEN 'Q_SOLARIS64_FS'THEN 20
WHEN 'Q_AIX_FS'THEN 21
WHEN 'Q_HPUX_FS'THEN 17
WHEN 'Q_SOLARIS_FS'THEN 19
WHEN 'Q_LINUX_FS'THEN 29
WHEN 'Q_WINXP32_FS'THEN 33
WHEN 'Q_WINXP64_FS'THEN 34
WHEN 'Q_TRU64_FS_64'THEN 36
WHEN 'Q_TRU64_FS_32'THEN 38
WHEN 'Q_WINNET32_FS'THEN 42
WHEN 'Q_WINNET64_FS'THEN 43
WHEN 'Q_MAC_FS'THEN 63
WHEN 'Q_SGI_FS'THEN 64
WHEN 'Q_FREEBSD_FS'THEN 74
WHEN 'Q_WINFS_MIG'THEN 58
WHEN 'Q_UNIXFS_MIG'THEN 66
WHEN 'Q_ORACLE'THEN 22
WHEN 'Q_DB2'THEN 37
WHEN 'Q_UNIX_DB2'THEN 62
WHEN 'Q_INFORMIX'THEN 3
WHEN 'Q_MSSQLSERVER'THEN 4
WHEN 'Q_MSSQL_2K'THEN 16
WHEN 'Q_MSSQL_YUKON'THEN 70
WHEN 'Q_MSSQL'THEN 81
WHEN 'Q_SYBASE'THEN 5
WHEN 'Q_MSEX_MB'THEN 8
WHEN 'Q_MSEX2K_MB'THEN 14
WHEN 'Q_MSEX2003_MB'THEN 54
WHEN 'Q_MSEX_DB'THEN 9
WHEN 'Q_MSEX2K_DB'THEN 15
WHEN 'Q_MSEX2003_DB'THEN 53
WHEN 'Q_MSEX55_PUB'THEN 35
WHEN 'Q_MSEX2K_WEB'THEN 44
WHEN 'Q_MSEX2003_WEB'THEN 55
WHEN 'Q_MSEX_ARCH'THEN 67
WHEN 'Q_MSEX55_ARCH'THEN 68
WHEN 'Q_MSEX2K_MIG'THEN 45
WHEN 'Q_MSEX2003_MIG'THEN 56
WHEN 'Q_MSEX55_MIG'THEN 57
WHEN 'Q_LOTUS_DB'THEN 6
WHEN 'Q_LOTUS_UNIX_DB'THEN 51
WHEN 'Q_LOTUS_DOMINO_DB'THEN 59
WHEN 'Q_LOTUS6_DB'THEN 77
WHEN 'Q_LOTUS_DOC'THEN 7
WHEN 'Q_LOTUS_UNIX_DOC'THEN 52
WHEN 'Q_LOTUS_DOMINO_DOC'THEN 60
WHEN 'Q_SHAREPOINT_DB'THEN 69
WHEN 'Q_SHAREPOINT_DOC'THEN 78
WHEN 'Q_GROUPWISE'THEN 71
WHEN 'Q_NDS'THEN 10
WHEN 'Q_SDM_WIN2K'THEN 24
WHEN 'Q_SDM_UNIX'THEN 48
WHEN 'Q_SAP_ORADB'THEN 61
WHEN 'Q_SAP_SAPDB'THEN 79
WHEN 'Q_PROXYHOST'THEN 25
WHEN 'Q_PROXYHOST_UNIX'THEN 40
WHEN 'Q_ACTIVEDIR'THEN 41
WHEN 'Q_IMAGELEVEL_WIN'THEN 65
WHEN 'Q_IMAGELEVEL_UNIX'THEN 75
WHEN 'Q_IMAGELEVEL_PROXY'THEN 76
WHEN 'Q_NETSTORAGE_MIG'THEN 73
WHEN 'Q_NAS'THEN 13
WHEN 'Q_REPLICATION'THEN 47
WHEN 'Q_REPLICATION_UNIX'THEN 50
WHEN 'Q_MSEXPF_MIG'THEN 82
WHEN 'Q_ORACLE_RAC'THEN 80
WHEN 'Q_NETWARE_MIG'THEN 83
WHEN 'Q_FILE_REPLICATION'THEN 84
WHEN 'Q_DATA_CLASSIFICATION'THEN 85
WHEN 'Q_NETWARE_LINUX'THEN 86
WHEN 'Q_PROXYHOST_IMAGE_UNIX'THEN 87
WHEN 'Q_CENTERA'THEN 88
WHEN 'Q_SHAREPOINT_ARCH'THEN 89
WHEN 'Q_LOTUS_DOC_MIG'THEN 90
WHEN 'Q_DPM_AGENT'THEN 91
WHEN 'Q_DB2_DPF'THEN 103
WHEN 'Q_MYSQL'THEN 104
WHEN 'Q_VIRTUAL_SERVER'THEN 106
			ELSE -1
		END
	if (@i_appTypeId=-1)
	BEGIN
		set @i_appTypeId=ISNULL((select  distinct  top 1 A.appTypeId from app_application A  inner join
		(select type ,name from APP_iDAType where name  = @i_appTypeName ) AS B on B.type = A.appTypeId
			where a.clientId = @i_clientId),-1)
	END
	if EXISTS (select 1 from app_application where apptypeId= @i_appTypeId and clientId=@i_clientId and @i_appTypeId <>-1)
		GOTO CHECK_INSTANCE
	ELSE
	BEGIN
		SET @lastError = 2
		SET @errorString	='Error: Invalid Agent ['+ case when @i_appTypeName is not null and len(@i_appTypeName) >0 then @i_appTypeName else '' end +']'
		GOTO SCRIPT_EXIT
	END
END
ELSE IF (SUBSTRING(@appTypeParam, 1, 2) = @instanceOption )
BEGIN
	SET @i_instanceName = (SELECT SUBSTRING(@appTypeParam, 3, LEN(@appTypeParam)-2))
	SET @countRows=(select count (distinct b.instance) from APP_InstanceName A
									inner join app_application B on a.id=b.instance
								where a.name =@i_instanceName and b.clientId=@i_clientId)
	if (@countRows >1)
	BEGIN
		SET @lastError = 1
		SET @errorString	='Error: Conflict in finding the instance, more than one instance has same name ['+@i_instanceName+'] for given client ['+@i_clientName+'], please provide client, agent and instance to resolve the conflict'
		GOTO SCRIPT_EXIT
	END
	ELSE IF (@countRows =0)
	BEGIN
		SET @lastError = 2
		SET @errorString	='Error: Invalid instance ['+@i_instanceName+']'
		GOTO SCRIPT_EXIT
	END
	Else
		BEGIN
		set @i_instanceId= (select distinct b.instance from APP_InstanceName A
									inner join app_application B on a.id=b.instance
							where a.name =@i_instanceName and b.clientId=@i_clientId)
		set @i_appTypeId						= (select top 1  appTypeId from app_application where instance=@i_instanceId
							and clientId=@i_clientId)
		GOTO CHECK_INSTANCE
		END
END
ELSE IF (SUBSTRING(@appTypeParam, 1, 2) = @backupsetOption )
	BEGIN
			SET @i_backupSetName =( SELECT SUBSTRING(@appTypeParam, 3, LEN(@appTypeParam)-2))
			SET @countRows=(select count (distinct b.backupSet) from APP_BackupSetName A
 										inner join app_application B on a.id=b.backupSet
								where a.name =@i_backupSetName and b.clientId=@i_clientId)
		if (@countRows >1)
			BEGIN
						SET @lastError = 1
		SET @errorString	='Error: Conflict in finding the backup set, more than one backup set has same name ['+@i_backupSetName+'] for given client ['+@i_clientName+'], please provide client, agent [,instance] to resolve the conflict'
						GOTO SCRIPT_EXIT
			END
		Else if (@countRows =0)
			BEGIN
		SET @lastError = 2
		SET @errorString	='Error: Invalid backup set ['+@i_backupSetName+']'
						GOTO SCRIPT_EXIT
			END
		Else
			BEGIN
				set @i_backupSetId=(select distinct b.backupSet from APP_BackupSetName A
 										inner join app_application B on a.id=b.backupSet
								where a.name =@i_backupSetName and b.clientId=@i_clientId)
 				set @i_instanceId=(select top 1 instance from app_application  where backupSet=@i_backupSetId and
								clientId=@i_clientId)
 					set @i_appTypeId						=(select  top 1 appTypeId from
 										app_application where backupSet=@i_backupSetId and
								clientId=@i_clientId and instance=@i_instanceId )
 			GOTO CHECK_INSTANCE
 			END
 	END
ELSE IF (SUBSTRING(@appTypeParam, 1, 2) = @subclientOption )
	BEGIN
			SET @i_subClientName = (SELECT SUBSTRING(@appTypeParam, 3, LEN(@appTypeParam)-2))
	SET @countRows=(select count (distinct id) from APP_Application where subClientName=@i_subClientName and clientId=@i_clientId)
		if (@countRows >1)
			BEGIN
						SET @lastError = 1
		SET @errorString	='Error: Conflict in finding the subclient, more than one subclient has same name ['+@i_subClientName+'] for given client ['+@i_clientName+'], please provide client, agent [,instance] ,backupset to resolve the conflict'
						GOTO SCRIPT_EXIT
			END
		Else if (@countRows =0)
			BEGIN
		SET @lastError = 2
		SET @errorString	='Error: Invalid subclient ['+@i_subClientName+']'
						GOTO SCRIPT_EXIT
			END
		Else
			BEGIN
				set @i_subClientId=(select top 1 id from APP_Application where subClientName=@i_subClientName and clientId=@i_clientId)
				set @i_backupSetId=(select top 1 backupset from APP_Application where id=@i_subClientId)
				set @i_instanceId=(select top 1 instance from APP_Application where  id=@i_subClientId)
				set @i_appTypeId=(select top 1 appTypeId from APP_Application where  id=@i_subClientId)
				GOTO START_MODIFYING_ROWS
			END
	END
ELSE
	BEGIN
				SET @lastError = 1
	SET @errorString = 'Error: Invalid option ['+@appTypeParam+'], please refer to the readme file and retry with necessary parameters'
				GOTO SCRIPT_EXIT
		END
CHECK_INSTANCE:
IF (@instanceParam= @NoParameter)
	GOTO START_MODIFYING_ROWS
IF (SUBSTRING(@instanceParam, 1, 2) = @instanceOption )
	BEGIN
		SET @i_instanceName =( SELECT SUBSTRING(@instanceParam, 3, LEN(@instanceParam)-2))
		set @i_instanceId=ISNULL((select top 1  A.id from app_instanceName A
						inner join APP_Application B on a.id = B.instance
						where B.appTypeId = @i_appTypeId and B.clientId = @i_clientId and A.name=@i_instanceName ),-1)
			IF(@i_instanceId<>-1)
						GOTO CHECK_BACKUPSET
			ELSE
				BEGIN
	SET @lastError = 2
	SET @errorString	='Error: Invalid instance ['+@i_instanceName+']'
						GOTO SCRIPT_EXIT
				END
	END
ELSE IF (SUBSTRING(@instanceParam, 1, 2) = @backupsetOption )
	BEGIN
		set @i_backupSetName=(SELECT SUBSTRING(@instanceParam, 3, LEN(@instanceParam)-2))
		if (@i_backupSetId <> -1 or @i_subClientId <>-1)
			BEGIN
					SET @lastError = 1
		SET @errorString = 'Error: Order of inputs is invalid, please refer to the readme file and retry with necessary parameters'
							GOTO SCRIPT_EXIT
			END
		else
			BEGIN
				if (@i_instanceId<>-1)
					BEGIN
						SET @countRows= (select  count (distinct b.backupSet) from APP_BackupSetName A
 						inner join app_application B on a.id=b.backupSet
 						where a.name =@i_backupSetName and b.clientId= @i_clientId  and b.appTypeId= @i_appTypeId and  b.instance=@i_instanceId )
 						IF (@countRows>1)
 							BEGIN
 								SET @lastError = 1
					SET @errorString	='Error: Conflict in finding the backup set, more than one backup set has same name ['+@i_backupSetName+'] for given client ['+@i_clientName+'], please provide client, agent [,instance] to resolve the conflict'
								GOTO SCRIPT_EXIT
 							END
 						ELSE IF (@countRows=0)
 							BEGIN
					SET @lastError = 2
					SET @errorString	='Error: Invalid backup set ['+@i_backupSetName+']'
								GOTO SCRIPT_EXIT
 							END
 						ELSE
 							BEGIN
 							set	@i_backupSetId=(select distinct b.backupSet from APP_BackupSetName A
 															inner join app_application B on a.id=b.backupSet
 															where a.name =@i_backupSetName and b.clientId=@i_clientId and b.appTypeId=@i_appTypeId and b.instance=@i_instanceId )
 								GOTO CHECK_BACKUPSET
 							END
					 END
				else
					BEGIN
						SET @countRows= (select  count (distinct b.backupSet) from APP_BackupSetName A
 						inner join app_application B on a.id=b.backupSet
 						where a.name =@i_backupSetName and b.clientId= @i_clientId  and b.appTypeId= @i_appTypeId )
 						IF (@countRows>1)
 							BEGIN
 								SET @lastError = 1
					SET @errorString	='Error: Conflict in finding the backup set, more than one backup set has same name ['+@i_backupSetName+'] for given client ['+@i_clientName+'], please provide client, agent [,instance] to resolve the conflict'
								GOTO SCRIPT_EXIT
 							END
 						ELSE IF (@countRows=0)
 							BEGIN
					SET @lastError = 2
					SET @errorString	='Error: Invalid backup set ['+@i_backupSetName+']'
								GOTO SCRIPT_EXIT
 							END
 						ELSE
 							BEGIN
 								set @i_backupSetId=(select distinct b.backupSet from APP_BackupSetName A
 															inner join app_application B on a.id=b.backupSet
 															where a.name =@i_backupSetName and b.clientId=@i_clientId and b.appTypeId=@i_appTypeId  )
 								set @i_instanceId = (select distinct instance from app_application where backupSet=@i_backupSetId and
 															clientId=@i_clientId and appTypeId=@i_appTypeId )
 								GOTO CHECK_BACKUPSET
 							END
					END
			END
	END
ELSE IF (SUBSTRING(@instanceParam, 1, 2)= @subclientOption )
	BEGIN
		set @i_subClientName=(SELECT SUBSTRING(@instanceParam, 3, LEN(@instanceParam)-2))
		if (@i_subClientId<>-1)
		BEGIN
			SET @lastError = 1
							SET @errorString = 'Error: Duplicate subclient option ['+@instanceParam+'], this option is given more than one time'
							GOTO SCRIPT_EXIT
		END
		else if (@i_backupSetId<>-1)
			BEGIN
			SET @countRows=(select COUNT (distinct id) from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and appTypeId=@i_appTypeId and instance=@i_instanceId and backupSet=@i_backupSetId )
			IF (@countRows>1)
							BEGIN
								SET @lastError = 1
								SET @errorString	='Error: Conflict in finding the subclient, more than one subclient has same name ['+@i_subClientName+'] for given client ['+@i_clientName+'], please provide client, agent [,instance] ,backupset to resolve the conflict'
								GOTO SCRIPT_EXIT
							END
						ELSE IF (@countRows=0)
							BEGIN
								SET @lastError = 2
								SET @errorString	='Error: Invalid subclient ['+@i_subClientName+']'
								GOTO SCRIPT_EXIT
							END
						ELSE
							BEGIN
							set @i_subClientId= (select distinct id from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and appTypeId=@i_appTypeId and instance=@i_instanceId and backupSet=@i_backupSetId )
							GOTO START_MODIFYING_ROWS
							END
		END
		else if(@i_instanceId<>-1)
		BEGIN
			SET @countRows=(select COUNT (distinct id) from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and appTypeId=@i_appTypeId and instance=@i_instanceId )
			IF (@countRows>1)
						BEGIN
							SET @lastError = 1
							SET @errorString	='Error: Conflict in finding the subclient, more than one subclient has same name ['+@i_subClientName+'] for given client ['+@i_clientName+'], please provide client, agent [,instance] ,backupset to resolve the conflict'
							GOTO SCRIPT_EXIT
						END
			ELSE IF (@countRows=0)
						BEGIN
							SET @lastError = 2
							SET @errorString	='Error: Invalid subclient ['+@i_subClientName+']'
							GOTO SCRIPT_EXIT
						END
			ELSE
						BEGIN
						set @i_backupSetId=(select distinct backupset from APP_Application where subClientName= @i_subClientName  and clientId=@i_clientId and appTypeId=@i_appTypeId and instance=@i_instanceId )
						set @i_subClientId= (select distinct id from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and appTypeId=@i_appTypeId and instance=@i_instanceId )
						GOTO START_MODIFYING_ROWS
						END
		END
		else
		BEGIN
			SET @countRows=(select COUNT (distinct id) from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and appTypeId=@i_appTypeId)
			IF (@countRows>1)
						BEGIN
							SET @lastError = 1
							SET @errorString	='Error: Conflict in finding the subclient, more than one subclient has same name ['+@i_subClientName+'] for given client ['+@i_clientName+'], please provide client, agent [,instance] ,backupset to resolve the conflict'
							GOTO SCRIPT_EXIT
						END
			ELSE IF (@countRows=0)
						BEGIN
							SET @lastError = 2
							SET @errorString	='Error: Invalid subclient ['+@i_subClientName+']'
							GOTO SCRIPT_EXIT
						END
			ELSE
						BEGIN
						set @i_backupSetId= (select distinct backupSet from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and  appTypeId=@i_appTypeId )
						set @i_instanceId=(select distinct instance from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and  appTypeId=@i_appTypeId )
						set @i_subClientId= (select distinct id from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and  appTypeId=@i_appTypeId  )
						GOTO START_MODIFYING_ROWS
						END
		END
	END
ELSE
	BEGIN
	SET @lastError = 1
	SET @errorString = 'Error: Invalid option ['+@instanceParam+'], please refer to the readme file and retry with necessary parameters'
				GOTO SCRIPT_EXIT
	END
CHECK_BACKUPSET:
IF (@backupSetParam= @NoParameter)
	GOTO START_MODIFYING_ROWS
IF (SUBSTRING(@backupSetParam , 1, 2) = @backupsetOption )
	BEGIN
		SET @i_backupSetName = (SELECT SUBSTRING(@backupSetParam , 3, LEN(@backupSetParam )-2))
		set @i_backupSetId = isnull((select top 1  A.id from APP_BackupSetName A
						inner join APP_Application B on a.id = B.backupSet
						where B.appTypeId = @i_appTypeId and B.clientId = @i_clientId and b.instance = @i_instanceId and A.name=@i_backupSetName),-1)
		IF @i_backupSetId <> -1
				GOTO CHECK_SUBCLIENT
		ELSE
		BEGIN
			SET @lastError = 2
			SET @errorString	='Error: Invalid backup set ['+@i_backupSetName+']'
			GOTO SCRIPT_EXIT
		END
	END
ELSE IF (SUBSTRING(@backupSetParam , 1, 2 )= @subclientOption)
	BEGIN
		if (@i_backupSetId<>-1)
		BEGIN
				set @i_subClientName=(SELECT SUBSTRING(@backupSetParam, 3, LEN(@backupSetParam)-2))
		SET @countRows=(select COUNT (distinct id) from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and appTypeId=@i_appTypeId and instance=@i_instanceId and backupSet=@i_backupSetId )
		IF (@countRows>1)
						BEGIN
							SET @lastError = 1
							SET @errorString	='Error: Conflict in finding the subclient, more than one subclient has same name ['+@i_subClientName+'] for given client ['+@i_clientName+'], please provide client, agent [,instance] ,backupset to resolve the conflict'
							GOTO SCRIPT_EXIT
						END
			ELSE IF (@countRows=0)
						BEGIN
							SET @lastError = 2
							SET @errorString	='Error: Invalid subclient ['+@i_subClientName+']'
							GOTO SCRIPT_EXIT
						END
			ELSE
						BEGIN
						set @i_subClientId= (select distinct id from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and appTypeId=@i_appTypeId and backupset=@i_backupSetId and instance=@i_instanceId)
						GOTO START_MODIFYING_ROWS
						END
		END
		else
		BEGIN
			set @i_subClientName=(SELECT SUBSTRING(@backupSetParam, 3, LEN(@backupSetParam)-2))
			SET @countRows=(select COUNT (distinct id) from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and  appTypeId=@i_appTypeId and  instance=@i_instanceId )
			IF (@countRows>1)
							BEGIN
								SET @lastError = 1
								SET @errorString	='Error: Conflict in finding the subclient, more than one subclient has same name ['+@i_subClientName+'] for given client ['+@i_clientName+'], please provide client, agent [,instance] ,backupset to resolve the conflict'
								GOTO SCRIPT_EXIT
							END
				ELSE IF (@countRows=0)
							BEGIN
								SET @lastError = 2
								SET @errorString	='Error: Invalid subclient ['+@i_subClientName+']'
								GOTO SCRIPT_EXIT
							END
				ELSE
				BEGIN
					set @i_subClientId= (select distinct id from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and appTypeId=@i_appTypeId   and instance=@i_instanceId)
					set @i_backupSetId= (select distinct backupset from APP_Application where subClientName= @i_subClientName and clientId=@i_clientId and appTypeId=@i_appTypeId  and instance=@i_instanceId)
					GOTO START_MODIFYING_ROWS
				END
		END
	END
ELSE
	BEGIN
	SET @lastError = 1
	SET @errorString = 'Error: Invalid option ['+@backupSetParam+'], please refer to the readme file and retry with necessary parameters'
				GOTO SCRIPT_EXIT
	END
CHECK_SUBCLIENT:
IF (@subClientParam= @NoParameter)
	GOTO START_MODIFYING_ROWS
IF (SUBSTRING(@subClientParam , 1, 2) = @subclientOption )
		BEGIN
			SET @i_subClientName = (SELECT SUBSTRING(@subClientParam , 3, LEN(@subClientParam )-2))
			set @i_subClientId = ISNULL((select top 1 id from  APP_Application
								where appTypeId = @i_appTypeId and clientId = @i_clientId and instance = @i_instanceId and backupset=@i_backupSetId and subclientName = @i_subClientName ),-1)
			if (@i_subClientId = -1)
			BEGIN
				SET @lastError = 2
				SET @errorString	='Error: Invalid subclient ['+@i_subClientName+']'
				GOTO SCRIPT_EXIT
			END
		END
ELSE
	BEGIN
	SET @lastError = 1
		SET @errorString = 'Error: Invalid option ['+@subClientParam+'], please refer to the readme file and retry with necessary parameters'
				GOTO SCRIPT_EXIT
	END
START_MODIFYING_ROWS:
BEGIN TRY
	--converting all potential minues one initialized vars to 0
	SELECT @i_ClientId = CASE WHEN @i_ClientId < 0 THEN 0 ELSE @i_ClientId END , @i_appTypeId = CASE WHEN @i_appTypeId < 0 THEN 0 ELSE @i_appTypeId END, @i_instanceId = CASE WHEN @i_instanceId < 0 THEN 0 ELSE @i_instanceId END, @i_backupSetId = CASE WHEN @i_backupSetId < 0 THEN 0 ELSE @i_backupSetId END, @i_subClientId = CASE WHEN @i_subClientId < 0 THEN 0 ELSE @i_subClientId END
	IF OBJECT_ID('tempdb.dbo.#tblRet') is not null DROP TABLE #tblRet
	CREATE TABLE #tblRet (retString VARCHAR(100), retCode INT)
	EXEC archCopyToAppModify @i_copyId, @i_enableOption, @i_clientGroupId , @i_clientID, @i_appTypeId, @i_instanceId, @i_backupSetId, @i_subClientId, 0
	SELECT TOP 1 @errorString = retString, @retCode = retCode
	FROM #tblRet
	IF (ISNULL(@retCode,0) <> 0)
		print @errorString
	IF OBJECT_ID('tempdb.dbo.#tblRet') is not null DROP TABLE #tblRet
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @errorString = 'Failed to associate. ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE: '+ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		IF @lastError = 1
		BEGIN
			SELECT usage FROM GxQscripts
			WHERE name = 'QS_modifySubclientAssociationsForCopy'
		END
		Raiserror(@errorString,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		COMMIT TRAN
		SELECT 'Successful'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_modifySubclientAssociationsForCopy')
	delete from GxQscripts where name = 'QS_modifySubclientAssociationsForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_modifySubclientAssociationsForCopy')
	delete from GXDBVersions where aliasname = 'QS_modifySubclientAssociationsForCopy'
GO

insert into GXDBVersions values(2, 'QS_modifySubclientAssociationsForCopy',  '00000000000000000000', 'QS_modifySubclientAssociationsForCopy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_modifySubclientAssociationsForCopy',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn QS_modifySubclientAssociationsForCopy  -si ''e=enable|e=disable'' -si ''sp=storage policy name'' -si ''c=copy name'' [-si ''cl=clientName'']  [-si ''a=Agent''] [-si ''i=instanceName''] [-si ''b=backupsetName'']  [-si ''s=subClientName'']'
 + CHAR(10) + '-- 		Enable or disable subclient association with seconday copy of a storage policy'
 + CHAR(10) + '--       Enable or disable , storage policy name , copyname  -- these are mandatory options and these options must be in the same order specified above.'
 + CHAR(10) + '-- 	    Client name must appear after copy name'
 + CHAR(10) + '-- 	    After client name ,agent, instance, backupset all are optional parameters but  should not specify the Child entity before parent entity . The following are some of valid combinations'
 + CHAR(10) + '--       enable|disable storage policy name, copy name, client name'
 + CHAR(10) + '--       enable|disable storage policy name, copy name, client name, agent'
 + CHAR(10) + '--       enable|disable storage policy name, copy name, client name, instance'
 + CHAR(10) + '--       enable|disable storage policy name, copy name, client name, backupset'
 + CHAR(10) + '--       enable|disable storage policy name, copy name, client name, subclient'
 + CHAR(10) + '--       enable|disable storage policy name, copy name, client name, agent, backupset'
 + CHAR(10) + '--       The entity hierarchy must be maintained client->agent->instance->backupset->subclient'
 + CHAR(10) + '--       For example the following combination is invalid'
 + CHAR(10) + '--       enable|disable storage policy name, copy name, client name , agent ,backupset ,instance , subclient'
 + CHAR(10) + '--       as backupset should not be given before instance .'
 + CHAR(10) + '--       For help    use the following command '
 + CHAR(10) + '--       qoperation execscript -sn QS_modifySubclientAssociationsForCopy -help'
)
GO

