

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MergeVirtualclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_mergeVirtualClient <<<'

IF EXISTS (select * from sysobjects where name='QS_mergeVirtualClient')
	drop procedure QS_mergeVirtualClient
IF EXISTS (select * from GxQscripts where name='QS_mergeVirtualClient')
	delete from GxQscripts where name = 'QS_mergeVirtualClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_mergeVirtualClient')
	delete from GXDBVersions where aliasname = 'QS_mergeVirtualClient'
GO
print '... Creating Procedure: QS_mergeVirtualClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_mergeVirtualClient
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM_1 varchar(1024) = '%s',
  @PARAM_2 varchar(1024) = '%s',
  @PARAM_3 varchar(1024) = '%s',
  @PARAM_4 varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER   			 --
-------------------------------------------
--DECLARE @PARAM_1		varchar(1024)
--DECLARE @PARAM_2		varchar(1024)
--DECLARE @PARAM_3		varchar(1024)
--DECLARE @PARAM_4		varchar(1024)
--SET		@PARAM_1		= '%s'
--SET		@PARAM_2		= '%s'
--SET		@PARAM_3		= '%s'
--SET		@PARAM_4		= '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName			varchar(32)
SET	@scriptName			= 'mergeVirtualClient'
DECLARE @lastError			integer
SET	@lastError			= 0
DECLARE @localErrorMsg			varchar(512)
SET	@localErrorMsg			='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			='%'                        -- Get Around possible QScript Parameter
SET     @NoParameter			=@NoParameter + 's'         -- .. Substitution
DECLARE @Option_Galaxy			varchar(1024)
SET	@Option_Galaxy			= 'sim'
DECLARE @Option_Virtual			varchar(1024)
SET	@Option_Virtual			= 'virt'
DECLARE @VirtualFlag			integer
SET	@VirtualFlag			= 11
DECLARE @galaxyClientName 		varchar(1024)
SET 	@galaxyClientName		= NULL
DECLARE @galaxyClientId 		integer
SET 	@galaxyClientId			= 0
DECLARE @galaxyClientSpecialFlags	integer
DECLARE @virtualClientName 		varchar(1024)
SET 	@virtualClientName		= NULL
DECLARE @virtualClientId 		integer
SET 	@virtualClientId		= 0
DECLARE @virtualClientSpecialFlags	integer
DECLARE @propId 			integer
DECLARE @propValue 			varchar(1064)
DECLARE @unixTime 			integer
SET 	@unixTime 			= dbo.GetUnixTime(GetUTCDate())
IF @PARAM_1 = @Option_Galaxy
BEGIN
	SET @galaxyClientName = @PARAM_2
END
ELSE IF @PARAM_1 = @Option_Virtual
BEGIN
	SET @virtualClientName = @PARAM_2
END
IF @PARAM_3 = @Option_Galaxy
BEGIN
	SET @galaxyClientName = @PARAM_4
END
ELSE IF @PARAM_3 = @Option_Virtual
BEGIN
	SET @virtualClientName = @PARAM_4
END
IF @galaxyClientName = NULL OR @virtualClientName = NULL
BEGIN
	SET @localErrorMsg = 'Error.  Missing client name input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
SET @galaxyClientId = (SELECT id FROM APP_Client WHERE name = @galaxyClientName)
SET @galaxyClientSpecialFlags = (SELECT specialClientFlags FROM APP_Client WHERE name = @galaxyClientName)
IF @galaxyClientId = 0 OR @galaxyClientSpecialFlags = @VirtualFlag
BEGIN
	SET @localErrorMsg = 'Error.  Galaxy client not specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
SET @virtualClientId = (SELECT id FROM APP_Client WHERE name = @virtualClientName)
SET @virtualClientSpecialFlags = (SELECT specialClientFlags FROM APP_Client WHERE name = @virtualClientName)
IF @virtualClientId = 0 OR @virtualClientSpecialFlags != @VirtualFlag
BEGIN
	SET @localErrorMsg = 'Error.  Virtual client not specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
BEGIN TRAN
BEGIN TRY
--Update the AppClientProps and VM Hosts
SET @propId = null
SET @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine Name' and modified = 0 and componentNameId = @galaxyClientId
IF @propId is null
BEGIN
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @galaxyClientId, attrName, 1, attrVal, @unixTime, 0 FROM APP_ClientProp
		WHERE componentNameId = @virtualClientId AND attrName = 'Virtual Machine Name' AND modified = 0
END
ELSE
BEGIN
	UPDATE APP_ClientProp SET attrVal = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @virtualClientId
		AND attrName = 'Virtual Machine Name' AND modified = 0) WHERE id = @propId
END
SET @propId = null
SET @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine GUID' and modified = 0 and componentNameId = @galaxyClientId
IF @propId is null
BEGIN
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @galaxyClientId, attrName, 1, attrVal, @unixTime, 0 FROM APP_ClientProp
		WHERE componentNameId = @virtualClientId AND attrName = 'Virtual Machine GUID' AND modified = 0
END
ELSE
BEGIN
	UPDATE APP_ClientProp SET attrVal = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @virtualClientId
		AND attrName = 'Virtual Machine GUID' AND modified = 0) WHERE id = @propId
END
SET @propId = null
SET @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine Host Name' and modified = 0 and componentNameId = @galaxyClientId
IF @propId is null
BEGIN
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @galaxyClientId, attrName, 1, attrVal, @unixTime, 0 FROM APP_ClientProp
		WHERE componentNameId = @virtualClientId AND attrName = 'Virtual Machine Host Name' AND modified = 0
END
ELSE
BEGIN
	UPDATE APP_ClientProp SET attrVal = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @virtualClientId
		AND attrName = 'Virtual Machine Host Name' AND modified = 0) WHERE id = @propId
END
SET @propId = null
SET @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine IP Address' and modified = 0 and componentNameId = @galaxyClientId
IF @propId is null
BEGIN
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @galaxyClientId, attrName, 1, attrVal, @unixTime, 0 FROM APP_ClientProp
		WHERE componentNameId = @virtualClientId AND attrName = 'Virtual Machine IP Address' AND modified = 0
END
ELSE
BEGIN
	UPDATE APP_ClientProp SET attrVal = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @virtualClientId
		AND attrName = 'Virtual Machine IP Address' AND modified = 0) WHERE id = @propId
END
UPDATE App_VM SET clientId = @galaxyClientId WHERE clientId = @virtualClientId
--Delete @currentAppClientId from app_client
DELETE FROM APP_ClientGroupAssoc WHERE clientId = @virtualClientId
DELETE FROM APP_ClientProp WHERE componentNameId = @virtualClientId
DELETE FROM APP_Platform WHERE clientId = @virtualClientId
DELETE FROM APP_Client WHERE id = @virtualClientId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	set @lastError = ERROR_NUMBER()
    	set @localErrorMsg = @localErrorMsg + ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
ARGS_ERROR:
PRINT ' '
PRINT 'Script ' + @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: '
PRINT '   ' + REPLACE(@PARAM_1, @NoParameter, '[]')
PRINT '   ' + REPLACE(@PARAM_2, @NoParameter, '[]')
PRINT '   ' + REPLACE(@PARAM_3, @NoParameter, '[]')
PRINT '   ' + REPLACE(@PARAM_4, @NoParameter, '[]')
PRINT 'Exit Code(' + convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MergeVirtualclient')
	delete from GxQscripts where name = 'QS_MergeVirtualclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MergeVirtualclient')
	delete from GXDBVersions where aliasname = 'QS_MergeVirtualclient'
GO

insert into GXDBVersions values(2, 'QS_MergeVirtualclient',  '00000000000000000000', 'QS_MergeVirtualclient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MergeVirtualclient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '   Qscript -f mergeVirtualClient.sql -i sim clientName_1 virt clientName_2 
'
 + CHAR(10) + '--   script_name : mergeVirtualClient'
)
GO

