

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_matadorInstallUpdateSchedule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_matadorInstallUpdateSchedule.sp,v $ $Id: QS_matadorInstallUpdateSchedule.sp,v 1.1.274.2 2018/03/19 23:58:38 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_matadorInstallUpdateSchedule <<<'

IF EXISTS (select * from sysobjects where name='QS_matadorInstallUpdateSchedule')
	drop procedure QS_matadorInstallUpdateSchedule
IF EXISTS (select * from GxQscripts where name='QS_matadorInstallUpdateSchedule')
	delete from GxQscripts where name = 'QS_matadorInstallUpdateSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_matadorInstallUpdateSchedule')
	delete from GXDBVersions where aliasname = 'QS_matadorInstallUpdateSchedule'
GO
print '... Creating Procedure: QS_matadorInstallUpdateSchedule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_matadorInstallUpdateSchedule
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
AS
SET NOCOUNT ON
SET ARITHABORT ON
	DECLARE @schedId	INT
	DECLARE @userId		INT
	DECLARE @taskId		INT
	DECLARE @now		DATETIME
	DECLARE @dayOfWeek	INT
	DECLARE @sunday		DATETIME
	DECLARE @year		INT
	DECLARE @month		INT
	DECLARE @day		INT
	SET @now = getdate()
	SET @year = DATEPART(year, @now)
	SET @month = DATEPART(month, @now)
	SET @day = DATEPART(day, @now)
	SET @now = dbo.getstartday( @year , @month , 0)
	SET @now = DATEADD(day, @day-1, @now)
	SET @now = DATEADD(hour, 14, @now)
	SET @schedId = (SELECT id FROM Schedule WHERE taskType = -1 AND type = -2 AND taskId = 0)
	SET @userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0  ORDER BY id)
	SET @dayOfWeek = DATEPART(weekday, @now)
	--ALREADY SUNDAY
	IF @dayOfWeek = 7
		SET @sunday = @now
	ELSE
		SET @sunday = @now + (8-@dayOfWeek)
	--INSTALL UPDATE
	INSERT INTO SchedAdminTask VALUES (@schedId, @userId, 0, 0, 5784, 0, 0, '')
	SET  @taskId = (select @@identity)
	INSERT INTO SchedAdminParam VALUES(@taskId, 8, 4, 4308, 2)
	INSERT INTO SchedAdminParam VALUES(@taskId, 8, 4, 4309, 0)
	INSERT INTO SchedAdminParam VALUES(@taskId, 8, 4, 4310, 0)
	INSERT INTO Schedule
		SELECT @taskId, 4, 19, counter, errors, fireIfMissed, 1, inProcess, 1, 1, isSingleton, sCount,
				1, monthDay, occurence, dayNumber, (14*60*60), interval, -1, dbo.getUnixTime(GetUTCDate()),
				0, ds_flags, tz_offset, tz_name, '', @sunday, @sunday, lastEvent, lastAttempt,
				schedTemplateInstanceId, endOfDay, skipOccurence, skipDayNumber, calendarId
				FROM Schedule WHERE id in ( SELECT scheduleId FROM SchedRestoreTask WHERE flags = 9999)
	SET  @schedId = (select @@identity)
	UPDATE SchedAdminTask SET scheduleId = @schedId WHERE id = @taskId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_matadorInstallUpdateSchedule')
	delete from GxQscripts where name = 'QS_matadorInstallUpdateSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_matadorInstallUpdateSchedule')
	delete from GXDBVersions where aliasname = 'QS_matadorInstallUpdateSchedule'
GO

insert into GXDBVersions values(2, 'QS_matadorInstallUpdateSchedule',  '00010001027400020000', 'QS_matadorInstallUpdateSchedule', '00010001027400020000')
GO

insert into GxQscripts values(2,'QS_matadorInstallUpdateSchedule',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn matadorInstallUpdateSchedule
'
 + CHAR(10) + '-- 	script_name: matadorInstallUpdateSchedule.'
 + CHAR(10) + '-- 	Script to set Install Update Schedules for Matador'
)
GO

