

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_matadorCreateVirtualServerInstance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_matadorCreateVirtualServerInstance <<<'

IF EXISTS (select * from sysobjects where name='QS_matadorCreateVirtualServerInstance')
	drop procedure QS_matadorCreateVirtualServerInstance
IF EXISTS (select * from GxQscripts where name='QS_matadorCreateVirtualServerInstance')
	delete from GxQscripts where name = 'QS_matadorCreateVirtualServerInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_matadorCreateVirtualServerInstance')
	delete from GXDBVersions where aliasname = 'QS_matadorCreateVirtualServerInstance'
GO
print '... Creating Procedure: QS_matadorCreateVirtualServerInstance'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_matadorCreateVirtualServerInstance
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM_1 varchar(1024),
  @PARAM_2 varchar(1024),
  @PARAM_3 varchar(1024),
  @PARAM_4 varchar(1024),
  @PARAM_5 varchar(1024),
  @PARAM_6 varchar(1024),
  @PARAM_7 varchar(1024)='%%s'
AS
SET NOCOUNT ON
DECLARE @client nvarchar(1024)
SET @client = @PARAM_1
DECLARE @instanceName nvarchar(1024)
SET @instancename = @PARAM_2
DECLARE @instanceType nvarchar(1024)
SET @instanceType = @PARAM_3
DECLARE @hostName nvarchar(1024)
SET @hostName = @PARAM_4
DECLARE @user nvarchar(1024)
SET @user = @PARAM_5
DECLARE @pwd nvarchar(1024)
SET @pwd = @PARAM_6
DECLARE @esxserverXml nvarchar(1024)
SET  @esxserverXml = @PARAM_7
----------------------Error Handling----------------------------------------------
DECLARE @errorCode integer
SET @errorCode = 0
DECLARE @errorString nvarchar(1024)
SET @errorString = ''
DECLARE @noParameter nvarchar(4)
SET @noParameter = '%%'
SET @noParameter = @noParameter + 's'
----------------------const------------------------------
DECLARE @scriptName nvarchar(128)
SET @scriptName = 'matadorCreateVirtualServerInstance'
DECLARE @nowTime integer
SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
DECLARE @virtualServerApptype integer
SET @virtualServerApptype = 106
--Instance Types
DECLARE @MSVirtualServerType integer
SET @MSVirtualServerType = 102
DECLARE @virtualCentreType integer
SET @virtualCentreType = 101
DECLARE @virtualESXType integer
SET @virtualESXType = 100
DECLARE @XENCentreype integer
SET @XENCentreype = 201
DECLARE @XENServerType integer
SET @XENServerType = 202
---------------------------------
DECLARE @defArchGrpId integer
SET @defArchGrpId = 1
DECLARE @logArchGrpId integer
SET @logArchGrpId = 1
DECLARE @instStatus integer
SEt @instStatus = 0
---------------------parameter 1 - client name--------------------------------------------
IF @client = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client Name was not supplied as an input.'
	GOTO ERROR_EXIT
END
DECLARE @clientId integer
SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @client), 0)
IF @clientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@client+'] not found.'
	GOTO ERROR_EXIT
END
IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @virtualServerApptype)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@client+'] does not have Virtual Server iDataAgent.'
	GOTO ERROR_EXIT
END
-----------------------------instance name ----------------------------
IF @instanceName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Instance Name was not supplied as an input.'
	GOTO ERROR_EXIT
END
-----------------------------instance type ----------------------------
IF @instanceType = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Instance Type was not supplied as an input.'
	GOTO ERROR_EXIT
END
-----------------Validate parameters for virtual server  instance---------------
--Duplicate Instance Name
IF EXISTS (SELECT * FROM APP_InstanceName I INNER JOIN APP_Application A ON I.id = A.instance
		WHERE I.name = @instanceName AND A.clientid = @clientId AND A.apptypeid = @virtualServerApptype)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Instance ['+@instanceName+'] already exists in client ['+@client+'].'
	GOTO ERROR_EXIT
END
--credentials for virtual centre instance type
	IF (@user = @noparameter OR
		@pwd = @noParameter OR
		@hostName = @noParameter ) AND (@instanceType = @XENCentreype OR @instanceType = @virtualCentreType)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. User, password and hostname required for InstanceType'+@instanceType+'. Please try again with all inputs.'
		GOTO ERROR_EXIT
	END
--no user, pwd and host name for instance types other than virtual centre
	IF ((@user <> @noParameter OR @pwd <> @noParameter OR @hostName <> @noParameter )  AND NOT(@instanceType = @virtualCentreType OR @instanceType = @XENCentreype))
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. User, password and HostName not allowed for instance type'+@instanceType+'. Please try again with all inputs.'
		GOTO ERROR_EXIT
	END
BEGIN TRAN
--Create instance
INSERT INTO APP_InstanceName (name, reftime, modified, status) VALUES(@instanceName, @nowTime, 0, @instStatus)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Could not create instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @instanceId integer
SET @instanceId = @@IDENTITY
	--Create instance properties
BEGIN
	--InstanceType
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Virtual Server Instance Type', 10, @instanceType, @nowTime, 0)
END
	--Instance Type - Virtual Centres
IF (@instanceType = @virtualCentreType OR @instanceType = @XENCentreype)
BEGIN
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Virtual Server Host', 1, @hostName, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Virtual Server User', 1, @user, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Virtual Server Password', 1, @pwd, @nowTime, 0)
END
	--Instance Type - Virtual Servers
IF (@instanceType = @virtualESXType OR @instanceType = @XENServerType) AND @esxserverXml <> @noParameter
BEGIN
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'ESX Servers XML', 1, @esxserverXml, @nowTime, 0)
END
--Create default backupset
INSERT INTO APP_BackupsetName (name, refTime, modified, status) VALUES ('defaultBackupSet', @nowTime, 0, 8)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error trying to create instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @backupsetId integer
SET @backupsetId = @@IDENTITY
--Create default SC
INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
	VALUES(@clientId, @virtualServerApptype, @instanceId, @backupsetId, 0, @defArchGrpId , @logArchGrpId , @nowTime, 0, 'default', 8)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error trying to create default subclient for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
----Create commandline SC
--INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
--	VALUES(@clientId, @virtualServerApptype, @instanceId, @backupsetId, 0, @cmdArchGrpId , @logArchGrpId , @nowTime, 0, '(command line)', 64)
--SET @errorCode = @@error
--IF @errorCode <> 0
--BEGIN
--	SET @errorString = 'Error. Error trying to create subclient for instance['+@instanceName +'].'
--	GOTO TRANS_EXIT
--END
TRANS_EXIT:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
ERROR_EXIT:
--Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1)	 --State
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_matadorCreateVirtualServerInstance')
	delete from GxQscripts where name = 'QS_matadorCreateVirtualServerInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_matadorCreateVirtualServerInstance')
	delete from GXDBVersions where aliasname = 'QS_matadorCreateVirtualServerInstance'
GO

insert into GXDBVersions values(2, 'QS_matadorCreateVirtualServerInstance',  '00000000000000000000', 'QS_matadorCreateVirtualServerInstance', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_matadorCreateVirtualServerInstance',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn matadorCreateVirtualServerInstance 
'
 + CHAR(10) + '	-si client_name 
'
 + CHAR(10) + '	-si instance_name 
'
 + CHAR(10) + '	-si instance_type
'
 + CHAR(10) + '	[-si host_name]			//required for virtual centre
'
 + CHAR(10) + '	[-si user]				//required for virtual centre
'
 + CHAR(10) + '	[-p2 password]			//required for virtual centre
'
 + CHAR(10) + '	[-si esxserver_xml]		//required for ESX Server
'
 + CHAR(10) + '-- 	script_name: matadorCreateVirtualServerInstance'
 + CHAR(10) + '-- 	Script to create Virtual Server instance.'
)
GO

