

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_mappingsForTapeImport.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_mappingsForTapeImport <<<'

IF EXISTS (select * from sysobjects where name='QS_mappingsForTapeImport')
	drop procedure QS_mappingsForTapeImport
IF EXISTS (select * from GxQscripts where name='QS_mappingsForTapeImport')
	delete from GxQscripts where name = 'QS_mappingsForTapeImport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_mappingsForTapeImport')
	delete from GXDBVersions where aliasname = 'QS_mappingsForTapeImport'
GO
print '... Creating Procedure: QS_mappingsForTapeImport'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_mappingsForTapeImport
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = '',
  @PARAM3 varchar(1024) = ''
AS
Set NOCOUNT ON
---------------Input variables---------------------
 DECLARE @i_option VARCHAR(10)
 DECLARE @i_oldId INT
 DECLARE @i_newId INT
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'mappingsForTapeImport'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @entityType integer
BEGIN TRY
BEGIN TRAN
	IF(@PARAM1 = @NoParameter OR @PARAM2 = @NoParameter OR @PARAM3 = @NoParameter) --Requires option and both old and new ids
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_mappingsForTapeImport'
		SET @localErrorMsg = 'Error: Insufficient command line parameters'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	SET @i_option = @PARAM1
	SET @i_oldId = convert(INT, @PARAM2)
	SET @i_NewId = convert(INT, @PARAM3)
	IF NOT EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'TapeImport_Mappings')
		CREATE TABLE TapeImport_Mappings
		(
			old_Id 	INT,
			new_Id 	INT,
			entityType	INT,
			oldArchGroupId INT,
			allowReset INT,
			primary key(old_Id, entityType)
		)
	--------------------------------------------------------
	--Set allowReset to true if mapped new entity is deleted
	UPDATE TapeImport_Mappings
	SET allowReset = 1
	FROM TapeImport_Mappings a LEFT OUTER JOIN ArchGroupCopy b ON a.new_Id = b.id
	WHERE b.id IS NULL
AND a.entityType = 18
		AND a.allowReset = 0
	UPDATE TapeImport_Mappings
	SET allowReset = 1
	FROM TapeImport_Mappings a LEFT OUTER JOIN APP_Application b ON a.new_Id = b.id
	WHERE b.id IS NULL
AND a.entityType = 7
		AND a.allowReset = 0
	--------------------------------------------------------
	IF @i_option = 'SPCOPY'
	BEGIN
		--Validate old and new ids
		IF EXISTS(SELECT * FROM ArchGroupCopy WHERE id = @i_oldId)
		BEGIN
			SET @localErrorMsg	=	'Error: Mapping is allowed for only deleted storage policy copies, given old copy [' + CONVERT(varchar, @i_oldId) + '] still exist'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		IF NOT EXISTS(SELECT * FROM ArchGroupCopy WHERE id = @i_newId)
		BEGIN
			SET @localErrorMsg	=	'Error: Invalid new storage policy copy [' + CONVERT(varchar, @i_newId) + ']'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		IF EXISTS(SELECT * FROM ArchGroupCopy WHERE id = @i_newId AND isSnapCopy = 1)
		BEGIN
			SET @localErrorMsg	=	'Error: Invalid mapping, mapping to snap copy is not allowed'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
IF EXISTS(SELECT * FROM ArchGroupCopy WHERE id = @i_newId AND ((dedupeFlags & 262144) > 0 OR type = 5))
		BEGIN
			SET @localErrorMsg	=	'Error: Invalid mapping, mapping to dedup\transitive copy is not allowed'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		--Check whether given new copy is already mapped with different old copy
IF EXISTS(SELECT 1 FROM TapeImport_Mappings WHERE old_Id <> @i_oldId AND new_Id = @i_newId AND entityType = 18)
		BEGIN
			SET @localErrorMsg	=	'Error: Mapping one storage policy copy with multiple storage policies is not allowed. '  + CHAR(13) + CHAR(10)
									+ 'Storage policy copy [' + CONVERT(varchar, @i_newId) + '] is already mapped with ['  + CHAR(13) + CHAR(10)
+ (SELECT  CONVERT(varchar, old_Id) FROM TapeImport_Mappings WHERE new_Id = @i_newId AND entityType = 18)
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
SET @entityType = 18
	END
	ELSE IF @i_option = 'SUBCLIENT'
	BEGIN
		--Validate old and new ids
		IF EXISTS(SELECT 1 FROM APP_Application WHERE id = @i_oldId)
		BEGIN
			SET @localErrorMsg	=	'Error: Mapping is allowed for only deleted subclients, given old subclient  [' + CONVERT(varchar, @i_oldId) + '] still exist'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		IF NOT EXISTS(SELECT 1 FROM APP_Application WHERE id = @i_newId)
		BEGIN
			SET @localErrorMsg	=	'Error: Invalid new subclient id [' + CONVERT(varchar, @i_newId) + ']'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
SET @entityType = 7
	END
	ELSE
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_mappingsForTapeImport'
		SET @localErrorMsg	=	'Error: Invalid option'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	--Insert mappings if not exist already, if exists and allowed to reset then update
	IF NOT EXISTS(SELECT 1 FROM TapeImport_Mappings WHERE old_Id = @i_oldId AND entityType = @entityType)
	BEGIN
		INSERT INTO TapeImport_Mappings VALUES(@i_oldId, @i_newId, @entityType, 0, 1)
	END
	ELSE IF EXISTS(SELECT 1 FROM TapeImport_Mappings WHERE old_Id = @i_oldId AND entityType = @entityType AND allowReset = 0)
	BEGIN
		SET @localErrorMsg	=	'Error: Mapping already exist and resetting is not allowed'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	ELSE
	BEGIN
		UPDATE TapeImport_Mappings
		SET new_Id = @i_newId
		WHERE old_Id = @i_oldId AND entityType = @entityType
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		COMMIT TRAN
		SELECT 'Successfully mapped old ' + @i_option + '[' + convert(VARCHAR, @i_oldId) + ']  with new ' + @i_option + '[' + convert(VARCHAR, @i_newId) + '].'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_mappingsForTapeImport')
	delete from GxQscripts where name = 'QS_mappingsForTapeImport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_mappingsForTapeImport')
	delete from GXDBVersions where aliasname = 'QS_mappingsForTapeImport'
GO

insert into GXDBVersions values(2, 'QS_mappingsForTapeImport',  '00000000000000000000', 'QS_mappingsForTapeImport', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_mappingsForTapeImport',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn mappingsForTapeImport -si <OPTION> -si <old_Id> -si <new_Id>'
 + CHAR(10) + '-- 	OPTION - SPCOPY or SUBCLIENT'
)
GO

