

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_managedDiskSpaceConfig.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_managedDiskSpaceConfig <<<'

IF EXISTS (select * from sysobjects where name='QS_managedDiskSpaceConfig')
	drop procedure QS_managedDiskSpaceConfig
IF EXISTS (select * from GxQscripts where name='QS_managedDiskSpaceConfig')
	delete from GxQscripts where name = 'QS_managedDiskSpaceConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_managedDiskSpaceConfig')
	delete from GXDBVersions where aliasname = 'QS_managedDiskSpaceConfig'
GO
print '... Creating Procedure: QS_managedDiskSpaceConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_managedDiskSpaceConfig
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = ''
AS
BEGIN TRY
BEGIN TRAN
	SET NOCOUNT ON
	DECLARE @errorString 		VARCHAR(max)
	DECLARE @errorCode			INT
	DECLARE @option				varchar(50)
	DECLARE @copyListFileName	varchar(max)
	DECLARE @query				nvarchar(max)
	SET @errorCode = 0
	SET @errorString = 'NO ERROR'
	IF(@PARAM1 = '%s')
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please provide an option(ENABLE\DISABLE\LISTENABLED\LISTDISABLED)'
		GOTO SCRIPT_EXIT
	END
	SET @option = @PARAM1
	IF(@option = 'ENABLE' OR @option = 'DISABLE') AND (@PARAM2 = '%s')
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please provide storagePolicyCopy list file name or All to enable or disable ManagedDiskSpace'
		GOTO SCRIPT_EXIT
	END
	SET @copyListFileName  = @PARAM2
	IF OBJECT_ID('tempdb.dbo.#EligibleCopiesList') IS NOT NULL DROP TABLE #EligibleCopiesList
	CREATE TABLE #EligibleCopiesList (copyId int, archGroupName varchar(1024), copyName varchar(1024))
	IF OBJECT_ID('tempdb.dbo.#ManagedDiskSpaceCopiesList') IS NOT NULL DROP TABLE #ManagedDiskSpaceCopiesList
	CREATE TABLE #ManagedDiskSpaceCopiesList (copyId int, archGroupName varchar(1024), copyName varchar(1024), exist int)
	IF OBJECT_ID('tempdb.dbo.#CopiesList') IS NOT NULL DROP TABLE #CopiesList
	CREATE TABLE #CopiesList (archGroupName varchar(1024), copyName varchar(1024))
	INSERT INTO #EligibleCopiesList
	SELECT DISTINCT AGC.Id, AG.Name, AGC.Name
	FROM ArchGroup AG, ArchGroupCopy AGC, MMDataPath CF, MMDrivePool MDP, MMMasterPool MMP,
		MMLibrary ML, ArchAgingRule AR
	WHERE AG.Id = AGC.ArchGroupId
		AND AGC.Id = CF.CopyId
		AND CF.DrivePoolId = MDP.DrivePoolId
		AND MDP.MasterPoolId = MMP.MasterPoolId
		AND MMP.LibraryId = ML.LibraryId
		AND AGC.Id = AR.CopyId
		AND AGC.isSnapCopy = 0   --Non snap copy
		AND (AGC.DedupeFlags & 2359296) = 0 --SILO and DEDUP are not enabled
		AND AR.RetentionDays <> -1 --Retention is not infinite
		AND (CF.Flag & 1) > 0 --Default Data Path
	IF(@option = 'ENABLE' OR @option = 'DISABLE')
	BEGIN
		IF (@option = 'ENABLE' AND @copyListFileName = 'ALL')
		BEGIN
			INSERT INTO #ManagedDiskSpaceCopiesList
			SELECT AGC.Id, AG.Name, AGC.Name, 0
			FROM ArchGroup AG INNER JOIN ArchGroupCopy AGC ON AG.Id = AGC.archGroupId
			INNER JOIN ArchAgingRule AR ON AGC.Id = AR.CopyId
			INNER JOIN #EligibleCopiesList EC ON AGC.Id = EC.copyId
			WHERE (AR.Flags & 8) = 0
		END
		ELSE IF (@option = 'DISABLE' AND @copyListFileName = 'ALL')
		BEGIN
			INSERT INTO #ManagedDiskSpaceCopiesList
			SELECT AGC.Id, AG.Name, AGC.Name, 0
			FROM ArchGroup AG INNER JOIN ArchGroupCopy AGC ON AG.Id = AGC.archGroupId
			INNER JOIN ArchAgingRule AR ON AGC.Id = AR.CopyId
			WHERE (AR.Flags & 8) = 8
		END
		ELSE
		BEGIN
			set @query = N'BULK INSERT #CopiesList FROM ''' + @copyListFileName + ''' WITH ( FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'')'
			exec sp_executesql @query
			--Remove leading and trainling spaces if any
			UPDATE #CopiesList
			SET archGroupName = LTRIM(RTRIM(archGroupName)),
				copyName      = LTRIM(RTRIM(copyName))
			INSERT INTO #ManagedDiskSpaceCopiesList
			SELECT AGC.Id, AG.Name, AGC.Name, 0
			FROM #CopiesList CL, ArchGroup AG, ArchGroupCopy AGC
			WHERE CL.archGroupName = AG.Name AND CL.CopyName = AGC.Name
				AND AG.Id = AGC.ArchGroupId
			IF EXISTS
			(
				SELECT 1
				FROM #CopiesList a LEFT OUTER JOIN #ManagedDiskSpaceCopiesList b
					ON a.archGroupName = b.archGroupName AND a.copyName = b.copyName
				WHERE b.archGroupName IS NULL
			)
			BEGIN
				SELECT 'INVALID StoragePolicy\Copy Name'
				SELECT 'StoragePolicyName, CopyName'
				SELECT a.archGroupName + ', ' + a.copyName
				FROM #CopiesList a LEFT OUTER JOIN #ManagedDiskSpaceCopiesList b
					ON a.archGroupName = b.archGroupName AND a.copyName = b.copyName
				WHERE b.archGroupName IS NULL
			END
		END
	END
	IF(@option = 'LISTENABLED')
	BEGIN
		IF EXISTS
		(
			SELECT 1
			FROM ArchGroup AG INNER JOIN ArchGroupCopy AGC ON AG.Id = AGC.archGroupId
			INNER JOIN ArchAgingRule AR ON AGC.Id = AR.CopyId
			WHERE (AR.Flags & 8) = 8
		)
		BEGIN
			SELECT 'StoragePolicyName, CopyName'
			SELECT AG.Name + ', ' + AGC.Name
			FROM ArchGroup AG INNER JOIN ArchGroupCopy AGC ON AG.Id = AGC.archGroupId
				INNER JOIN ArchAgingRule AR ON AGC.Id = AR.CopyId
			WHERE (AR.Flags & 8) = 8
		END
		ELSE
		BEGIN
			SELECT 'No copies found with ManagedDiskSpace enabled'
		END
	END
	ELSE IF(@option = 'LISTDISABLED')
	BEGIN
		IF EXISTS
		(
			SELECT 1
			FROM ArchGroup AG INNER JOIN ArchGroupCopy AGC ON AG.Id = AGC.archGroupId
			INNER JOIN ArchAgingRule AR ON AGC.Id = AR.CopyId
			INNER JOIN #EligibleCopiesList EC ON AGC.Id = EC.CopyId
			WHERE (AR.Flags & 8) = 0
		)
		BEGIN
			SELECT 'StoragePolicyName, CopyName'
			SELECT AG.Name + ', ' + AGC.Name
			FROM ArchGroup AG INNER JOIN ArchGroupCopy AGC ON AG.Id = AGC.archGroupId
				INNER JOIN ArchAgingRule AR ON AGC.Id = AR.CopyId
				INNER JOIN #EligibleCopiesList EC ON AGC.Id = EC.CopyId
			WHERE (AR.Flags & 8) = 0
		END
		ELSE
		BEGIN
			SELECT 'No copies found with ManagedDiskSpace disabled'
		END
	END
	ELSE IF(@option = 'ENABLE')
	BEGIN
		--Check for non eligible copies for ManagedDiskSpace property
		UPDATE #ManagedDiskSpaceCopiesList
		SET exist = 2
		FROM #ManagedDiskSpaceCopiesList C LEFT OUTER JOIN #EligibleCopiesList A
		ON A.CopyId = C.CopyId
		WHERE A.CopyId IS NULL
		IF EXISTS(SELECT 1 FROM #ManagedDiskSpaceCopiesList WHERE exist = 2)
		BEGIN
			SELECT 'ManagedDiskSpace is not allowed for below copies'
			SELECT 'StoragePolicyName, CopyName'
			SELECT archGroupName + ', ' + copyName
			FROM #ManagedDiskSpaceCopiesList
			WHERE exist = 2
		END
		--Check for propety is already enabled or not
		UPDATE #ManagedDiskSpaceCopiesList
		SET exist = 1
		FROM ArchAgingRule A INNER JOIN #ManagedDiskSpaceCopiesList C
		ON A.CopyId = C.CopyId AND (A.Flags & 8) = 8
		IF EXISTS(SELECT 1 FROM #ManagedDiskSpaceCopiesList WHERE exist = 1)
		BEGIN
			SELECT 'ManagedDiskSpace is already enabled for below copies'
			SELECT 'StoragePolicyName, CopyName'
			SELECT archGroupName + ', ' + copyName
			FROM #ManagedDiskSpaceCopiesList
			WHERE exist = 1
		END
		IF EXISTS(SELECT 1 FROM #ManagedDiskSpaceCopiesList WHERE exist = 0)
		BEGIN
			--Enable managed disk space for given copies
			UPDATE ArchAgingRule
			SET Flags = A.Flags | 8
			FROM ArchAgingRule A INNER JOIN #ManagedDiskSpaceCopiesList C
			ON A.CopyId = C.CopyId AND exist = 0
			SELECT 'Successfully enabled ManagedDiskSpace for below copies'
			SELECT 'StoragePolicyName, CopyName'
			SELECT archGroupName + ', ' + copyName
			FROM #ManagedDiskSpaceCopiesList
			WHERE exist = 0
		END
		ELSE
		BEGIN
			SELECT 'No copies found with ManagedDiskSpace disabled'
		END
	END
	ELSE IF(@option = 'DISABLE')
	BEGIN
		--Check for propety is already disabled or not
		UPDATE #ManagedDiskSpaceCopiesList
		SET exist = 1
		FROM ArchAgingRule A INNER JOIN #ManagedDiskSpaceCopiesList C
		ON A.CopyId = C.CopyId AND (A.Flags & 8) = 0
		IF EXISTS(SELECT 1 FROM #ManagedDiskSpaceCopiesList WHERE exist = 1)
		BEGIN
			SELECT 'ManagedDiskSpace is already disabled for below copies'
			SELECT 'StoragePolicyName, CopyName'
			SELECT archGroupName + ', ' + copyName
			FROM #ManagedDiskSpaceCopiesList
			WHERE exist = 1
		END
		IF EXISTS(SELECT 1 FROM #ManagedDiskSpaceCopiesList WHERE exist = 0)
		BEGIN
			--Disable managed disk space for given copies
			UPDATE ArchAgingRule
			SET Flags = Flags & (~8)
			FROM ArchAgingRule A INNER JOIN #ManagedDiskSpaceCopiesList C
			ON A.CopyId = C.CopyId AND exist = 0
			SELECT 'Successfully disabled ManagedDiskSpace for below copies'
			SELECT 'StoragePolicyName, CopyName'
			SELECT archGroupName + ', ' + copyName
			FROM #ManagedDiskSpaceCopiesList
			WHERE exist = 0
		END
		ELSE
		BEGIN
			SELECT 'No copies found with ManagedDiskSpace enabled'
		END
	END
	ELSE
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_managedDiskSpaceConfig'
		SET @errorCode = 1
		SET @errorString = 'INVALID OPTION'
		GOTO SCRIPT_EXIT
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@ERROR
	SET @errorString = (SELECT ERROR_MESSAGE())
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @errorCode <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@errorString,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		COMMIT TRAN
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_managedDiskSpaceConfig')
	delete from GxQscripts where name = 'QS_managedDiskSpaceConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_managedDiskSpaceConfig')
	delete from GXDBVersions where aliasname = 'QS_managedDiskSpaceConfig'
GO

insert into GXDBVersions values(2, 'QS_managedDiskSpaceConfig',  '00000000000000000000', 'QS_managedDiskSpaceConfig', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_managedDiskSpaceConfig',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn managedDiskSpaceConfig -si OPTION [-si ALL\FILENAME]'
 + CHAR(10) + '-- 	OPTION - LISTENABLED\LISTDISABLED\ENABLE\DISABLE'
 + CHAR(10) + '-- 		LISTENABLED  : Lists all copies which have ManagedDiskSpace enabled'
 + CHAR(10) + '-- 		LISTDISABLED : Lists all copies which have ManagedDiskSpace disabled'
 + CHAR(10) + '-- 		ENABLE       : Enables ManagedDiskSpace for all or given list of copies based on second parameter'
 + CHAR(10) + '-- 		DISABLE      : Disables ManagedDiskSpace for all or given list of copies based on second parameter'
 + CHAR(10) + '-- 	ALL\FILENAME '
 + CHAR(10) + '-- 		- Specify ALL to enable\disable ManagedDiskSpace for all copies'
 + CHAR(10) + '-- 		- Specify a file name containing list of copies to enable\disable ManagedDiskSpace on them'
 + CHAR(10) + '-- 		- The file should contain list of copies in the format - StoragePolicyName, CopyName '
)
GO

