

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_importBulkMedia.sp] ---------- 

-------------------------------------------
--         Name:   QS_importBulkMedia.sp
--         Date:   09/25/2012
--       Author:   Mandar Khadilkar
--  Description:   Incorporate a set of media in Simpana from comma delimited file
--
--           TR:   120601-000018
--     Customer:   Ancestry.com Inc
-------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_importBulkMedia')
BEGIN
	print '>>> Drop Stored Procedure: QS_importBulkMedia <<<'
	drop procedure QS_importBulkMedia
END
IF EXISTS (select * from GxQscripts where name='QS_importBulkMedia')
	delete from GxQscripts where name = 'QS_importBulkMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_importBulkMedia')
	delete from GXDBVersions where aliasname = 'QS_importBulkMedia'
GO
print '... Creating Procedure: QS_importBulkMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_importBulkMedia
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @fileName NVARCHAR(1024) = N''
AS
SET NOCOUNT ON
-- Convenience Definitions
DECLARE @scriptName NVARCHAR(50) = N'QS_importBulkMedia'
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(200) = N'Error encountered while executing script'
DECLARE @NoParameter NVARCHAR(3) = ''
-- Local Variables
DECLARE @query NVARCHAR(MAX)
DECLARE @curUnixTime INTEGER
DECLARE @shelf VARCHAR(128)
DECLARE @commcellid INTEGER
DECLARE @libid INTEGER
DECLARE @dupmedia INTEGER = 0
DECLARE @totalMedia INTEGER = 0
DECLARE @badMedia INTEGER = 0
DECLARE @goodMedia INTEGER = 0
BEGIN TRY
BEGIN TRANSACTION ImportMedia
-- Perform basic validations
IF @fileName = @NoParameter
BEGIN
    SET @errorCode = 1
    SET @errorString = N'Error - File name not specified.'
    GOTO ARGS_ERROR
END
IF OBJECT_ID('tempdb..#tmpRawData', 'U') IS NOT NULL
BEGIN
    DROP TABLE #tmpRawData
END
IF OBJECT_ID('tempdb..#tmpMediaData', 'U') IS NOT NULL
BEGIN
    DROP TABLE #tmpMediaData
END
CREATE TABLE #tmpRawData
(label VARCHAR(40),
 mgroup VARCHAR(40),
 barcode VARCHAR(256),
 dateWritten VARCHAR(40),
 dateRead VARCHAR(40),
 location VARCHAR(128),
 expiryDate VARCHAR(40),
 mediatypename VARCHAR(40)
)
SET @query = 'BULK INSERT #tmpRawData FROM ''' + @filename + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'', FIRSTROW = 1 , LASTROW = 1)';
EXEC sp_executesql @query
IF @@ROWCOUNT = 0
BEGIN
    SET @errorCode = 2
    SET @errorString = N'Error - Empty file.'
    GOTO ARGS_ERROR
END
-- Validations successful. Clean up, load raw table
DELETE FROM #tmpRawData
SET @query = 'BULK INSERT #tmpRawData FROM ''' + @filename + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'', FIRSTROW = 2)';
EXEC sp_executesql @query
SET @errorCode = ERROR_NUMBER()
SET @errorString = ERROR_MESSAGE()
IF (@errorCode <> 0)
BEGIN
    SET @errorString = 'ERROR: ImportBulkMedia -- #tmpRawData -- Load CSV file '
    GOTO ARGS_ERROR
END
-- Remove duplicate barcodes from raw data
DELETE FROM #tmpRawData
WHERE %%PHYSLOC%% NOT IN
(SELECT MAX(%%PHYSLOC%%) FROM #tmpRawData GROUP BY BARCODE)
SET @dupmedia = @@ROWCOUNT
-- Load temp table from raw data and drop raw data
CREATE TABLE #tmpMediaData
(label VARCHAR(40),
 mgroup VARCHAR(40),
 barcode VARCHAR(256),
 dateWritten INTEGER DEFAULT (0),
 dateRead INTEGER DEFAULT (0),
 location VARCHAR(128),
 expiryDate VARCHAR(40),
 mediatypename VARCHAR(40),
 libraryid INTEGER NOT NULL DEFAULT (0),
 sparegroupid INTEGER NOT NULL DEFAULT (0),
 mediatypeid INTEGER NOT NULL DEFAULT (0),
 mediaid INTEGER NOT NULL DEFAULT (0),
 exportlocationid INTEGER NOT NULL DEFAULT (0),
 flag INTEGER NOT NULL DEFAULT (0) -- 1-Duplicate media, 2-Invalid media type
)
INSERT INTO #tmpMediaData(label, mgroup, barcode, dateWritten, dateRead, location, expiryDate, mediatypename)
SELECT label, mgroup, barcode,
CASE dateWritten
WHEN 'Never' THEN 0
ELSE dbo.GetUnixTime((CONVERT(DATETIME, dateWritten)))
END
,
CASE dateRead
WHEN 'Never' THEN 0
ELSE dbo.GetUnixTime((CONVERT(DATETIME, dateRead)))
END,
location, expiryDate, mediatypename FROM #tmpRawData
SET @totalMedia = @dupmedia + @@ROWCOUNT -- Consider duplicate media for couting total media
DROP TABLE #tmpRawData
-- Start Main Processing
--Flag barcodes (media) that already exist in MMMedia
UPDATE #tmpMediaData
SET flag = 1
FROM MMMedia M
WHERE #tmpMediaData.barcode = M.BarCode
SET @dupmedia = @dupmedia + @@ROWCOUNT
--Update media type id
UPDATE #tmpMediaData
SET mediatypeid = MT.MediaTypeId
FROM MMMediaType MT
WHERE #tmpMediaData.mediatypename = MT.MediaTypeName AND flag = 0
--Flag media with invalid media type
UPDATE #tmpMediaData
SET flag = 2
WHERE mediatypeid = 0 AND flag = 0
SET @badMedia = @@ROWCOUNT
UPDATE #tmpMediaData
SET exportlocationid = MME.ExportLocationId
FROM MMExportLocation MME
WHERE #tmpMediaData.location = MME.ExportLocation AND flag = 0
SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
SET @commcellid = (SELECT number FROM APP_CommCell WHERE id = 2)
DECLARE curLocation CURSOR FOR
SELECT DISTINCT mgroup from #tmpMediaData WHERE flag = 0
AND mgroup NOT IN (SELECT AliasName FROM MMLibrary)
OPEN curLocation
FETCH NEXT FROM curLocation INTO @shelf
WHILE @@FETCH_STATUS = 0
BEGIN
      INSERT INTO MMLibrary(LibraryName, AliasName, LibrarySoftState,
                     LibraryEnabled, LibraryBroken, LibraryTypeId,
                     BarCodeReaderPresent, LibraryInstallTime, LowWaterMarkMB,
                     LibraryLicenseType, LibraryVendor, LibraryModel,
                     FirmwareRevision,SerialNumber, WWNNumber,
                     FiberChannelPort,NumberOfMounts, LastServiceTime,
                     DriveCount, BaseAddress,ExternalGUID,
                     PrivateData, LibraryAttribute,MountTimeoutSec, UnmountTimeoutSec,
                     NumberOfSoftErrors, NumberOfHardErrors,  DefaultMediaTypeId,
                     InventoryInProgress, IsConvertedToSited,
                     LastFullInventoryTime, InventoryJobId_h, InventoryJobId_l,
                     LibraryStatusReason, OfflineTimeStamp, UseWithinDaysInSec,
                     DriveCleanIntervalInSec, VMSDirection, CacheMountPeriodInSec,
                     StdAlnMedRetentionTime, SlotBaseAddress, NumberOfMailSlots,
                     TURIntervalInSec, ConfigParams, Descript, StdAlnChkIntervalInSec, StdAlnNextChkTime,
                     ReadRetryIntervalInSec, ReadRetryAttempts, RestrictActivity, LibraryStatusEventId,
                     StartVMSElementAddress, ExtendedAttributes, ThresholdPercentage, ThresholdVariation,
                     LibrarySubType, VTLType, origCCId, origLibraryId, WarningWaterMark, OutOfSpaceAlertInDays)
      VALUES (@shelf, @shelf, 1, 1, 0, 8, 0, @curUnixTime, 0, 0, 'Commvault System',
              'Shelf Library','1.1', '', '', 0, 0, 0, 0, 0, '', '', 984000, -1, -1,
              0, 0, (SELECT TOP(1) mediatypeid FROM #tmpMediaData WHERE mgroup = @shelf AND flag = 0),
              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, '', '', 0, 0,
              0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0)
      FETCH NEXT FROM curLocation INTO @shelf
END
CLOSE curLocation
DEALLOCATE curLocation
UPDATE #tmpMediaData
SET libraryid = MML.LibraryId
FROM MMLibrary MML
WHERE #tmpMediaData.mgroup = MML.AliasName AND flag = 0
SET @errorCode = @@ERROR
IF (@errorCode <> 0)
BEGIN
    SET @errorString = 'ERROR: ImportBulkMedia -- #tmpMediaData -- Update libraryId '
    GOTO ARGS_ERROR
END
UPDATE MMLibrary
SET LibraryName = AliasName + CONVERT(varchar, LibraryId)
WHERE LibraryId in (SELECT DISTINCT libraryid FROM #tmpMediaData WHERE flag = 0)
SET @errorCode = @@ERROR
IF (@errorCode <> 0)
BEGIN
    SET @errorString = 'ERROR: ImportBulkMedia -- MMLibrary -- Update LibraryName'
    GOTO ARGS_ERROR
END
DECLARE curLib CURSOR FOR
SELECT DISTINCT libraryid from #tmpMediaData WHERE flag = 0
AND libraryid NOT IN (SELECT DISTINCT LibraryId from MMSpareGroup)
OPEN curLib
FETCH NEXT FROM curLib INTO @libid
WHILE @@FETCH_STATUS = 0
BEGIN
      INSERT INTO MMSpareGroup(SpareGroupName, LibraryId, LowWaterMark,
                  SpareGroupType,LastUpdateTime, ExternalGUID, IsLowWaterMark,
                  LowWaterMarkTime, HighWaterMark, Attributes, MediaTypeId,
                  UsableSpareCountInLib, PrefferedRecordingFormatId)
      VALUES ('Default Scratch', @libid, 20, 2, @curUnixTime, '', 0, 0, 0,
               20, 146, 0, 0)
      INSERT INTO MMSpareGroup(SpareGroupName, LibraryId, LowWaterMark,
                  SpareGroupType,LastUpdateTime, ExternalGUID, IsLowWaterMark,
                  LowWaterMarkTime, HighWaterMark, Attributes, MediaTypeId,
                  UsableSpareCountInLib, PrefferedRecordingFormatId)
      VALUES ('Retired Media', @libid, -1, 8, @curUnixTime, '', 0, 0, 0,
               0, 0, 0, 0)
      INSERT INTO MMSpareGroup(SpareGroupName, LibraryId, LowWaterMark,
                  SpareGroupType,LastUpdateTime, ExternalGUID, IsLowWaterMark,
                  LowWaterMarkTime, HighWaterMark, Attributes, MediaTypeId,
                  UsableSpareCountInLib, PrefferedRecordingFormatId)
      VALUES ('Foreign Media', @libid, -1, 16, @curUnixTime, '', 0, 0, 0,
               0, 0, 0, 0)
      INSERT INTO MMSpareGroup(SpareGroupName, LibraryId, LowWaterMark,
                  SpareGroupType,LastUpdateTime, ExternalGUID, IsLowWaterMark,
                  LowWaterMarkTime, HighWaterMark, Attributes, MediaTypeId,
                  UsableSpareCountInLib, PrefferedRecordingFormatId)
      VALUES ('Overwrite Protect Media', @libid, -1, 64, @curUnixTime, '', 0, 0, 0,
               0, 0, 0, 0)
      INSERT INTO MMSpareGroup(SpareGroupName, LibraryId, LowWaterMark,
                  SpareGroupType,LastUpdateTime, ExternalGUID, IsLowWaterMark,
                  LowWaterMarkTime, HighWaterMark, Attributes, MediaTypeId,
                  UsableSpareCountInLib, PrefferedRecordingFormatId)
      VALUES ('Catalog Media', @libid, -1, 128, @curUnixTime, '', 0, 0, 0,
               0, 0, 0, 0)
      INSERT INTO MMSpareGroup(SpareGroupName, LibraryId, LowWaterMark,
                  SpareGroupType,LastUpdateTime, ExternalGUID, IsLowWaterMark,
                  LowWaterMarkTime, HighWaterMark, Attributes, MediaTypeId,
                  UsableSpareCountInLib, PrefferedRecordingFormatId)
      VALUES ('Cleaning Media', @libid, 1, 32, @curUnixTime, '', 0, 0, 0,
               12, 0, 0, 0)
      FETCH NEXT FROM curLib INTO @libid
END
CLOSE curLib
DEALLOCATE curLib
UPDATE #tmpMediaData
SET sparegroupid = MMS.SpareGroupId
FROM MMSpareGroup MMS
WHERE #tmpMediaData.libraryid = MMS.LibraryId
AND MMS.SpareGroupName = 'Default Scratch' AND flag = 0
INSERT INTO MMMedia(UniqueId, BarCode, MediaTypeId,
                    CreationTime, NumberOfReUses, LastRestoreTime, LastBackupTime,
                    LibraryId, SpareGroupId,
                    LastExportTime, MediaLocation, ExternalGUID,
                    MediaFlags, IsOMLWritten, MediaStatusReason,
                    ExportLocationId, LastWriteLibraryId, Attributes, ContainerId, OverWriteJobId,
                    origCCcommCellID, origCCmediaID, Descript, NumberOfSideOverwrites, ScheduleRunId,
                    retentionFlags, retentionExpireTime, IsAged, IsInMediaGroup, PinMediaExpireTime,
                    origSpareGroupId, RMSpareStatus, RMSpareStatusUpdateTime, ExtendedAttributes, minRetentionTime, HwEncKey)
SELECT '__UNIQUEID__' + CONVERT(varchar, @commcellid) + '_BC_'+ T.barcode, T.barcode, T.mediatypeid,
       dbo.GetUnixTime(GETUTCDATE()), 0, T.dateRead, T.dateWritten,
       T.libraryid, T.sparegroupid,
       0, 3, '',
       1, 0, 0,
       T.exportlocationid, 0, 33554432, 0, 0,
       2, 0, T.label, 0, 0,
       0, 0, 0, 0, 0,
       0, -1, 0, 0, 0, ''
FROM #tmpMediaData T
WHERE flag = 0
SET @goodMedia = @@ROWCOUNT
Update #tmpMediaData
SET mediaid = MM.MediaId
FROM MMMedia MM
WHERE #tmpMediaData.barcode = MM.BarCode
AND #tmpMediaData.libraryid = MM.LibraryId
AND flag = 0
UPDATE MMMedia
SET UniqueId = CONVERT(varchar, @commcellid) + '_BC_'+ barcode + '_' + CONVERT(varchar, MediaId)
WHERE UniqueId like '__UNIQUEID%'
INSERT INTO MMMediaSide(MediaId, SideName, MediaSideFlags,
            NumberOfRestores, NumberOfBackups, NumberOfMounts,
            NumberOfSoftErrors, NumberOfHardErrors, NumberOfReUses,
            LastRestoreTime, LastBackupTime, TotalSpaceMB, FreeBytesMB,
            LogicalBytesMB, PhysicalBytesMB, IsOMLValid, FailureReason,
            ExternalGUID, IsOMLWritten, isErasable, UploadDataMB, DownloadDataMB)
SELECT T.mediaid, 'A_' + CONVERT(varchar, T.mediaid), 1,
       0, 0, 0,
       0, 0, 0,
       T.dateRead, T.dateWritten, -1, -1,
       0, 0, 0, '',
       '', 0, 0, 0, 0
FROM #tmpMediaData T
WHERE flag = 0
SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
INSERT INTO MMVolume(VolumeName, CreationTime, VolumeFlags, VolumeInitialized,
            FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts, NumberOfSoftErrors,
            NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB,
            NumberOfActiveFiles, LastFile, RecordingFormatId, ExternalGUID, OMLVersion,
            VolumeState, VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID,
            origCCvolumeID, MediaId, MediaSideId, Attributes, MediaGroupId,
            ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId, SiloStatus, CurrMountPathId,
            FailureErrorCode, MMSpareStatus)
SELECT 'V_' + CONVERT(varchar, MM.MediaId), @curUnixTime, 5, 0
       , -1, 0, 0, MMS.NumberOfMounts, 0
       , 0, MMS.LastRestoreTime, MMS.LastBackupTime, 0, MMS.PhysicalBytesMB
       , 0, 0, 0, '', 2
       , 0, 0, 0, 0, 2
       , 0, MM.MediaId, MMS.MediaSideId, 0, 0
       , @curUnixTime, -1, 0, 0, -1, 0, 0, 0
FROM  MMMedia MM, MMMediaSide MMS, #tmpMediaData T
WHERE MM.MediaId = MMS.MediaId AND T.mediaid = MM.MediaId
AND T.flag = 0
--Print Output
SELECT 'Total Media: ' + convert(varchar,@totalMedia )
SELECT 'Duplicate media: ' + convert(varchar, @dupmedia)
SELECT 'Media with invalid media type: ' + convert(varchar, @badmedia)
SELECT 'Processed Media: ' + convert(varchar, @goodmedia) + CHAR(10)
IF @dupmedia > 0
BEGIN
 SELECT 'List of Duplicate Media:'
 SELECT barcode as "Barcode", mgroup as "Group" FROM #tmpMediaData WHERE flag = 1
END
IF @badMedia > 0
BEGIN
 SELECT 'List of media with invalid media type:'
 SELECT barcode as "Barcode", mgroup as "Group" FROM #tmpMediaData WHERE flag = 2
END
DROP TABLE #tmpMediaData
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
ARGS_ERROR:
SELECT @scriptName + ' completed at '
         + Convert(varchar, getdate())
         + ' with Parameters: ['+ @fileName + '].'
         + CHAR(10) + 'Exit Code: ' + convert(varchar, @errorCode)
IF @errorCode = 0
BEGIN
   COMMIT TRANSACTION ImportMedia
END
IF @errorCode <> 0
BEGIN
     Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
     ROLLBACK TRANSACTION ImportMedia
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_importBulkMedia')
	delete from GxQscripts where name = 'QS_importBulkMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_importBulkMedia')
	delete from GXDBVersions where aliasname = 'QS_importBulkMedia'
GO

insert into GXDBVersions values(2, 'QS_importBulkMedia',  '00000000000000000000', 'QS_importBulkMedia', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_importBulkMedia',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '        Utility to import media present in a comma delimited file into a VaultTracker media repository.
'
 + CHAR(10) + '        Usage: qoperation execscript -sn importBulkMedia -si ''fully qualified path of comma delimited file''
'
 + CHAR(10) + '        Example: qoperation execscript -sn importBulkMedia -si D:\media\dataFile.csv
'
 + CHAR(10) + '        Sample File:
'
 + CHAR(10) + '        Media label,Group,Barcode,Date written,Date read,Offsite Location,Media Expiry Date,Media Type
'
 + CHAR(10) + '        S81600,ANCFILER,S81600,19-Mar-08,Never,PSI,Never,ULTRIUM V4
'
 + CHAR(10) + '        S81602,ANCFILER,S81602,20-Mar-08,Never,PSI,Never,ULTRIUM V4
'
)
GO

