

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_getMASubClientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_getMASubClientList.sp,v $ $Id: QS_getMASubClientList.sp,v 1.3.210.2 2018/03/20 00:17:34 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_getMASubClientList <<<'

IF EXISTS (select * from sysobjects where name='QS_getMASubClientList')
	drop procedure QS_getMASubClientList
IF EXISTS (select * from GxQscripts where name='QS_getMASubClientList')
	delete from GxQscripts where name = 'QS_getMASubClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_getMASubClientList')
	delete from GXDBVersions where aliasname = 'QS_getMASubClientList'
GO
print '... Creating Procedure: QS_getMASubClientList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_getMASubClientList
AS
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ARITHABORT ON
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
CREATE TABLE #tempArchGrpCopy
(
	clientId	integer,
	archGroupId	integer,
	archCopyId integer
)
--drop table #tempHost
CREATE TABLE #tempHost
(
	clientId		integer,
	clientName		nvarchar(288),
	hostName		nvarchar(288),
	accessPath		nvarchar(288)
)
CREATE TABLE #tempResult
(
	MAClientName		nvarchar(288),
	MAHostName		nvarchar(288),
	IdxAccessPath	nvarchar(288),
	subClientId		int,
	subClientName	nvarchar(288),
	archGroupId		int,
	clientId		int,
	clientName	nvarchar(288)
)
--Get all the MAs in this commcell
INSERT INTO #tempHost
SELECT APPC.id, APPC.name, APPC.net_hostName, IA.Path
FROM APP_Client APPC, MMHost MMH, IdxAccessPath IA, IdxCache IC
WHERE APPC.id = MMH.clientId
and APPC.id = IA.clientId
and IA.IdxCacheId = IC.IdxCacheId
and IC.IdxCacheType = 1
and APPC.id > 1
-- Get all the storage policies which have these MAs in datapaths of the primary copy only.
-- for all copies having preferred datapath setting and only default datapaths are selected
INSERT INTO #tempArchGrpCopy
SELECT distinct T.clientId, AGC.archGroupId, AGC.id
FROM #tempHost T, archGroup AG, archGroupCopy AGC, MMDatapath MM, MMDrivePool MMD
WHERE T.clientId = MMD.ClientId
and MM.DrivePoolId = MMD.DrivePoolId
and MM.copyId = AGC.id
and AG.defaultCopy = AGC.id
and (AGC.flags & 512) = 0
and (MM.Flag & 1) > 0
-- for all copies having roundrobin datapath setting and all datapaths are selected
INSERT INTO #tempArchGrpCopy
SELECT distinct T.clientId, AGC.archGroupId, AGC.id
FROM #tempHost T, archGroup AG, archGroupCopy AGC, MMDatapath MM, MMDrivePool MMD
WHERE T.clientId = MMD.ClientId
and MM.DrivePoolId = MMD.DrivePoolId
and MM.copyId = AGC.id
and AG.defaultCopy = AGC.id
and (AGC.flags & 512) > 0
-- get association of subclients with the storage policies, also filter out the subclients which has subclient datapaths
INSERT INTO #tempResult
SELECT TH.clientName, TH.hostName, TH.accessPath, APPA.id, APPA.subClientName, APPA.dataArchGrpID, APPA.clientId, ''
FROM #tempHost TH, #tempArchGrpCopy TA, APP_Application APPA
WHERE TH.clientId = TA.clientId
and TA.archGroupId = APPA.dataArchGrpId
and APPA.id not in (select componentNameId from APP_AppToDatapath)
INSERT INTO #tempResult
SELECT TH.clientName, TH.hostName, TH.accessPath, APPA.id, APPA.subClientName, APPA.logArchGrpId, APPA.clientId, ''
FROM #tempHost TH, #tempArchGrpCopy TA, APP_Application APPA
WHERE TH.clientId = TA.clientId
and TA.archGroupId = APPA.logArchGrpId
and APPA.logArchGrpId not in (select archGroupId from #tempResult)
Update #tempResult
SET clientName = APPC.name
FROM APP_Client APPC
WHERE #tempResult.clientId = APPC.id
SELECT MAClientName, MAHostName, IdxAccessPath, subClientId, subClientName, clientName
FROM #tempResult
order by MAHostName asc
DROP TABLE #tempHost
DROP TABLE #tempArchGrpCopy
DROP TABLE #tempResult
SCRIPT_EXIT:
set nocount off
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_getMASubClientList')
	delete from GxQscripts where name = 'QS_getMASubClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_getMASubClientList')
	delete from GXDBVersions where aliasname = 'QS_getMASubClientList'
GO

insert into GXDBVersions values(2, 'QS_getMASubClientList',  '00010003021000020000', 'QS_getMASubClientList', '00010003021000020000')
GO

insert into GxQscripts values(2,'QS_getMASubClientList',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn getMASubClientList
'
 + CHAR(10) + '-- 	script_name: getMASubClientList.'
 + CHAR(10) + '-- 	returns a list of MA and the associated subclients of each MA.'
)
GO

