

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_getAllRunningJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetAllRunningJobs')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetAllRunningJobs <<<'
	drop procedure QS_GetAllRunningJobs
END
IF EXISTS (select * from GxQscripts where name='QS_GetAllRunningJobs')
	delete from GxQscripts where name = 'QS_GetAllRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetAllRunningJobs')
	delete from GXDBVersions where aliasname = 'QS_GetAllRunningJobs'
GO
print '... Creating Procedure: QS_GetAllRunningJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetAllRunningJobs
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
-- Convenience Definitions ----------------------
DECLARE @scriptName	varchar(32)
set	@scriptName	= 'GetAllRunningJobs'
-------------------------- Get All Running Jobs ------------------
if OBJECT_ID('tempdb.dbo.#JobOperationName') is not NULL drop table dbo.#JobOperationName
create table #JobOperationName(opType integer, OpName nvarchar(64));
if OBJECT_ID('tempdb.dbo.#JobStateName') is not NULL drop table dbo.#JobStateName
create table #JobStateName(stateType integer, stateName nvarchar(64));
if OBJECT_ID('tempdb.dbo.#JobTypeName') is not NULL drop table dbo.#JobTypeName
create table #JobTypeName(jobType integer, jobTypeName nvarchar(64));
insert into #JobOperationName values	( 0,'No Operation');
insert into #JobOperationName values	( 1,'All Operation');
insert into #JobOperationName values	( 2,'Online');
insert into #JobOperationName values	( 3, 'Offline');
insert into #JobOperationName values	( 4,'Backup');
insert into #JobOperationName values	( 5,'Restore');
insert into #JobOperationName values	( 6, 'Import');
insert into #JobOperationName values	( 7,'CvImport');
insert into #JobOperationName values	( 8 , 'Media Init');
insert into #JobOperationName values	( 9 , 'Media Recycle');
insert into #JobOperationName values	( 10 , 'Prune');
insert into #JobOperationName values	( 11 , 'CS DR Backup');
insert into #JobOperationName values	( 12 , 'Index Restore');
insert into #JobOperationName values	( 13 , 'Aux Copy');
insert into #JobOperationName values	( 14 , 'Synthetic Full');
insert into #JobOperationName values	( 15 , 'W2K System Restore');
insert into #JobOperationName values	( 16 , 'W2K Full Build Restore');
insert into #JobOperationName values	( 17 , 'Report');
insert into #JobOperationName values	( 18 , 'Backup 3RD');
insert into #JobOperationName values	( 19 , 'W2K Full Build Restore371');
insert into #JobOperationName values	( 20 , 'SchedExport');
insert into #JobOperationName values	( 21 , 'Media Inventory');
insert into #JobOperationName values	( 22 , 'Snap Shot');
insert into #JobOperationName values	( 23 , 'Create Replica');
insert into #JobOperationName values	( 24 , 'Update Replica');
insert into #JobOperationName values	( 25 , 'DM Outlook Restore');
insert into #JobOperationName values	( 26 , 'Media Prediction');
insert into #JobOperationName values	( 27 , 'Snap Recovery');
insert into #JobOperationName values	( 28 , 'Schedule');
insert into #JobOperationName values	( 29 , 'Quick DM Restore');
insert into #JobOperationName values	( 30 , 'System State Backup');
insert into #JobOperationName values	( 31 , 'Archive Check');
insert into #JobOperationName values	( 32 , 'Tape Erase');
insert into #JobOperationName values	( 33 , 'Shelf Mangement');
insert into #JobOperationName values	( 34 , 'QR Copy Backup');
insert into #JobOperationName values	( 35 , 'Patch Update');
insert into #JobOperationName values	( 36 , 'Patch Download');
insert into #JobOperationName values	( 37 , 'QR RollBack');
insert into #JobOperationName values	( 38 , 'Selective Delete');
insert into #JobOperationName values	( 39 , 'WorkFlow');
insert into #JobOperationName values	( 40 , 'Index Free Restore');
insert into #JobOperationName values	( 41 , 'Storage Validation');
insert into #JobOperationName values	( 42 , 'Drive Cleaning');
insert into #JobOperationName values	( 43 , 'SysRecovery Backup');
insert into #JobOperationName values	( 44 , 'Browse And Delete');
insert into #JobOperationName values	( 45 , 'Snap Vault Restore');
insert into #JobOperationName values	( 46 , 'Stap Media');
insert into #JobOperationName values	( 47 , 'Catalogue Media');
insert into #JobOperationName values	( 48 , 'SR System Recovery');
insert into #JobOperationName values	( 49 , 'Search And Retrieve');
insert into #JobOperationName values	( 50 , 'Create Consistency Point');
insert into #JobOperationName values	( 51 , 'Create Recovery Point');
insert into #JobOperationName values	( 52 , 'FLR Copy Backup');
insert into #JobOperationName values	( 53 , 'Offline content Index');
insert into #JobOperationName values	( 54 , 'Power Restore');
insert into #JobOperationName values	( 55 , 'Power Search And Restore');
insert into #JobOperationName values	( 56 , 'CDR');
insert into #JobOperationName values	( 57 , 'Online Content Index');
insert into #JobOperationName values	( 58 , 'SRM OpType');
insert into #JobOperationName values	( 59 , 'Snap Backup');
insert into #JobOperationName values	( 60 , 'Snap To Tape');
insert into #JobOperationName values	( 61 , 'Snap Tp Tape WorkFlow');
insert into #JobOperationName values	( 62 , 'SRM Report');
insert into #JobOperationName values	( 63 , 'Maglib Maintenance');
insert into #JobOperationName values	( 64 , 'Info Management');
insert into #JobOperationName values	( 65 , 'Snap Backup3RD');
insert into #JobOperationName values	( 66 , 'Offline Mining Restore');
insert into #JobOperationName values	( 67 , 'Install Client');
insert into #JobOperationName values	( 68 , 'UnInstall Client');
insert into #JobOperationName values	( 69 , 'FDC WorkFlow');
insert into #JobOperationName values	( 70 , 'Mining Backup');
insert into #JobOperationName values	( 71 , 'CCM Capture');
insert into #JobOperationName values	( 72 , 'CCM Merge');
insert into #JobOperationName values	( 73 , 'FDC Client');
insert into #JobOperationName values	( 74 , 'Media Refresh');
insert into #JobOperationName values	( 75 , 'FD CopyType');
insert into #JobOperationName values	( 76 , 'Archive Optype');
insert into #JobOperationName values	( 77 , 'Mining Content Index');
insert into #JobOperationName values	( 78 , 'FDC Preparation');
insert into #JobOperationName values	( 104 , 'Aux Copy');
insert into #JobOperationName values	( 98 , 'Archiving');
insert into #JobOperationName values	( 102 , 'Archiving Restore');
insert into #JobOperationName values	( 87 , 'NAS Backup');
insert into #JobOperationName select operation, OpName from JMOpTable where operation not in (select optype from #JobOperationName)
insert into #JobStateName values (0, 'null');
insert into #JobStateName values (1, 'Running');
insert into #JobStateName values (2, 'Pending');
insert into #JobStateName values (3, 'Waiting');
insert into #JobStateName values (4, 'Completed');
insert into #JobStateName values (5, 'Suspended');
insert into #JobStateName values (6, 'Kill Pending');
insert into #JobStateName values (7, 'Suspend Pending');
insert into #JobStateName values (8, 'Interrupt Pending');
insert into #JobStateName values (9, 'Completed Success');
insert into #JobStateName values (10, 'Failed');
insert into #JobStateName values (11, 'Killed');
insert into #JobStateName values (12, 'Completed w/ one or more errors');
insert into #JobStateName values (13, 'System Kill Pending');
insert into #JobStateName values (14, 'Suspended');
insert into #JobStateName values (15, 'Queued');
insert into #JobStateName values (16, 'Queued');
insert into #JobStateName values (17, 'Running (cannot be verified');
insert into #JobStateName values (18, 'Abnormal Terminated Cleanup');
insert into #JobStateName values (19, 'Completed w/ one or more warnings');
insert into #JobTypeName values (1, 'Full');
insert into #JobTypeName values (2, 'Incremental');
insert into #JobTypeName values (4, 'Differential');
insert into #JobTypeName values (8, 'Any Level');
insert into #JobTypeName values (64, 'Synthetic Full');
insert into #JobTypeName values (128, 'Synthetic Full');
insert into #JobTypeName values (256, 'Trans. Log No Trunc.');
insert into #JobTypeName values (512, 'ASR');
insert into #JobTypeName values (1024, 'Offline Full');
insert into #JobTypeName values (2048, 'Create Snapshot');
insert into #JobTypeName values (4096, 'Create QR Volume');
insert into #JobTypeName values (8192, 'Update QR Volume');
insert into #JobTypeName values (16384, 'Synthetic Full');
insert into #JobTypeName values (32768, 'Online Full');
insert into #JobTypeName values (131072, 'SRM Analysis');
insert into #JobTypeName values (262144, 'SRM Discovery')
Select jobID, case (select COUNT(*) from #JobOperationName where runningBackups.opType = #JobOperationName.opType)
		when 0 then
		     (select JMOpTable.opName from JMOpTable where runningBackups.opType = JMOpTable.operation and JMOpTable.appTypeType = runningBackups.appTypeId)
		else
			(select #JobOperationName.OpName from #JobOperationName where runningBackups.opType = #JobOperationName.opType)
		end as "OperationType",
(select jobtypename from #JobTypeName where runningBackups.bkpLevel = jobType) as JobType, combPriority as Priority,
clientName, instanceName, backupSetName, subclientname, currentPhaseName, currentPolicyName as storagePolicyName, mediaAgentName, jobDescription, DelayReason, UserName, fromTime,
(select stateName from #JobStateName where runningBackups.state = stateType) as StateName, jobStartTime, percentcomplete, filesXfered as FilesTransfered
from RunningBackups runningBackups
Union ALL
Select jobID, case (select COUNT(*) from #JobOperationName where runningAdminJobs.opType = #JobOperationName.opType)
		when 0 then
		     (select JMOpTable.opName from JMOpTable where runningAdminJobs.opType = JMOpTable.operation and JMOpTable.appTypeType = runningAdminJobs.appType)
		else
			(select #JobOperationName.OpName from #JobOperationName where runningAdminJobs.opType = #JobOperationName.opType)
		end as "OperationType",
(select jobtypename from #JobTypeName where RunningAdminJobs.ER_BkpLevel = jobType) as JobType, combPriority as Priority,
		clientName, instanceName, backupSetName, subclientname, currentPhaseName,
storagePolicyName, null as mediaAgentName, jobDescription, DelayReason, UserName, fromTime,
(select stateName from #JobStateName where runningAdminJobs.state = stateType) as StateName, jobStartTime, percentcomplete, NULL as FilesTransfered
from RunningAdminJobs runningAdminJobs
Union ALL
Select jobID, case (select COUNT(*) from #JobOperationName where runningRestores.opType = #JobOperationName.opType)
		when 0 then
		     (select JMOpTable.opName from JMOpTable where runningRestores.opType = JMOpTable.operation and JMOpTable.appTypeType = runningRestores.appType)
		else
			(select #JobOperationName.OpName from #JobOperationName where runningRestores.opType = #JobOperationName.opType)
		end as "OperationType",
NULL as JobType, combPriority as Priority,
		NULL as clientName, NULL as instance, null as backupSetName, null as subclientname,
currentPhaseName, null as storagePolicyName, mediaAgent, jobDescription, DelayReason,
UserName, null as fromTime, (select stateName from #JobStateName where runningRestores.state = stateType) as StateName, jobStartTime, percentcomplete, NULL as FilesTransfered
from RunningRestores runningRestores
drop table #JobOperationName
drop table #JobStatename
drop table #JobTypeName
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_getAllRunningJobs')
	delete from GxQscripts where name = 'QS_getAllRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_getAllRunningJobs')
	delete from GXDBVersions where aliasname = 'QS_getAllRunningJobs'
GO

insert into GXDBVersions values(2, 'QS_getAllRunningJobs',  '00000000000000000000', 'QS_getAllRunningJobs', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_getAllRunningJobs',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetAllRunningJobs
'
 + CHAR(10) + '--   script_name :GetAllRunningJobs'
)
GO

