

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_getAlertSNMPNotification.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_getAlertSNMPnotification <<<'

IF EXISTS (select * from sysobjects where name='QS_getAlertSNMPnotification')
	drop procedure QS_getAlertSNMPnotification
IF EXISTS (select * from GxQscripts where name='QS_getAlertSNMPnotification')
	delete from GxQscripts where name = 'QS_getAlertSNMPnotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_getAlertSNMPnotification')
	delete from GXDBVersions where aliasname = 'QS_getAlertSNMPnotification'
GO
print '... Creating Procedure: QS_getAlertSNMPnotification'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_getAlertSNMPnotification
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'getAlertSNMPnotification'
DECLARE @NT_ALERTTYPE_SRM_ADVISORY		integer
SET     @NT_ALERTTYPE_SRM_ADVISORY		= 49
DECLARE @NT_SNMP_ALERTNOTIF			    integer
SET     @NT_SNMP_ALERTNOTIF				= 4
--DECLARE @SC_STATUS_BITS        integer
--SET		@SC_STATUS_BITS        =  2+4+16					-- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DUMMY
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
--DECLARE @appTypeId				integer
--DECLARE @instanceId				integer
--DECLARE @backupSetId			integer
--DECLARE	@subClientId			integer
-- DONE PROCESSING CMD ARGS, START THINGS GOING: ------
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
-- Please refer sql stored procedure br_NTalertList for detail
DECLARE @hasSRM             int
SET @hasSRM    = ISNULL(db_id('SRM'), 0)
SELECT NTnotificationRule.NotificationName as AlertName,
		NTAlertType.name as AlertType,
		CASE (NTnotificationRule.NotifType & @NT_SNMP_ALERTNOTIF)WHEN @NT_SNMP_ALERTNOTIF THEN 'YES' ELSE 'NO' END as SNMPEnabled
FROM NTnotificationRule,NTAlertType
WHERE NTnotificationRule.alertTypeId = NTAlertType.id
		-- as per sql stored procedure br_NTalertList logic used to not show  SRM ADVISORIES Alerts is different than this thats why its is commented
		--AND NTnotificationRule.alertTypeId <> @NT_ALERTTYPE_SRM_ADVISORY
		AND NTnotificationRule.revision > 0
		-- Do NOT show these ALERTS
		AND NOT
		(
			-- ROMS ALERTS
			( NTnotificationRule.status &64 = 64 )
			---- JOB BASED ALERTS
			--OR	( (NTnotificationRule.status &32 = 32) OR (NTnotificationRule.status &8 = 8)))
			-- SRM ADVISORIES ALERTS
			OR	( (NTnotificationRule.status &32 = 32) OR (NTnotificationRule.status &8 = 8) )
		)
		-- IF SRM ISN'T INSTALLED (ANYMORE) --
		-- .. DON'T RETURN SRM ALERTS       --
		AND NOT
		(
			@hasSRM <> 0 AND (
			NTnotificationRule.categoryId = 7   				--'NT_CATEGORY_SRM'
			OR NTnotificationRule.alertTypeId in (
						51,					-- 'NT_ALERTTYPE_SRM'
						56,			-- 'NT_ALERTTYPE_SRM_REPORT'
						31, 			-- 'NT_ALERTTYPE_SRM_WINFS'
						32,			-- 'NT_ALERTTYPE_SRM_ORACLE'
						33,				-- 'NT_ALERTTYPE_SRM_SQL'
						34,				-- 'NT_ALERTTYPE_SRM_NAS'
						35,			-- 'NT_ALERTTYPE_SRM_EXCHANGE'
						36,		-- 'NT_ALERTTYPE_SRM_SHARE_POINT'
						37,			-- 'NT_ALERTTYPE_SRM_UNIXFS'
						38,		--'NT_ALERTTYPE_SRM_COST_ANALYSIS'
						39 )   		--'NT_ALERTTYPE_SRM_NETWARE'
			)
		)
 SET @lastError = @@error
	IF @lastError <> 0
		GOTO ARGS_ERROR
---------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_getAlertSNMPNotification')
	delete from GxQscripts where name = 'QS_getAlertSNMPNotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_getAlertSNMPNotification')
	delete from GXDBVersions where aliasname = 'QS_getAlertSNMPNotification'
GO

insert into GXDBVersions values(2, 'QS_getAlertSNMPNotification',  '00000000000000000000', 'QS_getAlertSNMPNotification', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_getAlertSNMPNotification',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qscript -f getAlertSNMPnotification.sql 
'
 + CHAR(10) + '--   script_name : getAlertSNMPnotification'
)
GO

