

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_enableLaptopBackup.sp] ---------- 

-------------------------------------------
--         Name:   QS_enableLaptopBackup.sql
--         Date:   14-Jul-2011
--       Author:   SKatz
--  Description:   Enable/Disable laptop Backup Property for a client
--
-- TR(original):   None
--     Customer:   Cargill
--   CommcellId:   N/A (generic)
-------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_enableLaptopBackup')
BEGIN
	print '>>> Drop Stored Procedure: QS_enableLaptopBackup <<<'
	drop procedure QS_enableLaptopBackup
END
IF EXISTS (select * from GxQscripts where name='QS_enableLaptopBackup')
	delete from GxQscripts where name = 'QS_enableLaptopBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_enableLaptopBackup')
	delete from GXDBVersions where aliasname = 'QS_enableLaptopBackup'
GO
print '... Creating Procedure: QS_enableLaptopBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_enableLaptopBackup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
  @NEWSTATE varchar(1024) = '',
  @CLIENTNAME varchar(1024) = ''
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'QS_enableLaptopBackup'
DECLARE @created			   integer
SET     @created				= 0
DECLARE @LAPTOP_STATUS_BIT     integer
SET		@LAPTOP_STATUS_BIT     =  4096				--  CV_STATUS_PERSONAL_WKSTN    0x1000
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @clientId				integer
DECLARE @isEnabled				integer
SET		@isEnabled				= 0
DECLARE	@currStatus				integer
SET		@currStatus				= 0
DECLARE @OldState				varchar(512)
DECLARE @NewStateName			varchar(128)
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @lastError				integer
SET     @lastError  			= 0							-- Be optimistic
DECLARE @cpFound				integer
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF (@newState = @NoParameter)
BEGIN														------------------------------
	SET @localErrorMsg	='Error. No new state Specified.'	-- CHECK FOR 'NEW' STATE	--
	Set @lastError = 1										------------------------------
	goto   ARGS_ERROR
END
--
------------------------------------------------
-- "Normalize" new state to what Props Expect --
------------------------------------------------
IF(@newState = N'OFF')
	SET @isEnabled	= 0
ELSE IF(@newState = N'ON')
	SET @isEnabled	= 1
ELSE
BEGIN
	SET @localErrorMsg	='Error. Invalid state ['+ @newState + '] specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF (@clientName = @NoParameter)								------------------------------
BEGIN														-- CHECK FOR CLIENT NAME	--
	SET @localErrorMsg	='Error. No Client Name Specified.'	------------------------------
	Set @lastError = 1
	goto   ARGS_ERROR
END
--
--------------------------------------
-- Figure Out ClientId from name	--
--------------------------------------
SET @clientId     = (Select id from APP_CLIENT where name = @CLIENTNAME)
IF @clientId is Null
BEGIN
	SET @localErrorMsg	='No Client with name ['+@ClientName+'] exists.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--
BEGIN TRY
	BEGIN TRAN
	SET @currStatus = (select status FROM App_Client where id = @clientId)
--	USER WANTS TO ENABLED LAPTOP BACKUP AND IT IS NOT CURRENTLY ENABLED:
	IF @isEnabled <> 0
	BEGIN
		UPDATE APP_CLIENT SET STATUS = STATUS  | @LAPTOP_STATUS_BIT WHERE id = @clientId
		-- If Personal Workstation client property exist enable it
		UPDATE cp
			SET cp.attrVal = N'1'	-- enabling
		FROM APP_ClientProp cp
		WHERE
			cp.modified = 0
			AND cp.attrName = N'Personal Workstation'
			AND cp.componentNameId = @clientId
		SET  @cpFound = @@ROWCOUNT
		IF (@cpFound = 0)
		BEGIN
			INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				VALUES(@clientId, N'Personal Workstation', 7, N'1', @nowTime, 0, 0)
		END
	END
--	USER WANTS TO DISABLE LAPTOP BACKUP AND IT IS CURRENTLY ENABLED:
	IF @isEnabled = 0
	BEGIN
		UPDATE APP_CLIENT SET STATUS = STATUS & ~@LAPTOP_STATUS_BIT WHERE id = @clientId
		-- If Personal Workstation client property exist disable it
		UPDATE cp
			SET cp.attrVal = N'0'		-- disabling
		FROM APP_ClientProp cp
		WHERE
			cp.modified = 0
			AND cp.attrName = N'Personal Workstation'
			AND cp.componentNameId = @clientId
		SET  @cpFound = @@ROWCOUNT
		IF (@cpFound = 0)
		BEGIN
			INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				VALUES(@clientId, N'Personal Workstation', 7, N'0', @nowTime, 0, 0)
		END
/* PER ANAND V., DON'T AGE OFF ANY LOCAL CONTENT ADDED.  LEAVING CODE COMMENTED OUT, "JUST IN CASE"
		UPDATE APP_SCFILTERFILE
			SET MODIFIED = @nowTime
			WHERE componentNameId in (SELECT DISTINCT id
										FROM APP_APPLICATION
										WHERE clientId = @clientId
										  AND appTypeId in (select appTypeId from APP_AppTypeGroupAssoc where appgroupId=35))
 */
		-- See if the Laptop Client is a CCS Laptop configuration
		DECLARE @ccsEnabled INT = 0
		SELECT
			@ccsEnabled = 1
		FROM APP_ClientProp cp WITH(NOLOCK)
		WHERE
			cp.attrName = N'CCS Enabled'
			AND cp.modified = 0
			AND cp.attrVal = N'1'
			AND cp.componentNameId = @clientId
		IF (@ccsEnabled = 1)
		BEGIN
			DECLARE @startTime INT = 0
			SET @startTime = dbo.GetUnixTime(GETUTCDATE())
			-- Disabled CCS Operations
			UPDATE cp
				SET attrVal = N'0'
			FROM APP_ClientProp cp
			WHERE
				cp.attrName = N'CCS Enabled'
				AND cp.modified = 0
				AND cp.attrVal = N'1'
				AND cp.componentNameId = @clientId
			-- Delete outstanding Token 19 rows for clients being reloaded or disabled, no use pushing this data to clients
            DELETE wqr
            FROM APP_WorkQueueRequest wqr
			WHERE
                wqr.clientId = @clientId
                AND wqr.workToken = 19      -- WORK_TOKEN_CCS_DB_UPDATE
			 UPDATE adv
                SET value = N'DISABLED',
                    enabled = 1,
                    deleted = 0
            FROM APP_AdvanceSettings adv
            WHERE
                adv.entityType = 3      -- CLIENT ENTITY TYPE
                AND adv.entityId = @clientId
                AND adv.keyName = N'sCCSDbStatus'
                AND adv.relativePath = N'iDataAgent'
			-- Disable CCS Operations on the client
			INSERT INTO APP_WorkQueueRequest(clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
				VALUES (
					@clientId,
					-1,
					49,       -- WORK_TOKEN_CCS_DB_CHANGE_STATE
					'RELOAD_DISABLED',
					@startTime,
					0,
					0,
					0
				)
		END
	END
END TRY
--
--
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END   CATCH
IF @lastError  = 0
	COMMIT  Tran
ELSE
	ROLLBACK Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: newstate = ['
         + @newState
         + '], client = ['
         + @clientName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_enableLaptopBackup')
	delete from GxQscripts where name = 'QS_enableLaptopBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_enableLaptopBackup')
	delete from GXDBVersions where aliasname = 'QS_enableLaptopBackup'
GO

insert into GXDBVersions values(2, 'QS_enableLaptopBackup',  '00000000000000000000', 'QS_enableLaptopBackup', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_enableLaptopBackup',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn enableLaptopBackup -si ''ON''|''OFF'' -si ''clientName'''
 + CHAR(10) + '--       To enable/disable laptop backup for a particular client'
)
GO

