

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_changeScheduleOwner.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ChangeScheduleOwner <<<'

IF EXISTS (select * from sysobjects where name='QS_ChangeScheduleOwner')
	drop procedure QS_ChangeScheduleOwner
IF EXISTS (select * from GxQscripts where name='QS_ChangeScheduleOwner')
	delete from GxQscripts where name = 'QS_ChangeScheduleOwner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeScheduleOwner')
	delete from GXDBVersions where aliasname = 'QS_ChangeScheduleOwner'
GO
print '... Creating Procedure: QS_ChangeScheduleOwner'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ChangeScheduleOwner
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @oldUserName NVARCHAR(1024),
  @newUserName NVARCHAR(1024),
  @scheduleName NVARCHAR(1024) = N'',
  @operationType INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @errorCode int
DECLARE @errorString nvarchar(1024)
SET @errorcode = 0
SET @errorstring = 'Succeeded.'
DECLARE @oldUserId INT = 0
DECLARE @newUserId INT = 0
DECLARE @scheduleId INT = 0
SET @oldUserId = ISNULL((SELECT id FROM UMUsers (READUNCOMMITTED) WHERE login = @oldUserName), 0)
IF @oldUserId = 0
	SET @oldUserId = ISNULL((SELECT id FROM UMUsers (READUNCOMMITTED) WHERE login LIKE @oldUserName + '(Deleted%'), 0)
IF @oldUserId = 0
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Error. Previous user name ['+ @oldUserName +'] was not found in DataBase.'
	GOTO cleanup
END
SET @newUserId = ISNULL((SELECT id FROM UMUsers (READUNCOMMITTED) WHERE login = @newUserName), 0)
IF @newUserId = 0
BEGIN
	SET @errorCode=-2
	SET @errorString = 'Error. New user name ['+ @newUserName +'] was not found in DataBase.'
	GOTO cleanup
END
IF @scheduleName <> ''
BEGIN
	SET @scheduleId = ISNULL((SELECT TOP 1 T.taskId FROM TM_SubTask (READUNCOMMITTED) S
JOIN TM_Task (READUNCOMMITTED) T ON T.taskId = S.taskId AND T.deleted = 0 AND T.taskType IN (2) AND T.ownerId = @oldUserId
								WHERE subTaskName = @scheduleName), 0)
	IF @scheduleId = 0
SET @scheduleId = ISNULL((SELECT TOP 1 taskId FROM TM_Task (READUNCOMMITTED) WHERE deleted = 0 AND taskType = 4 AND ownerId = @oldUserId
								AND taskName = @scheduleName), 0)
END
BEGIN TRY
BEGIN TRAN
	UPDATE tmJob
	SET value=@newUserId
	FROM TM_JobOptions tmJob
	INNER JOIN TM_SubTask tmSub
	ON tmJob.subTaskId = tmSub.subTaskId
	WHERE ( tmJob.taskId = @scheduleId OR @scheduleId = 0)
	AND (tmJob.optionId=140019 OR tmJob.optionId=140021)
	AND (tmSub.operationType = @operationType OR @operationType=0)
	AND modified=0
	AND tmJob.value <> @newUserId
	UPDATE tmTask
	SET ownerId = @newUserId, runUserId = @newUserId
	FROM TM_Task tmTask
	inner join TM_SubTask tmSub
	ON tmTask.taskId = tmSub.taskId
	WHERE (tmTask.ownerId = @oldUserId OR tmTask.runUserId = @oldUserId)
	AND
	(tmTask.taskId = @scheduleId OR @scheduleId = 0)
	AND
	(tmSub.operationType = @operationType OR @operationType = 0)
	AND
	(tmTask.ownerId <> @newUserId OR tmTask.runUserId <> @newUserId)
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	ROLLBACK TRAN
	SET @errorcode = ERROR_NUMBER()
	SET @errorstring = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END
End CATCH
cleanup:
if @errorCode <> 0
    Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
    )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_changeScheduleOwner')
	delete from GxQscripts where name = 'QS_changeScheduleOwner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_changeScheduleOwner')
	delete from GXDBVersions where aliasname = 'QS_changeScheduleOwner'
GO

insert into GXDBVersions values(2, 'QS_changeScheduleOwner',  '00000000000000000000', 'QS_changeScheduleOwner', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_changeScheduleOwner',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn ChangeScheduleOwner -si oldUserName -si newUserName [-si scheduleName] [-si operationType]
'
)
GO

