

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_associateGlobalDedupPolicyToCopy.sp] ---------- 

------------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_associateGlobalDedupPolicyToCopy.sp,v $ $Id: QS_associateGlobalDedupPolicyToCopy.sp,v 1.5.60.2 2018/03/27 08:19:06 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_associateGlobalDedupPolicyToCopy <<<'

IF EXISTS (select * from sysobjects where name='QS_associateGlobalDedupPolicyToCopy')
	drop procedure QS_associateGlobalDedupPolicyToCopy
IF EXISTS (select * from GxQscripts where name='QS_associateGlobalDedupPolicyToCopy')
	delete from GxQscripts where name = 'QS_associateGlobalDedupPolicyToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_associateGlobalDedupPolicyToCopy')
	delete from GXDBVersions where aliasname = 'QS_associateGlobalDedupPolicyToCopy'
GO
print '... Creating Procedure: QS_associateGlobalDedupPolicyToCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_associateGlobalDedupPolicyToCopy
-- Qscript Usage.
-- Stored Procedure Inputs
  @copyParam varchar(1024) = '',
  @spParam varchar(1024) ='',
  @globalSpParam varchar(1024) = ''
AS
Set NOCOUNT ON
--INput variables
DECLARE @i_copyName VARCHAR(1024)
DECLARE @i_spName VARCHAR(1024)
DECLARE @i_globalSpName VARCHAR(1024)
DECLARE @i_copyId INT
DECLARE @i_spId INT
declare @i_gdpId INT
set @i_copyId=0
set @i_spId=0
set @i_gdpId=0
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'QS_associateGlobalDedupPolicyToCopy'
DECLARE @errorString	varchar(512)
SET		@errorString	='Error Encountered when running script.'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @countRows INT
SET @countRows=0
IF OBJECT_ID('tempdb.dbo.#EligibleArchGroups') is not null DROP TABLE #EligibleArchGroups
CREATE TABLE #EligibleArchGroups(id int ,name NVARCHAR(255))
--Copy Param
	IF (@copyParam= @NoParameter)
	BEGIN
		SET @lastError = 1
		select 'Error: Missing parameter, please provide a Copy name for which global dedup host policy to be associated'
		GOTO SCRIPT_EXIT
	END
	ELSE
	BEGIN
		SET	@i_copyName =  @copyParam
	END
--Storage Policy Param
	if (@spParam	=@NoParameter)
	BEGIN
		SET @lastError = 1
		select  'Error: Missing parameter, please provide storage policy name -si "storagepolicyname"'
		GOTO SCRIPT_EXIT
	END
	ELSE
	BEGIN
		SET @i_spName  = @spParam
		IF  exists (select top 1  id from archGroup WITH (READUNCOMMITTED) where  name = @i_spName )
									BEGIN
									set @i_spId =(select top 1  id from archGroup WITH (READUNCOMMITTED) where name =@i_spName  and (origCCcommCellid =0 or origCCcommCellid=2))
									END
		ELSE
		BEGIN
			SET @lastError = 1
			select 'Error: Invalid storage policy ['+ case when @i_spName is not null and len(@i_spName)>0 then @i_spName else '' end + ']'
			GOTO SCRIPT_EXIT
		END
		IF  exists (select top 1  id from archGroupCopy WITH (READUNCOMMITTED) where  archgroupId = @i_spId and name =  @i_copyName and (origCCcommCellid =0 or origCCcommCellid=2))
		BEGIN
			SET @i_copyId = (select top 1  id from archGroupCopy WITH (READUNCOMMITTED) where  archgroupId = @i_spId and name =  @i_copyName and (origCCcommCellid =0 or origCCcommCellid=2))
		END
		ELSE
		BEGIN
			SET @lastError = 1
			select  'Error: Storage policy  ['+ case when @i_spName is not null and len(@i_spName)>0 then @i_spName else '' end + '] is not having copy with name ['+case when @i_copyName is not null and len(@i_copyName)>0 then @i_copyName else '' end  +']'
			GOTO SCRIPT_EXIT
		END
	END
--Global Storage Policy Param
	if (@globalSpParam	=@NoParameter)
	BEGIN
		SET @lastError = 1
		select 'Error: Missing parameter, please provide Global Dedup storage policy name -si "global dedup storagepolicy"'
		GOTO SCRIPT_EXIT
	END
	ELSE
	BEGIN
		SET	@i_globalSpName  = @globalSpParam
IF  exists (select top 1  id from archGroup WITH (READUNCOMMITTED) where  name = @i_globalSpName and  flags & 256 = 256  and (origCCcommCellid =0 or origCCcommCellid=2) )
			BEGIN
set @i_gdpId =(select top 1  id from archGroup WITH (READUNCOMMITTED) where name = @i_globalSpName and  flags & 256 = 256 and (origCCcommCellid =0 or origCCcommCellid=2))
									END
		ELSE
		BEGIN
			SET @lastError = 1
			select  'Error: Invalid Global dedup storage policy ['+ case when @i_globalSpName is not null and len(@i_globalSpName)>0 then @i_globalSpName else '' end + ']'
			GOTO SCRIPT_EXIT
		END
	END
--select *, from archGroupCopy CVA_SP_GLOBAL_DEDUP_FLAG
declare @defaultCpopy int =0
declare @dedpFlags int = 262144
declare @copyDdpFlags int =0
BEGIN TRY
if  ( exists (select id from archGroup  WITH (READUNCOMMITTED) where (origCCcommCellid =0 or origCCcommCellid=2) and type= 2 and id=@i_spId))
BEGIN
	SET @lastError = 2
	select  'Error:  storage policy  ['+case when @i_spName is not null and len(@i_spName)>0 then @i_spName else '' end +'] is DR storage policy.'
	GOTO SCRIPT_EXIT
END
if (exists (select 1 from MMDataPath where copyId=@i_copyId and spareGroupId<>0))
Begin
	SET @lastError = 2
	select  'Error:  storage policy copy ['+case when @i_copyName is not null and len(@i_copyName)>0 then @i_copyName else '' end +'] is created using tape library'
	GOTO SCRIPT_EXIT
End
--CVA_AGCOPYTYPE_TRANSITIVE 5
if (exists (select id from archGroupCopy WITH (READUNCOMMITTED) where (origCCcommCellid =0 or origCCcommCellid=2) and id = @i_copyId and type = 5 and archGroupId = @i_spId))
Begin
	SET @lastError = 2
	select  'Error:  storage policy copy ['+case when @i_copyName is not null and len(@i_copyName)>0 then @i_copyName else '' end +'] is transitive copy. Transitive copy cannot be associated to global dedup host policy'
	GOTO SCRIPT_EXIT
End
--CVA_SIDB_STORE_ENABLED_FLAG  262144
set @copyDdpFlags =( select dedupeflags & 262144 from archGroupCopy where id=@i_copyId)
if (@copyDdpFlags=@dedpFlags)
Begin
	SET @lastError = 2
	select 'Error: Dedup is already enabled on this copy ['+case when @i_copyName is not null and len(@i_copyName)>0 then @i_copyName else '' end +']'
	GOTO SCRIPT_EXIT
End
if (exists (select 1 from archGroupCopy  WITH (READUNCOMMITTED) where isMirrorCopy=1 and id=@i_copyId))
begin
	select ' Error: copy ['+case when @i_copyName is not null and len(@i_copyName)>0 then @i_copyName else '' end +']is Mirror copy cannot be associated to global dedup storage polcy'
	SET @lastError = 2
	GOTO SCRIPT_EXIT
end
if (exists (select 1 from archGroup  WITH (READUNCOMMITTED) where id=@i_spId and  (flags& 256) = 256))
Begin
	select ' Error: Storage Policy ['+case when @i_spName is not null and len(@i_spName)>0 then @i_spName else '' end +'] is Global dedup policy , please provide another storage policy'
	SET @lastError = 2
	GOTO SCRIPT_EXIT
End
if (exists (select 1 from archGroupCopy WITH (READUNCOMMITTED) where isSnapCopy=1 and id=@i_copyId))
begin
	SET @lastError = 2
	select ' Error: copy ['+case when @i_copyName is not null and len(@i_copyName)>0 then @i_copyName else '' end +'] is Snap copy cannot be associated to global dedup storage polcy'
	GOTO SCRIPT_EXIT
end
insert into #EligibleArchGroups
exec  archGlobalDedupePolicyList 0,0,@i_spId
if not exists (select 1 from #EligibleArchGroups where id =@i_gdpId)
Begin
	SET @lastError = 2
	select ' Error: Global dedup Storage policy  ['+case when @i_globalSpName is not null and len(@i_globalSpName)>0 then @i_globalSpName else '' end +'] is already used in other copy. Two copies of the same storage policy can not use the same Global Dedupe Host Policy'
	GOTO SCRIPT_EXIT
End
	set @defaultCpopy = (select defaultcopy  from archGroup  WITH (READUNCOMMITTED) where id=@i_spId)
	 if (@defaultCpopy= @i_copyId )
	 Begin
		if (exists (select 1 from JMBkpJobInfo WITH (READUNCOMMITTED)  where currentPolicy=@i_spId) )
		Begin
			SET @lastError = 2
			select ' Error: Jobs are running for this Storage Policy  ['+case when @i_spName  is not null and len(@i_spName )>0 then @i_spName  else '' end +']'
			GOTO SCRIPT_EXIT
		End
	 End
	 if (exists (select 1 from JMjobdataStats WITH (READUNCOMMITTED) where archgrpCopyId = @i_copyId and status <> 101) or exists (select 1 from archFileCopy where archCopyId=@i_copyId))
	 Begin
			SET @lastError = 2
			select ' Error: Copy  ['+case when @i_copyName  is not null and len(@i_copyname )>0 then @i_copyName  else '' end +'] already used for backups please associate a new copy.'
			GOTO SCRIPT_EXIT
		End
	 if (exists (select 1 from JMAdminJobInfoTable WITH (READUNCOMMITTED) where archGrpId=@i_spId))
	 Begin
			SET @lastError = 2
			select ' Error: Jobs are running for this Storage Policy  ['+case when @i_spName  is not null and len(@i_spName )>0 then @i_spName  else '' end +']'
			GOTO SCRIPT_EXIT
	 End
    BEGIN TRAN
	delete from App_apptodatapath where datapathid in (select datapathid from MMDataPath where CopyId=@i_copyId )
	update MMmediagroup set DrivePoolId =0 , SpareGroupId =0  ,DesiredMediaTypeId=0 ,RecordingFormatId=0 , DataPathId =0
		 where datapathid in (select datapathid from MMDataPath where CopyId=@i_copyId )
	delete from MMDataPath where CopyId=@i_copyId
update archGroupCopy set dedupeFlags = dedupeFlags | 134217728  , maxMultiPlex =0   where id=@i_copyId and  (origCCcommCellid =0 or origCCcommCellid=2)
update archGroup SET flags = flags | (32 | 4) where id=@i_spId and  (origCCcommCellid =0 or origCCcommCellid=2)
	exec ArchCopyUseGlobalDedupe  @i_copyId,@i_gdpId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @errorString = 'Failed to associate . ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE: '+ERROR_MESSAGE()
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
IF @lastError <> 0
	BEGIN
		IF (@lastError = 1 )
		BEGIN
			select 'Failed to associate'
			SELECT usage FROM GxQscripts
			WHERE name = 'QS_associateGlobalDedupPolicyToCopy'
		END
		ELSE IF (@lastError=2)
		BEGIN
			select 'Failed to associate'
		END
		ELSE
		BEGIN
			ROLLBACK TRAN
			Raiserror(@errorString,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
		END
	END
ELSE
	BEGIN
		COMMIT TRAN
		SELECT 'Successful'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_associateGlobalDedupPolicyToCopy')
	delete from GxQscripts where name = 'QS_associateGlobalDedupPolicyToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_associateGlobalDedupPolicyToCopy')
	delete from GXDBVersions where aliasname = 'QS_associateGlobalDedupPolicyToCopy'
GO

insert into GXDBVersions values(2, 'QS_associateGlobalDedupPolicyToCopy',  '00010005006000020000', 'QS_associateGlobalDedupPolicyToCopy', '00010005006000020000')
GO

insert into GxQscripts values(2,'QS_associateGlobalDedupPolicyToCopy',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '--    This command is for associating copy to global dedup host policy.  '
 + CHAR(10) + '--    Copy must be already created using GUI or Command line.   '
 + CHAR(10) + '   	 run the following command from Base using qlogin
'
 + CHAR(10) + '-- 		qoperation execscript -sn associateGlobalDedupPolicyToCopy  -si ''copy name'' -si ''storage policy name''  -si ''global dedup storage policy name'''
 + CHAR(10) + '--       qoperation execscript -sn associateGlobalDedupPolicyToCopy -help'
)
GO

