

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_archViewSISavings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_archViewSISavings <<<'

IF EXISTS (select * from sysobjects where name='QS_archViewSISavings')
	drop procedure QS_archViewSISavings
IF EXISTS (select * from GxQscripts where name='QS_archViewSISavings')
	delete from GxQscripts where name = 'QS_archViewSISavings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_archViewSISavings')
	delete from GXDBVersions where aliasname = 'QS_archViewSISavings'
GO
print '... Creating Procedure: QS_archViewSISavings'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_archViewSISavings
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_ClientId int = 0,
  @i_appTypeId int = 0,
  @i_instanceId int = 0,
  @i_backupsetId int = 0,
  @i_subclientId int = 0,
  @i_JobId int = 0,
  @i_commCellId int = 0,
  @i_BackupLevel varchar(50) = 'FULL',
  @i_archGrpId int = 0,
  @i_archCopyId int = 0,
  @i_reqjobInfo int = 0
AS
SET NOCOUNT ON
-- Backup levels
-- FULL				= 0x1 | 0x40 | 0x80 | 0x400 | 0x8000
-- INCR		 		= 0x2
-- DIFFERENTIAL		= 0x4
-- SYNTHETIC_FULL	= 0x40
-- SYNTHETIC_FULL_AND_INCR = 0x80
-- SEL_OFFLINE_FULL	= 0x400
-- SEL_ONLINE_FULL	= 0x8000
DECLARE @bkpLevel int
IF @i_BackupLevel like 'FULL'
	SET @bkpLevel = 1
ELSE IF @i_BackupLevel like 'INCR'
	SET @bkpLevel = 2 --0x2
ELSE IF @i_BackupLevel like 'DIFF'
	SET @bkpLevel = 4 --0x4
ELSE IF @i_BackupLevel like 'SYNFULL'
	SET @bkpLevel = 64 --0x40
ELSE IF @i_BackupLevel like 'SYNFULLINCR'
	SET @bkpLevel = 128 --0x80
ELSE IF @i_BackupLevel like 'SELOFFLINEFULL'
	SET @bkpLevel = 1024 --0x400
ELSE IF @i_BackupLevel like 'SELONLINEFULL'
	SET @bkpLevel = 32768 --0x8000
IF	@bkpLevel = 1
	SET @bkpLevel = (1 + 64 + 128 + 1024 + 32768)
CREATE TABLE #JobList
(
	jobId				int,
	jobStatus			int,
	agedTime			int,
	appId				int,
	commCellId			int,
	totalUncompBytes	bigint
)
IF	@i_archCopyId > 0
	INSERT INTO #JobList
	SELECT DISTINCT JMB.jobId,JMB.status,JMB.agedTime,JMB.appId, JMB.commCellId, JMB.totalUncompBytes
	FROM JMBkpStats JMB, JMJobDataStats JMD
	WHERE JMB.jobId = JMD.jobId
	AND JMB.commCellId = JMD.commCellId
	AND JMD.archGrpCopyId = @i_archCopyId
ELSE
IF	@i_archGrpId > 0
	INSERT INTO #JobList
	SELECT jobId, status,agedTime,appId, commCellId, totalUncompBytes
	FROM JMBkpStats
	WHERE dataArchGrpId = @i_archGrpId OR logArchGrpId = @i_archGrpId
ELSE
IF	@i_JobId > 0 AND @i_commCellId > 0
	INSERT	INTO #JobList
	SELECT	jobId, status,agedTime,appId, commCellId, totalUncompBytes
	FROM	JMBkpStats
	WHERE	jobId = @i_JobId AND commCellId = @i_commCellId
ELSE
IF	@i_ClientId > 0
	INSERT	INTO #JobList
	SELECT	J.jobId,J.status,J.agedTime, J.appId, J.commCellId, J.totalUncompBytes
	FROM	JMBkpStats J, APP_Application A
	WHERE	J.appId = A.id AND A.clientId = @i_ClientId
		AND (@i_appTypeId = 0 OR A.appTypeId = @i_appTypeId)
		AND (@bkpLevel = 0 OR (J.bkpLevel & @bkpLevel) <> 0)
		AND J.status in (1, 3, 14)
IF (@i_archGrpId > 0) OR (@i_archCopyId > 0)
BEGIN
CREATE TABLE #tempResult
(
	clientId			int,
	clientName			nvarchar(max),
	appTypeId			int,
	appTypeName			nvarchar(max),
	backupsetId			int,
	backupSetName		nvarchar(max),
	subClientId			int,
	subClientName		nvarchar(max),
	instanceId			int,
	instanceName		nvarchar(max),
	totalDataSize	bigint,
	sizeOnMedia	bigint,
	LastBackupTime		int,
	DedupSavings		bigint,
	jobsCount			int,    --useless column for tempResult, it is added only to match the output parameter for the response
	jobId				int,
	jobStatus			varchar(50)  ,
	agedTime			int
)
IF (@i_archGrpId > 0)
BEGIN
	INSERT INTO #tempResult
	SELECT
	MAX(A.ClientId),
	'',
	MAX(A.appTypeId),
	'',
	0,
	'',
	J.appId,
	'',
	0,
	'',
	0,
	0,
	0,
	SUM(ISNULL(AFD.secondaryObjSize, 0) + ISNULL(AFD.secondaryMetaDataSize, 0)
								+ ISNULL(AFD.primaryMetaDataSize, 0)) as DedupSavings
	,1,J.jobId,
	CASE
    WHEN J.jobStatus = 0 THEN 'Running'
    WHEN J.jobStatus = 1 THEN 'Completed'
    WHEN J.jobStatus = 2 THEN 'Failed'
    WHEN J.jobStatus = 3 THEN 'Completed with errors'
    WHEN J.jobStatus = 4 THEN 'Killed'
    WHEN J.jobStatus = 5 THEN 'Suspended'
    WHEN J.jobStatus = 6 THEN 'Interrupted'
    WHEN J.jobStatus = 7 THEN 'Any Status'
    WHEN J.jobStatus = 8 THEN 'Skipped'
    WHEN J.jobStatus = 9 THEN 'Failed To Start'
    ELSE 'Not Available'
    END AS "Status",
	J.agedTime
	FROM #JobList J
	 INNER JOIN APP_Application A
		ON J.appId = A.id
	 INNER JOIN archFile AF
		ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.isValid = 1
	 INNER JOIN archGroup AG
		ON AG.id = @i_archGrpId
	 INNER JOIN archFileCopy AFC
		ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = AG.defaultCopy AND (AFC.flags & 256) = 0
	 LEFT OUTER JOIN archFileCopyDedup AFD
		ON AFD.archFileId = AFC.archFileId AND AFD.commCellId = AFC.commCellId AND AFD.archCopyId = AFC.archCopyId
	GROUP BY J.appId,J.jobId,J.jobStatus,J.agedTime
	UPDATE #tempResult
	SET sizeOnMedia = (SELECT SUM(J.sizeOnMedia) FROM JMJobDataStats J, archGroup AG WHERE AG.id = @i_archGrpId	AND J.archGrpCopyId = AG.defaultCopy  AND J.jobId = #tempResult.jobId)
END
ELSE IF (@i_archCopyId > 0)
BEGIN
	INSERT INTO #tempResult
	SELECT
	MAX(A.ClientId),
	'',
	MAX(A.appTypeId),
	'',
	0,
	'',
	J.appId,
	'',
	0,
        '',
        0,
	0,
	0,
	SUM(ISNULL(AFD.secondaryObjSize, 0) + ISNULL(AFD.secondaryMetaDataSize, 0)
								+ ISNULL(AFD.primaryMetaDataSize, 0)) as DedupSavings
	,1,J.jobId	,
	J.jobStatus,
	J.agedTime
	FROM #JobList J
	 INNER JOIN APP_Application A
		ON J.appId = A.id
	 INNER JOIN archFile AF
		ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.isValid = 1
	 INNER JOIN archGroupCopy AGC
		ON AGC.id = @i_archCopyId
	 INNER JOIN archFileCopy AFC
		ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = AGC.id AND (AFC.flags & 256) = 0
	 LEFT OUTER JOIN archFileCopyDedup AFD
		ON AFD.archFileId = AFC.archFileId AND AFD.commCellId = AFC.commCellId AND AFD.archCopyId = AFC.archCopyId
	GROUP BY J.appId,J.jobId,J.jobStatus,J.agedTime
	UPDATE #tempResult
	SET sizeOnMedia = (SELECT SUM(J.sizeOnMedia) FROM JMJobDataStats J WHERE J.archGrpCopyId = @i_archCopyId AND J.jobId =#tempResult.jobId )
END
if(@i_ClientId>0)
BEGIN
delete FROM #tempResult WHERE clientId !=@i_ClientId
END
if(@i_appTypeId>0)
BEGIN
delete FROM #tempResult WHERE appTypeId !=@i_appTypeId
END
if(@i_instanceId>0)
BEGIN
delete FROM #tempResult WHERE instanceId !=@i_instanceId
END
if(@i_subclientId>0)
BEGIN
delete FROM #tempResult WHERE subClientId !=@i_subclientId
END
UPDATE #tempResult
set clientName = APPC.name,
appTypeName = APPTYP.name,
totalDataSize = (SELECT SUM(totalUncompBytes) FROM #JobList WHERE jobId = #tempResult.jobId),
LastBackupTime = (SELECT MAX(cTime) FROM archFile WHERE jobId  = #tempResult.jobId)
FROM APP_Client APPC, APP_iDAType APPTYP
WHERE #tempResult.clientId = APPC.id
AND #tempResult.appTypeId = APPTYP.type
UPDATE #tempResult
set subClientName = APPSC.subclientName,
 backupsetId = APPBS.id,
 backupSetName = APPBS.name,
 instanceId = APPSC.instance,
 instanceName = APPINS.name
FROM  APP_Application APPSC,APP_BackupSetName APPBS, APP_InstanceName APPINS
WHERE #tempResult.subClientId = APPSC.id
	AND
	APPSC.backupSet = APPBS.id
	AND APPSC.instance = APPINS.id
IF(@i_reqjobInfo=1)
SELECT * FROM #tempResult order by appTypeId
ELSE
BEGIN
	CREATE TABLE #tempAggResult
	(
		clientId			int,
		clientName			nvarchar(max),
		appTypeId			int,
		appTypeName			nvarchar(max),
		backupsetId			int,
		backupSetName		nvarchar(max),
		subClientId			int,
		subClientName		nvarchar(max),
		instanceId			int,
		instanceName		nvarchar(max),
		totalDataSize	bigint,
		sizeOnMedia	bigint,
		LastBackupTime		int,
		DedupSavings		bigint,
		jobsCount			int
	)
	INSERT INTO #tempAggResult
	SELECT
	t.clientId,
	t.clientName,
	t.appTypeId,
	t.appTypeName,
	t.backupsetId,
	t.backupSetName,
	t.subClientId,
	t.subClientName,
	t.instanceId,
	t.instanceName,
	SUM(t.totalDataSize),
	0,
	MAX(t.LastBackupTime),
	SUM(t.DedupSavings),
	COUNT(*)
	FROM #tempResult t
	GROUP BY t.clientId,
	t.clientName,
	t.appTypeId,
	t.appTypeName,
	t.backupsetId,
	t.backupSetName,
	t.subClientId,
	t.subClientName,
	t.instanceId,
	t.instanceName
IF (@i_archGrpId > 0)
BEGIN
	UPDATE #tempAggResult
	SET sizeOnMedia = (SELECT SUM(J.sizeOnMedia) FROM JMJobDataStats J, archGroup AG WHERE AG.id = @i_archGrpId	AND J.archGrpCopyId = AG.defaultCopy AND J.appId = #tempAggResult.subClientId)
END
ELSE IF (@i_archCopyId > 0)
BEGIN
	UPDATE #tempAggResult
	SET sizeOnMedia = (SELECT SUM(J.sizeOnMedia) FROM JMJobDataStats J WHERE J.archGrpCopyId = @i_archCopyId AND J.appId = #tempAggResult.subClientId)
END
SELECT * FROM #tempAggResult order by appTypeId
END
END
ELSE
SELECT 	SizeOfApplicationInBytes = (SELECT SUM(totalUncompBytes) FROM #JobList),
	 SUM(AFC.physicalSize) as SizeOfBackupInBytes,
	 SUM(AFC.physicalSize - ISNULL(AFD.secondaryObjSize, 0) + ISNULL(AFD.secondaryMetaDataSize, 0)
								+ ISNULL(AFD.primaryMetaDataSize, 0)) as SizeOfDedupSavingInBytes
FROM	#JobList J
		INNER JOIN archFile AF
			ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.isValid = 1
		INNER JOIN archGroup AG
			ON AG.id = AF.archGroupId
		INNER JOIN archFileCopy AFC
			ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = AG.defaultCopy AND (AFC.flags & 256) = 0
		LEFT OUTER JOIN archFileCopyDedup AFD
			ON AFD.archFileId = AFC.archFileId AND AFD.commCellId = AFC.commCellId AND AFD.archCopyId = AFC.archCopyId
DROP TABLE #JobList
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_archViewSISavings')
	delete from GxQscripts where name = 'QS_archViewSISavings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_archViewSISavings')
	delete from GXDBVersions where aliasname = 'QS_archViewSISavings'
GO

insert into GXDBVersions values(2, 'QS_archViewSISavings',  '00010013020800020000', 'QS_archViewSISavings', '00010013020800020000')
GO

insert into GxQscripts values(2,'QS_archViewSISavings',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn archViewSISavings -si @i_ClientId=''clientId'' -si @i_appTypeId=''appTypeId'' -si @i_JobId=''jobId'' -si @i_commCellId=''commCellId'' -si @i_BackupLevel=''backUpLevel''
'
 + CHAR(10) + '-- 	script_name: archViewSISavings.'
 + CHAR(10) + '-- 	returns total dedup savings for the given input params.'
)
GO

