

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_archIndexSize.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_archIndexSize.sp,v $ $Id: QS_archIndexSize.sp,v 1.10.210.3 2018/03/22 01:02:20 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_archIndexSize <<<'

IF EXISTS (select * from sysobjects where name='QS_archIndexSize')
	drop procedure QS_archIndexSize
IF EXISTS (select * from GxQscripts where name='QS_archIndexSize')
	delete from GxQscripts where name = 'QS_archIndexSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_archIndexSize')
	delete from GXDBVersions where aliasname = 'QS_archIndexSize'
GO
print '... Creating Procedure: QS_archIndexSize'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_archIndexSize
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @noOfdays int = 0
AS
  DECLARE @archGrpId int
  DECLARE @archGrpName nvarchar(288)
  DECLARE @idxSizeMB bigint
SET ANSI_PADDING ON
SET ARITHABORT ON
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER   			 --
-------------------------------------------
DECLARE @PARAM_1	integer
SET @PARAM_1 = 0
SET		@PARAM_1	= @noOfdays
IF (@PARAM_1 = 0)
BEGIN
	print 'Error: Insufficient command line parameters'
	GOTO SCRIPT_EXIT
END
CREATE TABLE #tempJobStats
(
	jobId		integer,
	commCellId	integer,
	archGroupId	integer,
	appId		integer,
	bkpLevel	integer,
	fullCycleNum	integer,
	servStartDate	integer,
	archFileId	integer,
	fileType	integer,
)
CREATE TABLE #tempArchGrp
(
	appId		integer,
	archGroupId	integer,
	archGroupName	nvarchar(288),
	archGroupCopyId	integer
)
CREATE TABLE #tempHost
(
	clientId		integer,
	IdxCacheId		integer,
	lastBackupTime	integer
)
CREATE TABLE #tempArchFile
(
	archFileId	integer,
	archGroupId	integer,
	drivePoolId integer,
	clientId	integer,
	physicalSize	bigint
)
CREATE TABLE #tempResult
(
	IdxCacheId		int,
	IdxCacheDescription nvarchar(60),
	IdxFreeDiskSpaceMB	int,
	IdxDiskUsageMB		int,
	StoragePolicyId	int,
	StoragePolicyName nvarchar(2048),
	ClientId	nvarchar(288),
	ClientIdNum		int,
	indexCacheNeeded_InMB	bigint,
	MediaAgentName  nvarchar(310),
	MediaAgentHostName	nvarchar(310),
	lastBackupTime		int,
	sharingCount		int,
	releaseId			int
)
DECLARE @curtime int
DECLARE @backTrackTime int
SET @curtime = dbo.GetUnixTime(GETUTCDATE())
print 'Showing index cache needed for days:' + convert(varchar, @noOfdays)
SET @backTrackTime = @curTime - (@PARAM_1 * 24 * 60 * 60)
-- Get all the jobs applicable withint the time range
INSERT INTO #tempJobStats
SELECT MAX(JMBS.jobId), 2, 0, JMBS.appId, 0, JMBS.fullCycleNum, 0, 0, AF.fileType
FROM JMBkpStats as JMBS WITH (NOLOCK), archFile AF WITH (NOLOCK)
WHERE servStartDate > @backTrackTime
and JMBS.commCellId = 2
and JMBS.dataStatus = 0 -- DATA_STATUS_VALID
and JMBS.jobId = AF.jobId
and JMBS.commCellId = AF.commCellId
and AF.isValid = 1
and AF.fileType in (2, 6, 7, 8)
group by JMBS.appId, JMBS.fullCycleNum, AF.fileType
UPDATE #tempJobStats
SET archFileId = AF.id
FROM archFile AF WITH (NOLOCK)
WHERE #tempJobStats.jobId = AF.jobId
and #tempJobStats.commCellId = AF.commCellId
and AF.isValid = 1
and AF.fileType in (2, 6, 7, 8)
and AF.commCellId = 2
UPDATE #tempJobStats
SET archGroupId = JMBS.dataArchGrpId,
bkpLevel = JMBS.bkpLevel,
servStartDate = JMBS.servStartDate
FROM JMBkpStats JMBS WITH (NOLOCK)
WHERE #tempJobStats.jobId = JMBS.jobId and #tempJobStats.commCellId = JMBS.commCellId
--print 'Collected Job Data'
--select * from #tempJobStats
-- Get all the storage policies for the subclients for which jobs were run within the specified time range.
-- Get the data and log storage policies if any configured.
INSERT INTO #tempArchGrp
SELECT distinct T.appId, T.archGroupId, '', 0
FROM #tempJobStats T
--print 'Collected Storage Policy Data'
--Get the archFile info
INSERT INTO #tempArchFile
SELECT TJ.archFileId, T.archGroupId, 0, 0, 0
FROM #tempArchGrp T, #tempJobStats TJ
WHERE T.archGroupId = TJ.archGroupId
UPDATE #tempArchFile
SET physicalSize = AFC.physicalSize,
drivePoolId = AFC.drivePoolId
FROM archFileCopy AFC WITH (NOLOCK)
WHERE #tempArchFile.archFileId = AFC.archFileId
and AFC.commCellId = 2
and AFC.isValid = 1
UPDATE #tempArchFile
SET clientId = MMDP.ClientId
FROM MMDrivePool MMDP WITH (NOLOCK)
WHERE #tempArchFile.drivePoolId = MMDP.drivePoolId
delete from #tempArchFile
where clientId = 0
--print 'get all associated host names'
-- Get the host associated to the storage policy
INSERT INTO #tempHost
SELECT MH.ClientId, 0, 0
FROM MMHost MH WITH (NOLOCK), IdxAccessPath IA WITH (NOLOCK), IdxCache IC WITH (NOLOCK)
WHERE MH.ClientId = IA.ClientId
and IA.IdxCacheId = IC.IdxCacheId
and IC.IdxCacheType = 1
and MH.ClientId <> 1
UPDATE #tempHost
SET lastBackupTime = TR.createTime
FROM (
SELECT MAX(AF.cTime) as createTime, T.ClientId
FROM #tempHost T, MMDrivePool MMDP WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archFile AF WITH (NOLOCK)
WHERE T.ClientId = MMDP.ClientId
and MMDP.DrivePoolId = AFC.drivePoolId
and AF.id = AFC.archFileId
and AF.fileType in (2, 6, 8)
GROUP BY T.ClientId
) as TR
WHERE #tempHost.ClientId = TR.ClientId
UPDATE #tempHost
SET IdxCacheId = IA.IdxCacheId
FROM IdxAccessPath IA WITH (NOLOCK)
WHERE #tempHost.ClientId = IA.ClientId
--print 'Collected archFile Data'
INSERT INTO #tempResult
SELECT IA.IdxCacheId, '', 0, 0, 0, '', '', 0, sum(T.physicalSize), '', '', 0, 0, 0
FROM #tempArchFile T, IdxAccessPath IA WITH (NOLOCK), IdxCache as IC WITH (NOLOCK)
WHERE T.clientId = IA.ClientId
and IA.IdxCacheId = IC.IdxCacheId
and IC.IdxCacheType = 1
and IC.CatalogServerClientId = 0 -- Filter out the rows which are pointing to catalog server profile
GROUP BY IA.IdxCacheId
-- Insert the Caches which are not picked up due to no backup for those clients.
INSERT INTO #tempResult
SELECT distinct IC.IdxCacheId, '', 0, 0, 0, '', '', 0, 0, '', '', 0, 0, 0
FROM IdxCache IC WITH (NOLOCK), IdxAccessPath IA WITH (NOLOCK)
WHERE IC.IdxCacheId not in (select IdxCacheId from #tempResult)
and IC.IdxCacheId <> 0
and IC.IdxCacheId = IA.IdxCacheId
and IC.IdxCacheType = 1
and IC.CatalogServerClientId = 0
UPDATE #tempResult
SET sharingCount = TT.counter,
lastBackupTime = TT.lastBackupTime
FROM
( SELECT count(*) as counter, TH.IdxCacheId, MAX(TH.lastBackupTime) as lastBackupTime
  FROM #tempHost as TH
  Group By TH.IdxCacheId
) as TT
WHERE #tempResult.IdxCacheId = TT.IdxCacheId
UPDATE #tempResult
SET ClientId = (SELECT SUBSTRING((SELECT ',' + cast(IA.ClientId as varchar(10)) FROM  IdxAccessPath IA WITH (NOLOCK) WHERE #tempResult.IdxCacheId = IA.IdxCacheId FOR XML PATH('')),2,200000) AS CSV)
UPDATE #tempResult
SET MediaAgentName = (SELECT SUBSTRING((SELECT ',' + APPC.name FROM  APP_Client APPC WITH (NOLOCK), IdxAccessPath IA WITH (NOLOCK) WHERE IA.IdxCacheId = #tempResult.IdxCacheId and IA.ClientId = APPC.id FOR XML PATH('')),2,200000) AS CSV)
UPDATE #tempResult
SET MediaAgentHostName = (SELECT SUBSTRING((SELECT ',' + APPC.net_hostname FROM  APP_Client APPC WITH (NOLOCK), IdxAccessPath IA WITH (NOLOCK) WHERE IA.IdxCacheId = #tempResult.IdxCacheId and IA.ClientId = APPC.id FOR XML PATH('')),2,200000) AS CSV)
--Insert the MAs which are pointing to catalog server since grouping to MA names is done above.
INSERT INTO #tempResult
SELECT IC.IdxCacheId, '', 0, 0, 0, '', '', IA.ClientId, sum(T.physicalSize), '', '', 0, 1, 0
FROM #tempArchFile T, IdxAccessPath IA WITH (NOLOCK), IdxCache as IC WITH (NOLOCK)
WHERE T.clientId = IA.ClientId
and IA.IdxCacheId = IC.IdxCacheId
and IC.IdxCacheType = 1
and IC.CatalogServerClientId > 0 -- Included the rows which are pointing to catalog server profile
and IC.IdxCacheId not in (select IdxCacheId from #tempResult)
GROUP BY IA.ClientId, IC.IdxCacheId	--Group by clientId since the MAs pointing to catalog server should show individual rows.
-- Insert the MAs which are not picked up due to no backup for those clients.
INSERT INTO #tempResult
SELECT distinct IC.IdxCacheId, '', 0, 0, 0, '', '', IA.ClientId, 0, '', '', 0, 1, 0
FROM IdxCache IC WITH (NOLOCK), IdxAccessPath IA WITH (NOLOCK)
WHERE IA.ClientId not in (select ClientIdNum from #tempResult)
and IC.IdxCacheId <> 0
and IC.IdxCacheId = IA.IdxCacheId
and IC.IdxCacheType = 1
and IC.CatalogServerClientId > 0
--Update the cacheIds which are inserted as 0
UPDATE #tempResult
SET IdxCacheId = IA.IdxCacheId
FROM IdxAccessPath IA WITH (NOLOCK)
WHERE #tempResult.IdxCacheId = 0
and #tempResult.ClientIdNum =  IA.ClientId
and #tempResult.ClientIdNum > 0
UPDATE #tempResult
SET MediaAgentName = APPC.name
FROM APP_Client APPC
WHERE #tempResult.ClientIdNum = APPC.id
and #tempResult.ClientIdNum > 0
UPDATE #tempResult
SET MediaAgentHostName = APPC.net_hostname
FROM APP_Client APPC
WHERE #tempResult.ClientIdNum = APPC.id
and #tempResult.ClientIdNum > 0
UPDATE #tempResult
SET releaseId = APPC.releaseId
FROM APP_Client APPC
WHERE #tempResult.ClientId = APPC.id
and #tempResult.ClientId > 0
UPDATE #tempResult
SET IdxCacheDescription = IC.Description,
IdxFreeDiskSpaceMB = IC.FreeDiskSpaceMB,
IdxDiskUsageMB = IC.DiskUsageMB
FROM IdxCache IC WITH (NOLOCK)
WHERE #tempResult.IdxCacheId = IC.IdxCacheId
and IC.CatalogServerClientId = 0
UPDATE #tempResult
SET IdxCacheDescription = IC.Description,
IdxFreeDiskSpaceMB = IA.FreeDiskSpaceMB,
IdxDiskUsageMB = IA.DiskUsageMB
FROM IdxCache IC WITH (NOLOCK), IdxAccessPath IA WITH (NOLOCK)
WHERE #tempResult.IdxCacheId = IC.IdxCacheId
and IC.IdxCacheId = IA.IdxCacheId
and #tempResult.ClientIdNum = IA.ClientId
and IC.CatalogServerClientId > 0
UPDATE #tempResult
SET lastBackupTime = TH.lastBackupTime
FROM #tempHost TH
WHERE #tempResult.ClientIdNum = TH.clientId
and #tempResult.ClientIdNum > 0
UPDATE #tempResult
SET indexCacheNeeded_InMB = (indexCacheNeeded_InMB/ (1024 * 1024 * sharingCount))
--Update the FreeDiskSpace and UsedDiskSpace for V11 Index Cache
UPDATE #tempResult
SET IdxFreeDiskSpaceMB = AP.attrVal
FROM APP_ClientProp AP WITH (NOLOCK) WHERE AP.componentNameId = ClientId AND releaseId>=16 AND AP.attrName = 'Idx: free disk size' AND AP.modified = 0
UPDATE #tempResult
SET IdxDiskUsageMB = AP.attrVal
FROM APP_ClientProp AP WITH (NOLOCK) WHERE AP.componentNameId = ClientId AND releaseId>=16 AND AP.attrName = 'Idx: used disk size' AND AP.modified = 0
--print 'Preparing result'
select IdxCacheDescription, MediaAgentName, MediaAgentHostName, indexCacheNeeded_InMB, IdxFreeDiskSpaceMB, IdxDiskUsageMB, (case when (lastBackupTime > 0) then convert(varchar, dbo.GetDateTime(lastBackupTime), 120) else '0' end) as lastBackupTime from #tempResult order by MediaAgentName asc
DROP TABLE #tempJobStats
DROP TABLE #tempArchGrp
DROP TABLE #tempArchFile
DROP TABLE #tempHost
DROP TABLE #tempResult
SCRIPT_EXIT:
set nocount off
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_archIndexSize')
	delete from GxQscripts where name = 'QS_archIndexSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_archIndexSize')
	delete from GXDBVersions where aliasname = 'QS_archIndexSize'
GO

insert into GXDBVersions values(2, 'QS_archIndexSize',  '00010010021000030000', 'QS_archIndexSize', '00010010021000030000')
GO

insert into GxQscripts values(2,'QS_archIndexSize',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn archIndexSize -si @noOfdays=''noOfDays''
'
 + CHAR(10) + '-- 	script_name: archIndexSize.'
 + CHAR(10) + '-- 	returns index space for the jobs run over the input number of days..'
)
GO

