

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_archCopyFailoverSelect.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_archCopyFailoverSelect.sp,v $ $Id: QS_archCopyFailoverSelect.sp,v 1.1.2.6 2018/03/22 01:06:13 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_archCopyFailoverSelect <<<'

IF EXISTS (select * from sysobjects where name='QS_archCopyFailoverSelect')
	drop procedure QS_archCopyFailoverSelect
IF EXISTS (select * from GxQscripts where name='QS_archCopyFailoverSelect')
	delete from GxQscripts where name = 'QS_archCopyFailoverSelect'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_archCopyFailoverSelect')
	delete from GXDBVersions where aliasname = 'QS_archCopyFailoverSelect'
GO
print '... Creating Procedure: QS_archCopyFailoverSelect'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_archCopyFailoverSelect
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_storagePolicyName varchar(1024),
  @i_copyName varchar(1024),
  @i_mediaAgentName varchar(1024) = ''
AS
SET NOCOUNT ON
	declare @i_copyId							integer
	declare	@i_defaultDrivePoolId				integer
	declare @i_selectmode						integer
	declare @i_archGroupId						integer
	declare @i_archGroupTypeId					integer
	declare @i_showMAsForLibrary				integer
	declare @i_showDrivePoolsForMA				integer
	declare @i_showMagDrivePoolsForSilo			integer
	declare @l_showOnlyMagLibs					integer
	declare	@ErrStr 							varchar(2048)
	SET @i_archGroupId = ISNULL ((SELECT id FROM ArchGroup WHERE name = @i_storagePolicyName), 0)
	IF @i_archGroupId = 0
	BEGIN
		SET @ErrStr = 'Storage policy does not exists, please pass valid storage policy name.'
		GOTO EXIT_ERROR
	END
	SET @i_copyId = ISNULL ((SELECT id FROM ArchGroupCopy WHERE archGroupId = @i_archGroupId AND name = @i_copyName), 0)
	IF @i_copyId = 0
	BEGIN
		SET @ErrStr = 'Storage policy copy does not exists, please pass valid storage policy copy name.'
		GOTO EXIT_ERROR
	END
SET @i_defaultDrivePoolId = ISNULL ((SELECT  DrivePoolId FROM MMDataPath WHERE CopyId	= @i_copyId AND Flag & 1 > 0) , 0)
	IF @i_defaultDrivePoolId = 0
	BEGIN
		SET @ErrStr = 'No valid default data path for the given copy.'
		GOTO EXIT_ERROR
	END
	DECLARE @UseAlternameDP	 	int = 0
	DECLARE @UseRoundRobinDP 	int = 0
	DECLARE @IsSiloCopy			int = 0
	SET @i_selectmode	= 0
	SELECT
@UseAlternameDP 	= 	ISNULL(flags, 0) & (8 | 16),
@UseRoundRobinDP 	= 	ISNULL(flags, 0) & 512,
@IsSiloCopy			= 	ISNULL(flags, 0) & 524288
	FROM archGroupCopy WHERE id = @i_copyId
	IF @UseRoundRobinDP > 0
		SET @i_selectmode = 1
	IF @UseAlternameDP > 0
		SET @i_selectmode = 2
	IF @IsSiloCopy > 0
SET @i_selectmode = @i_selectmode | 128 | 4096
	SET @i_archGroupTypeId				= 		(SELECT type FROM archGroup WHERE id = @i_archGroupId)
	SET @i_showMAsForLibrary			= 		0
	SET @i_showDrivePoolsForMA			= 		0
	SET @i_showMagDrivePoolsForSilo		= 		0
	IF OBJECT_ID('tempdb.dbo.#FailOverCandidates') IS NOT NULL
		DROP TABLE #FailOverCandidates
	CREATE TABLE #FailOverCandidates
					(
						DataPathId				integer,
						DrivePoolId 			integer,
						DrivePoolName			nvarchar(255),
						DrivePoolType			integer,
						MountPathTypeId			integer,
						drivePoolNumDrives		integer,
						mediaAgentId		    integer,
						mediaAgentName			nvarchar(255),
						mediaAgentReleaseId	    integer,
						libraryId		        integer,
						libraryName		        nvarchar(255),
						libraryTypeId			integer,
						libraryAliasName	    nvarchar(255),
						libraryAttribute		integer,
						spareGroupId		    integer,
						spareGroupName			nvarchar(255),
						indexCacheId		    integer,
						indexCacheName			nvarchar(255),
						DPChunkSizeMB		    integer,
						DPBlockSizeKB		    integer,
						HWCompressionPossible	integer,
						clientId				integer,
						HWEncryptionPossible	integer,
						DeviceTypeId 			integer
					)
	INSERT INTO #FailOverCandidates
	EXEC archGetDataPathsForCopy @i_copyId, @i_defaultDrivePoolId, @i_selectmode, @i_archGroupId, @i_archGroupTypeId, @i_showMAsForLibrary, @i_showDrivePoolsForMA, @i_showMagDrivePoolsForSilo
	SELECT DISTINCT FC.mediaAgentName, FC.LibraryAliasName, FC.DrivePoolName, FC.SpareGroupName
	FROM 	#FailOverCandidates FC
	WHERE 	FC.mediaAgentName  = ( CASE WHEN @i_mediaAgentName <> '' THEN @i_mediaAgentName ELSE FC.mediaAgentName END )
AND LibraryTypeId in (1, 4)
			AND NOT EXISTS (SELECT 1 FROM MMDataPath DP WHERE DP.CopyId = @i_copyId AND DP.DrivePoolId = FC.DrivePoolId AND DP.HostClientId = FC.mediaAgentId AND DP.spareGroupId = FC.spareGroupId)
	ORDER BY FC.mediaAgentName ASC, FC.LibraryAliasName ASC, FC.DrivePoolName ASC
	DROP TABLE #FailOverCandidates
	RETURN
EXIT_ERROR:
	SELECT @ErrStr
GO

IF EXISTS (select * from GxQscripts where name = 'QS_archCopyFailoverSelect')
	delete from GxQscripts where name = 'QS_archCopyFailoverSelect'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_archCopyFailoverSelect')
	delete from GXDBVersions where aliasname = 'QS_archCopyFailoverSelect'
GO

insert into GXDBVersions values(2, 'QS_archCopyFailoverSelect',  '00010001000200060000', 'QS_archCopyFailoverSelect', '00010001000200060000')
GO

insert into GxQscripts values(2,'QS_archCopyFailoverSelect',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn archCopyFailoverSelect -si storagePolicyName -si copyName -si mediaAgentName
'
 + CHAR(10) + '-- 	script_name: archCopyFailoverSelect.'
 + CHAR(10) + '-- 	returns the list of available failover tape data paths to add for this particular copy.'
)
GO

