

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_WebFeatures.sp] ---------- 

-------------------------------------------
--         Name:   QS_WebFeatures.sql
--         Date:   25-June-2014
--       Author:   SKatz
--  Description:   Update webconsole feature list
--
-- TR(original):   None
--     Customer:
--   CommcellId:   N/A (generic)
-------------------------------------------
-- TODO:  ADD OVERWRITE (VS UPDATE), NO WAIT FOR JOB RUNNING JOBS TO COMPLETE OPTIONS (hidden)
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_WebFeatures <<<'

IF EXISTS (select * from sysobjects where name='QS_WebFeatures')
	drop procedure QS_WebFeatures
IF EXISTS (select * from GxQscripts where name='QS_WebFeatures')
	delete from GxQscripts where name = 'QS_WebFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_WebFeatures')
	delete from GXDBVersions where aliasname = 'QS_WebFeatures'
GO
print '... Creating Procedure: QS_WebFeatures'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_WebFeatures
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
  @COMMAND NVARCHAR(1024) = '',
  @FEATURE NVARCHAR(1024) = ''
AS
SET NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'QS_WebFeatures'
DECLARE @created				AS integer		= 0
DECLARE @nowTime				AS integer		= dbo.GetUnixTime (GetUTCdate())
DECLARE @SEPERATOR				AS char(1)		= CHAR(18)
DECLARE @QUOTE					AS char(1)		= CHAR(39)
--
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--
--
-------- Local Variables    -------------
DECLARE @localErrorMsg			AS	varchar(512)	='Error Encountered when running script.'
DECLARE @lastError				AS	integer = 0							-- Be optimistic
DECLARE @featureId				INT = 0
DECLARE @featureName			NVARCHAR(MAX) = ''
DECLARE @featureList			NVARCHAR(MAX) = ''
DECLARE @isFeatureGet			INT = 0
DECLARE @isRemove				INT = 0
DECLARE @featureValue			BIGINT = 0
DECLARE	@LAPTOP_BACKUP			INT = 1
DECLARE	@DOWNLOAD				INT = 2
DECLARE	@VM_PROVISIONING		INT	= 3
DECLARE	@REPORTS				INT = 4
DECLARE	@PUSHINSTALL			INT = 5
DECLARE	@VCENTER				INT = 6
DECLARE	@COMPLIANCE_SEARCH		INT	= 7
DECLARE	@DOCUMENTATION			INT	= 8			--IGNORED
DECLARE	@COMMCELL_CONSOLE		INT	= 9			--IGNORED
DECLARE	@CLOUDAPPS				INT	= 10
DECLARE	@CUSTOMREPORTS			INT	= 11
DECLARE	@CLIENTREGISTRATION		INT	= 12
DECLARE	@EDC					INT	= 13		--IGNORED
DECLARE	@SURVEY					INT	= 14		--IGNORED
DECLARE	@CONFIGURATIONREQUEST	INT = 15		--IGNORED
DECLARE	@SYNCREQUEST			INT = 16
DECLARE	@GENERATEAUTHCODE		INT = 17		--IGNORED
DECLARE	@CVEVENTS				INT = 18		--IGNORED
DECLARE @MONITORINGCLOUDAPP		INT = 19		--IGNORED
DECLARE	@WORKFLOWFORM			INT = 20		--IGNORED
DECLARE	@PSEECG					INT = 21		--IGNORED
DECLARE	@LICENSE_GENERATOR		INT = 22		--IGNORED
DECLARE	@DATABASES				INT = 23
DECLARE @CVLOCALE				INT = 24		--IGNORED
DECLARE @CVLOCALE_ADMIN			INT = 25		--IGNORED
DECLARE @PRIVACYCONTROLS		INT = 26
DECLARE @MDM INT = 27
DECLARE	@LG_NEW_INDIVIDUAL_LICENSE INT = 29
DECLARE	@LG_MODIFY_INDIVIDUAL_LICENSE INT = 30
DECLARE	@STORAGE_PROVISIONING INT = 31
DECLARE @STORAGE_REPLICATION_APP INT = 32
DECLARE @ANALYTICS INT = 33
DECLARE	@LG_CAPACITY_LICENSE INT = 34
DECLARE @VMLABS INT = 38
declare @WEBCONSOLE_SSO_APP		INT = 39
DECLARE	@LG_NEW_LICENSE INT = 41
DECLARE	@LG_MODIFY_LICENSE INT = 42
DECLARE	@LG_IP_CHANGE_LICENSE INT = 43
DECLARE	@LG_STAGING_LICENSE INT = 44
DECLARE	@LG_DELETE_LICENSE INT = 45
DECLARE	@LG_TRANSFER_LICENSE INT = 46
DECLARE	@LG_VIEW_LICENSE INT = 47
DECLARE @LMCLOUDAPP INT = 36
DECLARE @RECORDSMANAGEMENT INT = 35
DECLARE @SYSMONITORINGCLOUDAPP INT = 37
DECLARE @Timeoff INT = 40
DECLARE @COLLABORATIVESHARES INT = 49
DECLARE @CVLEGAL_APP INT = 50
DECLARE @SoftwareStore INT = 51
DECLARE @COLLABORATIVESHARE_DISABLE_CAPABILITY INT = 14 -- 14th bit on CvFeatureList in GxGlobalParam is being used to hide Collaborative share button.
DECLARE @LASTROW				INT = 51
DECLARE @ROWCOUNT				INT = 63
--
DECLARE @featureMapTable TABLE
(
  feature 		INT,
  featureName	varchar(1024)
)
--
INSERT INTO @featureMapTable (feature, featureName) VALUES(@LAPTOP_BACKUP, 'Backups'),
(@DOWNLOAD, 'Download Center'),
(@VM_PROVISIONING, 'Virtual Machines'),
(@REPORTS, 'Reports'),
(@PUSHINSTALL, 'Software Deployment'),
(@VCENTER, 'Vcenter'),
(@COMPLIANCE_SEARCH, 'Compliance Search'),
(@DOCUMENTATION, 'Documentation'),
(@COMMCELL_CONSOLE, 'Console'),
(@CLOUDAPPS, 'Cloud Apps'),
(@CUSTOMREPORTS, 'Custom Reports'),
(@CLIENTREGISTRATION, 'Automatic Registration'),
(@EDC, 'EDC'),
(@SURVEY, 'Survey'),
(@CONFIGURATIONREQUEST, 'Configuration Request'),
(@SYNCREQUEST, 'Sync Folders'),
(@GENERATEAUTHCODE, 'Generate Authcode'),
(@CVEVENTS, 'Events Organizer'),
(@MONITORINGCLOUDAPP, 'Log Monitoring'),
(@WORKFLOWFORM, 'Workflow'),
(@PSEECG, 'PseEcg'),
(@LICENSE_GENERATOR, 'License Generator'),
(@DATABASES, 'DataBase Management'),
(@CVLOCALE, 'Localization'),
(@CVLOCALE_ADMIN, 'Localization Admin'),
(@PRIVACYCONTROLS, 'Laptop Privacy Control'),
(@MDM, 'MDM'),
(@LG_NEW_INDIVIDUAL_LICENSE, 'LG New Individual License'),
(@LG_MODIFY_INDIVIDUAL_LICENSE, 'LG Modify Individual License'),
(@STORAGE_PROVISIONING, 'Storage Provisioning'),
(@STORAGE_REPLICATION_APP, 'Storage Replication'),
(@ANALYTICS, 'Anayltics'),
(@LG_CAPACITY_LICENSE, 'LG Capacity License'),
(@VMLABS, 'VM Labs'),
(@WEBCONSOLE_SSO_APP, 'Webconsole SSO'),
(@LG_NEW_LICENSE, 'LG New License'),
(@LG_MODIFY_LICENSE, 'LG Modify License'),
(@LG_IP_CHANGE_LICENSE, 'LG IP Change License'),
(@LG_STAGING_LICENSE, 'LG Staging License'),
(@LG_DELETE_LICENSE, 'LG Delete License'),
(@LG_TRANSFER_LICENSE, 'LG Transfer License'),
(@LG_VIEW_LICENSE, 'LG View License'),
(@LMCLOUDAPP, 'LM Cloud'),
(@RECORDSMANAGEMENT, 'Records Management'),
(@SYSMONITORINGCLOUDAPP, 'System Monitoring Cloud'),
(@Timeoff, 'Time Off'),
(@COLLABORATIVESHARES, 'Collaborative Shares'),
(@CVLEGAL_APP, 'CV Legal'),
(@SoftwareStore, 'Software Store')
 WHILE @LASTROW < @ROWCOUNT
 BEGIN
	SET @LASTROW = @LASTROW + 1
	INSERT @featureMapTable (feature, featureName)
	VALUES (@LASTROW, @LASTROW)
 END
--
------------------------------------------------------------
--- CHECK IF MINIMUM (& VALID!) PARAMETERS SPECIFIED	 ---
------------------------------------------------------------
IF @COMMAND = ''
BEGIN
	SET @localErrorMsg	='Error. No command specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--
IF @COMMAND = 'get'
	SET @isFeatureGet = 1
--
IF @FEATURE = '' AND @isFeatureGet = 0
BEGIN
	SET @localErrorMsg	='Error. No feature specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--
IF @COMMAND = 'remove'
	SET @isRemove = 1
--	-------------------------------------------------------------------
BEGIN TRY
	IF ISNUMERIC(@FEATURE) = 0
	BEGIN
		SET @featureId = ISNULL((SELECT feature FROM @featureMapTable WHERE featureName = @FEATURE), 0)
	END
	ELSE
	BEGIN
		SET @featureId = CAST(@FEATURE AS INT)
	END
	BEGIN TRAN
	SET @featureId = @featureId - 1
SET @featureValue = ISNULL((SELECT value FROM GXGlobalParam WHERE name LIKE 'CvFeaturesList'), 1077968911)
	IF @isFeatureGet = 1
	BEGIN
		DECLARE featureCursor CURSOR STATIC FOR
				SELECT [feature], [featureName]
				FROM @featureMapTable
		OPEN featureCursor
		FETCH NEXT FROM featureCursor INTO @featureId, @featureName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @featureId = @featureId - 1
			-- COLLABORATIVE SHARES ARE ON BY DEFAULT i.e. IF BIT IS NOT PRESENT IN @featureValues, MEANS TURNED ON
			IF (@featureId = @COLLABORATIVESHARES - 1 AND @featureValue & POWER(CAST(2 AS BIGINT), @COLLABORATIVESHARE_DISABLE_CAPABILITY - 1) = 0)
				OR (@featureValue & POWER(CAST(2 AS BIGINT), @featureId) = POWER(CAST(2 AS BIGINT), @featureId))
			BEGIN
				IF (LEN(@featureList) > 0)
					SET @featureList = @featureList + ', '
				SET @featureList = @featureList + @featureName
			END
			FETCH NEXT FROM featureCursor INTO @featureId, @featureName
		END
		CLOSE featureCursor
		DEALLOCATE featureCursor
		PRINT 'List of features that are enabled:'
		PRINT @featureList
		PRINT ''
	END
	ELSE
	BEGIN
		IF @isRemove = 1
		BEGIN
			IF @featureId = @COLLABORATIVESHARES - 1
				SET @featureValue = @featureValue | POWER(CAST(2 AS BIGINT), CAST(@COLLABORATIVESHARE_DISABLE_CAPABILITY AS BIGINT) - 1)
			ELSE
				SET @featureValue = @featureValue & ~POWER(CAST(2 AS BIGINT), CAST(@featureId AS BIGINT))
		END
		ELSE	--ADD FEATURE
		BEGIN
			IF @featureId = @COLLABORATIVESHARES - 1
				SET @featureValue = @featureValue & ~POWER(CAST(2 AS BIGINT), CAST(@COLLABORATIVESHARE_DISABLE_CAPABILITY AS BIGINT) - 1)
			ELSE
				SET @featureValue = @featureValue | POWER(CAST(2 AS BIGINT), CAST(@featureId AS BIGINT))
		END
		MERGE GXGlobalParam GP
		USING
		(
			SELECT 'CvFeaturesList' name
		) AS FL ON FL.name = GP.name
		WHEN MATCHED THEN
			UPDATE SET value = @featureValue
		WHEN NOT MATCHED THEN
			INSERT (name, value, created, modified)
			VALUES ('CvFeaturesList', @featureValue, @nowTime, 0);
	END
--
END TRY
--
--
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
	--Close cursor
	IF ( CURSOR_STATUS('global', 'featureCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'featureCursor') >= 0 )
	CLOSE featureCursor
	IF ( CURSOR_STATUS('global','featureCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','featureCursor') = -1 )
	DEALLOCATE featureCursor
END   CATCH
PROCESS_ERROR:
IF @lastError  = 0
	COMMIT TRAN
ELSE
	ROLLBACK Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: Command = ['
         + @COMMAND
         + '], feature = ['
         + @FEATURE
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_WebFeatures')
	delete from GxQscripts where name = 'QS_WebFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_WebFeatures')
	delete from GXDBVersions where aliasname = 'QS_WebFeatures'
GO

insert into GXDBVersions values(2, 'QS_WebFeatures',  '00000000000000000000', 'QS_WebFeatures', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_WebFeatures',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn WebFeatures -si "add/remove/get" -si "feature name/id"'
 + CHAR(10) + '-- 		Script to enable or disable a web feature'
 + CHAR(10) + '		List of features:
'
 + CHAR(10) + '
'
 + CHAR(10) + '		 1 - Backups
'
 + CHAR(10) + '		 2 - Download Center
'
 + CHAR(10) + '		 3 - Virtual Machines
'
 + CHAR(10) + '		 4 - Reports
'
 + CHAR(10) + '		 5 - Software Deployment
'
 + CHAR(10) + '		 6 - Vcenter
'
 + CHAR(10) + '		 7 - Compliance Search
'
 + CHAR(10) + '		10 - Cloud Apps
'
 + CHAR(10) + '		11 - Custom Reports
'
 + CHAR(10) + '		12 - Automatic Registration
'
 + CHAR(10) + '		16 - Sync Folders
'
 + CHAR(10) + '		23 - DataBase Management
'
 + CHAR(10) + '		26 - Laptop Privacy Control
'
 + CHAR(10) + '		31 - Storage Provisioning
'
 + CHAR(10) + '		49 - Collaborative Shares
'
)
GO

