

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_VTAddSP.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_VTAddSP <<<'

IF EXISTS (select * from sysobjects where name='QS_VTAddSP')
	drop procedure QS_VTAddSP
IF EXISTS (select * from GxQscripts where name='QS_VTAddSP')
	delete from GxQscripts where name = 'QS_VTAddSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_VTAddSP')
	delete from GXDBVersions where aliasname = 'QS_VTAddSP'
GO
print '... Creating Procedure: QS_VTAddSP'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_VTAddSP
-- Qscript is Enabled
-- QScript secure this script does the user validation
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @vtPolicyName NVARCHAR(1024),
  @spName NVARCHAR(1024),
  @copyName NVARCHAR(1024) = ''
AS
SET NOCOUNT ON
DECLARE @userId int = 0
DECLARE @capabailityFlag int = 0
DECLARE @errorCode int = 0
DECLARE @errorString nvarchar(1024) = 'Succeeded.'
DECLARE @vtPolicyId INT = 0
DECLARE @spId INT = 0
DECLARE @copyId INT = 0
DECLARE @adminUserId integer = 0
SET @adminUserId = ISNULL (( select id from UMUsers where name = 'Administrator'), 0)
IF @adminUserId = 0
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Error. Failed to get user id for administrator.'
	GOTO CLEANUP
END
SET @userId =  ISNULL( (select userId from #tempQSUser), 0)
IF @userId = 0
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Error. Failed to get user id.'
	GOTO CLEANUP
END
IF @vtPolicyName = ''
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Vault Tracker Policy Name is not provided.'
	GOTO CLEANUP
END
IF @spName = ''
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Storage Policy Name is not provided.'
	GOTO CLEANUP
END
SET @vtPolicyId = ISNULL((SELECT policyId FROM VTPolicy (READUNCOMMITTED) WHERE policyName = @vtPolicyName), 0)
IF @vtPolicyId = 0
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Error. Vault Tracker Policy ['+ @vtPolicyName +'] was not found in DataBase.'
	GOTO CLEANUP
END
SET @spId = ISNULL((SELECT Id FROM ArchGroup (READUNCOMMITTED) WHERE Name = @spName), 0)
IF @spId = 0
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Error. Storage Policy ['+ @spName +'] was not found in DataBase.'
	GOTO CLEANUP
END
IF @copyName <> ''
BEGIN
	SET @copyId = ISNULL((SELECT Id FROM ArchGroupCopy (READUNCOMMITTED) WHERE Name = @copyName and ArchGroupId = @spId), 0)
	IF @copyId = 0
	BEGIN
		SET @errorCode = -1
		SET @errorString = 'Error. Storage Policy Copy ['+ @copyName +'] of Storage Policy ['+ @spName +'] was not found in DataBase.'
		GOTO CLEANUP
	END
END
IF object_id('tempdb.dbo.#tempPermission') is not null DROP TABLE #tempPermission
CREATE TABLE #tempPermission ( permissionId INT )
EXEC sec_getPermissionsOnEntity '#tempPermission', @userId, 21, @vtPolicyId
IF NOT EXISTS (SELECT 1 FROM #tempPermission WHERE permissionId = 26)
BEGIN
	SET @errorCode = -1
	SET @errorString = 'User has no right to modify Vault Tracker Policy ['+ @vtPolicyName +'].'
	GOTO CLEANUP
END
delete from #tempPermission
EXEC sec_getPermissionsOnEntity '#tempPermission', @userId, 17, @spId
IF NOT EXISTS (SELECT 1 FROM #tempPermission WHERE permissionId = 4)
BEGIN
	SET @errorCode = -1
	SET @errorString = 'User has no right to use Storage Policy ['+ @spName +'].'
	GOTO CLEANUP
END
IF object_id('tempdb.dbo.#tmpAGCListForVTUser') is not null DROP TABLE #tmpAGCListForVTUser
CREATE TABLE #tmpAGCListForVTUser (
	archGroupId INT,
	archGroupName NVARCHAR(255),
	copyId INT,
	copyName NVARCHAR(255),
	isSelected INT
)
INSERT INTO #tmpAGCListForVTUser
EXEC MMS2GetTmPolicyToCopyList @vtPolicyId, @userId
IF NOT EXISTS (SELECT 1 FROM #tmpAGCListForVTUser WHERE archGroupId = @spId AND (@copyId = 0 or copyId = @copyId))
BEGIN
	SET @errorCode = -1
	SET @errorString = 'The storage policy or copy cannot be selected for this VT policy.'
	GOTO CLEANUP
END
IF object_id('tempdb.dbo.#tmpAGCListForVTAdmin') is not null DROP TABLE #tmpAGCListForVTAdmin
CREATE TABLE #tmpAGCListForVTAdmin (
	archGroupId INT,
	archGroupName NVARCHAR(255),
	copyId INT,
	copyName NVARCHAR(255),
	isSelected INT
)
INSERT INTO #tmpAGCListForVTAdmin
EXEC MMS2GetTmPolicyToCopyList @vtPolicyId, @adminUserId
IF NOT EXISTS (SELECT 1 FROM #tmpAGCListForVTAdmin WHERE archGroupId = @spId AND (@copyId = 0 or copyId = @copyId))
BEGIN
	SET @errorCode = -1
	SET @errorString = 'The storage policy or copy does not use qualified tape library.'
	GOTO CLEANUP
END
IF EXISTS (SELECT 1 FROM VTPolicyToCopy WHERE PolicyId = @vtPolicyId AND ArchGroupId = 0 AND CopyId = 0)
BEGIN
	SELECT 'All Storage Policies are associated with Vault Tracker Policy ['+ @vtPolicyName +'].'
	GOTO CLEANUP
END
IF EXISTS (SELECT 1 FROM VTPolicyToCopy WHERE PolicyId = @vtPolicyId AND ArchGroupId = @spId AND CopyId = 0)
BEGIN
	SELECT 'All copies of the Storage Policy are associated with Vault Tracker Policy ['+ @vtPolicyName +'].'
	GOTO CLEANUP
END
IF EXISTS (SELECT 1 FROM VTPolicyToCopy WHERE PolicyId = @vtPolicyId AND ArchGroupId = @spId AND copyId = @copyId)
BEGIN
	SELECT 'The Storage Policy copy is already associated with Vault Tracker Policy ['+ @vtPolicyName +'].'
	GOTO CLEANUP
END
BEGIN TRY
BEGIN TRAN VTAddSP_TRAN
	IF @copyId = 0 AND NOT EXISTS (SELECT 1 FROM #tmpAGCListForVTAdmin WHERE archGroupId <> @spId AND isSelected = 0)
	OR @copyId > 0 AND NOT EXISTS (SELECT 1 FROM #tmpAGCListForVTAdmin WHERE copyId <> @copyId AND isSelected = 0)
	BEGIN
		-- Associate all storage policies
		IF EXISTS (SELECT 1 FROM VTPolicyToCopy WHERE PolicyId = @vtPolicyId)
			DELETE FROM VTPolicyToCopy
			WHERE PolicyId = @vtPolicyId
		INSERT INTO VTPolicyToCopy
		SELECT @vtPolicyId, 0, 0
	END
	ELSE
	IF @copyId = 0
	OR @copyId > 0 AND NOT EXISTS (SELECT 1 FROM #tmpAGCListForVTAdmin WHERE archGroupId = @spId AND copyId <> @copyId AND isSelected = 0)
	BEGIN
		-- Associate the whole storage policy
		IF EXISTS (SELECT 1 FROM VTPolicyToCopy WHERE PolicyId = @vtPolicyId AND ArchGroupId = @spId)
			DELETE FROM VTPolicyToCopy
			WHERE PolicyId = @vtPolicyId AND ArchGroupId = @spId
		INSERT INTO VTPolicyToCopy
		SELECT @vtPolicyId, @spId, 0
	END
	ELSE
	BEGIN
		-- Simply add this copy!
		INSERT INTO VTPolicyToCopy
		SELECT @vtPolicyId, @spId, @copyId
	END
COMMIT TRAN VTAddSP_TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	ROLLBACK TRAN VTAddSP_TRAN
	SET @errorcode = ERROR_NUMBER()
	SET @errorstring = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END
End CATCH
CLEANUP:
if @errorCode <> 0
    Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
    )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_VTAddSP')
	delete from GxQscripts where name = 'QS_VTAddSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_VTAddSP')
	delete from GXDBVersions where aliasname = 'QS_VTAddSP'
GO

insert into GXDBVersions values(2, 'QS_VTAddSP',  '00000000000000000000', 'QS_VTAddSP', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_VTAddSP',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn VTAddSP -si vtPolicyName -si spName [-si copyName]
'
)
GO

