

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_VSASubclientContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_VSASubclientContent <<<'

IF EXISTS (select * from sysobjects where name='QS_VSASubclientContent')
	drop procedure QS_VSASubclientContent
IF EXISTS (select * from GxQscripts where name='QS_VSASubclientContent')
	delete from GxQscripts where name = 'QS_VSASubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_VSASubclientContent')
	delete from GXDBVersions where aliasname = 'QS_VSASubclientContent'
GO
print '... Creating Procedure: QS_VSASubclientContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_VSASubclientContent
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @i_ClientName nvarchar(255) = '%s',
  @i_InstanceName nvarchar(512) = '%s',
  @i_BackupSetName nvarchar(128) = '%s',
  @i_SubclientName nvarchar(128) = '%s',
  @i_OperationName nvarchar(128) = '%s',
  @i_vmName nvarchar(255) = '%s',
  @i_NewBackupSetName nvarchar(128) = '%s',
  @i_NewSubclientName nvarchar(128) = '%s',
  @i_vmListFileName nvarchar(1024) = '%s',
  @i_vmGUID nvarchar(1024) = '%s',
  @i_vmESXServer nvarchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
set nocount on
-----------insufficient parameters ---------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
---------------constants--------------------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'VSASubclientContent'
--------------error handling-----------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
----------------Variables--------------------
DECLARE @newSubclientId		INT	= 0
DECLARE @subclientId		INT	= 0
DECLARE @SubclientNum		INT	= 0
DECLARE @vmName				NVARCHAR(MAX)
DECLARE	@newVms				XML
CREATE TABLE #tempVmListTable			(vmName NVARCHAR(1024))
CREATE TABLE #tempMissedVmListTable		(vmName NVARCHAR(1024))
CREATE TABLE #tempDuplicateVmListTable	(vmName NVARCHAR(1024))
CREATE TABLE #tempSubclientIDs			(id INT)
CREATE TABLE #tempAddVmListTable		(vmName NVARCHAR(1024),
										 vmGUID NVARCHAR(1024),
										 vmESXServer NVARCHAR(1024))
BEGIN TRY
	BEGIN TRANSACTION
	---------------------------------------------
	-------- Check input arguments --------------
	IF @i_ClientName = @noParameter
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. No Client name was given. Please use @i_ClientName.'
		GOTO ARGS_ERROR
	END
	-- check if client exist
	DECLARE @clientId INT = (SELECT id from APP_Client where name = @i_ClientName)
	IF @clientId IS NULL OR  @clientId = 0
	BEGIN
    	SET @errorCode = 2
    	SET @errorString = 'Error.  Client ['+ @i_ClientName + '] does not exist. Please provide correct Client name.'
    	goto   ARGS_ERROR
	END
	IF @i_InstanceName = @noParameter
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. No Instance name was given. Please use @i_InstanceName.'
		GOTO ARGS_ERROR
	END
	-- check if instance exist on given client
	DECLARE @InstanceId INT = (SELECT TOP 1 id from APP_Application
				   where clientId in ( select id from APP_Client where name = @i_ClientName)
					 and instance in ( select id from APP_InstanceName where name = @i_InstanceName))
	IF @InstanceId IS NULL OR  @InstanceId = 0
		BEGIN
    		SET @errorCode = 2
    		SET @errorString = 'Error. Instance ['+ @i_InstanceName + '] does not exist on Client ['+ @i_ClientName + ']. Please provide correct Instance name.'
    		goto   ARGS_ERROR
		END
	-- if user didn't provide Subclient name and BackupSet name then
	-- verify that we have only one Backupset
	IF @i_SubclientName = @noParameter AND @i_BackupSetName = @noParameter
		IF 1 < (SELECT count(DISTINCT(backupSet)) from APP_Application
				   where clientId in ( select id from APP_Client where name = @i_ClientName)
					 and instance in ( select id from APP_InstanceName where name = @i_InstanceName))
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error. There are more then 1 BackupSet for given client ['+ @i_ClientName + '] and instance ['+ @i_InstanceName + ']. Please provide Subclient name or BackupSet name.'
			GOTO ARGS_ERROR
		END
	-- check Subclient provided for 'Add' operation
	IF @i_OperationName = 'Add' AND @i_SubclientName = @noParameter
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. @i_SubclientName must be provided for operation''Add''.'
		GOTO ARGS_ERROR
	END
	-- check Subclient exist
	IF @i_SubclientName <> @noParameter
	BEGIN
		SET @SubclientNum = (SELECT count(id) from APP_Application
				   where subclientName = @i_SubclientName
					 and clientId in ( select id from APP_Client where name = @i_ClientName)
					 and instance in ( select id from APP_InstanceName where name = @i_InstanceName))
		IF @SubclientNum IS NULL OR  @SubclientNum = 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error. Subclient ['+ @i_SubclientName + '] does not exist on client ['+ @i_ClientName + '] and instance ['+ @i_InstanceName + ']. Please provide correct Subclient name.'
			GOTO ARGS_ERROR
		END
		-- if user provide Subclient name and no BackupSet name then
		-- verify that Subclient name is unique
		IF @SubclientNum > 1 AND @i_BackupSetName = @noParameter
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error. Subclient name ['+ @i_SubclientName + '] is not unique for given client ['+ @i_ClientName + '] and instance ['+ @i_InstanceName + ']. Please provide BackupSet name.'
			GOTO ARGS_ERROR
		END
		-- check subclient exist in given backupset
		IF @i_BackupSetName <> @noParameter
		BEGIN
			SET @SubclientNum = (SELECT count(id) from APP_Application
				   where subclientName = @i_SubclientName
					 and clientId in ( select id from APP_Client where name = @i_ClientName)
					 and instance in ( select id from APP_InstanceName where name = @i_InstanceName)
					 and backupSet in ( select id from APP_BackupSetName where name = @i_BackupSetName))
			IF @SubclientNum IS NULL OR  @SubclientNum = 0
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Error. Subclient ['+ @i_SubclientName + '] does not exist on backupSet [' + @i_BackupSetName + '], client ['+ @i_ClientName + '] and instance ['+ @i_InstanceName + ']. Please provide correct BackupSet and Subclient names.'
				GOTO ARGS_ERROR
			END
		END
	END
	IF @i_OperationName = @noParameter
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. No Operation name was given. Please use @i_OperationName.'
		GOTO ARGS_ERROR
	END
	IF @i_OperationName = 'Move' AND @i_NewSubclientName = @noParameter
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Operation name = ''Move'' but no New Subclient Name was given. Please specify it via @i_NewSubclientName'
		GOTO ARGS_ERROR
	END
	-- check BackupSet exist
	IF @i_BackupSetName <> @noParameter
	BEGIN
		DECLARE @tempId INT = (SELECT TOP 1 id from APP_Application
						   where clientId in ( select id from APP_Client where name = @i_ClientName)
							 and instance in ( select id from APP_InstanceName where name = @i_InstanceName)
							 and backupSet in ( select id from APP_BackupSetName where name = @i_BackupSetName))
		IF @tempId IS NULL OR  @tempId = 0
		BEGIN
    		SET @errorCode = 2
    		SET @errorString = 'Error. BackupSet ['+ @i_BackupSetName + '] does not exist on Client ['+ @i_ClientName + '] and instance ['+ @i_InstanceName + ']. Please provide correct BackupSet name via @i_BackupSetName.'
    		goto   ARGS_ERROR
		END
	END
	-- check new BackupSet exist
	IF @i_NewBackupSetName <> @noParameter
	BEGIN
		SET @tempId = (SELECT TOP 1 id from APP_Application
						   where clientId in ( select id from APP_Client where name = @i_ClientName)
							 and instance in ( select id from APP_InstanceName where name = @i_InstanceName)
							 and backupSet in ( select id from APP_BackupSetName where name = @i_NewBackupSetName))
		IF @tempId IS NULL OR  @tempId = 0
		BEGIN
    		SET @errorCode = 2
    		SET @errorString = 'Error. New BackupSet ['+ @i_NewBackupSetName + '] does not exist on Client ['+ @i_ClientName + '] and instance ['+ @i_InstanceName + ']. Please provide correct new BackupSet name via @i_NewBackupSetName.'
    		goto   ARGS_ERROR
		END
	END
	-- check new Subclient exist and unique for Move operation
	IF @i_OperationName = 'Move' AND @i_NewSubclientName <> @noParameter
	BEGIN
		DECLARE @NewSubclientNum INT = (SELECT count(id) from APP_Application
				   where subclientName = @i_NewSubclientName
					 and clientId in ( select id from APP_Client where name = @i_ClientName)
					 and instance in ( select id from APP_InstanceName where name = @i_InstanceName))
		IF @NewSubclientNum IS NULL OR  @NewSubclientNum = 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error. Subclient ['+ @i_NewSubclientName + '] does not exist on client ['+ @i_ClientName + '] and instance ['+ @i_InstanceName + ']. Please provide correct Subclient name via @i_NewSubclientName.'
			GOTO ARGS_ERROR
		END
		-- if user provided new Subclient name and no new BackupSet name then
		-- verify that new Subclient name is unique
		IF @NewSubclientNum > 1 AND @i_NewBackupSetName = @noParameter
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error. Subclient name ['+ @i_NewSubclientName + '] is not unique for given client ['+ @i_ClientName + '] and instance ['+ @i_InstanceName + ']. Please provide BackupSet name via @i_NewBackupSetName.'
			GOTO ARGS_ERROR
		END
	END
	IF @i_vmName = @noParameter AND @i_vmListFileName = @noParameter AND @i_OperationName <> 'List'
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. No vm name was given. Please specify @i_vmName or @i_vmListFileName.'
		GOTO ARGS_ERROR
	END
	-------- Check if file exists and populate vms ----------------
	IF @i_vmListFileName <> @noParameter AND ( @i_OperationName = 'Move' OR @i_OperationName = 'Delete')
	BEGIN
		EXEC ('bulk INSERT #tempVmListTable FROM "' + @i_vmListFileName + '"')
		IF @@Error <> 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error. Unable to open VM List file.' + @i_vmListFileName
			GOTO ARGS_ERROR
		END
	END
	-------- Check if file exists and populate vms/GUIDs/ESXServers ----------------
	IF @i_vmListFileName <> @noParameter AND @i_OperationName = 'Add'
	BEGIN
		EXEC ('bulk INSERT #tempAddVmListTable FROM "' + @i_vmListFileName + '" WITH(FIELDTERMINATOR = '','',ROWTERMINATOR = ''\n'')')
		IF @@Error <> 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error. Insert values from VM List file.' + @i_vmListFileName
			GOTO ARGS_ERROR
		END
	END
	------ Add vmName to temp table if specified -----------------
	IF @i_vmName <> @noParameter AND ( @i_OperationName = 'Move' OR @i_OperationName = 'Delete')
		INSERT INTO #tempVmListTable values(@i_vmName)
	-------- Check if file exists and populate vms ----------------
	IF @i_vmName <> @noParameter AND @i_OperationName = 'Add'
	BEGIN
		IF @i_vmGUID = @noParameter
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error. If @i_vmName specified for ''Add'' operation then @i_vmGUID and @i_vmESXServer must be provided.'
			GOTO ARGS_ERROR
		END
		INSERT INTO #tempAddVmListTable values(@i_vmName,@i_vmGUID,@i_vmESXServer)
	END
	-- Process #tempAddVmListTable and #tempVmListTable to encode spaces in vmName (see transform_string_encode() in NCVS)
	-- and also trim spaces in vmGUID and vmESXServer
	UPDATE #tempAddVmListTable SET	vmGUID = RTRIM(LTRIM(vmGUID)),
									vmESXServer = RTRIM(LTRIM(vmESXServer))
	-----------------------------------------------------------------
	------- Check vm GUID format before inserting -------------------
	-- it supposed to have format like:
	-- 564dea5e-8bc4-052f-a40f-780005173e0a
	-- check position 9,14,19,24 for '-'
	IF (SELECT count(vmGUID) from #tempAddVmListTable) > 0
	BEGIN
		IF (SELECT count(vmGUID) from #tempAddVmListTable
				WHERE SUBSTRING(vmGUID,9,1)<>'-'
				   OR SUBSTRING(vmGUID,14,1)<>'-'
				   OR SUBSTRING(vmGUID,19,1)<>'-'
				   OR SUBSTRING(vmGUID,24,1)<>'-'
				) > 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error. VM GUID (UUID) specified for ''Add'' operation has incorrect format. UUID format should be like: ''564dea5e-8bc4-052f-a40f-780005173e0a'''
			GOTO ARGS_ERROR
		END
	END
	----------------------------------------------------------------
	-------- Get SubclientIDs for different optional parameters ----
	-- 1. No subclient name and no backupset name
	IF @i_SubclientName = @noParameter AND @i_BackupSetName = @noParameter
		INSERT INTO #tempSubclientIDs (id) SELECT id from APP_Application
					WHERE clientId in ( SELECT id FROM APP_Client WHERE name = @i_ClientName)
						  and instance in ( SELECT id FROM APP_InstanceName WHERE name = @i_InstanceName)
	-- 2. No subclient name but backupset name
	IF @i_SubclientName = @noParameter AND @i_BackupSetName <> @noParameter
		INSERT INTO #tempSubclientIDs (id) SELECT id from APP_Application
					WHERE clientId in ( SELECT id FROM APP_Client WHERE name = @i_ClientName)
						  and instance in ( SELECT id FROM APP_InstanceName WHERE name = @i_InstanceName)
						  and backupSet in ( select id from APP_BackupSetName where name = @i_BackupSetName)
	-- 3. Subclient name but no backupset name
	IF @i_SubclientName <> @noParameter AND @i_BackupSetName = @noParameter
		INSERT INTO #tempSubclientIDs (id) SELECT id from APP_Application
					WHERE subclientName = @i_SubclientName
						  and clientId in ( SELECT id FROM APP_Client WHERE name = @i_ClientName)
						  and instance in ( SELECT id FROM APP_InstanceName WHERE name = @i_InstanceName)
	-- 4. Subclient name and backupset name
	IF @i_SubclientName <> @noParameter AND @i_BackupSetName <> @noParameter
		INSERT INTO #tempSubclientIDs (id) SELECT id from APP_Application
					WHERE subclientName = @i_SubclientName
						  and clientId in ( SELECT id FROM APP_Client WHERE name = @i_ClientName)
						  and instance in ( SELECT id FROM APP_InstanceName WHERE name = @i_InstanceName)
						  and backupSet in ( select id from APP_BackupSetName where name = @i_BackupSetName)
	----------------------------------------------------------------------------------------------------------------
	------ Verify that subclientis unique ------------------------------------
	SET @SubclientNum = ( SELECT COUNT(DISTINCT(id)) FROM #tempSubclientIDs)
	IF @SubclientNum <> 1
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Error. SubclientID is not unique.'
		GOTO ARGS_ERROR
	END
	SET @subClientID = (SELECT TOP 1 id FROM #tempSubclientIDs)
	--------------------------------------------------------------------------
	--------------- Move specified vms to new subclient ------------------------------------------------------------
	IF @i_OperationName = 'Move'
	BEGIN
		IF @i_NewBackupSetName <> @noParameter
			SET @newSubclientId = (select id from APP_Application
					where subclientName = @i_NewSubclientName
						  and clientId in ( select id from APP_Client where name = @i_ClientName)
						  and instance in ( select id from APP_InstanceName where name = @i_InstanceName)
						  and backupSet in ( select id from APP_BackupSetName where name = @i_NewBackupSetName))
		ELSE
			SET @newSubclientId = (select id from APP_Application
					where subclientName = @i_NewSubclientName
						  and clientId in ( select id from APP_Client where name = @i_ClientName)
						  and instance in ( select id from APP_InstanceName where name = @i_InstanceName))
		if @newSubclientId = 0
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error. Failed to get SubclientID for ' + @i_ClientName + ', ' + @i_InstanceName + ', ' + @i_NewSubclientName + '.'
			GOTO ARGS_ERROR
		END
		---------- Check if provided VMs exist in given subclient -----------------------------------------------
		INSERT INTO #tempMissedVmListTable
			SELECT * FROM #tempVmListTable
				WHERE vmName NOT IN
					(
						SELECT T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(1024)')
						FROM
						(
							SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x
							FROM APP_SubClientProp where attrName='Virtual Server Dyanimc Content'
							AND componentNameId = @subClientID
							AND modified=0
						) tmp
						CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children[@displayName]') AS T(c)
					)
		---------- Check if provided VMs exist in new subclient -------------------------------------------------
		INSERT INTO #tempDuplicateVmListTable
			SELECT * FROM #tempVmListTable
				WHERE vmName IN
					(
						SELECT T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(1024)')
						FROM (
							SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x
							FROM APP_SubClientProp
								where attrName='Virtual Server Dyanimc Content'
								AND modified=0
								AND componentNameId = @newSubclientId
						) tmp
						CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children[@displayName]') AS T(c)
					)
		------------ Removing Duplicated and Missed VMs from table before executing 'Move' operation ------------
		DELETE FROM #tempVmListTable
			WHERE vmName in ( SELECT * FROM #tempDuplicateVmListTable) or vmName in (SELECT * FROM #tempMissedVmListTable)
		---- Get existing VMs information in New subclient ( where we are moving to)
		DECLARE     @contentInDB  XML
		SET @contentInDB =
			( SELECT CAST(CAST(attrVal as VARCHAR(MAX)) as XML) x
				FROM APP_SubClientProp
				WHERE modified = 0
				AND attrType = 1
				AND attrName='Virtual Server Dyanimc Content'
				AND componentNameId =  @newSubclientId
			)
		---- Get VMs information which we need to move from Old Subclient
		DECLARE @tempDBVmInfoTable	TABLE (vmName NVARCHAR(1024), vmInfo XML)
		INSERT INTO @tempDBVmInfoTable
				SELECT T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(max)'), T.c.query('.')
				FROM #tempVmListTable vmL,
				(
					SELECT CAST(CAST(attrVal as VARCHAR(MAX)) as XML) x
					FROM APP_SubClientProp
						WHERE attrName='Virtual Server Dyanimc Content'
						AND attrType = 1
						AND modified=0
						AND componentNameId = @subClientID
				) tmp
				CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children') AS T(c)
				WHERE T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(max)') = vmL.vmName
		SET @newVMs = (select vmInfo.query('children') FROM @tempDBVmInfoTable FOR XML PATH(''), TYPE)
		--- Combine Existing VMs information with New VMs
		SET @contentInDB.modify('insert sql:variable("@newVms") into (/VirtualServer_VMSubClientEntity)[1]')
		------------ Creating a new entry with New subclient ID -------------------------------------------------
		INSERT INTO APP_SubClientProp
			(componentNameId,attrName,attrType, attrVal,created,modified,ccpID)
			SELECT @newSubclientId, attrName, attrType, CAST( @contentInDB AS NVARCHAR(max)), created, modified, ccpID
			FROM APP_SubClientProp
				WHERE attrName='Virtual Server Dyanimc Content'
				AND attrType = 1
				AND modified=0
				AND componentNameId = @newSubclientId
				AND attrVal <> CAST( @contentInDB AS NVARCHAR(max))
		----------- Mark old entry as invalid -------------------------------------------------------------------
		update APP_SubClientProp set modified = dbo.GetUnixTime(CURRENT_TIMESTAMP)
			WHERE attrName='Virtual Server Dyanimc Content'
			AND attrType = 1
			AND modified=0
			AND componentNameId = @newSubclientId
			AND attrVal <> CAST( @contentInDB AS NVARCHAR(max))
		------------- Get VMs info from old Subclient to remove VMs which was moved to New subclient ------------
		SET @contentInDB =
			( SELECT CAST(CAST(attrVal as VARCHAR(MAX)) as XML) x
				FROM APP_SubClientProp
				WHERE modified = 0
				AND attrType = 1
				AND attrName='Virtual Server Dyanimc Content'
				AND componentNameId =  @subClientID
			)
		--------- Remove VMs which were moved ------------------------------------------------------
		DECLARE tempCur CURSOR FOR
		SELECT #tempVmListTable.vmName
		FROM #tempVmListTable
		OPEN tempCur;
		FETCH NEXT FROM tempCur INTO @vmName;
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @contentInDB.modify('delete (/VirtualServer_VMSubClientEntity/children[@displayName=sql:variable("@vmName")])')
			FETCH NEXT FROM tempCur INTO @vmName;
			END;
		CLOSE tempCur;
		DEALLOCATE tempCur;
		------------ Creating a new entry with removed VMs for Old subclient -------------------------------------------------
		INSERT INTO APP_SubClientProp
			(componentNameId,attrName,attrType, attrVal,created,modified,ccpID)
			SELECT @subClientID, attrName, attrType, CAST( @contentInDB AS NVARCHAR(max)), created, modified, ccpID
			FROM APP_SubClientProp
				WHERE attrName='Virtual Server Dyanimc Content'
				AND attrType = 1
				AND modified=0
				AND componentNameId = @subClientID
				AND attrVal <> CAST( @contentInDB AS NVARCHAR(max))
		----------- Mark old entry as invalid -------------------------------------------------------------------
		update APP_SubClientProp set modified = dbo.GetUnixTime(CURRENT_TIMESTAMP)
			WHERE attrName='Virtual Server Dyanimc Content'
			AND attrType = 1
			AND modified=0
			AND componentNameId = @subClientID
			AND attrVal <> CAST( @contentInDB AS NVARCHAR(max))
	END   ----- end 'Move' operation ----------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------------------
	--------------- Delete specified vms from given subclient ---------------------------------------------------
	IF @i_OperationName = 'Delete'
	BEGIN
		---------- Check if provided VMs exist in given subclient -----------------------------------------------
		INSERT INTO #tempMissedVmListTable
			SELECT * FROM #tempVmListTable
				WHERE vmName NOT IN
					(
						SELECT T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(1024)')
						FROM
						(
							SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x
							FROM APP_SubClientProp where attrName='Virtual Server Dyanimc Content'
							AND componentNameId = @subClientID
							AND modified=0
						) tmp
						CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children[@displayName]') AS T(c)
					)
		------------ Removing Missed VMs from table before executing 'Delete' operation ------------
		Delete FROM #tempVmListTable
			WHERE vmName IN (SELECT * FROM #tempMissedVmListTable)
		------------- Get VMs info from Subclient to remove VMs ------------------------------------
		SET @contentInDB =
			( SELECT CAST(CAST(attrVal as VARCHAR(MAX)) as XML) x
				FROM APP_SubClientProp
				WHERE modified = 0
				AND attrType = 1
				AND attrName='Virtual Server Dyanimc Content'
				AND componentNameId =  @subClientID
			)
		--------- Remove VMs which were moved ------------------------------------------------------
		DECLARE tempCur CURSOR FOR
		SELECT #tempVmListTable.vmName
		FROM #tempVmListTable
		OPEN tempCur;
		FETCH NEXT FROM tempCur INTO @vmName;
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @contentInDB.modify('delete (/VirtualServer_VMSubClientEntity/children[@displayName=sql:variable("@vmName")])')
			FETCH NEXT FROM tempCur INTO @vmName;
			END;
		CLOSE tempCur;
		DEALLOCATE tempCur;
		------------ Creating a new entry with removed VMs for Old subclient -------------------------------------------------
		INSERT INTO APP_SubClientProp
			(componentNameId,attrName,attrType, attrVal,created,modified,ccpID)
			SELECT @subClientID, attrName, attrType, CAST( @contentInDB AS NVARCHAR(max)), created, modified, ccpID
			FROM APP_SubClientProp
				WHERE attrName='Virtual Server Dyanimc Content'
				AND attrType = 1
				AND modified=0
				AND componentNameId = @subClientID
				AND  attrVal <> CAST( @contentInDB AS NVARCHAR(max))
		----------- Mark old entry as invalid -------------------------------------------------------------------
		update APP_SubClientProp set modified = dbo.GetUnixTime(CURRENT_TIMESTAMP)
			WHERE attrName='Virtual Server Dyanimc Content'
			AND attrType = 1
			AND modified=0
			AND componentNameId = @subClientID
			AND attrVal <> CAST( @contentInDB AS NVARCHAR(max))
	END	----- end 'Delete' operation ----------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------------------
	--------------- List vms from given subclient ---------------------------------------------------------------
	IF @i_OperationName = 'List'
	BEGIN
		INSERT INTO #tempVmListTable
			SELECT T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(1024)')
			FROM
			(
				SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x
				FROM APP_SubClientProp where attrName='Virtual Server Dyanimc Content'
				AND componentNameId = @subClientID
				AND modified=0
			) tmp
			CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children[@displayName]') AS T(c)
	END	----- end 'List' operation -------------------------------------------------------------------------------
	--------------------------------------------------------------------------------------------------------------
	--------------- Add specified vms to subclient ---------------------------------------------------------------
	IF @i_OperationName = 'Add'
	BEGIN
		---------- Check if provided VMs already exist in subclient ----------------------------------------------
		INSERT INTO #tempDuplicateVmListTable
			SELECT vmName
			FROM #tempAddVmListTable
			WHERE vmName IN
				(
					SELECT T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(1024)')
					FROM (
						SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x
						FROM APP_SubClientProp
							where attrName='Virtual Server Dyanimc Content'
							AND modified=0
							AND componentNameId = @subClientID
					) tmp
					CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children[@displayName]') AS T(c)
				)
		------------ Removing Duplicated VMs from table before executing 'Add' operation ------------
		DELETE FROM #tempAddVmListTable
			WHERE vmName IN ( SELECT vmName FROM #tempDuplicateVmListTable)
		---- Get existing VMs information from subclient
		SET @contentInDB =
			( SELECT CAST(CAST(attrVal as VARCHAR(MAX)) as XML) x
				FROM APP_SubClientProp
				WHERE modified = 0
				AND attrType = 1
				AND attrName='Virtual Server Dyanimc Content'
				AND componentNameId =  @subClientID
			)
		---- Get VMs information which we need to add
		SET @newVMs =
			(SELECT
				'1' as '@allOrAnyChildren',
				vmGUID as '@name',
				'9' as '@type',
				vmName as '@displayName',
				'1' as '@equalsOrNotEquals'
				FROM   #tempAddVmListTable
				FOR XML PATH('children'), TYPE
			)
		--- Combine Existing VMs information with New VMs
		SET @contentInDB.modify('insert sql:variable("@newVms") into (/VirtualServer_VMSubClientEntity)[1]')
		------------ Creating a new entry with added VMs  -------------------------------------------------------
		INSERT INTO APP_SubClientProp
			(componentNameId,attrName,attrType, attrVal,created,modified,ccpID)
			SELECT @subClientID, attrName, attrType, CAST( @contentInDB AS NVARCHAR(max)), created, modified, ccpID
			FROM APP_SubClientProp
				WHERE attrName='Virtual Server Dyanimc Content'
				AND attrType = 1
				AND modified=0
				AND componentNameId = @subClientID
				AND attrVal <> CAST( @contentInDB AS NVARCHAR(max))
		----------- Mark old entry as invalid -------------------------------------------------------------------
		update APP_SubClientProp set modified = dbo.GetUnixTime(CURRENT_TIMESTAMP)
			WHERE attrName='Virtual Server Dyanimc Content'
			AND attrType = 1
			AND modified=0
			AND componentNameId = @subClientID
			AND attrVal <> CAST( @contentInDB AS NVARCHAR(max))
	END ----- end 'Add' operation ----------------------------------------------------------------------------
	----------------------------------------------------------------------------------------------------------
	------------- Showing operation details -----------------------------------------
	--- 1. Successfull VMs ----------------------------------------------------------
	DECLARE @resMessage NVARCHAR(1024)
	DECLARE @Vms int
	IF @i_OperationName = 'Add'
		SET @Vms = ( SELECT COUNT(DISTINCT(vmName)) FROM #tempAddVmListTable)
	ELSE
		SET @Vms = ( SELECT COUNT(DISTINCT(vmName)) FROM #tempVmListTable)
	IF @Vms <> 0
	BEGIN
		IF @i_OperationName = 'List'
			SET @resMessage = '[' + @i_OperationName + '] operation was successfully executed. Following [' + Convert(varchar(8),@Vms) + '] VMs detected:'
		ELSE
			SET @resMessage = '[' + @i_OperationName + '] operation was successfully executed on following [' + Convert(varchar(8),@Vms) + '] VMs: '
		PRINT @resMessage
		IF @i_OperationName = 'Add'
			SELECT DISTINCT(vmName) FROM #tempAddVmListTable
		ELSE
			SELECT DISTINCT(vmName) FROM #tempVmListTable
	END
	--- 2. VMs which do not exist in given subclient ------------------------------
	DECLARE @MissedVms int
	SET @MissedVms = ( SELECT COUNT(DISTINCT(vmName)) FROM #tempMissedVmListTable)
	if @MissedVms <> 0
	BEGIN
		SET @resMessage =  'Following [' + Convert(varchar(8),@MissedVms) + '] VMs were NOT found and thus operation [' + @i_OperationName + '] was skipped for them: '
		PRINT ' '
		PRINT @resMessage
		SELECT DISTINCT(vmName) FROM #tempMissedVmListTable
	END
	--- 3. Duplicated VMs which already present in new subclient ------------------
	DECLARE @DuplicateVms int
	SET @DuplicateVms = ( SELECT COUNT(DISTINCT(vmName)) FROM #tempDuplicateVmListTable)
	if @DuplicateVms <> 0
	BEGIN
		IF @i_OperationName = 'Add'
			SET @resMessage = 'Following [' + Convert(varchar(8),@DuplicateVms) + '] VMs already exist in [' + @i_SubclientName + '] subclient and thus operation [' + @i_OperationName + '] was skipped for them: '
		ELSE
			SET @resMessage = 'Following [' + Convert(varchar(8),@DuplicateVms) + '] VMs already exist in [' + @i_NewSubclientName + '] subclient and thus operation [' + @i_OperationName + '] was skipped for them: '
		PRINT ' '
		PRINT @resMessage
		SELECT DISTINCT(vmName) FROM #tempDuplicateVmListTable
	END
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR) + N') ErrorMsg(' + @errorString + N').'
	PRINT N'So Rolling back Transactions.'
END CATCH
---------------------------------------------------------------------------------
ARGS_ERROR:
	DROP TABLE #tempVmListTable
	DROP TABLE #tempMissedVmListTable
	DROP TABLE #tempDuplicateVmListTable
	DROP TABLE #tempSubclientIDs
	DROP TABLE #tempAddVmListTable
if @errorCode <> 0
BEGIN
	ROLLBACK TRANSACTION
	PRINT @scriptName + ' failed. ErrorCode ['+	Convert(varchar(2),@errorCode) +'].'
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
			)
END
ELSE
BEGIN
	PRINT ' '
	PRINT @scriptName + ' succeeded.'
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_VSASubclientContent')
	delete from GxQscripts where name = 'QS_VSASubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_VSASubclientContent')
	delete from GXDBVersions where aliasname = 'QS_VSASubclientContent'
GO

insert into GXDBVersions values(2, 'QS_VSASubclientContent',  '00000000000000000000', 'QS_VSASubclientContent', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_VSASubclientContent',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn VSASubclientContent -si @i_ClientName=''client_name'' -si @i_InstanceName=''Instance_Name'' -si @i_SubclientName=''subclient_name'' -si @i_OperationName=''Operation_Name'' [ -si @i_BackupSetName=''BackupSetName'' -si @i_vmName=''VM_Name'' -si @i_NewBackupSetName=''NewBackupSetName'' -si @i_NewSubclientName=''New_Subclient_Name'' -si @i_vmListFileName=''vm_List_File_Name'' -si @i_vmGUID=''vmGUID'' -si @i_vmESXServer=''ESXServer'']
'
 + CHAR(10) + '-- 		@i_OperationName one of {''Move''|''Delete''|''List''|''Add''}.'
 + CHAR(10) + '-- 		if @i_OperationName=''Move'' you have to specify @i_NewSubclientName.'
 + CHAR(10) + '-- 		You can specify one VM by @i_vmName or list of VMs by @i_vmListFileName or combination of both.'
 + CHAR(10) + '-- 		@i_vmListFileName must contain full path to text file with VM information.'
 + CHAR(10) + '-- 		if @i_OperationName=''Add'' then file specified by @i_vmListFileName must have comma separated VM name, VM GUID, VM ESX Server on each line of file like (CSV file):'
 + CHAR(10) + '-- 			vmName1,vmGUID1,vmESXServer1'
 + CHAR(10) + '-- 			vmName2,vmGUID2,vmESXServer2'
 + CHAR(10) + '-- 			Note: VM GUID (UUID) format should be like: ''XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX'', also ESX Server name could be skipped. Real file line example:'
 + CHAR(10) + '-- 			testvm4,564d27a5-1847-b59e-0615-b9cb5ef77e9b,'
 + CHAR(10) + '-- 			testvm5,564d27a5-1847-b59e-0615-b9cb5ef77e9c,'
 + CHAR(10) + '-- 		if @i_OperationName=''Move'' or ''Delete'' then file specified by @i_vmListFileName must have just VM name on each line of file like:'
 + CHAR(10) + '-- 			vmName1'
 + CHAR(10) + '-- 			vmName2'
 + CHAR(10) + '-- 		Use optional parameters @i_BackupSetName/@i_NewBackupSetName if @i_SubclientName/@i_NewSubclientName are not unique for provided client and instance.'
 + CHAR(10) + '-- 		if @i_OperationName=''Add'' and file is not specified by @i_vmListFileName then you have to specify VM name via @i_vmName, VM GUID via  @i_vmGUID amd  VM ESX Server via @i_vmESXServer.'
 + CHAR(10) + '
'
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '
'
 + CHAR(10) + '-- 		qoperation execscript -sn VSASubclientContent -si @i_ClientName=''myClient'' -si @i_InstanceName=''TestInstance'' -si @i_SubclientName=''SmallSubclient'' -si @i_OperationName=''Move'' -si @i_vmName=''VM1'' -si @i_NewBackupSetName=''TestBackupSet'' -si @i_NewSubclientName=''TestSubclient2'''
 + CHAR(10) + '
'
 + CHAR(10) + '-- 		qoperation execscript -sn VSASubclientContent -si @i_ClientName=''myClient'' -si @i_InstanceName=''TestInstance'' -si @i_SubclientName=''SmallSubclient'' -si @i_OperationName=''Delete'' -si @i_vmListFileName=''c:\VmList.txt'''
 + CHAR(10) + '
'
 + CHAR(10) + '-- 		qoperation execscript -sn VSASubclientContent -si @i_ClientName=''myClient'' -si @i_InstanceName=''TestInstance'' -si @i_BackupSetName=''defaultBackupSet'' -si @i_SubclientName=''SmallSubclient'' -si @i_OperationName=''List'''
 + CHAR(10) + '
'
 + CHAR(10) + '-- 		qoperation execscript -sn VSASubclientContent -si @i_ClientName=''myClient'' -si @i_InstanceName=''TestInstance'' -si @i_SubclientName=''SmallSubclient'' -si @i_OperationName=''Add'' -si @i_vmName=''VM_Name1'' -si @i_vmGUID=''564d27a5-1847-b59e-0615-b9cb5ef77e9b'' -si @i_vmESXServer=''ESXServer1'''
)
GO

