

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_VMBackupSizes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- 	+-----------------------------------------------------------------------+
--	| 		Cursor: "QS_VMBackupSizes"			|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_VMBackupSizes')
BEGIN
	print '>>> Drop Stored Procedure: QS_VMBackupSizes <<<'
	drop procedure QS_VMBackupSizes
END
IF EXISTS (select * from GxQscripts where name='QS_VMBackupSizes')
	delete from GxQscripts where name = 'QS_VMBackupSizes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_VMBackupSizes')
	delete from GXDBVersions where aliasname = 'QS_VMBackupSizes'
GO
print '... Creating Procedure: QS_VMBackupSizes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_VMBackupSizes
  @i_PbackupLevel NVARCHAR(32)=N'',
  @i_PsubClientName NVARCHAR(128)=N'',
  @i_PstartDate DATETIME='',
  @i_PendDate DATETIME='',
  @i_PincludeAgedJobs INT=0,
  @i_PincludeMediaDeleted INT=0,
  @i_PincludeSnapBkpJobs INT=0, 
  @i_PincludeSRMData INT=0,
  @i_PoutputType INT=0
AS
  DECLARE @o_VMName NVARCHAR(255)
  DECLARE @o_BackupSetName NVARCHAR(128)
  DECLARE @o_SubClientName NVARCHAR(128)
  DECLARE @o_TotalFullJobs INT
  DECLARE @o_SizeOfVMOnHost FLOAT
  DECLARE @o_LastFullBackupTime NVARCHAR(20)
  DECLARE @o_ApplicationSize_F FLOAT(4)
  DECLARE @o_DataWritten_F FLOAT(4)
  DECLARE @o_DataXferred_F FLOAT(4)
  DECLARE @o_ImpliedCompression_F FLOAT(2)
  DECLARE @o_Deduplication_F FLOAT(2)
  DECLARE @o_TotalIncrJobs INT
  DECLARE @o_LastIncBkpTime NVARCHAR(20)
  DECLARE @o_ApplicationSize_I FLOAT(4)
  DECLARE @o_DataWritten_I FLOAT(4)
  DECLARE @o_DataXferred_I FLOAT(4)
  DECLARE @o_ImpliedCompression_I FLOAT(2)
  DECLARE @o_Deduplication_I FLOAT(2)
  DECLARE @o_GuestOS NVARCHAR(256)
  DECLARE @o_ProvisionedStorage FLOAT(4)
  DECLARE @o_DiskUtilization FLOAT(4)
  DECLARE @o_Memory FLOAT
  DECLARE @o_MemoryUtilization FLOAT(2)
  DECLARE @o_GuestCPUUsage INT
  DECLARE @o_GuestMemoryUsed FLOAT(2)
  DECLARE @o_MemoryUsedonHost FLOAT(2)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
 SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
DECLARE @bkpLevel      INT;
SELECT @bkpLevel =
		CASE WHEN @i_PbackupLevel Like '%FULL%'
			THEN 1
                  WHEN @i_PbackupLevel Like '%Incr%'
           THEN 2
		ELSE 0
		END
DECLARE @subClient	NVARCHAR(128)	= @i_PsubClientName;			--Assign the subclientName here, IF you want all the subclients leave it blank
DECLARE @startDateVal  datetime = @i_PstartDate;					--modify to specify startDate IN yyyy-mm-dd format, to SELECT last 30 days make it ''
DECLARE @endDateVal	datetime = @i_PendDate;					--modify to specify endDate
DECLARE @includeAgedJobs		INTEGER = @i_PincludeAgedJobs		/* 0 - Do not include aged jobs; 1 - Include aged jobs*/
DECLARE @includeMediaDeleted	INTEGER = @i_PincludeMediaDeleted	/* 0 - Do not include media deleted jobs; 1 - Include media deleted jobs*/
DECLARE @includeSnapBkpJobs		INTEGER = @i_PincludeSnapBkpJobs /* 0 - Do not include snap bkpjobs; 1 = include snap backup jobs*/
DECLARE @i_outputType			INTEGER = @i_PoutputType			/* 0 - Display the data at the whole VM level, 1 - Get only the latest job data*/
DECLARE @csName	 NVARCHAR(256) = '';
DECLARE @csTimeZone NVARCHAR(256) = '';
SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
SELECT	@csTimeZone = TimeZoneStdName
FROM SchedTimeZone
WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
DECLARE @startDate INT = 0;
DECLARE @endDate INT = 0;
IF @startDateVal = '' OR @endDateVal = ''  --SET last 30 days data
BEGIN
	SET @startDateVal = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()-30), 0)
	SET @endDateVal = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()+1), 0)
END
SET @startDate  = dbo.GetUnixTime( dbo.LocalToUTCDateTimeConversionManaged(@startDateVal, @csTimeZone))
SET @endDate  =  dbo.GetUnixTime(dbo.LocalToUTCDateTimeConversionManaged(@endDateVal, @csTimeZone))
DECLARE @tmpBkpLevelTable TABLE(jobType INTeger);
IF @bkpLevel = 1 or @bkpLevel = 0
	BEGIN
		INSERT INTO @tmpBkpLevelTable values(1);
		INSERT INTO @tmpBkpLevelTable values(1024);
		INSERT INTO @tmpBkpLevelTable values(32768);
		INSERT INTO @tmpBkpLevelTable values(64);
		INSERT INTO @tmpBkpLevelTable values(128);
	END
IF @bkpLevel = 2 or @bkpLevel = 0
	BEGIN
		INSERT INTO @tmpBkpLevelTable values(2);
		INSERT INTO @tmpBkpLevelTable values(16384);
	END
IF object_id('tempdb.dbo.#BkpStatsTempTable') IS NOT NULL DROP TABLE #BkpStatsTempTable
CREATE TABLE #BkpStatsTempTable
(
type INT,
jobId int,
commCellId int,
appId int,
appType int,
bkpLevel int,
status int,
servStartDate int,
servEndDate int,
opType int,
totalCompBytes bigint,
totalUncompBytes bigint,
totalBackupSize bigint,
fromTime int,
toTime int,
nwTransBytes bigint,
DataWritten BIGINT
)
INSERT INTO #BkpStatsTempTable
SELECT CASE
			WHEN (jbs.bkpLevel=1 or jbs.bkpLevel = 1024 or jbs.bkpLevel = 32768 or jbs.bkpLevel =64 or jbs.bkpLevel = 128)
				then 1
			WHEN (jbs.bkpLevel = 2 or jbs.bkpLevel = 16384)
				then 2
				end
		,jbs.jobId, jbs.commCellId, jbs.appId, jbs.appType, jbs.bkpLevel, jbs.status, jbs.servStartDate, jbs.servEndDate, jbs.opType, jbs.totalCompBytes, jbs.totalUncompBytes, jbs.totalBackupSize, jbs.fromTime, jbs.toTime, jbs.nwTransBytes
		,cast (0 as BIGINT)
FROM CommServ.dbo.jmbkpstats as jbs
		JOIN @tmpBkpLevelTable bkpleveltbl
                	on jbs.bkplevel = bkpleveltbl.jobtype
	WHERE jbs.appType = 106 --CV_APPTYPE_VIRTUAL_SERVER				106
	  AND (jbs.status = 1 OR jbs.status = 3 OR jbs.status = 14) --completed, CWE, CWW  jobs only
	  AND jbs.servStartDate >= @startDate
	  AND jbs.servEndDate <= @endDate
	  AND ((@includeAgedJobs = 0 AND jbs.dataStatus <> 1) OR @includeAgedJobs = 1)
	  AND ((@includeMediaDeleted = 0 AND jbs.dataStatus <> 2) OR @includeMediaDeleted = 1)
	  AND ((@includeSnapBkpJobs = 0 AND jbs.opType <> 59) OR @includeSnapBkpJobs = 1)
IF @i_outputType = 1
BEGIN
	delete #BkpStatsTempTable
	from #BkpStatsTempTable bkp1 join
		(SELECT MAX(jobId) maxJob , appid, commcellId, type
		FROM #BkpStatsTempTable
		GROUP BY appId, commCellId, type) BKP2
		on BKP1.appId = BKP2.appId AND BKP1.commcellId = BKP2.commcellId AND BKP1.type = BKP2.type
	where bkp1.jobId < BKP2.maxJob
END
UPDATE  #BkpStatsTempTable
SET     DataWritten = X.sizeOnMedia
FROM    (SELECT T.jobid XJobId, T.commcellId XCommCellId, MAX(T.sizeOnMedia) AS sizeOnMedia
        FROM    (SELECT S.jobid, S.commcellId, S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
                FROM    JMJobDataStats S WITH (READUNCOMMITTED), #BkpStatsTempTable B
                WHERE   S.commcellId = B.commCellId AND S.jobid = B.jobid AND S.AuxCopyJobId = 0
                GROUP BY S.jobid, S.commcellId, S.archGrpCopyId) AS T
        GROUP BY T.jobid, T.commcellId) AS X
WHERE   jobId = X.XJobId AND commCellId = X.XCommcellId
 IF OBJECT_ID('tempdb.dbo.#BackupCopyJob') IS NOT null DROP TABLE #BackupCopyJob
  CREATE TABLE #BackupCopyJob (jobId INT, snapJobId INT, commCellId INT)
             INSERT  INTO #BackupCopyJob
             SELECT  B.jobId, B.jobIdActedOn, B.commCellId
             FROM    #BkpStatsTempTable J
                     INNER JOIN JMBkpStats B WITH (NOLOCK) ON J.JobId = B.jobId AND 2 = B.commCellId
             WHERE   B.opType = 60
             UPDATE  J
             SET     DataWritten = T.sizeOnMedia
             FROM    #BkpStatsTempTable J
                     INNER JOIN (
                         SELECT  BC.jobId, BC.commCellId, SUM(S.sizeOnMedia) AS sizeOnMedia
                         FROM    JMJobDataStats S WITH (NOLOCK)
                                 INNER JOIN #BackupCopyJob BC ON S.commCellId = BC.commCellId and S.jobid = BC.snapJobId
                                 INNER JOIN archGroup AG WITH (NOLOCK) ON S.archGrpId = AG.id AND S.archGrpCopyId = AG.defaultCopy
                         GROUP BY BC.jobId, BC.commCellId
                     ) T ON J.JobId = T.jobId AND 2 = T.commCellId
 DROP TABLE #BackupCopyJob
IF object_id('temp.dbo.#vmInventoryDetails') IS NOT NULL DROP TABLE #vmInventoryDetails
CREATE TABLE #vmInventoryDetails(
		clientId INT
		, clientName NVARCHAR(256)
		, subClientId INT
		, vsVMClientId INT
		, VMRelatedSubClientName NVARCHAR(256)
		, vsVMId INT
		, vsVMName NVARCHAR(256)
		, vsVMOptionsGuestOS NVARCHAR(256)
		, vsVMSummaryMemorySize float
		, vsVMHostName NVARCHAR(256)
		, vsVMSummaryDiskUtilization float
		, vsVMSummaryProvisionedStorage float
		, vsVMSummaryUsedStorage float
		, vsVMResourceAllocMemoryUtilization float
		, vsVMResourceAllocOverallCPUUsageMHz INT
		, vsVMResourceAllocGuestMemoryUsage float
		, vsVMResourceAllocHostMemoryUsage float)
IF @i_PincludeSRMData = 1 AND DB_ID('SRM') IS NOT NULL
BEGIN
	INSERT INTO #vmInventoryDetails
	EXEC sp_executesql N'SELECT DISTINCT
			  v600.clientId
			, v600.clientName
			, v600.subClientId
			, v601.vsVMClientId
			, v600.subClientName as VMRelatedSubClientName
			, v601.vsVMId
			, v601.vsVMName
			, v603.vsVMOptionsGuestOS
			, v603.vsVMSummaryMemorySize
			, v603.vsVMHostName
			, v603.vsVMSummaryDiskUtilization
			, v603.vsVMSummaryProvisionedStorage
			, v603.vsVMSummaryUsedStorage
			, v603.vsVMResourceAllocMemoryUtilization
			, v603.vsVMResourceAllocOverallCPUUsageMHz
			, v603.vsVMResourceAllocGuestMemoryUsage
			, v603.vsVMResourceAllocHostMemoryUsage
		FROM
			  SRM..SRMXMLRepCommServClientInfoView AS v600
			, SRM..SRMXMLRepVSEntitiesView AS v601
			, SRM..SRMXMLRepVSVirtualMachineDetailsView AS v603
		WHERE v600.appTypeGrouping = 9
			AND v601.instanceId = v600.csInstanceId
			AND v603.vsDataCenterId = v601.vsDataCenterId AND v603.vsHostId = v601.vsHostId AND v603.vsVMId = v601.vsVMId'
END
IF NOT EXISTS(SELECT clientId FROM #vmInventoryDetails)
BEGIN
INSERT INTO #vmInventoryDetails
SELECT
		  NULL AS clientId
		, NULL AS clientName
		, NULL AS subClientId
		, NULL AS vsVMClientId
		, NULL as VMRelatedSubClientName
		, NULL AS vsVMId
		, NULL AS vsVMName
		, NULL AS vsVMOptionsGuestOS
		, 0 AS vsVMSummaryMemorySize
		, NULL AS vsVMHostName
		, 0 AS vsVMSummaryDiskUtilization
		, 0 AS vsVMSummaryProvisionedStorage
		, 0 AS vsVMSummaryUsedStorage
		, 0 AS vsVMResourceAllocMemoryUtilization
		, 0 AS vsVMResourceAllocOverallCPUUsageMHz
		, 0 AS vsVMResourceAllocGuestMemoryUsage
		, 0 AS vsVMResourceAllocHostMemoryUsage
END
IF object_id('temp.dbo.#BkpDataTempTable') IS NOT NULL DROP TABLE #BkpDataTempTable
CREATE TABLE #BkpDataTempTable(
		NAME VARCHAR(255)
		, bkpSubClientId INT
		, bType INT
		, typeCount INT
		, subClientName NVARCHAR(128)
		, backupSetName NVARCHAR(128)
		, bkpCommCellId INT
		, lastJobTime INT
		, appId INT
		, qType INT
		, qClient INT
		, qClientName NVARCHAR(255)
		, clientId INT
		, clientName NVARCHAR(256)
		, subClientId INT
		, vsVMClientId INT
		, VMRelatedSubClientName NVARCHAR(256)
		, vsVMId INT
		, vsVMName NVARCHAR(256)
		, vsVMOptionsGuestOS NVARCHAR(256)
		, vsVMSummaryMemorySize float
		, vsVMHostName NVARCHAR(256)
		, vsVMSummaryDiskUtilization float
		, vsVMSummaryProvisionedStorage float
		, vsVMSummaryUsedStorage float
		, vsVMResourceAllocMemoryUtilization float
		, vsVMResourceAllocOverallCPUUsageMHz INT
		, vsVMResourceAllocGuestMemoryUsage float
		, vsVMResourceAllocHostMemoryUsage float
)
INSERT INTO #BkpDataTempTable
SELECT *
FROM (
	SELECT *
	FROM
	(
		SELECT
			client.name
			, app.Id as bkpSubClientId
			, jbs.type AS bType
			, COUNT(jbs.type) as typeCount
			, app.subclientName
			, BS.name as backupSetName
			, jbs.commCellId bkpCommcellId
			, max(servStartDate) as lastJobTime
		FROM #BkpStatsTempTable jbs
			JOIN CommServ.dbo.APP_Application app
				ON app.id = jbs.appId
			JOIN CommServ.dbo.APP_Client as client
				ON app.clientId = client.id
			JOIN CommServ.dbo.APP_BackupSetName BS
				ON BS.id = app.backupSet
		WHERE (@subClient = '' or subclientName like @subClient)
		GROUP BY client.name, app.id, app.subclientName, jbs.type, jbs.commCellId, BS.id, BS.name
	) as BkpData
	INNER JOIN
	(
		SELECT	DISTINCT J.appId AS appID, J.type AS qType, Q.clientId AS qClient, Q.clientName AS qClientName
		FROM	#BkpStatsTempTable J
			INNER JOIN CommServ.dbo.JMQinetixUpdateStatus Q
			ON	J.jobid = Q.jobId AND J.commcellId = Q.commCellId
	) AS tempQinetix
	ON	BkpData.bkpSubClientId = tempQinetix.appID AND tempQinetix.qType = BkpData.bType
	LEFT OUTER JOIN #vmInventoryDetails vID
	ON	BkpData.bkpSubClientId = vID.subClientId
		AND vID.vsvmClientId = tempQinetix.qClient
	) as results
DROP TABLE #vmInventoryDetails
UPDATE #BkpDataTempTable
SET vsVMSummaryUsedStorage = 0,vsVMSummaryMemorySize = 0, vsVMSummaryProvisionedStorage=0,vsVMResourceAllocMemoryUtilization=0,vsVMResourceAllocOverallCPUUsageMHz=0,vsVMResourceAllocGuestMemoryUsage=0
WHERE vsVMSummaryUsedStorage is NULL AND vsVMResourceAllocOverallCPUUsageMHz is NULL
IF object_id('temp.dbo.#vmPropJobData') IS NOT NULL DROP TABLE #vmPropJobData
CREATE TABLE #vmPropJobData
(
	jobId			INT,
	vmClientId		INT,
	appId			INT,
	type			INT,
	vmStatus		INT,
	vmUsedSpace		BIGINT,
	vmSize			BIGINT,
	vmBkpEndTime	BIGINT,
	guestOS			NVARCHAR(256)
)
insert INTO #vmPropJobData
SELECT
	vmp.jobId
	, vmp.VMclientId
	, bst.appId
	, bst.Type
	, ISNULL((SELECT (cast(attrVal as BIGINT)) FROM APP_VMProp a WHERE a.attrName = 'vmStatus' AND a.jobId = vmp.jobId AND a.vmClientId = vmp.vmClientId),-1)
	, isnull((SELECT (cast(attrVal as BIGINT)) FROM APP_VMProp a WHERE a.attrName = 'vmUsedSpace' AND a.jobId = vmp.jobId AND a.vmClientId = vmp.vmClientId),0)
	, isnull((SELECT (cast(attrVal as BIGINT)) FROM app_vmprop a WHERE a.attrName = 'vmSize' AND a.jobId = vmp.jobId AND a.vmClientId = vmp.vmClientId),0)
	, 0
	, isnull((SELECT attrVal  FROM app_vmprop a WHERE a.attrName = 'vmOperatingSystem' AND a.jobId = vmp.jobId AND a.vmClientId = vmp.vmClientId),0)
FROM APP_VMProp vmp
		JOIN #BkpStatsTempTable bSt
			ON vmp.jobId = bSt.jobId
GROUP BY vmp.jobId, vmp.VMclientId, bst.appId, bSt.type
ORDER BY VMclientId, appid
DELETE FROM #vmPropJobData WHERE vmStatus not IN (0,3)
IF EXISTS (SELECT jobId FROM #vmPropJobData WHERE vmUsedSpace = 0)
UPDATE #vmPropJobData
SET vmUsedSpace = D.vmUsedSpace
FROM #vmPropJobData D JOIN (SELECT MAX(jobId) JbId , appid, vmclientid FROM #vmPropJobData WHERE vmusedspace <> 0 GROUP BY appId, vmClientId ) R
ON D.appId = R.appId AND D.vmClientId = R.vmClientId
WHERE vmUsedSpace = 0 AND D.vmUsedSpace <> 0
IF @i_PincludeSRMData = 1 AND EXISTS (SELECT jobId FROM #vmPropJobData WHERE vmUsedSpace = 0)
UPDATE #vmPropJobData
SET vmUsedSpace = cast(SRMInv.vsVMSummaryUsedStorage as BIGINT)
FROM #vmPropJobData D JOIN #BkpDataTempTable SRMInv ON D.vmClientId = SRMInv.vsVMId AND D.appId = SRMInv.subClientId
WHERE vmUsedSpace = 0 AND SRMInv.vsVMSummaryUsedStorage is not null AND SRMInv.vsVMSummaryUsedStorage <> 0
IF EXISTS (SELECT jobId FROM #vmPropJobData WHERE vmSize = 0)
UPDATE #vmPropJobData
SET vmSize = D.vmSize
FROM #vmPropJobData D JOIN (SELECT MAX(jobId) JbId , appid, vmclientid FROM #vmPropJobData WHERE vmSize <> 0 GROUP BY appId, vmClientId ) R
ON D.appId = R.appId AND D.vmClientId = R.vmClientId
WHERE vmSize = 0 AND D.vmSize <> 0
IF @i_PincludeSRMData = 1 AND EXISTS (SELECT jobId FROM #vmPropJobData WHERE vmSize = 0)
UPDATE #vmPropJobData
SET vmSize = cast(SRMInv.vsVMSummaryProvisionedStorage as BIGINT)
FROM #vmPropJobData D JOIN #BkpDataTempTable SRMInv ON D.vmClientId = SRMInv.vsVMId AND D.appId = SRMInv.subClientId
WHERE vmSize = 0 AND SRMInv.vsVMSummaryProvisionedStorage is not null AND SRMInv.vsVMSummaryProvisionedStorage <> 0
IF object_id('temp.dbo.#vmPropJobDataMid') IS NOT NULL DROP TABLE #vmPropJobDataMid
CREATE TABLE #vmPropJobDataMid
(jobId INT, vmClientId INT, appId INT, type INT, vmBkpEndTime BIGINT, vmStatus INT, DataWritten_VM FLOAT(4), DataXered_VM FLOAT(4), AppSize_VM FLOAT(4), TotalCompBytes_VM FLOAT(4), guestOS NVARCHAR(256))
insert INTO #vmPropJobDataMid
SELECT
	VPJD.jobId
	, VPJD.vmClientId
	, VPJD.appId
	, VPJD.type
	, bst.servStartDate
	, vpjd.vmStatus
	, CASE WHEN (results.vmUsedSpace_job <= 0)	then 0 ELSE (VPJD.vmUsedSpace	* ( cast (bst.dataWritten as FLOAT(4))/ results.vmUsedSpace_job)) end
	, CASE WHEN (results.vmUsedSpace_job <= 0)	then 0 ELSE (VPJD.vmUsedSpace	* ( cast (bst.nwTransBytes  as FLOAT(4)) / results.vmUsedSpace_job)) end
	, CASE WHEN (results.vmSize_job <= 0)		then 0 ELSE (VPJD.vmSize		* ( cast (bst.totalUncompBytes as FLOAT(4)) / results.vmSize_job)) end
	, CASE WHEN (results.vmUsedSpace_job <= 0)	then 0 ELSE (VPJD.vmUsedSpace	* ( CAST (bst.TotalCompBytes as FLOAT(4)) / results.vmUsedSpace_job)) end
	, VPJD.guestOS
FROM #vmPropJobData VPJD
	JOIN (SELECT jobid, appid, SUM(vmUsedSpace) vmUsedSpace_job,SUM(vmSize) vmSize_job, type FROM #vmPropJobData GROUP BY jobId, appId, type)results
		ON VPJD.jobId = results.jobId AND VPJD. appId = results.appId AND VPJD.type = results.type
	JOIN #BkpStatsTempTable bst
		ON results.jobId = bst.jobid
DROP TABLE #vmPropJobData
IF object_id('temp.dbo.#vmPropJobDataRes') IS NOT NULL DROP TABLE #vmPropJobDataRes
CREATE TABLE #vmPropJobDataRes
(vmClientId INT, applicationId INT, type INT, successCount INT, DataWritten_VM DECIMAL(10,2), DataXered_VM DECIMAL(10,2), AppSize_VM DECIMAL(10,2), TotalCompBytes_VM DECIMAL(10,2), lastJobId INT, lastBkpJobTime BIGINT, guestOS NVARCHAR(256) DEFAULT null )
insert INTO #vmPropJobDataRes
SELECT vmClientId
		, appId
		, type
		, 0
		, SUM(DataWritten_VM)/(1024*1024*1024)
		, SUM(DataXered_VM)/(1024*1024*1024)
		, SUM(AppSize_VM)/(1024*1024*1024)
		, SUM(TotalCompBytes_VM)/(1024*1024*1024)
		, 0
		, 0
		, ISNULL(MAX(guestOS), 'N/A')
FROM #vmPropJobDataMid
GROUP BY vmClientId, appid, type
UPDATE #vmPropJobDataRes
SET successCount = tempR.successCount, lastJobId = tempR.jobId
FROM #vmPropJobDataRes Res
		JOIN (SELECT COUNT(*) successCount, max( jobid )jobId, vmClientId, appId, type FROM #vmPropJobDataMid
								GROUP BY vmClientId, appId,type) tempR
ON Res.applicationId = tempR.appId AND Res.vmClientId = tempR.vmClientId AND Res.type = tempR.type
UPDATE #vmPropJobDataRes
SET lastBkpJobTime = M.vmBkpEndTime
FROM #vmPropJobDataRes R JOIN #vmPropJobDataMid M ON R.lastJobId = M.jobId AND M.vmClientId = R.vmClientId AND M.appId = R.applicationId
DROP TABLE #vmPropJobDataMid;
IF object_id('temp.dbo.#tempSizeOfVM') IS NOT NULL DROP TABLE #tempSizeOfVM
CREATE TABLE #tempSizeOfVM(jobId INT, vmClientId INT, appId INT, SizeOfVMOnHost DECIMAL(10,2), provisionedStorage DECIMAL(10,2), disKUtilization DECIMAL(10,2));
INSERT INTO #tempSizeOfVM
SELECT MAX(BS.jobId), VP.VMclientId, RES.applicationId,0,0,0
FROM JMBkpStats BS
	JOIN APP_VMProp VP
		ON BS.jobId = VP.jobId
	JOIN #vmPropJobDataRes RES
		ON VP.VMclientId = RES.vmClientId
			AND BS.appId = RES.applicationId
	WHERE BS.bkpLevel IN (1, 1024, 32768, 64, 128) AND BS.status IN (1, 3, 14) GROUP BY vp.VMclientId, RES.applicationId
UPDATE #tempSizeOfVM
SET SizeOfVMOnHost = (cast(P.attrVal as FLOAT(4)) / 1024 / 1024 / 1024)
FROM #tempSizeOfVM T JOIN APP_VMProp P ON T.jobId = P.jobId AND T.vmClientId = P.VMclientId
WHERE P.attrName = 'vmUsedSpace' AND (CAST (P.attrVal as BIGINT) ) <> 0
IF @i_PincludeSRMData = 1 AND EXISTS (SELECT jobId FROM #tempSizeOfVM WHERE SizeOfVMOnHost = 0)
UPDATE #tempSizeOfVM
SET SizeOfVMOnHost = cast(SRMInv.vsVMSummaryUsedStorage as FLOAT(4))/1024/1024/1024
FROM #tempSizeOfVM T JOIN #BkpDataTempTable SRMInv ON T.appId = SRMInv.subClientId AND T.vmClientId = SRMInv.vsvmid
WHERE SizeOfVMOnHost = 0 AND SRMInv.vsVMSummaryUsedStorage <> 0 AND SRMInv.vsVMSummaryUsedStorage is not null
UPDATE #tempSizeOfVM
SET provisionedStorage = (cast(P.attrVal as FLOAT(4)) / 1024 / 1024 / 1024)
FROM #tempSizeOfVM T JOIN APP_VMProp P ON T.jobId = P.jobId AND T.vmClientId = P.VMclientId
WHERE P.attrName = 'vmSize' AND (CAST (P.attrVal as BIGINT) ) <> 0
IF @i_PincludeSRMData = 1 AND EXISTS (SELECT jobId FROM #tempSizeOfVM WHERE provisionedStorage = 0)
UPDATE #tempSizeOfVM
SET provisionedStorage = cast(SRMInv.vsVMSummaryProvisionedStorage as FLOAT(4))/1024/1024/1024
FROM #tempSizeOfVM T JOIN #BkpDataTempTable SRMInv ON T.appId = SRMInv.subClientId AND T.vmClientId = SRMInv.vsVMId
WHERE provisionedStorage = 0 AND SRMInv.vsVMSummaryProvisionedStorage <> 0 AND SRMInv.vsVMSummaryProvisionedStorage is not null
UPDATE #tempSizeOfVM
SET disKUtilization = CASE WHEN provisionedStorage = 0 then 0 ELSE (SizeOfVMOnHost / provisionedStorage) * 100 end
SELECT
		ISNULL(X.qClientName,I.qClientName) as 'VM Name'
		, ISNULL(X.backupSetName, ISNULL(I.backupSetName,'N/A')) as 'Backupset'
		, ISNULL(X.appId, ISNULL(I.appId, 0)) as 'Subclient Id'
		, ISNULL(X.subclientName, ISNULL(I.subclientName,'N/A')) as 'Subclient'
		, ISNULL(X.successcount, 0) as 'Total Full Jobs'
		, ISNULL((SELECT T.SizeOfVMOnHost FROM #tempSizeOfVM T WHERE T.appId = ISNULL(X.applicationId,I.applicationId) AND T.vmClientId = ISNULL(X.vmClientId,I.vmClientId)),0) as 'Size Of VM (GB)'
		, ISNULL(X.lastJobId, 0) as 'Last Full Backup Job Id'
		, CASE WHEN X.lastBkpJobTime IS NULL THEN 'N/A' ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(X.lastBkpJobTime), @csTimeZone) END  as 'Last Full Backup Time'
		, ISNULL(X.AppSize_VM,0) as 'Full Job Application Size (GB)'
		, ISNULL(X.DataWritten_VM,0) as 'Full Job Data Written Size (GB)'
		, ISNULL(X.DataXered_VM,0) as 'Full Job Data Transferred Size (GB)'
		, cast(ISNULL((CASE WHEN ((X.AppSize_VM - X.TotalCompBytes_VM)<0 OR (X.AppSize_VM =0))  then 0 ELSE ((X.AppSize_VM - X.TotalCompBytes_VM)/cast(X.AppSize_VM as FLOAT(2)))*100 end),0) as decimal(10,2))  as 'Full Job Compression'
		, cast(ISNULL((CASE WHEN ((X.AppSize_VM - X.DataWritten_VM)<0 OR (X.AppSize_VM =0) ) then 0 ELSE ((X.AppSize_VM - X.DataWritten_VM)/cast(X.AppSize_VM as FLOAT(4)))*100 end),0) as decimal(10,2))  as 'Full Job Deduplication'
		, ISNULL(I.successCount,0) as 'Total Incremental Jobs'
		, ISNULL(I.lastJobId, 0) as 'Last Incremental Backup Job Id'
		, CASE WHEN I.lastBkpJobTime IS NULL THEN 'N/A' ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(I.lastBkpJobTime), @csTimeZone) END  as 'Last Incremental Backup Time'
		, ISNULL(I.AppSize_VM,0) as 'Incremental Job Application Size (GB)'
		, ISNULL(I.DataWritten_VM,0) as 'Incremental Job Data Written Size (GB)'
		, ISNULL(I.DataXered_VM,0) as 'Incremental Job Data Transferred Size (GB)'
		, cast(ISNULL((CASE WHEN ((I.AppSize_VM - I.TotalCompBytes_VM)<=0 OR (I.AppSize_VM =0))  then 0 ELSE ((I.AppSize_VM - I.TotalCompBytes_VM)/cast(I.AppSize_VM as FLOAT(2)))*100 end),0)as decimal(10,2))  as 'Incremental Job Compression'
		, cast(ISNULL((CASE WHEN ((I.AppSize_VM - I.DataWritten_VM)<0 OR (I.AppSize_VM =0) )	then 0 ELSE ((I.AppSize_VM - I.DataWritten_VM)/cast(I.AppSize_VM as FLOAT(4)))*100 end),0) as decimal(10,2)) as 'Incremental Job Deduplication'
		, ISNULL(X.guestOS, ISNULL(I.guestOS,'N/A')) as 'Guest OS'
		, ISNULL((SELECT T.provisionedStorage FROM #tempSizeOfVM T WHERE T.appId = ISNULL(X.applicationId,I.applicationId) AND T.vmClientId = ISNULL(X.vmClientId,I.vmClientId)),0) as 'Provisioned Storage'
		, ISNULL((SELECT T.disKUtilization FROM #tempSizeOfVM T WHERE T.appId = ISNULL(X.applicationId,I.applicationId) AND T.vmClientId = ISNULL(X.vmClientId,I.vmClientId)),0) as 'Disk Utilization'
		, cast(cast(ISNULL(X.vsVMSummaryMemorySize,ISNULL(I.vsVMSummaryMemorySize,0)) as float)/(1024 * 1024 * 1024) as FLOAT(2)) as 'Memory'
		, cast(cast(ISNULL(X.vsVMResourceAllocMemoryUtilization,ISNULL(I.vsVMResourceAllocMemoryUtilization,0))AS float)/(1024.0) as FLOAT(2)) as 'Memory Utilization'
		, ISNULL(X.vsVMResourceAllocOverallCPUUsageMHz,ISNULL(I.vsVMResourceAllocOverallCPUUsageMHz,0)) as 'Guest CPU Usage'
		, cast(cast(ISNULL(X.vsVMResourceAllocGuestMemoryUsage,ISNULL(I.vsVMResourceAllocGuestMemoryUsage,0)) as float)/(1024 * 1024 * 1024) as FLOAT(2)) as 'Guest Memory Used'
		, CAST( cast(ISNULL(X.vsVMResourceAllocHostMemoryUsage,ISNULL(I.vsVMResourceAllocHostMemoryUsage,0)) as float)/(1024 * 1024 * 1024) as FLOAT(2)) as 'Memory Used On Host'
FROM (SELECT * FROM #BkpDataTempTable B JOIN #vmPropJobDataRes R ON B.qclient = R.vmClientId AND b.bkpsubclientid = R.applicationId WHERE bType=1 AND R.type = 1) X full outer JOIN (SELECT * FROM #BkpDataTempTable B JOIN #vmPropJobDataRes R ON B.qclient = R.vmClientId AND b.bkpsubclientid = R.applicationId WHERE bType=2 AND R.type =2) I ON X.qClient = I.qClient And X.applicationId = I.applicationId
ORDER BY 'VM Name', X.bkpSubClientId, X.bType
DROP TABLE #tempSizeOfVM
DROP TABLE #BkpStatsTempTable
DROP TABLE #BkpDataTempTable
DROP TABLE #vmPropJobDataRes
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_VMBackupSizes')
	delete from GxQscripts where name = 'QS_VMBackupSizes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_VMBackupSizes')
	delete from GXDBVersions where aliasname = 'QS_VMBackupSizes'
GO

insert into GXDBVersions values(2, 'QS_VMBackupSizes',  '00000000000000000000', 'QS_VMBackupSizes', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_VMBackupSizes',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_VMBackupSizes'
 + CHAR(10) + '--  -                    [-si @i_PbackupLevel = ''FULL'']'
 + CHAR(10) + '--  -                    [-si @i_PsubClientName = '''']'
 + CHAR(10) + '--  -                    [-si @i_PstartDate = ''yyyy-mm-dd'']'
 + CHAR(10) + '--  -                    [-si @i_PendDate = ''yyyy-mm-dd'']'
 + CHAR(10) + '--  -                    [-si @i_PincludeAgedJobs = ''0'']'
 + CHAR(10) + '--  -                    [-si @i_PincludeMediaDeleted = ''0'']'
 + CHAR(10) + '--  -                    [-si @i_PincludeSnapBkpJobs = ''0'']'
 + CHAR(10) + '--  -					[-si @i_PincludeSRMData	= ''0'']'
 + CHAR(10) + '--  - 					[-si @i_PoutputType = ''0'']'
 + CHAR(10) + '--  - '
 + CHAR(10) + '--  Options: @i_PbackupLevel		: ''FULL'', ''Incr'' or ''''.'
 + CHAR(10) + '-- 			@i_PoutPutType		: 0 ->show all the jobs data 1->show only the latest jobs data '
 + CHAR(10) + '--  Default: @i_PstartDate   = ''''. Default last 30 days jobs are considered.'
)
GO

