

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateNextEvent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateNextEvent <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateNextEvent')
	drop procedure QS_UpdateNextEvent
IF EXISTS (select * from GxQscripts where name='QS_UpdateNextEvent')
	delete from GxQscripts where name = 'QS_UpdateNextEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateNextEvent')
	delete from GXDBVersions where aliasname = 'QS_UpdateNextEvent'
GO
print '... Creating Procedure: QS_UpdateNextEvent'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateNextEvent
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @nextEvent varchar(1024) = '%s',
  @taskId varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @nextEvent	varchar(1024)
--SET		@nextEvent	= '%s'
--DECLARE @taskId	varchar(1024)
--SET		@taskId	= '%s'
---------------------------------------
--test
--SET		@nextEvent		= '2010-06-19 08:50:00.000'
--SET		@taskId	= '22'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'UpdateNextEvent'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET	@localErrorMsg			='Error Encountered when running script.'
----------------------- check inputs -----------------
IF @nextEvent	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Next schedule event Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @nextEvent < getdate()
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Next schedule event cannot be in the past.'
	GOTO ARGS_ERROR
END
IF @taskId	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule policy name Expected as parameter 2.'
	GOTO ARGS_ERROR
END
--------------SETP 1 ---------------------
BEGIN TRAN
	IF EXISTS(SELECT * FROM TM_AssocEntity WHERE taskId=@taskId )
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Schedule instance ['+CAST(@taskId AS VARCHAR(10))+'] has associations will not be modified'
		GOTO TRANS_EXIT
	END
	IF EXISTS(SELECT * FROM TM_Task WHERE taskType=4 AND taskId=@taskId)
	BEGIN
		UPDATE TM_RunTime SET nextRunTime=@nextEvent, nextTime=dbo.getunixtime(@nextEvent) WHERE patternId IN (
				SELECT patternId FROM TM_PatternAssoc WHERE subTaskId IN (
					SELECT subTaskId FROM TM_SubTask WHERE taskId = @taskId
				)
			) AND processed = 0 AND firing = 0
		UPDATE TM_RunTimeAssoc SET nextRunTime=@nextEvent WHERE runTimeId IN (
				SELECT runTimeId From TM_RunTime WHERE patternId IN (
					SELECT patternId FROM TM_PatternAssoc WHERE subTaskId IN (
						SELECT subTaskId FROM TM_SubTask WHERE taskId = @taskId
					)
				) AND processed = 0 AND firing = 0
			) AND processed = 0 AND firing = 0
	END
	ELSE
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. No schedule template found for schedule policy instance ['+CAST(@taskId AS VARCHAR(10))+']'
		GOTO TRANS_EXIT
	END
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@nextEvent+', '+CAST(@taskId AS VARCHAR(10))+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateNextEvent')
	delete from GxQscripts where name = 'QS_UpdateNextEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateNextEvent')
	delete from GXDBVersions where aliasname = 'QS_UpdateNextEvent'
GO

insert into GXDBVersions values(2, 'QS_UpdateNextEvent',  '00000000000000000000', 'QS_UpdateNextEvent', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_UpdateNextEvent',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn UpdateNextEvent.sql -si nextEvent -si task id
'
 + CHAR(10) + '--   script_name : UpdateNextEvent'
)
GO

