

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateMongoConnectionString.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_UpdateMongoConnectionString')
BEGIN
	print '>>> Drop Stored Procedure: QS_UpdateMongoConnectionString <<<'
	drop procedure QS_UpdateMongoConnectionString
END
IF EXISTS (select * from GxQscripts where name='QS_UpdateMongoConnectionString')
	delete from GxQscripts where name = 'QS_UpdateMongoConnectionString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateMongoConnectionString')
	delete from GXDBVersions where aliasname = 'QS_UpdateMongoConnectionString'
GO
print '... Creating Procedure: QS_UpdateMongoConnectionString'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_UpdateMongoConnectionString
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @clientName nvarchar(1024)
AS
DECLARE @errorCode int = 0
DECLARE @errorString nvarchar(1024) = ''
DECLARE @scriptName nvarchar(1024) = 'QS_UpdateMongoConnectionString'
DECLARE @clientId int = 0
DECLARE @nowTime2		INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER   			 --
-------------------------------------------
BEGIN TRY
	SELECT @clientId = id from App_Client (NOLOCK) WHERE name = @clientName
	IF(@clientId = 0)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Client name [' + @clientName + '] is not valid'
	END
ELSE IF NOT EXISTS(SELECT 1 FROM SimInstalledPackages (NOLOCK) WHERE simPackageID IN (952, 1604) and clientId=@clientId)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Client [' + @clientName + '] does not have Mongo DB package installed'
	END
	ELSE
	BEGIN
		BEGIN TRAN
		UPDATE APP_ClientProp
		SET attrVal = App_Client.net_hostName
		FROM App_clientProp INNER JOIN App_Client
		ON App_clientProp.componentNameID = App_Client.Id
		where attrName = 'Mongo DB Instance'
		AND componentNameId = @clientId
		AND App_clientProp.modified = 0
		COMMIT TRAN
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER ()
	SET @errorstring = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
	IF(XACT_STATE() <> 0)
	BEGIN
		ROLLBACK TRAN
	END
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	if @errorCode <> 0
		Raiserror(@errorString,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	ELSE
	BEGIN
		PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: [Client Name:'+ @clientName + ',Client Id: '+CONVERT(NVARCHAR(8),@clientId)+' ]. Exit Code(' +convert(varchar(2), @ErrorCode) + ' ' + @errorString + ').'
	END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateMongoConnectionString')
	delete from GxQscripts where name = 'QS_UpdateMongoConnectionString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateMongoConnectionString')
	delete from GXDBVersions where aliasname = 'QS_UpdateMongoConnectionString'
GO

insert into GXDBVersions values(2, 'QS_UpdateMongoConnectionString',  '00000000000000000000', 'QS_UpdateMongoConnectionString', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_UpdateMongoConnectionString',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn UpdateMongoConnectionString -si clientName
'
)
GO

