

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateCommcellHostName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_UpdateCommcellHostName.sp,v $ $Id: QS_UpdateCommcellHostName.sp,v 1.3.34.2 2018/03/27 08:02:30 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateCommcellHostName <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateCommcellHostName')
	drop procedure QS_UpdateCommcellHostName
IF EXISTS (select * from GxQscripts where name='QS_UpdateCommcellHostName')
	delete from GxQscripts where name = 'QS_UpdateCommcellHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateCommcellHostName')
	delete from GXDBVersions where aliasname = 'QS_UpdateCommcellHostName'
GO
print '... Creating Procedure: QS_UpdateCommcellHostName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_UpdateCommcellHostName
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
  @PARAM_01 varchar(1024) = '%s',		-- Commcell Id
  @PARAM_02 varchar(1024) = '%s'		-- New Host Name/ IP
AS
-------------------------------------------
--         Name:   UpdateCommcellHostName
--         Date:   21-Jul-2014
--       Author:   BKharabe
--  Description:   Update CCHostName in App_CommcellInfo for external commcell, if the current hostname/ip is not accessible
--   CommcellId:   N/A (Generic Script)
-------------------------------------------
-------------------------------------------
-- CANNOT DO THE FOLLOWING IN A STORED PROCEDURE!  (MAKE SURE TO COMMENT OUT WHEN COPYING TEXT!)
--use commserv
--SET ANSI_PADDING ON
--GO
--SET ARITHABORT ON
--GO
--SET QUOTED_IDENTIFIER ON
--GO
--Set NOCOUNT ON
-- Stored Procedure Inputs
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'UpdateCommcellHostName'
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @commcellId int
DECLARE @commcellNumber int
DECLARE @lastError			integer
DECLARE @localErrorMsg		varchar(512)
SET		@localErrorMsg		='Error Encountered when running script.'
SET     @lastError				= 0		-- Be optimistic
SET		@commcellNumber			= 0
SET		@commcellId			= 0
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
BEGIN TRY
	SET		@commcellNumber			= dbo.ConvertHexToInt(@PARAM_01)
END   TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET		@commcellNumber			= 0
END CATCH
IF @commcellNumber <= 0 OR LOWER(@PARAM_02) = 'ffffffff'
BEGIN
	SET @localErrorMsg	='Error. Invalid commcell id specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @PARAM_02 = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Invalid parameters.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
BEGIN TRY
	SET @commcellId = ISNULL((Select id from APP_CommCell where number = @commcellNumber), 0)
	IF @commcellId = 0
	BEGIN
		SET @localErrorMsg	='Error. Commcell id [' + @PARAM_01 + '] not found.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END   TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	Set @lastError      = ERROR_NUMBER()
	SET @localErrorMsg  = ERROR_MESSAGE()
	goto   ARGS_ERROR
END	  CATCH
IF @commcellId = 2
BEGIN
	SET @localErrorMsg	='Error. Attempting to update current commcell which is not a supported operation.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: commcellid = ['
         + @PARAM_01
         + '], host name/IP = ['
         + @PARAM_02
         + '].'
begin tran
BEGIN TRY
	UPDATE APP_CommCellInfo SET CCHostName = @PARAM_02 where commcellId = @commcellId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END   CATCH
ABORT:
IF @lastError  = 0
	COMMIT  Tran
ELSE
	ROLLBACK Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameter: commcellid = ['
         + @PARAM_01
		 + '], host name/IP ['
         + @PARAM_02
         + ']. Exit Code(' +convert(varchar(8), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateCommcellHostName')
	delete from GxQscripts where name = 'QS_UpdateCommcellHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateCommcellHostName')
	delete from GXDBVersions where aliasname = 'QS_UpdateCommcellHostName'
GO

insert into GXDBVersions values(2, 'QS_UpdateCommcellHostName',  '00010003003400020000', 'QS_UpdateCommcellHostName', '00010003003400020000')
GO

insert into GxQscripts values(2,'QS_UpdateCommcellHostName',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn  UpdateCommcellHostName -si <Hexadecimal commcellid>  -si <new host name/IP>'
)
GO

