

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateClientRelease.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Prakash Bhukar
--	Date:   3/29/2016
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_UpdateClientRelease.sp,v $ $Id: QS_UpdateClientRelease.sp,v 1.1.2.4 2017/03/31 03:56:07 ylu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateClientRelease <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateClientRelease')
	drop procedure QS_UpdateClientRelease
IF EXISTS (select * from GxQscripts where name='QS_UpdateClientRelease')
	delete from GxQscripts where name = 'QS_UpdateClientRelease'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateClientRelease')
	delete from GXDBVersions where aliasname = 'QS_UpdateClientRelease'
GO
print '... Creating Procedure: QS_UpdateClientRelease'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateClientRelease
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @in_clientName NVARCHAR(128),
  @in_releaseNum NVARCHAR(64),
  @in_authCode NVARCHAR(1024)
AS
SET NOCOUNT ON
-------------------------------------------
DECLARE @RegCode     		NVARCHAR(64) = N''
DECLARE @DBRegCode     		NVARCHAR(64) = N''
DECLARE @CsGuid     		NVARCHAR(64) = N''
DECLARE @ErrorNumber        INTEGER = 0
DECLARE @ErrorMessage       NVARCHAR(MAX) = N''
DECLARE @ScriptName         VARCHAR(32) = 'QS_UpdateClientRelease'
DECLARE @ClientId		INT = 0
DECLARE @ReleaseId      INTEGER = 0
DECLARE @ReleaseStr		VARCHAR(32) = N''
DECLARE @BuildStr		VARCHAR(32) = N''
DECLARE @BuildStr1		VARCHAR(32) = N''
DECLARE @Id				INT = 0
DECLARE @EncFld			VARCHAR(MAX) = N''
DECLARE @rawData 		varchar(max)
DECLARE @STR_DASH 		varchar(10) =':-'
DECLARE @len 			INT = 0
IF @in_clientName = N'' OR @in_releaseNum = N'' OR @in_authCode = N''
BEGIN
    SET @ErrorMessage = N'Empty input parametrs passed. Usage: qoperation execscript -sn QS_UpdateClientRelease -si clientName -si releaseNum -si authCode'
    SET @ErrorNumber = 2
    GOTO    QS_ERROR
END
SELECT @CsGuid = ISNULL(csGUID,'') FROM APP_CommCell WHERE id = 2
EXEC miscProc2 @in_authCode, @RegCode OUTPUT
SELECT @DBRegCode = RegNo FROM dbo.GetSNoRegCode(@CsGuid)
IF @RegCode <> @DBRegCode
BEGIN
	SET @ErrorMessage = N'Wrong Authorization code passed [' + @in_authCode + '].'
	SET @ErrorNumber = 3
	GOTO    QS_ERROR
END
SELECT @ReleaseId = id from simAllGalaxyRel WHERE release = @in_releaseNum
SELECT @ClientId = id from app_client where Name = @in_clientName
IF @ClientId = 0
BEGIN
	SET @ErrorMessage = N'Invalid client name passed [' + @in_clientName + '].'
	SET @ErrorNumber = 3
	GOTO    QS_ERROR
END
SELECT @len = CHARINDEX('.',@in_releaseNum)
SELECT @ReleaseStr = CASE
					WHEN @len > 0 THEN SUBSTRING(@in_releaseNum,0,@len)
					ELSE @in_releaseNum
					END
SET @BuildStr1 = CASE @ReleaseId
				WHEN 13 THEN 'BUILD68'
				WHEN 14 THEN 'BUILD84'
				WHEN 15 THEN 'BUILD116'
				WHEN 16 THEN 'BUILD80'
				ELSE ''
				END
IF @BuildStr1 = N''
BEGIN
	SET @ErrorMessage = N'Release [' + @in_releaseNum + '] Is Not Supported.'
	SET @ErrorNumber = 3
	GOTO    QS_ERROR
END
SET @BuildStr = '('+@BuildStr1+')'
IF EXISTS( SELECT * FROM LicUsage WHERE CID = @ClientId AND ReleaseId <> @ReleaseId)
BEGIN
	DECLARE db_cursor CURSOR FOR
	SELECT id
	FROM LicUsage
	WHERE CID = @ClientId AND LicType not in (10,26,71)
	OPEN db_cursor
	FETCH NEXT FROM db_cursor INTO @Id
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @rawData = (
        SELECT  name  + @STR_DASH +
				CAST(cid AS VARCHAR(64)) + @STR_DASH +
				CAST(LicType AS VARCHAR(64)) + @STR_DASH +
				CAST(AppType AS VARCHAR(64)) + @STR_DASH +
				LTRIM(RTRIM(OpType))  + @STR_DASH +
				CAST(dbo.GetUnixTime(OpTimeUTC) AS VARCHAR(64)) + @STR_DASH +
				CAST(TokensUsed AS VARCHAR(64)) + @STR_DASH +
				CAST(Eval AS VARCHAR(64)) + @STR_DASH +
				CAST(dbo.GetUnixTime(ExpiryDateUTC) AS VARCHAR(64)) + @STR_DASH +
				CAST(@ReleaseId AS VARCHAR(64)) + @STR_DASH +
				CAST(SimOSID AS VARCHAR(64)) + @STR_DASH +
				'0'+@BuildStr + @STR_DASH +
				CAST(InstallFlag AS VARCHAR(64))
        FROM licusage (NOLOCK) WHERE id = @id)
        EXEC pswEncryptionManaged @rawData, @EncFld OUTPUT
        IF (@EncFld IS NULL or LEN(@EncFld) = 0)
            BEGIN
                SET @ErrorNumber = 1
                SET @ErrorMessage  ='Failure in updating license record ' + CAST(@id   AS varchar(64) )
                GOTO  QS_ERROR
            END
        ELSE
		BEGIN
		   UPDATE LicUsage
		   SET EncryptedField = @EncFld, ReleaseId = @ReleaseId, Build = '0'+@BuildStr
		   WHERE id = @Id
		END
		FETCH NEXT FROM db_cursor INTO @Id
	END
	CLOSE db_cursor
	DEALLOCATE db_cursor
END
IF EXISTS( SELECT * FROM app_client WHERE id = @ClientId AND releaseId <> @ReleaseId)
	UPDATE app_client SET releaseId = @ReleaseId WHERE id = @ClientId
IF EXISTS( SELECT * FROM APP_ClientProp WHERE componentNameId = @ClientId )
BEGIN
	UPDATE APP_ClientProp SET attrVal = @BuildStr1 where componentNameId = @ClientId AND attrName = 'Galaxy Build' AND modified = 0
	UPDATE APP_ClientProp SET attrVal = @ReleaseStr where componentNameId = @ClientId AND attrName = 'SP Version Info' AND modified = 0
	UPDATE APP_ClientProp SET attrVal = '' where componentNameId = @ClientId AND attrName = 'SP Version and Patch Info' AND modified = 0
	IF CAST(@ReleaseStr AS INT) < 10
		SET @ReleaseStr = @ReleaseStr+'.0.0'
	UPDATE APP_ClientProp SET attrVal = @ReleaseStr + @BuildStr where componentNameId = @ClientId AND attrName = 'Client Version' AND modified = 0
END
QS_ERROR:
    IF @ErrorNumber = 0
        PRINT @scriptName + ' completed successfully at '   + CONVERT(VARCHAR(60), GETDATE())+' For client [' +@in_clientName+'].'
    ELSE
    BEGIN
        PRINT @scriptName + ' completed with errors at '    + CONVERT(VARCHAR(60), GETDATE())+'. Error [' + CONVERT(VARCHAR(10), @ErrorNumber) + ':' + @ErrorMessage + '].'
        IF @ErrorNumber <> 0
            Raiserror(@ErrorMessage,
                        15,  --Severity (> 10 to force DOS Error Code = 1)
                        1    --State
                        )
    END
GO
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateClientRelease')
	delete from GxQscripts where name = 'QS_UpdateClientRelease'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateClientRelease')
	delete from GXDBVersions where aliasname = 'QS_UpdateClientRelease'
GO

insert into GXDBVersions values(2, 'QS_UpdateClientRelease',  '00010001000200040000', 'QS_UpdateClientRelease', '00010001000200040000')
GO

insert into GxQscripts values(2,'QS_UpdateClientRelease',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '        qoperation execscript -sn QS_UpdateClientRelease -si clientName -si releaseNum -si authCode
'
 + CHAR(10) + '--       clientName 	- client name.'
 + CHAR(10) + '--       releaseNum 	- new release to be updated.'
 + CHAR(10) + '--       authCode 	- authcode for validation.'
)
GO

