

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateClientDestinationGUID.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateClientDestinationGUID <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateClientDestinationGUID')
	drop procedure QS_UpdateClientDestinationGUID
IF EXISTS (select * from GxQscripts where name='QS_UpdateClientDestinationGUID')
	delete from GxQscripts where name = 'QS_UpdateClientDestinationGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateClientDestinationGUID')
	delete from GXDBVersions where aliasname = 'QS_UpdateClientDestinationGUID'
GO
print '... Creating Procedure: QS_UpdateClientDestinationGUID'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_UpdateClientDestinationGUID
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
  @PARAM_01 varchar(1024) = '%s',		-- Client Name
  @PARAM_02 varchar(1024) = '%s',		-- Original GUID
  @PARAM_03 varchar(1024) = '%s'			-- New QUID
AS
-------------------------------------------
--         Name:   UpdateClientDestinationGUID
--         Date:   23-Jan-2011
--       Author:   SKatz
--  Description:   Update the Destination GUIDs
-- TR(original):   110119-000714
--     Customer:   Dow Kokam
--   CommcellId:   N/A (Generic Script)
-------------------------------------------
-------------------------------------------
-- CANNOT DO THE FOLLOWING IN A STORED PROCEDURE!  (MAKE SURE TO COMMENT OUT WHEN COPYING TEXT!)
--use commserv
--SET ANSI_PADDING ON
--GO
--SET ARITHABORT ON
--GO
--SET QUOTED_IDENTIFIER ON
--GO
--Set NOCOUNT ON
-- Stored Procedure Inputs
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'UpdateClientDestinationGUID'
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
DECLARE @ATTR_DESTHOST			nvarchar(256)
SET		@ATTR_DESTHOST			=N'FLR Destination Hostid'
-------- Local Variables    -------------
DECLARE @clientId			integer
DECLARE @lastError			integer
DECLARE @localErrorMsg		varchar(512)
SET		@localErrorMsg		='Error Encountered when running script.'
SET     @lastError			= 0		-- Be optimistic
SET		@clientId			= 0
DECLARE @nowTime        	integer
SET     @nowTime        = dbo.GetUnixTime (GetUTCdate())
DECLARE	@rowCount		integer
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF @PARAM_03 = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Invalid parameters.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
BEGIN TRY
	SET @clientId = ISNULL((Select id from app_client where name = @PARAM_01), 0)
	IF @clientId = 0
	BEGIN
		SET @localErrorMsg	='Error. Invalid Client Name [' + @PARAM_01 + '].'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END   TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	Set @lastError      = ERROR_NUMBER()
	SET @localErrorMsg  = ERROR_MESSAGE()
	goto   ARGS_ERROR
END	  CATCH
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: client = ['
         + @PARAM_01
         + '], Old Guid = ['
         + @PARAM_02
         + '], New Guid = ['
         + @PARAM_03
         + '].'
------------------------------------------------
-- DO THE WORK (LOOP FOR ALL SUBCLIENTS)!	----
------------------------------------------------
begin tran
BEGIN TRY
--	Select componentNameId from app_backupsetprop where attrName = @ATTR_DESTHOST AND attrVal = @clientId AND modified = 0
--	select * from app_screplicationPair
--		 where pairId in (select id from app_application
--						Where backupset in (Select componentNameId from app_backupsetprop
--										 where attrName = @ATTR_DESTHOST AND attrVal = @clientId AND modified = 0))
--	and propType=10008
	UPDATE APP_ScReplicationPair
	SET modified = @nowTime
	WHERE propType = 10008
	  AND MODIFIED = 0
--	  AND pairID in (select id from app_application where clientId = @clientId)
	  and pairId in (select id from app_application
						Where backupset in (Select componentNameId from app_backupsetprop
										 where attrName = @ATTR_DESTHOST AND attrVal = @clientId AND modified = 0))
	  AND stringVal = @PARAM_02
--	IF NO MATCHES FOUND, ALERT THE USER AND ABORT!
	SET @rowCount = @@rowcount
	IF @rowcount = 0
	BEGIN
		Set @lastError = 1
		set @localErrorMsg = 'No pairs with destination client['+@PARAM_01+'] and Destination GUID [' + @PARAM_02 + '] exists!'
		GOTO ABORT
	END
	INSERT APP_ScReplicationPair (pairId, propType, created, modified, intVal, stringVal)
		SELECT pairId, propType, @nowTime, 0, 0, @PARAM_03
		FROM APP_ScreplicationPair
		WHERE propType = 10008
		  AND MODIFIED = @nowTime
		  AND pairId in (select id from app_application
						Where backupset in (Select componentNameId from app_backupsetprop
										 where attrName = @ATTR_DESTHOST AND attrVal = @clientId AND modified = 0))
		  AND stringVal = @PARAM_02
--SELECT * from APP_ScReplicationPair
--WHERE modified = @nowtime or created = @nowTime
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END   CATCH
ABORT:
IF @lastError  = 0
	COMMIT  Tran
ELSE
	ROLLBACK Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameter: client = ['
         + @PARAM_01
		 + '], old GUID ['
         + @PARAM_02
		 + '], new GUID ['
         + @PARAM_03
         + ']. Exit Code(' +convert(varchar(8), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO
---- exec QS_UpdateClientDestinationGUID 'ida08', 'sdfsdfd', 'sdfsdfd'   --TEST

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateClientDestinationGUID')
	delete from GxQscripts where name = 'QS_UpdateClientDestinationGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateClientDestinationGUID')
	delete from GXDBVersions where aliasname = 'QS_UpdateClientDestinationGUID'
GO

insert into GXDBVersions values(2, 'QS_UpdateClientDestinationGUID',  '00000000000000000000', 'QS_UpdateClientDestinationGUID', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_UpdateClientDestinationGUID',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn  UpdateClientDestinationGUID -si <client name>  -si <original Dest GUID>  -si <new Dest GUID> '
)
GO

