

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateCIProxyClient.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateCIProxyClient <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateCIProxyClient')
	drop procedure QS_UpdateCIProxyClient
IF EXISTS (select * from GxQscripts where name='QS_UpdateCIProxyClient')
	delete from GxQscripts where name = 'QS_UpdateCIProxyClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateCIProxyClient')
	delete from GXDBVersions where aliasname = 'QS_UpdateCIProxyClient'
GO
print '... Creating Procedure: QS_UpdateCIProxyClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateCIProxyClient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_ciClientName nvarchar(2048) = N'',
  @i_fsClientName nvarchar(2048) = N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_UpdateCIProxyClient'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
-----------------------invalid parameters------------------------------
IF(@i_ciClientName = @NoParameter OR @i_fsClientName = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of client---------------------
DECLARE @ciClientId INT = 0
DECLARE @fsClientId INT = 0
SET @ciClientId = ISNULL((SELECT id FROM APP_Client WHERE name = @i_ciClientName), 0)
IF @ciClientId = 0
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid CI client name [' + @i_ciClientName + '] specified.'
	GOTO SCRIPT_EXIT
END
SET @fsClientId = ISNULL((SELECT id FROM APP_Client WHERE name = @i_fsClientName), 0)
IF @fsClientId = 0
BEGIN
	SET @errorCode = 3
	SET @errorString = 'Error. Invalid proxy client name [' + @i_fsClientName + '] specified.'
	GOTO SCRIPT_EXIT
END
-----------------Insert/Update "Proxy Filesystem Client Id" into APP_ClientProp table--------------
DECLARE @nowtime as int
SET @nowtime = dbo.GetUnixTime (GetUTCDate())
DECLARE @PROXY_FILESYSTEM_CLIENT_ID VARCHAR(100) = 'Proxy Filesystem Client Id'
--If this property already exists, then update it--
IF EXISTS (SELECT *
			FROM APP_ClientProp
			WHERE componentNameId = @ciClientId AND attrName = @PROXY_FILESYSTEM_CLIENT_ID AND modified = 0)
BEGIN
		UPDATE APP_ClientProp
		SET attrval = @fsClientId
		WHERE componentNameId = @ciClientId and attrName = @PROXY_FILESYSTEM_CLIENT_ID and modified = 0
END
ELSE
BEGIN
	INSERT APP_ClientProp(componentNameId , attrName, attrtype, attrVal, created , modified , ccpId )
		VALUES (@ciClientId, @PROXY_FILESYSTEM_CLIENT_ID, 2, @fsClientId, @nowtime, 0, 0)
END
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@i_ciClientName + ', '+@i_fsClientName
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateCIProxyClient')
	delete from GxQscripts where name = 'QS_UpdateCIProxyClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateCIProxyClient')
	delete from GXDBVersions where aliasname = 'QS_UpdateCIProxyClient'
GO

insert into GXDBVersions values(2, 'QS_UpdateCIProxyClient',  '00000000000000000000', 'QS_UpdateCIProxyClient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_UpdateCIProxyClient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_UpdateCIProxyClient.sql -si ''ciClientName'' -si ''proxyClientName''
'
 + CHAR(10) + '-- 	script_name: QS_UpdateCIProxyClient'
 + CHAR(10) + '-- 	 Script to set proxy client for CI client'
 + CHAR(10) + '-- 	clientName - Name of the Client for which need to set the proxy'
 + CHAR(10) + '-- 	proxyClientName - proxy client name'
)
GO

