

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateBarcodeRange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_UpdateBarcodeRange')
BEGIN
	print '>>> Drop Stored Procedure: QS_UpdateBarcodeRange <<<'
	drop procedure QS_UpdateBarcodeRange
END
IF EXISTS (select * from GxQscripts where name='QS_UpdateBarcodeRange')
	delete from GxQscripts where name = 'QS_UpdateBarcodeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateBarcodeRange')
	delete from GXDBVersions where aliasname = 'QS_UpdateBarcodeRange'
GO
print '... Creating Procedure: QS_UpdateBarcodeRange'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateBarcodeRange
-- Qscript is enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
--SP Input Params
  @libraryName VARCHAR(1024) = '%s',
  @opType VARCHAR(1024) = '%s',
  @oldbarcode VARCHAR(1024) = '%s',
  @newbarcode VARCHAR(1024) = '%s',
  @oldPrefix VARCHAR(1024) = '%s',
  @newPrefix VARCHAR(1024) = '%s',
  @oldSuffix VARCHAR(1024) = '%s',
  @newSuffix VARCHAR(1024) = '%s',
  @barcodeStart VARCHAR(1024) = '%s',
  @barcodeEnd VARCHAR(1024) = '%s',
  @existingPrefix VARCHAR(1024) = '%s',
  @existingSuffix VARCHAR(1024) = '%s'
AS
SET NOCOUNT ON
	/*Main Input variables*/
DECLARE @errorString VARCHAR(1024)
DECLARE @libraryId INT = NULL;
SET @errorString = '%s'
SET @libraryName = LTRIM(RTRIM(@libraryName))
SET @opType = LTRIM(RTRIM(@opType))
SET @oldbarcode = LTRIM(RTRIM(@oldbarcode))
SET @oldPrefix = LTRIM(RTRIM(@oldPrefix))
SET @newPrefix = LTRIM(RTRIM(@newPrefix))
SET @oldSuffix = LTRIM(RTRIM(@oldSuffix))
SET @newSuffix = LTRIM(RTRIM(@newSuffix))
SET @barcodeStart = LTRIM(RTRIM(@barcodeStart))
SET @barcodeEnd = LTRIM(RTRIM(@barcodeEnd))
SET @existingPrefix = LTRIM(RTRIM(@existingPrefix))
SET @existingSuffix = LTRIM(RTRIM(@existingSuffix))
--Check if the input params are provided
--Checking If Sufficient parameters are passed
IF (@libraryName = '%s')
BEGIN
		SET @errorString = 'Error: Provide library name or all_libraries keyword.
		Please refer to the readme file and try again.'
		GOTO SCRIPT_EXIT
END
ELSE IF (@libraryName = 'all_libraries')
BEGIN
	SET @libraryId = NULL;
END
ELSE
BEGIN
	SET @libraryId = (SELECT DISTINCT LibraryId from MMLibrary WHERE AliasName = @libraryName )
	IF(@libraryId IS NULL)
	BEGIN
		SET @errorString = 'Error: Given library does not exist in database. Please input a valid library name and try again.'
		GOTO SCRIPT_EXIT
	END
END
--Switching based on opType
IF (@opType = '%s')
BEGIN
	SET @errorString = 'Error: opType missing, please refer to the documentation and retry with necessary parameters.'
	GOTO SCRIPT_EXIT
END
ELSE IF (LOWER(@opType) = 'change barcode')
BEGIN
	IF (@oldbarcode = '%s' OR @newbarcode = '%s' OR LEN(@oldbarcode) < 1 OR LEN(@newbarcode) < 1)
	BEGIN
		SET @errorString = 'Error: change barcode requires newbarcode and oldbarcode, please refer to the documentation and retry with necessary parameters.'
		GOTO SCRIPT_EXIT
	END
	ELSE IF NOT EXISTS (SELECT TOP 1 1 FROM MMMedia WHERE BarCode = @oldbarcode AND (@libraryId IS NULL OR LibraryId = @libraryId))
	BEGIN
		SET @errorString = 'Error: Provide a valid old barcode.'
		GOTO SCRIPT_EXIT
	END
	ELSE IF EXISTS (SELECT TOP 1 1 FROM MMMedia WHERE BarCode = @newbarcode)
	BEGIN
		SET @errorString = 'Error: Provide a valid new barcode. New Barcode already exist'
		GOTO SCRIPT_EXIT
	END
	GOTO CHANGE_BARCODE
END
ELSE IF (LOWER(@opType) = 'change prefix')
BEGIN
	IF (@oldPrefix = '%s' OR @newPrefix = '%s' OR LEN(@oldPrefix) < 1 OR LEN(@newPrefix) < 1)
	BEGIN
		SET @errorString = 'Error: Provide Old And New Prefix Values, please refer to the documentation and retry with necessary parameters.'
		GOTO SCRIPT_EXIT
	END
	ELSE IF NOT EXISTS (SELECT TOP 1 1 FROM MMMedia WHERE BarCode LIKE @oldPrefix + '%' AND (@libraryId IS NULL OR LibraryId = @libraryId))
	BEGIN
		SET @errorString = 'Error: Provide a valid prefix.'
		GOTO SCRIPT_EXIT
	END
	GOTO CHANGE_PREFIX
END
ELSE IF (LOWER(@opType) = 'add prefix')
BEGIN
	IF (@newPrefix = '%s' OR LEN(@newPrefix) < 1)
	BEGIN
		SET @errorString = 'Error: Provide New Prefix Value
			Please refer to the documentation and retry with necessary parameters.'
		GOTO SCRIPT_EXIT
	END
	SET @oldPrefix = ''
	GOTO CHANGE_PREFIX
END
ELSE IF (LOWER(@opType) = 'change suffix')
BEGIN
	IF(@oldSuffix = '%s' OR @newSuffix = '%s' OR LEN(@oldSuffix) < 1 OR LEN(@newSuffix) < 1)
	BEGIN
		SET @errorString = 'Error: Provide Old And New Suffix Values
		 Please refer to the documentation and retry with necessary parameters.'
		GOTO SCRIPT_EXIT
	END
	ELSE IF NOT EXISTS (SELECT TOP 1 1 FROM MMMedia WHERE BarCode LIKE '%' + @oldSuffix AND (@libraryId IS NULL OR LibraryId = @libraryId))
	BEGIN
		SET @errorString = 'Error: Provide a valid suffix.'
		GOTO SCRIPT_EXIT
	END
	GOTO CHANGE_SUFFIX
END
ELSE IF (LOWER(@opType) = 'add suffix')
BEGIN
	IF(@newSuffix = '%s' OR LEN(@newSuffix) < 1)
	BEGIN
		SET @errorString = 'Error: Provide New Suffix Value
		 Please refer to the documentation and retry with necessary parameters.'
		GOTO SCRIPT_EXIT
	END
	SET @oldSuffix = ''
	GOTO CHANGE_SUFFIX
END
ELSE --Range operations
BEGIN
	IF (@barcodeStart = '%s' OR @barcodeEnd = '%s' OR LEN(@barcodeStart) < 1 OR LEN(@barcodeEnd) < 1)
	BEGIN
		SET @errorString = 'Error: Provide Begin And End Barcodes
		Please refer to the documentation and retry with necessary parameters.'
		GOTO SCRIPT_EXIT
	END
	ELSE IF (NOT( LEN(@barcodeStart) = LEN(@barcodeEnd) ))
	BEGIN
		SET @errorString = 'Error: Begin and End Barcodes are not of equal length
		Please refer to the readme file and try again.'
		GOTO SCRIPT_EXIT
	END
	IF (LOWER(@opType) = 'change prefix by barcode range')
	BEGIN
		IF (@oldPrefix = '%s' OR @newPrefix = '%s' OR @existingSuffix = '%s' OR LEN(@oldPrefix) < 1 OR LEN(@newPrefix) < 1 OR LEN(@existingSuffix) < 1)
		BEGIN
			SET @errorString = 'Error: Provide Old, New and Existing Prefix Values
				Please refer to the documentation and retry with necessary parameters.'
			GOTO SCRIPT_EXIT
		END
		ELSE IF NOT EXISTS (
							SELECT TOP 1 1
							FROM MMMedia
							WHERE BarCode LIKE @oldPrefix+ '%'+@existingSuffix
								AND Barcode BETWEEN @barcodeStart AND @barcodeEnd
								AND (@libraryId IS NULL OR LibraryId = @libraryId)
							)
		BEGIN
			SET @errorString = 'Error: Provide a valid input.'
			GOTO SCRIPT_EXIT
		END
		GOTO CHANGE_PREFIX_BY_RANGE
	END
	ELSE IF (LOWER(@opType) = 'change suffix by barcode range')
	BEGIN
		IF(@oldSuffix = '%s' OR @newSuffix = '%s' OR @existingPrefix = '%s' OR LEN(@oldSuffix) < 1 OR LEN(@newSuffix) < 1 OR LEN(@existingPrefix) < 1)
		BEGIN
			SET @errorString = 'Error: Provide Old Suffix, New Suffix And Existing Prefix Values
			Please refer to the documentation and retry with necessary parameters.'
			GOTO SCRIPT_EXIT
		END
		ELSE IF NOT EXISTS (
							SELECT TOP 1 1
							FROM MMMedia
							WHERE BarCode LIKE (@existingPrefix+'%'+@oldSuffix)
								AND Barcode  BETWEEN @barcodeStart AND @barcodeEnd
								AND (@libraryId IS NULL OR LibraryId = @libraryId)
						)
		BEGIN
			SET @errorString = 'Error: Provide a valid input.'
			GOTO SCRIPT_EXIT
		END
		GOTO CHANGE_SUFFIX_BY_RANGE
	END
	ELSE IF (LOWER(@opType) = 'change barcode by range')
	BEGIN
		IF (@oldPrefix = '%s' OR @newPrefix = '%s' OR @oldSuffix = '%s' OR @newSuffix = '%s' OR LEN(@oldPrefix) < 1 OR LEN(@newPrefix) < 1 OR LEN(@oldSuffix) < 1 OR LEN(@newSuffix) < 1)
		BEGIN
			SET @errorString = 'Error: Provide old and new, prefix-suffix.
				Please refer to the documentation and retry with necessary parameters.'
			GOTO SCRIPT_EXIT
		END
		ELSE IF NOT EXISTS (
							SELECT *
							FROM MMMedia
							WHERE BarCode LIKE @oldPrefix+'%'+@oldSuffix
								AND Barcode BETWEEN @barcodeStart AND @barcodeEnd
								AND (@libraryId IS NULL OR LibraryId = @libraryId)
						)
		BEGIN
			SET @errorString = 'Error: Provide a valid input.'
			GOTO SCRIPT_EXIT
		END
		GOTO CHANGE_BARCODE_WITH_RANGE
	END
END
SET @errorString = 'Error: Invalid operation type
					Please refer to the documentation and retry with necessary parameters.'
GOTO SCRIPT_EXIT
CHANGE_BARCODE_WITH_RANGE:
		;with change_prefix_cte
		AS(
			SELECT MediaId, @newPrefix + RIGHT(BarCode, LEN(BarCode) - LEN(@oldPrefix)) as Barcode
			FROM MMMedia
			WHERE BarCode LIKE @oldPrefix+'%'+@oldSuffix
				AND Barcode BETWEEN @barcodeStart AND @barcodeEnd
				AND (@libraryId IS NULL OR LibraryId = @libraryId)
		),
		change_suffix_cte
		AS(
			SELECT MediaId, LEFT(BarCode, LEN(BarCode) - LEN(@oldSuffix))+ @newSuffix as Barcode
			FROM change_prefix_cte
		)
		UPDATE M
		SET M.BarCode = cte.Barcode
		FROM MMMedia M
			INNER JOIN change_suffix_cte cte ON M.MediaId = cte.MediaId
	GOTO SCRIPT_EXIT
CHANGE_BARCODE:
		UPDATE MMMedia
		SET BarCode = @newbarcode
		WHERE BarCode = @oldbarcode
			AND (@libraryId IS NULL OR LibraryId = @libraryId)
	GOTO SCRIPT_EXIT
/*Prefix changing code*/
CHANGE_PREFIX:
		UPDATE MMMedia
		SET BarCode = @newPrefix + RIGHT(BarCode, LEN(BarCode) - LEN(@oldPrefix))
		WHERE BarCode LIKE @oldPrefix+'%'
			AND (@libraryId IS NULL OR LibraryId = @libraryId)
	GOTO SCRIPT_EXIT
CHANGE_PREFIX_BY_RANGE:
		UPDATE MMMedia
		SET BarCode = @newPrefix + RIGHT(BarCode, LEN(BarCode) - LEN(@oldPrefix))
		WHERE BarCode LIKE @oldPrefix+ '%'+@existingSuffix
			AND Barcode BETWEEN @barcodeStart AND @barcodeEnd
			AND (@libraryId IS NULL OR LibraryId = @libraryId)
	GOTO SCRIPT_EXIT
/*Suffix changing code*/
CHANGE_SUFFIX:
		UPDATE MMMedia
		SET BarCode = LEFT(BarCode, LEN(BarCode) - LEN(@oldSuffix))+ @newSuffix
		WHERE BarCode LIKE '%'+@oldSuffix
			AND (@libraryId IS NULL OR LibraryId = @libraryId)
	GOTO SCRIPT_EXIT
CHANGE_SUFFIX_BY_RANGE:
		UPDATE MMMedia
		SET BarCode = LEFT(BarCode, LEN(BarCode) - LEN(@oldSuffix))+ @newSuffix
		WHERE BarCode LIKE (@existingPrefix+'%'+@oldSuffix)
			AND Barcode BETWEEN @barcodeStart AND @barcodeEnd
			AND (@libraryId IS NULL OR LibraryId = @libraryId)
	GOTO SCRIPT_EXIT
SCRIPT_EXIT:
	IF(@errorString <> '%s')
	BEGIN
		RAISERROR(@errorString,16,1)
	END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateBarcodeRange')
	delete from GxQscripts where name = 'QS_UpdateBarcodeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateBarcodeRange')
	delete from GXDBVersions where aliasname = 'QS_UpdateBarcodeRange'
GO

insert into GXDBVersions values(2, 'QS_UpdateBarcodeRange',  '00000000000000000000', 'QS_UpdateBarcodeRange', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_UpdateBarcodeRange',  4, GETDATE(), GETDATE(), '' + CHAR(10) + ' Script to update the barcodes in a specified range (change prefixes and/or suffixes or both), or to update only a single barcode. 
'
 + CHAR(10) + ' Usage:
'
 + CHAR(10) + ' To update only a single barcode
'
 + CHAR(10) + '--  qoperation execscript -sn QS_UpdateBarcodeRange -si @opType = ''Change Barcode'' -si @libraryName=''Name of the library'' -si @oldbarcode = ''Old barcode'' -si @newbarcode = ''New barcode'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To add prefix
'
 + CHAR(10) + '--  qoperation execscript -sn QS_UpdateBarcodeRange -si @opType = ''Add Prefix'' -si @libraryName= ''Name of the library'' -si @newPrefix = ''New prefix'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To update barcode by changing prefix of all tapes with a given prefix
'
 + CHAR(10) + '--  qoperation execscript -sn QS_UpdateBarcodeRange -si @opType = ''Change Prefix'' -si @libraryName= ''Name of the library'' -si @oldPrefix = ''Old prefix'' -si @newPrefix = ''New prefix'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To add suffix
'
 + CHAR(10) + '--  qoperation execscript -sn QS_UpdateBarcodeRange -si @opType = ''Add Suffix'' -si @libraryName=''Name of the library'' -si @newSuffix = ''New Suffix'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To update barcode by changing suffix of all tapes with a given suffix
'
 + CHAR(10) + '--  qoperation execscript -sn QS_UpdateBarcodeRange -si @opType = ''Change Suffix'' -si @libraryName=''Name of the library'' -si @oldSuffix = ''<Old suffix>'' -si @newSuffix = ''New Suffix'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To update a specified range of barcodes by changing prefix
'
 + CHAR(10) + '--  qoperation execscript -sn QS_UpdateBarcodeRange -si @opType = ''Change prefix by barcode range'' -si @libraryName=''Name of the library'' -si @barcodeStart = ''Starting range of the barcode'' -si @barcodeEnd = ''Ending range of the barcode'' -si @oldPrefix = ''Old prefix'' -si @newPrefix  = ''New Prefix'' -si @existingSuffix= ''Existing  suffix'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To update a specified range of barcodes by changing suffix
'
 + CHAR(10) + '--  qoperation execscript -sn QS_UpdateBarcodeRange -si @opType = ''Change suffix by barcode range'' -si @libraryName=''Name of the library'' -si @barcodeStart = ''Starting range of the barcode'' -si @barcodeEnd = ''Ending range of the barcode'' -si @oldSuffix = ''Old suffix'' -si @newSuffix  = ''New suffix'' -si @existingPrefix = ''Existing prefix'''
 + CHAR(10) + '
'
 + CHAR(10) + ' To update a specified range of barcodes by changing prefix and/or suffix
'
 + CHAR(10) + '--  qoperation execscript -sn QS_UpdateBarcodeRange -si @opType = ''Change barcode by range'' -si @libraryName=''Name of the library'' -si @barcodeStart = ''Starting range of the barcode'' -si @barcodeEnd = ''Ending range of the barcode'' -si @oldPrefix = ''Old prefix'' -si @newPrefix  = ''New Prefix'' -si @oldSuffix = ''Old suffix'' -si @newSuffix  = ''New suffix'''
 + CHAR(10) + '
'
 + CHAR(10) + ' Note:
'
 + CHAR(10) + '--  It is mandatory to provide a library name or the keyword all_libraries.'
)
GO

