

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateAnalyticsEngineCloudId.sp] ---------- 

SET ANSI_NULLS ON
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_UpdateAnalyticsEngineCloudId.sp,v $ $Id: QS_UpdateAnalyticsEngineCloudId.sp,v 1.1.2.5 2018/03/27 08:52:45 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateAnalyticsEngineCloudId <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateAnalyticsEngineCloudId')
	drop procedure QS_UpdateAnalyticsEngineCloudId
IF EXISTS (select * from GxQscripts where name='QS_UpdateAnalyticsEngineCloudId')
	delete from GxQscripts where name = 'QS_UpdateAnalyticsEngineCloudId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateAnalyticsEngineCloudId')
	delete from GXDBVersions where aliasname = 'QS_UpdateAnalyticsEngineCloudId'
GO
print '... Creating Procedure: QS_UpdateAnalyticsEngineCloudId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateAnalyticsEngineCloudId
--This script is used to update analytics cloudId from older to newer cloudId (eg. after index move operation)
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  4 Corresponds to "high", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
  @oldAnalyticsClientName nvarchar(1024) = N'',
  @newAnalyticsClientName nvarchar(1024) = N''		
AS
SET NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(64) = 'QS_UpdateAnalyticsEngineCloudId'
	DECLARE @localErrorCode	integer = 0
	DECLARE @localMsg		varchar(512) ='Successful.'
	DECLARE @NoParameter		varchar(4)
	SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
	SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
	declare @oldAnalyticsCloudId INT = 0
	declare @newAnalyticsCloudId INT = 0
	declare @oldAnalyticsClientId INT = 0
	declare @newAnalyticsClientId INT = 0
---------------Verify input ----------------
SET @oldAnalyticsClientId = ISNULL((SELECT TOP 1 ID FROM APP_CLIENT (NOLOCK) WHERE name = @oldAnalyticsClientName),0)
IF @oldAnalyticsClientId = 0
BEGIN
	SET @localMsg = @localMsg + N'Wrong old analytics client name [' + @oldAnalyticsClientName + '] is provided. Please provide correct analytics client name.'
	SET @localErrorCode = 1
	GOTO PROC_ERROR
END
SET @newAnalyticsClientId = ISNULL((SELECT TOP 1 ID FROM APP_CLIENT (NOLOCK) WHERE name = @newAnalyticsClientName),0)
IF @newAnalyticsClientId = 0
BEGIN
	SET @localMsg = @localMsg + N'Wrong new analytics client name  [' + @newAnalyticsClientName + '] is provided. Please provide correct analytics client name.'
	SET @localErrorCode = 2
	GOTO PROC_ERROR
END
SET @oldAnalyticsCloudId = ISNULL((SELECT TOP 1 CloudId FROM DM2SearchServerCoreInfo (NOLOCK) WHERE ClientId = @oldAnalyticsClientId AND CloudId IN (SELECT CloudId FROM DM2CLOUDCOREROLE (NOLOCK))),0)
IF @oldAnalyticsCloudId = 0
BEGIN
	SET @localMsg =@localMsg + N'Analytics engine is not configured on client [' + @oldAnalyticsClientName +']'
	SET @localErrorCode = 3
	GOTO PROC_ERROR
END
SET @newAnalyticsCloudId = ISNULL((SELECT TOP 1 CLOUDID FROM DM2SearchServerCoreInfo (NOLOCK) WHERE CLIENTID = @newAnalyticsClientId AND CloudId IN (SELECT CloudId FROM DM2CLOUDCOREROLE (NOLOCK))),0)
IF @newAnalyticsCloudId = 0
BEGIN
	SET @localMsg = @localMsg + N'Analytics engine is not configured on client [' + @newAnalyticsClientName +']'
	SET @localErrorCode = 4
	GOTO PROC_ERROR
END
--------------------- perform cloudId operation  -------------
BEGIN TRY
BEGIN TRAN
	UPDATE archFLAIndexingInfo
	SET cloudId = @newAnalyticsCloudId
	WHERE cloudId = @oldAnalyticsCloudId
	UPDATE archFLAIndexingRestart
	SET cloudId = @newAnalyticsCloudId
	WHERE cloudId = @oldAnalyticsCloudId
	UPDATE archFLAIndexingAged
	SET cloudId = @newAnalyticsCloudId
	WHERE cloudId = @oldAnalyticsCloudId
	UPDATE APP_ClientProp
	SET attrVal = @newAnalyticsCloudId
	WHERE attrName = 'AnalyticsCloudId' AND attrVal = @oldAnalyticsCloudId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @localErrorCode = ERROR_NUMBER()
	SELECT @localMsg = @localMsg + 'Failed with error: ' + ERROR_MESSAGE()
	IF (@@TRANCOUNT > 0)
		ROLLBACK TRAN
	goto PROC_ERROR
END CATCH
IF (@@TRANCOUNT > 0)
	COMMIT TRAN
PROC_ERROR:
PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'old analytics client ['+ @oldAnalyticsClientName + '], '
					+ 'new analytics client ['+ @newAnalyticsClientName + ']. '
					+ @localMsg
					+ ' ErrorCode (' + Convert(varchar(2),@localErrorCode) +').'
IF @localErrorCode > 0
BEGIN
	Raiserror(@localMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateAnalyticsEngineCloudId')
	delete from GxQscripts where name = 'QS_UpdateAnalyticsEngineCloudId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateAnalyticsEngineCloudId')
	delete from GXDBVersions where aliasname = 'QS_UpdateAnalyticsEngineCloudId'
GO

insert into GXDBVersions values(2, 'QS_UpdateAnalyticsEngineCloudId',  '00010001000200050000', 'QS_UpdateAnalyticsEngineCloudId', '00010001000200050000')
GO

insert into GxQscripts values(2,'QS_UpdateAnalyticsEngineCloudId',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn QS_UpdateAnalyticsEngineCloudId -si oldAnalyticsClientName -si newAnalyticsClientName'
 + CHAR(10) + '-- 		This script is used to update analytics cloudId from older to newer cloudId (eg. after index move operation)'
 + CHAR(10) + '-- 		oldAnalyticsClientName : client name of the older analytics engine'
 + CHAR(10) + '-- 		newAnalyticsClientName : client name of the newer analytics engine'
)
GO

