

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateActiveMqPort.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateActiveMqPort <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateActiveMqPort')
	drop procedure QS_UpdateActiveMqPort
IF EXISTS (select * from GxQscripts where name='QS_UpdateActiveMqPort')
	delete from GxQscripts where name = 'QS_UpdateActiveMqPort'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateActiveMqPort')
	delete from GXDBVersions where aliasname = 'QS_UpdateActiveMqPort'
GO
print '... Creating Procedure: QS_UpdateActiveMqPort'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_UpdateActiveMqPort
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @clientName nvarchar(1024),
  @tcpPort int = 0,
  @AMQPPort int = 0,
  @MQTTPort int = 0,
  @StompPort int = 0,
  @WSPort int = 0,
  @webconsolePort int = 0
AS
DECLARE @clientConnections Table(clientId int, connectionString XML) -- Need a new table with XML column as modify operation will not work on Nvarchar
DECLARE @errorCode int
DECLARE @errorString nvarchar(1024)
DECLARE @scriptName nvarchar(1024) = 'QS_UpdateActiveMqPort'
DECLARE @clientId int = 0
DECLARE @nowTime2		INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER   			 --
-------------------------------------------
BEGIN TRY
	SELECT @clientId = id from App_Client where name = @clientName
	IF(@clientId <> 0)
	BEGIN
		INSERT INTO @clientConnections SELECT ComponentNameId, AttrVal from App_ClientProp with (nolock) where componentNameId = @clientId AND  attrName = 'Message Queue Config'
		-- Check if this is a virtual clientId of a cluster. If this is, update corresponding physical nodes as well.
		-- Cluster bit is not needed for SP9 as message queue is not supported on cluster yet.
		--IF EXISTS(SELECT 1 FROM APP_VMToPMMap WHERE VMClientId = @clientId)
		--BEGIN
			--INSERT INTO @clientConnections SELECT PMClientId, attrVal FROM APP_VMToPMMap V JOIN App_ClientProp C ON C.ComponentNameId = V.PMClientId  WHERE VMClientId = @clientId AND C.attrName = 'Message Queue Config'
		--END
		IF @tcpPort <> 0
		BEGIN
			UPDATE @clientConnections SET connectionString.modify('replace value of (CVInstallManager_MessageQueue/@messagequeueTCPPort)[1] with sql:variable("@tcpPort")')
		END
		IF @AMQPPort <> 0
		BEGIN
			UPDATE @clientConnections SET connectionString.modify('replace value of (CVInstallManager_MessageQueue/@messagequeueAMQPPort)[1] with sql:variable("@AMQPPort")')
		END
		IF @MQTTPort <> 0
		BEGIN
			UPDATE @clientConnections SET connectionString.modify('replace value of (CVInstallManager_MessageQueue/@messagequeueMQTTPort)[1] with sql:variable("@MQTTPort")')
		END
		IF @StompPort <> 0
		BEGIN
			UPDATE @clientConnections SET connectionString.modify('replace value of (CVInstallManager_MessageQueue/@messagequeueStompPort)[1] with sql:variable("@StompPort")')
		END
		IF @webconsolePort <> 0
		BEGIN
			UPDATE @clientConnections SET connectionString.modify('replace value of (CVInstallManager_MessageQueue/@messagequeueWebconsolePort)[1] with sql:variable("@webconsolePort")')
		END
		IF @WSPort <> 0
		BEGIN
			UPDATE @clientConnections SET connectionString.modify('replace value of (CVInstallManager_MessageQueue/@messagequeueWSPort)[1] with sql:variable("@WSPort")')
		END
		UPDATE C SET attrVal = CONVERT(NVARCHAR(MAX), connectionString) from APP_ClientProp C join @clientConnections CC ON C.componentNameId = CC.clientId where C.attrName = 'Message Queue Config'
		insert into APP_WorkQueueRequest ([clientId],[remoteClient],[workToken],[workTokenParams],[createTime],[lastUpdateTime],[retryCount],[flag])
				select clientId, -1, 45,  CONVERT(NVARCHAR(MAX), connectionString) , @nowTime2,0,0,0 from @clientConnections
		--UPDATE A SET AttrVal.modify('replace value of (CVInstallManager_MessageQueue/@messagequeueTCPPort)[1] with sql:variable("@port")') FROM App_ClientProp A join @clients C ON A.componentNameId = C.clientId WHERE A.attrName = 'Message Queue Config'
	END
	ELSE
	BEGIN
		SET @errorString = 'Client name ' + @clientName + ' is not valid'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER ()
	SET @errorstring = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+ CONVERT(NVARCHAR(8),@clientId) + ',' + CONVERT(NVARCHAR(16), @tcpPort) + ',' + CONVERT(NVARCHAR(16), @AMQPPort) + ',' + CONVERT(NVARCHAR(16), @MQTTPort)+',' + CONVERT(NVARCHAR(16), @StompPort)+',' + CONVERT(NVARCHAR(16), @webconsolePort)+',' + CONVERT(NVARCHAR(16), @WSPort)+']. Exit Code(' +convert(varchar(2), @ErrorCode) + ' ' + @errorString + ').'
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateActiveMqPort')
	delete from GxQscripts where name = 'QS_UpdateActiveMqPort'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateActiveMqPort')
	delete from GXDBVersions where aliasname = 'QS_UpdateActiveMqPort'
GO

insert into GXDBVersions values(2, 'QS_UpdateActiveMqPort',  '00000000000000000000', 'QS_UpdateActiveMqPort', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_UpdateActiveMqPort',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn UpdateActiveMqPort -si @clientName -si @tcpPort -si @AMQPPort -si @MQTTPort -si @StompPort -si @WSPort -si @webconsolePort
'
)
GO

