

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UnPickJobsForCIForSps.sp] ---------- 

SET ANSI_NULLS ON
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_UnPickJobsForCIForSps.sp,v $ $Id: QS_UnPickJobsForCIForSps.sp,v 1.1.2.5 2019/10/11 16:34:18 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_UnPickJobsForCIForSps')
BEGIN
	print '>>> Drop Stored Procedure: QS_UnPickJobsForCIForSps <<<'
	drop procedure QS_UnPickJobsForCIForSps
END
IF EXISTS (select * from GxQscripts where name='QS_UnPickJobsForCIForSps')
	delete from GxQscripts where name = 'QS_UnPickJobsForCIForSps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UnPickJobsForCIForSps')
	delete from GXDBVersions where aliasname = 'QS_UnPickJobsForCIForSps'
GO
print '... Creating Procedure: QS_UnPickJobsForCIForSps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_UnPickJobsForCIForSps
--This script mark pick / partial CI jobs to Not Picked. Returns in output on what what jobs are affected and the number of rows updated in database.
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  4 Corresponds to "high", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
  @SPList nvarchar(max) = N''		
AS
SET NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(64) = 'QS_UnPickJobsForCIForSps'
	DECLARE @localErrorCode	integer = 0
	DECLARE @localMsg		varchar(512) ='Successful.'
	DECLARE @NoParameter		varchar(4)
	SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
	SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
	DECLARE @rowCount int = 0
	DECLARE @JOBSPicked VARCHAR(MAX)
-------------------------------------------------------------
IF (OBJECT_ID('tempdb.dbo.#archGroupList') IS NOT NULL) DROP TABLE #archGroupList
CREATE TABLE #archGroupList
(
	t_archGrpId INT
)
IF (OBJECT_ID('tempdb.dbo.#TArchFile') IS NOT NULL) DROP TABLE #TArchFile
CREATE TABLE #TArchFile
(
	t_ID INT,
	t_JobID INT,
	t_flags INT
)
-----------------------Get picked / PARTIAL jobs for CI for SP list-------------------
BEGIN TRY
BEGIN TRAN
IF ISNULL(@SPList, N'') = N'ALL'
BEGIN
	INSERT INTO #archGroupList (t_archGrpId)
	SELECT AG.id FROM archGroup AG
INNER JOIN archContentIndexingRules R  ON AG.id = R.archGroupId AND R.operationType = 1
	--	WHERE R.enabled =0
END
ELSE IF ISNULL(@SPList, N'') <> N''
BEGIN
	INSERT INTO #archGroupList (t_archGrpId)
	SELECT AG.id FROM archGroup AG
INNER JOIN archContentIndexingRules R  ON AG.id = R.archGroupId AND R.operationType = 1
	WHERE AG.name IN (SELECT Data FROM dbo.SplitString(@SPList, ','))
		--AND R.enabled =0
END
IF (SELECT COUNT(*) FROM #archGroupList) >0
BEGIN
		INSERT INTO #TArchFile (t_ID, t_JobId, t_flags)
		SELECT AF.id, AF.JOBID , AF.flags
		FROM archFile AF with (nolock)
		INNER JOIN  #archGroupList ON AF.archGroupId = t_archGrpId
WHERE (AF.Flags & (16 | 32) > 0) AND AF.fileType = 1 AND AF.isValid =1
END
ELSE
BEGIN
	SET @localMsg = 'Usage: Storage Policy must be equal to ALL OR the list of existing Storage policies Names (comma separated)  OR one existing Storage policy name on which Content Indexing is disabled as desired.'
	GOTO ERROR_EXIT
END
IF EXISTS (SELECT TOP 1 * FROM #TArchFile)
BEGIN
	--prune partial jobs
	INSERT INTO archContentIndexingAged (archFileId, commCellId, cloudId, appId, pruneType, agedFlag, operationType, jobId)
SELECT ID, commCellId, cloudId, appId, 1, 0, 1, AF.jobId
	FROM archFile AF WITH (NOLOCK)
		 INNER JOIN #TArchFile T ON T.t_ID = AF.ID
WHERE T.t_flags & 32 > 0
	--mark status as unpicked
	UPDATE archFile
SET Flags = (Flags & ~( 32| 16))
	FROM archFile AF INNER JOIN #TArchFile T ON T.t_ID = AF.ID
	IF (@@ERROR <> 0)
	BEGIN
		SET @localErrorCode = @@ERROR
		SET @localMsg = 'Failed to mark jobs as picked.'
		GOTO ERROR_EXIT
	END
	SET @rowCount = @@ROWCOUNT
	SELECT @JOBSPicked =  COALESCE( @JOBSPicked + ',', '') + CONVERT(VARCHAR(10),t_JOBID) FROM #TArchFile
	GROUP BY t_JOBID
	SET @localMsg = @localMsg + '. Jobs affected: ' + @JOBSPicked
END
ELSE
BEGIN
	SET @localMsg = 'No jobs found for the specified list of Storage Policy.'
	GOTO ERROR_EXIT
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @localErrorCode = ERROR_NUMBER()
	SELECT @localMsg = @scriptName + ' Failed with error: ' + ERROR_MESSAGE()
	goto PROC_ERROR
END CATCH
IF @rowCount > 0 AND @localErrorCode = 0
BEGIN
	SET @localMsg = @localMsg + '. Number of rows affected in database: ' + CONVERT(VARCHAR(10), @rowCount)
END
--SELECT @localMsg
ERROR_EXIT:
	IF @localErrorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'Storage Policies ['+ @SPList + ']. '
					+ @localMsg
					+ ' ErrorCode (' + Convert(varchar(2),@localErrorCode) +').'
	IF @localErrorCode > 0
	BEGIN
		Raiserror(@localMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
	END
IF OBJECT_ID('tempdb..#archGroupList') IS NOT NULL
	DROP TABLE #archGroupList
IF OBJECT_ID('tempdb..#TArchFile') IS NOT NULL
	DROP TABLE #TArchFile
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UnPickJobsForCIForSps')
	delete from GxQscripts where name = 'QS_UnPickJobsForCIForSps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UnPickJobsForCIForSps')
	delete from GXDBVersions where aliasname = 'QS_UnPickJobsForCIForSps'
GO

insert into GXDBVersions values(2, 'QS_UnPickJobsForCIForSps',  '00010001000200050000', 'QS_UnPickJobsForCIForSps', '00010001000200050000')
GO

insert into GxQscripts values(2,'QS_UnPickJobsForCIForSps',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '		qoperation execscript -sn QS_UnPickJobsForCIForSps -si ''SP1 Name,SP2 Name...|ALL''
'
 + CHAR(10) + '		SPNameList input must be either Comma separated list OR ALL.
'
 + CHAR(10) + '		Note: If jobs for All Storage policies need to be not picked for content indexing whose CI state is picked / partial, SPNameList parameter should be equal to ALL.
'
 + CHAR(10) + '		Note: Only PICKED AND PARTIAL jobs will be marked as Not Picked. Output returns what jobs are affected and number of rows updated in Database.
'
)
GO

