

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UnAgeJobsOnMedia.sp] ---------- 

--  +========================================================================+
--  |		 		Name:  QS_UnAgeJobsOnMedia()
--  | Description:  This SP is from Permanent QScript - UnAgeJobsOnMedia
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_UnAgeJobsOnMedia.sp,v $ $Id: QS_UnAgeJobsOnMedia.sp,v 1.8.48.3 2018/03/20 19:57:36 jiechen Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_UnAgeJobsOnMedia')
BEGIN
	print '>>> Drop Stored Procedure: QS_UnAgeJobsOnMedia <<<'
	drop procedure QS_UnAgeJobsOnMedia
END
IF EXISTS (select * from GxQscripts where name='QS_UnAgeJobsOnMedia')
	delete from GxQscripts where name = 'QS_UnAgeJobsOnMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UnAgeJobsOnMedia')
	delete from GXDBVersions where aliasname = 'QS_UnAgeJobsOnMedia'
GO
print '... Creating Procedure: QS_UnAgeJobsOnMedia'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_UnAgeJobsOnMedia
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_BarCode NVARCHAR(2048) = '',
  @i_Option VARCHAR(50) = '',
  @i_RetainUntil VARCHAR(10) = ''
AS
SET NOCOUNT ON
DECLARE @errorCode INTEGER
SET			@errorCode = 0
DECLARE @i_RetainUntilUnix BIGINT
DECLARE @l_commCellNumber  INTEGER
DECLARE @i_RetainUntilDays 	INTEGER
DECLARE @rowCnt INTEGER
SET @rowCnt = 0
DECLARE @i_MediaId INTEGER
SET			@i_MediaId = -1
DECLARE @CVA_UNAGED_JOB_FLAG INTEGER
SET			@CVA_UNAGED_JOB_FLAG = 1073741824
BEGIN TRANSACTION
	SELECT @l_commCellNumber = number
	FROM APP_CommCell
	WHERE id = 2
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF @i_Option <> 'RUN' AND @i_Option <> 'PRINT'
	BEGIN
			SET	@errorCode = -1
			GOTO CX_EXIT
	END
	IF @i_Option = 'RUN'
	BEGIN
		IF ISNUMERIC(@i_RetainUntil) = 1
		BEGIN
			SET	@i_RetainUntilDays = CAST(@i_RetainUntil AS INTEGER)
		END
		ELSE
	 	BEGIN
			SET	@errorCode = -6
			GOTO CX_EXIT
	 	END
 	END
--Code Below Here is From archUnageJobs.spb
		SELECT @i_MediaId = mediaId
		FROM MMMedia WITH (NOLOCK)
		WHERE barcode = @i_BarCode
		AND		mediaTypeId <> 10001
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF @i_MediaId = -1
	BEGIN
		SET	@errorCode = -4
		GOTO CX_EXIT
	END
		IF @i_RetainUntilDays < 0
			SET @i_RetainUntilUnix = -1
		ELSE
			SET @i_RetainUntilUnix = dbo.GetUnixTime(GETUTCDATE()) + CAST(@i_RetainUntilDays AS BIGINT) * 24 * 3600
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	IF OBJECT_ID('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
	IF OBJECT_ID('tempdb.dbo.#tempJob') IS NOT NULL DROP TABLE #tempJob
	IF OBJECT_ID('tempdb.dbo.#tempAFJob') IS NOT NULL DROP TABLE #tempAFJob
	CREATE TABLE #tempChunk
	(
			archChunkId		BIGINT,
			commCellId		INTEGER,
			VolumeId		INTEGER
			PRIMARY KEY(archChunkId, commCellId)
	)
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	CREATE	TABLE #tempJob (
			jobId						INTEGER,
			commCellId			INTEGER,
			archCopyId			INTEGER
			PRIMARY KEY(jobId, commCellId, archCopyId)
			)
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	CREATE	TABLE #tempAFJob (
			jobId						INTEGER,
			archFileId			INTEGER,
			afCommCellId		INTEGER,
			archChunkId			BIGINT,
			acCommCellId			INTEGER,
			archCopyId			INTEGER,
			fileType				INTEGER,
			isAged					INTEGER,
			isMediaDeleted 	INTEGER,
			isEdgeAF		INTEGER
			PRIMARY KEY(jobId, archFileId, afCommCellId, archChunkId, acCommCellId, archCopyId, fileType)
			)
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
		INSERT INTO #tempChunk
		SELECT AC.id, AC.commCellId, AC.volumeId
		FROM	archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK)
		WHERE	V.MediaId = @i_MediaId
		AND 	AC.volumeId = V.volumeId
		--AND	AC.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	-- Fail if the copyId for volumes does not match with the copyId of chunks
	IF EXISTS (SELECT V.VolumeId
			FROM MMVolume V WITH (NOLOCK), archStream S WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), #tempChunk C, archGroupCopy AGC WITH (NOLOCK)
		        WHERE C.volumeId = V.volumeId
			--AND	 C.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
			AND	 C.archChunkId = ACM.archChunkId
			AND 	 C.commCellId = ACM.chunkCommCellId
			AND	 V.mediaGroupId = S.mediaGroupId
			AND	 S.archGroupCopyId <> ACM.archCopyId
			AND	 ACM.archCopyId = AGC.id
			AND	(AGC.extendedFlags & 3) = 0)
			-- CVA_GLOBAL_AUXCOPY_POLICY_FLAG | CVA_USE_GLOBAL_AUXCOPY_POLICY_FLAG - do not check above for GACP as media is shared amoung copies.
	BEGIN
		SET	@errorCode = -5
		GOTO CX_EXIT
	END
		INSERT INTO #tempJob
		SELECT DISTINCT AF.jobId, AF.commCellId, ACM.archCopyId
		FROM	#tempChunk C, archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK)
		WHERE C.archChunkId = ACM.archChunkId
		AND 	C.commCellId = ACM.chunkCommCellId
		AND		ACM.archFileId = AF.id
		AND		ACM.commCellId = AF.commCellId
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	INSERT INTO #tempAFJob
SELECT	AF.jobId, ACM.archFileId, ACM.commCellId, ACM.archChunkId, ACM.chunkCommCellId, ACM.archCopyId, AF.fileType, (ACM.flags & 256), 0, (AF.flags & (32768|2097152))
	FROM	#tempJob T, archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK)
	WHERE T.jobId = AF.jobId
	AND 	T.commCellId = AF.commCellId
	AND		AF.id = ACM.archFileId
	AND		AF.commCellId = ACM.commCellId
	AND		T.archCopyId = ACM.archCopyId
	AND		AF.isValid = 1
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	--DO NOT un-age jobs if they are partially pruned from media
	UPDATE #tempAFJob
	SET isMediaDeleted = 1
	FROM	#tempAFJob T, (	SELECT JDS.JobId, JDS.commCellId, JDS.archGrpCopyId,
															 MAX(mediaDeletedTime) AS mediaDeletedTime, MAX(status) AS status,
															 MAX(disabled & 33554432) AS mediaDeletedFlag,
															 MAX(agedBy & 33554432) AS agedByFlag
												FROM JMJobDataStats JDS WITH (NOLOCK), #tempAFJob T1
												WHERE JDS.JobId = T1.JobId
												AND		JDS.commCellId = T1.afCommCellId
												AND 	JDS.archGrpCopyId = T1.archCopyId
												GROUP BY JDS.JobId, JDS.commCellId, JDS.archGrpCopyId) AS TT
	WHERE TT.JobId = T.JobId
	AND		TT.commCellId = T.afCommCellId
	AND 	TT.archGrpCopyId = T.archCopyId
	AND		(TT.mediaDeletedTime > 0 OR TT.status = 1000 OR TT.mediaDeletedFlag > 0 OR TT.agedByFlag > 0)
	SELECT	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@errorCode <> 0 GOTO CX_EXIT
	-- DO NOT un-age jobs if they are partially on magnetic media and AGED
	UPDATE #tempAFJob
	SET isMediaDeleted = 1
	FROM	#tempAFJob T, (	SELECT DISTINCT T.JobId, T.afCommCellId, T.archCopyId
				FROM MMMedia M WITH (NOLOCK), MMVolume V WITH (NOLOCK), archChunk AC WITH (NOLOCK), #tempAFJob T
				WHERE 	AC.id = T.archChunkId
				AND	AC.commCellId = T.acCommCellId
				AND	T.isAged > 0
				AND	AC.volumeId = V.volumeId
				--AND	AC.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
				AND	V.MediaId = M.MediaId
				AND	M.mediaTypeId = 10001) AS TT
	WHERE TT.JobId = T.JobId
	AND   TT.afCommCellId = T.afCommCellId
	AND   TT.archCopyId = T.archCopyId
	SELECT	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@errorCode <> 0 GOTO CX_EXIT
	-- DO NOT un-aged Failed / Killed jobs
	UPDATE #tempAFJob
	SET isMediaDeleted = 1
	FROM	#tempAFJob T, JMBkpStats JBS WITH (NOLOCK)
	WHERE T.JobId = JBS.JobId
	AND	T.afCommCellId = JBS.commCellId
	AND	JBS.status NOT IN (1, 3, 14)
	SELECT	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@errorCode <> 0 GOTO CX_EXIT
	-- DO NOT un-age partial jobs if encKey doesn't match with source copy.
	BEGIN
		-- Get source copies for copies involved in un-age jobs.
		IF OBJECT_ID('tempdb..#CopySrcMap') IS NOT NULL DROP TABLE #CopySrcMap
		CREATE TABLE #CopySrcMap (copyId smallint, sourceCopyId smallint, primaryCopyId smallint)
		INSERT INTO #CopySrcMap
		SELECT	AGC.id copyId, (case when AGC.sourceCopyId > 0 then AGC.sourceCopyId else (case when AGC.isSnapCopy > 0 then AG.defaultSnapCopy else AG.defaultCopy end) end) sourceCopyId, (case when AGC.isSnapCopy > 0 then AG.defaultSnapCopy else AG.defaultCopy end) primaryCopyId
		FROM	archGroupCopy AGC WITH (READUNCOMMITTED), archgroup AG WITH (READUNCOMMITTED)
where	AGC.archGroupId = AG.id AND (AGC.dedupeFlags & 262144) = 0
				AND AGC.id not in (AG.defaultCopy, AG.defaultSnapCopy)
				AND EXISTS (SELECT 1 FROM #tempAFJob WHERE archCopyId = AGC.id)
		IF @@ROWCOUNT > 0
		BEGIN
			-- DO NOT un-age partial jobs  when encKey doesn't match with source
			UPDATE 	#tempAFJob
			SET 	isMediaDeleted = 1
			FROM	#tempAFJob T, #CopySrcMap CSM,
					archFileCopy Dest WITH (READUNCOMMITTED), archFileCopy Src WITH (READUNCOMMITTED)
			WHERE 	T.archCopyId = CSM.copyId AND T.isMediaDeleted = 0
					AND T.archFileId = Dest.archFileId AND T.afCommCellId = Dest.commCellId
					AND Dest.archFileId = Src.archFileId AND Dest.commCellId = Src.commCellId
					AND Dest.archCopyId = CSM.copyId AND Src.archCopyId = CSM.sourceCopyId
					AND Dest.isValid = 0 AND Dest.encKey <> Src.encKey
			SELECT	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
			IF	@errorCode <> 0 GOTO CX_EXIT
			IF EXISTS (SELECT 1 FROM #tempAFJob WHERE isEdgeAF > 0)
			BEGIN
				-- Get all source copies in hierarchy for each of the copy involved in un-age jobs.
				WITH SourceCopies (copyId, sourceCopyId) AS
				(
					SELECT 	copyId, sourceCopyId
					FROM	(
								SELECT copyId, sourceCopyId
								FROM 	#CopySrcMap
								UNION
								-- Get Primary copies
								SELECT  copyId, primaryCopyId as sourceCopyId
								FROM	#CopySrcMap
								WHERE	sourceCopyId <> primaryCopyId
							) AS T
					UNION ALL
					SELECT	SC.copyId, AGC.sourceCopyId
					FROM	archGroupCopy AGC WITH (READUNCOMMITTED), SourceCopies SC
					WHERE	AGC.id = SC.sourceCopyId AND AGC.sourceCopyId > 0
				)
				-- DO NOT un-age if EDGE AF has more data in any of the parent copies when encKey doesn't match with source
				UPDATE 	#tempAFJob
				SET 	isMediaDeleted = 1
				FROM	#tempAFJob T, #CopySrcMap CSM,
						archFileCopy Dest WITH (READUNCOMMITTED), archFileCopy Src WITH (READUNCOMMITTED),
						(
							SELECT 	AFC.archFileId, AFC.commCellId, MAX(AFC.physicalSize) physicalSize
							FROM 	#tempAFJob TAF, archFileCopy AFC WITH (READUNCOMMITTED), SourceCopies SC
							WHERE	TAF.archFileId = AFC.archFileId AND TAF.afCommCellId = AFC.commCellId
									AND AFC.archCopyId = SC.sourceCopyId AND TAF.archCopyId = SC.copyId AND TAF.isEdgeAF > 0
							GROUP BY AFC.archFileId, AFC.commCellId
						) AS MaxSrc
				WHERE 	T.archCopyId = CSM.copyId AND T.isMediaDeleted = 0
						AND T.archFileId = Dest.archFileId AND T.afCommCellId = Dest.commCellId
						AND Dest.archFileId = Src.archFileId AND Dest.commCellId = Src.commCellId
						AND Dest.archCopyId = CSM.copyId AND Src.archCopyId = CSM.sourceCopyId
						AND Src.archFileId = MaxSrc.archFileId AND Src.commCellId = MaxSrc.commCellId
						AND MaxSrc.physicalSize > Dest.physicalSize AND Dest.encKey <> Src.encKey
				SELECT	@errorCode = @@ERROR, @rowCnt = (case when @rowCnt > 0 THEN @rowCnt else @@ROWCOUNT end)
				IF	@errorCode <> 0 GOTO CX_EXIT
				--Close current running edge AFs
				UPDATE  EAF
SET     flags = EAF.flags | 1048576
				FROM    archFile EAF INNER JOIN
						(
							SELECT 	AFC.archFileId, AFC.commCellId,
									ROW_NUMBER() OVER (PARTITION BY AF.appId, AFC.streamNum ORDER BY AFC.archFileId DESC) AS RowNum
							FROM 	#tempAFJob TAF, archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED),
									archGroup AG WITH (READUNCOMMITTED)
							WHERE	TAF.archFileId = AF.id AND TAF.afCommCellId = AF.commCellId
									AND AF.archGroupId = AG.id AND (TAF.archCopyId = AG.defaultCopy OR TAF.archCopyId = AG.defaultSnapCopy)
									AND AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId  AND AF.commCellId = 2
									AND AFC.archCopyId = TAF.archCopyId AND TAF.isEdgeAF = 1 AND TAF.isMediaDeleted = 0
									AND AF.backupLevel = 2 /*INCR*/
						) AS T ON EAF.id = T.archFileId AND EAF.commCellId = T.commCellId AND T.RowNum = 1
				SELECT	@errorCode = @@ERROR
				IF	@errorCode <> 0 GOTO CX_EXIT
			END
		END
	END
	IF @i_Option = 'RUN'
	BEGIN
	IF EXISTS (SELECT jobId FROM #tempAFJob WHERE isMediaDeleted = 0 AND isAged > 0)
	BEGIN
		-- Unset AGED and set AGED BY flags
		UPDATE archFileCopy WITH (PAGLOCK)
SET flags = (flags & ~256), agedBy = 1073741824-- Set un-aged job flag
		FROM #tempAFJob T, archFileCopy AFC
		WHERE AFC.archFileId = T.archFileId
		AND		AFC.commCellId = T.afCommCellId
		AND 	AFC.archCopyId = T.archCopyId
AND		AFC.flags & 256 > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		UPDATE archChunkMapping WITH (PAGLOCK)
SET flags = (flags & ~256), agedBy = 1073741824	-- Set un-aged job flag
		FROM #tempAFJob T, archChunkMapping ACM
		WHERE ACM.archChunkId = T.archChunkId
		AND		ACM.archFileId = T.archFileId
		AND		ACM.commCellId = T.afCommCellId
		AND 	ACM.chunkCommcellId = T.acCommcellId
		AND 	ACM.archCopyId = T.archCopyId
AND		ACM.flags & 256 > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		UPDATE archChunk WITH (PAGLOCK)
SET flags = (flags & ~256), agedBy = 1073741824	-- Set un-aged job flag
		FROM #tempAFJob T, archChunk AC
		WHERE AC.id = T.archChunkId
		AND		AC.commCellId = T.acCommCellId
AND		AC.flags & 256 > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		--Pin the job for RetainUntil time
		UPDATE JMJobDataStats WITH (PAGLOCK)
SET disabled = ((disabled & ~256)|2), agedBy = 1073741824,	-- Set manually retained flag and un-aged job flag
				manualRetentionEndTime = @i_RetainUntilUnix,
				agedTime = 0,
				mediaDeletedTime = 0
		FROM #tempAFJob T, JMJobDataStats JDS
		WHERE JDS.JobId = T.JobId
		AND		JDS.commCellId = T.afCommCellId
		AND 	JDS.archGrpCopyId = T.archCopyId
		AND		JDS.dataType = T.fileType
AND		JDS.disabled & 256 > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		UPDATE JMBkpStats WITH (PAGLOCK)
		SET 	dataStatus = 0, agedTime = 0,	mediaDeletedTime = 0
		FROM #tempAFJob T, JMBkpStats JBS
		WHERE JBS.JobId = T.JobId
		AND		JBS.commCellId = T.afCommCellId
		AND		JBS.agedTime > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		UPDATE JMAdminJobStatsTable WITH (PAGLOCK)
		SET 	dataStatus = 0
		FROM #tempAFJob T, JMAdminJobStatsTable JAS
		WHERE JAS.JobId = T.JobId
		AND		JAS.commCellId = T.afCommCellId
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		-- Delete archfile / chunks / volumes if they exist in MMDeletedAF table
		DELETE MMDeletedAF WITH (PAGLOCK)
		FROM MMDeletedAF DAF, #tempAFJob T
		WHERE T.archChunkId = DAF.archChunkId
		-- AND		T.afCommCellId = DAF.commCellId
		AND		T.acCommCellId = DAF.chunkCommCellId
		AND		T.archCopyId = DAF.copyId
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		-- Remove the recyclable volume entries
		DELETE MMDeletedAF WITH (PAGLOCK)
		FROM MMDeletedAF DAF, archChunk AC, #tempAFJob T
		WHERE AC.id = T.archChunkId
		AND		AC.commCellId = T.acCommCellId
		AND		AC.volumeId = DAF.volumeId
		-- AND	 	T.afCommCellId = DAF.CommCellId
		AND	 	T.acCommCellId = DAF.chunkCommCellId
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		AND		DAF.archFileId = 0
		AND		DAF.archChunkId = 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		-- Mark VolumeFlags as FULL and update VolumeFullReason code
		UPDATE MMVolume
		SET	VolumeFlags = 2, VolumeFullReason = 42044,  -- E_MM_VOL_FULL_JOBS_UNAGED
			volumeFullTime = dbo.GetUnixTime(GETUTCDATE()),
Attributes = (Attributes | 1073741824)
		FROM MMVolume V, archChunk AC, #tempAFJob T
		WHERE AC.id = T.archChunkId
		AND		AC.commCellId = T.acCommCellId
		AND		AC.volumeId = V.volumeId
		--AND	 	AC.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		-- Mark media as NOT AGED
		UPDATE MMMedia
		SET	IsAged = 0, IsInMediaGroup = 1,
Attributes = (M.Attributes | 1073741824)	-- UN-AGED FLAG
		FROM MMMedia M, MMVolume V, archChunk AC, #tempAFJob T
		WHERE T.isMediaDeleted = 0
		AND		T.isAged > 0
		AND		AC.id = T.archChunkId
		AND		AC.commCellId = T.acCommCellId
		AND		AC.volumeId = V.volumeId
		--AND		AC.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
		AND		V.MediaId = M.MediaId
		--AND		M.IsAged <> 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
	END
	IF @i_Option = 'RUN' OR @i_Option = 'PRINT'
	BEGIN
		-- List all jobs that are Un-Aged
		PRINT 'List of Jobs Un-Aged'
		PRINT '--------------------'
		PRINT ' '
		SELECT DISTINCT T.JobId AS "Job Id", T.afCommCellId AS "CommCell Id", T.fileType AS "File Type", T.archCopyId AS "Copy Id", AGC.name AS "Copy Name", AG.id AS "Storage Policy Id", AG.name AS "Storage Policy Name"
		FROM #tempAFJob T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE T.isMediaDeleted = 0
		AND		T.isAged > 0
		AND		T.archCopyId = AGC.id
		AND		AGC.archGroupId = AG.id
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		PRINT ' '
		PRINT ' '
		-- List all jobs that cannot be Un-Aged
		PRINT 'List of Jobs that cannot be Un-Aged'
		PRINT '-----------------------------------'
		PRINT ' '
		SELECT DISTINCT T.JobId AS "Job Id", T.afCommCellId AS "CommCell Id", T.fileType AS "File Type", T.archCopyId AS "Copy Id", AGC.name AS "Copy Name", AG.id AS "Storage Policy Id", AG.name AS "Storage Policy Name"
		FROM #tempAFJob T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE T.isMediaDeleted = 1
		AND		T.archCopyId = AGC.id
		AND		AGC.archGroupId = AG.id
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
CX_EXIT:
	IF @errorCode <> 0
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
	IF @errorCode = -1
		PRINT 'Error: Invalid option [' + @i_Option + ']. Valid options are [PRINT | RUN]'
	IF @errorCode = -4
		PRINT 'Error: Invalid Barcode [' + @i_BarCode + ']'
	IF @errorCode = -5
		PRINT 'Error: Inconsistent data. Cannot un-age the jobs for media [' + @i_BarCode + ']'
	IF @errorCode = -6
		PRINT 'Error: Invalid RetainUntilDays [' + @i_RetainUntil + ']'
	IF @errorCode <> 0
		PRINT 'Error: Failed to execute script. Error code [' + CAST(@errorCode AS VARCHAR(20)) + ']'
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UnAgeJobsOnMedia')
	delete from GxQscripts where name = 'QS_UnAgeJobsOnMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UnAgeJobsOnMedia')
	delete from GXDBVersions where aliasname = 'QS_UnAgeJobsOnMedia'
GO

insert into GXDBVersions values(2, 'QS_UnAgeJobsOnMedia',  '00010008004800030000', 'QS_UnAgeJobsOnMedia', '00010008004800030000')
GO

insert into GxQscripts values(2,'QS_UnAgeJobsOnMedia',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn UnAgeJobsOnMedia.sql -si <media_barcode> -si <option [PRINT | RUN]> [-si <RetainUntilDays>]
'
)
GO

