

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ToggleMountPathsofDDBMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ToggleMountPathsofDDBMA <<<'

IF EXISTS (select * from sysobjects where name='QS_ToggleMountPathsofDDBMA')
	drop procedure QS_ToggleMountPathsofDDBMA
IF EXISTS (select * from GxQscripts where name='QS_ToggleMountPathsofDDBMA')
	delete from GxQscripts where name = 'QS_ToggleMountPathsofDDBMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ToggleMountPathsofDDBMA')
	delete from GXDBVersions where aliasname = 'QS_ToggleMountPathsofDDBMA'
GO
print '... Creating Procedure: QS_ToggleMountPathsofDDBMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ToggleMountPathsofDDBMA
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @enable INT,
  @MAName NVARCHAR(510)
AS
Set NOCOUNT ON
	DECLARE @MANameValidation  INT = 0
	DECLARE @ClientId  INT = 0
	DECLARE @localErrorMsg  VARCHAR(512)
	SELECT	@MANameValidation = 1 , @ClientId = AC.id
	FROM APP_Client AC INNER JOIN MMHost MH ON  AC.id = MH.clientID
	WHERE	AC.name = @MAName
	IF @MANameValidation <> 1
	BEGIN
		SET @localErrorMsg = 'Error: No MA by this name found!'
		goto   ARGS_ERROR
	END
	UPDATE MMMountPath
	SET
		isenabled		 =	(CASE WHEN @enable = 1 THEN 1 ELSE 0 END),
		OfflineReason	 =	(CASE WHEN @enable = 1 THEN 0 ELSE 2 END), -- MOUNTPATH_DISABLED = 2
		OffLineTimeStamp =	(CASE WHEN @enable = 0 THEN datediff(second,'01/01/1970', getutcdate()) ELSE OffLineTimeStamp END)
	FROM
		IdxSIDBSubStore ISS
	WHERE
		ISS.ClientId = @ClientId
		AND
		EXISTS (SELECT 1 FROM MMVolume MV WHERE MV.SIDBStoreId = ISS.SIDBStoreId AND MV.MediaSideId = MMMountPath.MediaSideId)
		AND
		(ISS.SealedTime = 0 OR ISS.status = 0 )
		AND
(ISS.flags & 256 = 0)
		AND
		EXISTS (SELECT 1 FROM archCopySIDBStore ACSS WHERE ACSS.SIDBStoreId = ISS.SIDBStoreId)
Set NOCOUNT OFF
ARGS_ERROR:
	IF @MANameValidation <> 1
	BEGIN
		Raiserror(@localErrorMsg , 15, 1)
		RETURN -1
	END
	RETURN 0
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ToggleMountPathsofDDBMA')
	delete from GxQscripts where name = 'QS_ToggleMountPathsofDDBMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ToggleMountPathsofDDBMA')
	delete from GXDBVersions where aliasname = 'QS_ToggleMountPathsofDDBMA'
GO

insert into GXDBVersions values(2, 'QS_ToggleMountPathsofDDBMA',  '00000000000000000000', 'QS_ToggleMountPathsofDDBMA', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ToggleMountPathsofDDBMA',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn ToggleMountPathsofDDBMA [-si @enable = 1] [-si @MAName = ''test-MA'']'
 + CHAR(10) + '--  Options: @enable   : @enable = 1 : enable the mount paths ; @enable = 0 : disable the mount paths'
)
GO

