

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_StrikeRecovery.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_StrikeRecovery <<<'

IF EXISTS (select * from sysobjects where name='QS_StrikeRecovery')
	drop procedure QS_StrikeRecovery
IF EXISTS (select * from GxQscripts where name='QS_StrikeRecovery')
	delete from GxQscripts where name = 'QS_StrikeRecovery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_StrikeRecovery')
	delete from GXDBVersions where aliasname = 'QS_StrikeRecovery'
GO
print '... Creating Procedure: QS_StrikeRecovery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_StrikeRecovery
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @BackupWindowFrom VARCHAR(32) = '18:00',
  @CountSynthFull INTEGER = 0,
  @NumberOfDays INTEGER = 1
AS
SET NOCOUNT ON
SELECT	StrikeCounts,
		CommServer,
		ClientGroups,
		Client,
		Agent,
		Instance + ' : ' + Backupset + ' : ' + Subclient AS Subclient,
		BackupType,
		FailedFrom,
		FailedDays,
		RecoveryJobID,
		RecoveryJobStart,
		RecoveryJobEnd,
		TimeZone
FROM dbo.StrikeRecovery(@BackupWindowFrom, @CountSynthFull, @NumberOfDays)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_StrikeRecovery')
	delete from GxQscripts where name = 'QS_StrikeRecovery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_StrikeRecovery')
	delete from GXDBVersions where aliasname = 'QS_StrikeRecovery'
GO

insert into GXDBVersions values(2, 'QS_StrikeRecovery',  '00000000000000000000', 'QS_StrikeRecovery', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_StrikeRecovery',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn QS_StrikeRecovery [-si @BackupWindowFrom = ''20:00''] [-si @CountSynthFull = ''1''] [-si @NumberOfDays = ''7'']'
 + CHAR(10) + '-- 	Default: @BackupWindowFrom = ''18:00'', @CountSynthFull = 0, @NumberOfDays = 1'
)
GO

