

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_StorageUsageBySubclients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_StorageUsageBySubclients.sp,v $ $Id: QS_StorageUsageBySubclients.sp,v 1.2.72.4 2020/05/05 01:58:58 junlu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_StorageUsageBySubclients')
BEGIN
	print '>>> Drop Stored Procedure: QS_StorageUsageBySubclients <<<'
	drop procedure QS_StorageUsageBySubclients
END
IF EXISTS (select * from GxQscripts where name='QS_StorageUsageBySubclients')
	delete from GxQscripts where name = 'QS_StorageUsageBySubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_StorageUsageBySubclients')
	delete from GXDBVersions where aliasname = 'QS_StorageUsageBySubclients'
GO
print '... Creating Procedure: QS_StorageUsageBySubclients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_StorageUsageBySubclients
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @LastTimePeriod VARCHAR(32) = '',
  @FromHour INT = -1,
  @FromTime VARCHAR(32) = '',
  @ToTime VARCHAR(32) = '',
  @IncludeAgedData INT = 0,
  @SyncVolumeSize INT	= 0,
  @PolicyName VARCHAR(144)= '',
  @CopyName VARCHAR(64) = '',
  @SizeUnit VARCHAR(64) = '',
  @GroupBy VARCHAR(64) = '',
  @OrderBy VARCHAR(64) = ''
AS
SET NOCOUNT ON
--------------------------------------------
-- Set time range parameters              --
--------------------------------------------
DECLARE	@TimeRangeBegin	INT = 0
DECLARE	@TimeRangeEnd	INT = 0x7FFFFFFF
DECLARE	@FromDateTime	DATETIME = @FromTime
DECLARE	@ToDateTime		DATETIME = @ToTime
IF @LastTimePeriod <> ''
BEGIN
	DECLARE @n INT
	IF CHARINDEX(' days', @LastTimePeriod) > 0
	BEGIN
		SET @n = CAST(SUBSTRING(@LastTimePeriod, 0, CHARINDEX(' days', @LastTimePeriod)) AS INT)
		IF	@FromHour < 0
			SET @ToDateTime = GETDATE()
		ELSE
			SET @ToDateTime = DATEADD(HOUR, @FromHour, DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0))
		IF	@ToDateTime > GETDATE()
			SET @FromDateTime = DATEADD(DAY, -@n-1, @ToDateTime)
		ELSE
			SET @FromDateTime = DATEADD(DAY, -@n, @ToDateTime)
	END
	ELSE
	IF CHARINDEX(' months', @LastTimePeriod) > 0
	BEGIN
		SET @n = CAST(SUBSTRING(@LastTimePeriod, 0, CHARINDEX(' months', @LastTimePeriod)) AS INT)
		IF	@FromHour < 0
			SET @ToDateTime = GETDATE()
		ELSE
			SET @ToDateTime = DATEADD(HOUR, @FromHour, DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0))
		SET @FromDateTime = DATEADD(MONTH, -@n, @ToDateTime)
	END
	SET	@FromDateTime	= dbo.ClientLocalToUTCTime(@FromDateTime, 2)
	SET	@TimeRangeBegin = dbo.GetUnixTime(@FromDateTime)
	SET	@ToDateTime		= dbo.ClientLocalToUTCTime(@ToDateTime, 2)
	SET	@TimeRangeEnd	= dbo.GetUnixTime(@ToDateTime)
END
ELSE
BEGIN
	IF @FromTime <> ''
	BEGIN
		SET	@FromDateTime	= dbo.ClientLocalToUTCTime(@FromDateTime, 2)
		SET	@TimeRangeBegin = dbo.GetUnixTime(@FromDateTime)
	END
	IF @ToTime <> ''
	BEGIN
		SET	@ToDateTime		= dbo.ClientLocalToUTCTime(@ToDateTime, 2)
		SET	@TimeRangeEnd	= dbo.GetUnixTime(@ToDateTime)
	END
END
--------------------------------------------
-- Retrieve storage policy copy IDs       --
--------------------------------------------
DECLARE	@CopyId			INT = 0
CREATE TABLE #TblCopyIds (ArchGrpId INT, PolicyName NVARCHAR(144), CopyId INT, CopyName NVARCHAR(64), IsSnapCopy INT,
			dedupeFlags INT, StorageType VARCHAR(16));
CREATE TABLE #ExtraDedupCopy (ArchGrpId INT, CopyId INT, CopyName NVARCHAR(64), dedupeFlags INT)
IF @CopyName = '' AND @PolicyName = ''
	INSERT INTO #TblCopyIds
	SELECT	AG.id, AG.name, AGC.id, AGC.name, AGC.isSnapCopy, AGC.dedupeFlags,
CASE WHEN ((AGC.dedupeFlags & 262144) > 0) THEN 'Dedup'
				 WHEN DPL.DrivePoolType = 10001 THEN 'Disk'
				 ELSE 'Tape'
			END
	FROM	archGroup AG WITH (NOLOCK)
			INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.archGroupId = AG.id
			INNER JOIN MMDataPath DPT WITH (NOLOCK) ON DPT.CopyId = AGC.id
			INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON DPT.DrivePoolId = DPL.DrivePoolId
	WHERE	AG.type <> 4 AND AGC.id > 0 AND AGC.type IN (1, 2, 3) AND (DPT.Flag & 1) = 1
ELSE
BEGIN
	INSERT INTO #TblCopyIds
	SELECT	AG.id, AG.name, AGC.id, AGC.name, AGC.isSnapCopy, AGC.dedupeFlags,
CASE WHEN ((AGC.dedupeFlags & 262144) > 0) THEN 'Dedup'
				 WHEN DPL.DrivePoolType = 10001 THEN 'Disk'
				 ELSE 'Tape'
			END
	FROM	archGroup AG WITH (NOLOCK)
			INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.archGroupId = AG.id
			INNER JOIN MMDataPath DPT WITH (NOLOCK) ON DPT.CopyId = AGC.id
			INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON DPT.DrivePoolId = DPL.DrivePoolId
	WHERE	AG.name = @PolicyName AND (AGC.name = @CopyName OR @CopyName = '')
		AND AG.type <> 4 AND AGC.id > 0 AND AGC.type IN (1, 2, 3) AND (DPT.Flag & 1) = 1
IF EXISTS (SELECT * FROM #TblCopyIds WHERE (dedupeFlags & 134217728) > 0)
	BEGIN
		INSERT INTO #ExtraDedupCopy
		SELECT AGC.archGroupId, AGC.id, AGC.name, AGC.dedupeFlags
		FROM	#TblCopyIds C WITH (NOLOCK)
				INNER JOIN archCopyToGlobalPolicy GP1 WITH (NOLOCK) ON c.CopyId = GP1.copyId
				INNER JOIN archCopyToGlobalPolicy GP2 WITH (NOLOCK) ON GP1.globalPolicyId = GP2.globalPolicyId
INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON GP2.CopyId = AGC.id AND ((AGC.dedupeFlags & 134217728) > 0)
				LEFT OUTER JOIN #TblCopyIds D ON AGC.id = D.CopyId
		WHERE	D.ArchGrpId IS NULL
AND ((c.dedupeFlags & 134217728) > 0)
		INSERT INTO #TblCopyIds
		SELECT	AG.id, AG.name, D.CopyId, D.CopyName, 0, D.dedupeFlags, 'Dedup'
		FROM	#ExtraDedupCopy D
				INNER JOIN archGroup AG WITH (NOLOCK) ON D.ArchGrpId = AG.id
	END
END
-- Subclient sizes on each copies
CREATE TABLE #AppCopySize (VMClientId INT, appId INT, archGrpCopyId INT, dataRead BIGINT, dataWritten BIGINT)
--------------------------------------------
-- Retrieve application size of VMs       --
--------------------------------------------
CREATE	TABLE #JobVMs (
	jobId INT, commCellId INT, appId INT, bkpLevel INT, startDate INT, endDate INT, vmClientId INT,
	vmStatus INT, vmFailureReason VARCHAR(512),	vmAppSize BIGINT, vmGuestSize BIGINT, vmSize BIGINT
)
CREATE	TABLE #VMJobCopy (
	jobId INT, commCellId INT, archGrpCopyId INT, isSnapCopy INT, appId INT, bkpLevel INT, startDate INT, endDate INT,
	totalUncompBytes BIGINT, totalBackupSize BIGINT, CompBytes BIGINT
)
CREATE	TABLE #VMJobSize (jobId INT, commCellId INT, dataRead BIGINT)
CREATE	TABLE #VSA_AppIDs (appId INT, isIndexingV2 INT)
-- Before IndexingV2, JMJobDataStats and archFile tables only have entries of parent jobs. Count parent jobs.
-- Since IndexingV2, JMJobDataStats and archFile tables have entries of both parent and child jobs. Count child jobs.
-- Parent jobs associated with appId of IndexingV2 VSA subclients will be excluded in calcultion.
INSERT	INTO #VSA_AppIDs
SELECT	A.id, ISNULL(CP.attrVal, 0)
FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON IP.componentNameId = A.instance
			AND IP.attrName = 'Virtual Server Instance Type' AND IP.attrVal <> '' AND IP.modified = 0
		LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = A.clientId
			AND CP.attrName = 'IndexingV2_VSA' AND CP.modified = 0 AND CP.attrVal = '1'
WHERE	A.appTypeId = 106 AND A.subclientStatus&0x00020 = 0
INSERT INTO #VMJobCopy
SELECT	AF.jobId, AF.commCellId, ACM.archCopyId, C.IsSnapCopy, J.appId, J.bkpLevel, J.servStartDate, J.servEndDate,
		J.totalUncompBytes, J.totalBackupSize, SUM(ACM.physicalSize)
FROM	archChunk AC WITH (NOLOCK)
		INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
		INNER JOIN archFile AF WITH (NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND AF.isValid = 1
		INNER JOIN JMBkpStats J WITH (NOLOCK) ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND J.appType = 106
		INNER JOIN #TblCopyIds C ON ACM.archCopyId = C.CopyId
		LEFT OUTER JOIN #VSA_AppIDs VA ON AF.appId = VA.appId AND VA.isIndexingV2 = 1
WHERE	(AC.createTime BETWEEN @TimeRangeBegin AND @TimeRangeEnd
		OR AC.createTime <= @TimeRangeEnd AND (@TimeRangeBegin BETWEEN J.servStartDate AND J.servEndDate))
	AND J.servEndDate <= @TimeRangeEnd
	AND J.status IN (1, 3, 14)
	AND J.totalBackupSize > 0
AND (@IncludeAgedData = 1 OR (ACM.flags & 256) = 0)
	AND VA.appId IS NULL
GROUP BY AF.jobId, AF.commCellId, ACM.archCopyId, C.IsSnapCopy, J.appId, J.bkpLevel, J.servStartDate, J.servEndDate, J.totalUncompBytes, J.totalBackupSize
INSERT INTO #JobVMs
SELECT	DISTINCT jobId, commCellId, J.appId, bkpLevel, startDate, endDate, 0, 0, '', 0, 0, 0
FROM	#VMJobCopy  J
		INNER JOIN #VSA_AppIDs VA ON J.appId = VA.appId AND VA.isIndexingV2 = 0
IF EXISTS (SELECT 1 FROM #JobVMs)
BEGIN
	CREATE INDEX JobVMs_jobId_commCellId_idx ON #JobVMs (jobId, commCellId)
	-- Populate #JobVMs table for VMs and remove initial entries (with vmClientId = 0)
	EXEC AppSizeOfJobVMs 0
	INSERT INTO #VMJobSize
	SELECT	jobId, commCellId, SUM(vmAppSize)
	FROM	#JobVMs
	GROUP BY jobId, commCellId
	INSERT	INTO #AppCopySize
	SELECT	V.VMclientId, S.appId, S.archGrpCopyId,
			SUM((CASE WHEN S.isSnapCopy = 0 THEN (1.0*S.CompBytes/S.totalBackupSize) ELSE 1.0 END)*ISNULL(1.0*V.vmAppSize/J.dataRead, 1)*S.totalUncompBytes),
			SUM(ISNULL(1.0*V.vmAppSize/J.dataRead, 1)*S.CompBytes)
	FROM	#VMJobCopy S WITH (NOLOCK)
			INNER JOIN #VMJobSize J ON S.jobId = J.jobId AND S.commCellId = J.commCellId AND J.dataRead > 0
			INNER JOIN #JobVMs V ON J.jobId = V.jobId AND J.commCellId = V.commCellId
	WHERE	S.totalBackupSize > 0
	GROUP BY V.VMclientId, S.appId, S.archGrpCopyId
END
IF EXISTS (SELECT 1 FROM #VSA_AppIDs WHERE isIndexingV2 = 1)
BEGIN
	INSERT	INTO #AppCopySize
	SELECT	A.clientId, J.parentAppId, S.archGrpCopyId, SUM(S.totalUncompBytes), SUM(S.CompBytes)
	FROM	#VMJobCopy S
			INNER JOIN JMJobDataLink J WITH (NOLOCK) ON S.jobId = J.childJobId AND S.commCellId = J.commCellId
AND J.linkType IN (7, 8)
			INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
	WHERE	S.totalBackupSize > 0
	GROUP BY A.clientId, J.parentAppId, S.archGrpCopyId
END
DROP TABLE #JobVMs
DROP TABLE #VMJobSize
DROP TABLE #VMJobCopy
DROP TABLE #VSA_AppIDs
--------------------------------------------
-- Get sizes per subclient per copy       --
--------------------------------------------
-- DR Backup Jobs
INSERT INTO #AppCopySize
SELECT	0, J.appId, ACM.archCopyId, SUM(ACM.physicalSize), SUM(ACM.physicalSize)
FROM	archChunk AC WITH (NOLOCK)
		INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
		INNER JOIN archFile AF WITH (NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND AF.isValid = 1
		INNER JOIN #TblCopyIds C ON ACM.archCopyId = C.CopyId
		INNER JOIN JMAdminJobStatsTable J WITH (NOLOCK) ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId
WHERE	(AC.createTime BETWEEN @TimeRangeBegin AND @TimeRangeEnd
		OR AC.createTime <= @TimeRangeEnd AND (@TimeRangeBegin BETWEEN J.servStart AND J.servEnd))
	AND J.servEnd <= @TimeRangeEnd
	AND J.totalBackupSize > 0
AND (@IncludeAgedData = 1 OR (ACM.flags & 256) = 0)
GROUP BY J.appId, ACM.archCopyId
INSERT INTO #AppCopySize
SELECT	0, J.appId, ACM.archCopyId, SUM(ACM.physicalSize), SUM(ACM.physicalSize)
FROM	archChunkMapping ACM WITH (NOLOCK)
		INNER JOIN archFile AF WITH (NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND AF.isValid = 1
		INNER JOIN #TblCopyIds C ON ACM.archCopyId = C.CopyId
		INNER JOIN JMAdminJobStatsTable J WITH (NOLOCK) ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId
WHERE	J.servStart < @TimeRangeBegin AND J.servEnd BETWEEN @TimeRangeBegin AND @TimeRangeEnd
	AND J.totalBackupSize > 0
AND (@IncludeAgedData = 1 OR (ACM.flags & 256) = 0)
GROUP BY J.appId, ACM.archCopyId
-- Other jobs
INSERT INTO #AppCopySize
SELECT	0, J.appId, ACM.archCopyId,
		SUM(CASE WHEN C.isSnapCopy = 0 THEN (1.0*ACM.physicalSize/J.totalBackupSize)*J.totalUncompBytes ELSE J.totalUncompBytes END),
		SUM(ACM.physicalSize)
FROM	archChunk AC WITH (NOLOCK)
		INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
		INNER JOIN archFile AF WITH (NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND AF.isValid = 1
		INNER JOIN #TblCopyIds C ON ACM.archCopyId = C.CopyId
		INNER JOIN JMBkpStats J WITH (NOLOCK) ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId
WHERE	AC.createTime BETWEEN @TimeRangeBegin AND @TimeRangeEnd
	AND (J.servEndDate < @TimeRangeBegin OR J.servStartDate >= @TimeRangeBegin AND J.servEndDate <= @TimeRangeEnd)
	AND J.appType <> 106 AND J.totalBackupSize > 0
AND (@IncludeAgedData = 1 OR (ACM.flags & 256) = 0)
GROUP BY J.appId, ACM.archCopyId
INSERT INTO #AppCopySize
SELECT	0, J.appId, ACM.archCopyId,
		SUM(CASE WHEN C.isSnapCopy = 0 THEN (1.0*ACM.physicalSize/J.totalBackupSize)*J.totalUncompBytes ELSE J.totalUncompBytes END),
		SUM(ACM.physicalSize)
FROM	archChunkMapping ACM WITH (NOLOCK)
		INNER JOIN archFile AF WITH (NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND AF.isValid = 1
		INNER JOIN #TblCopyIds C ON ACM.archCopyId = C.CopyId
		INNER JOIN JMBkpStats J WITH (NOLOCK) ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId
WHERE	J.servStartDate < @TimeRangeBegin AND J.servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
	AND J.appType <> 106 AND J.totalBackupSize > 0
AND (@IncludeAgedData = 1 OR (ACM.flags & 256) = 0)
GROUP BY J.appId, ACM.archCopyId
--------------------------------------------
-- Calculate dedup ratio of dedupe copies --
--------------------------------------------
CREATE TABLE #DedupeCopy (
	archGrpCopyId INT, activeStoreId INT, dedupeFlags INT,
	dataRead BIGINT, dataWritten BIGINT, dedupRatio FLOAT, dedupSaving DECIMAL(10,2)
)
INSERT	INTO #DedupeCopy
SELECT	CopyId, 0, dedupeFlags, 0, 0, 0, 0
FROM	#TblCopyIds
WHERE	StorageType = 'Dedup'
EXEC DedupCopySaving @SyncVolumeSize
UPDATE	#AppCopySize
SET		dataWritten = #AppCopySize.dataRead * C.dedupRatio
FROM	#DedupeCopy C
WHERE	#AppCopySize.archGrpCopyId = C.archGrpCopyId
DELETE	#TblCopyIds
FROM	#ExtraDedupCopy
WHERE	#TblCopyIds.CopyId = #ExtraDedupCopy.CopyId
DROP TABLE #DedupeCopy
DROP TABLE #ExtraDedupCopy
CREATE TABLE #ClientGroupsString (clientId INT, clientGroups NVARCHAR(MAX))
EXEC GetClientGroupsString 0
--------------------------------------------
-- Return resuls in order of Client, Agent, Backupset, Instance, Subclient, StoragePolicy, Copy --
--------------------------------------------
IF @GroupBy LIKE 'Client'
	IF @SizeUnit = 'TB'
		SELECT	ISNULL(CL.name, 'VM Client ID = ' + CAST(S.clientId AS VARCHAR(20))) AS 'Client',
				CAST(S.dataRead/1024.0/1024.0/1024.0/1024.0 AS DECIMAL(20,3)) AS 'Application Size (TB)',
				CAST(S.dataWritten/1024.0/1024.0/1024.0/1024.0 AS DECIMAL(20,3)) AS 'Data Written (TB)',
				ISNULL(CG.ClientGroups, '') AS 'Client Group'
		FROM	(SELECT	CASE WHEN VMClientId > 0 THEN VMClientId ELSE A.clientId END AS clientId,
						SUM(dataRead) AS dataRead, SUM(dataWritten) AS dataWritten
				 FROM	#AppCopySize APP
						INNER JOIN APP_Application A WITH (NOLOCK) ON APP.appId = A.id
				 GROUP BY CASE WHEN VMClientId > 0 THEN VMClientId ELSE A.clientId END
				) S
				INNER JOIN APP_Client CL WITH (NOLOCK) ON S.clientId = CL.id
				LEFT OUTER JOIN #ClientGroupsString CG ON S.clientId = CG.ClientId
		ORDER BY (CASE WHEN @OrderBy LIKE '%Application Size%' THEN S.dataRead
					WHEN @OrderBy LIKE '%Data Written%' THEN S.dataWritten ELSE 0 END) DESC,
				(CASE WHEN @OrderBy = 'Client Group' THEN ISNULL(CG.ClientGroups, '') ELSE '' END),
				'Client'
	ELSE
		SELECT	ISNULL(CL.name, 'VM Client ID = ' + CAST(S.clientId AS VARCHAR(20))) AS 'Client',
				CAST(S.dataRead/1024.0/1024.0/1024.0 AS DECIMAL(20,3)) AS 'Application Size (GB)',
				CAST(S.dataWritten/1024.0/1024.0/1024.0 AS DECIMAL(20,3)) AS 'Data Written (GB)',
				ISNULL(CG.ClientGroups, '') AS 'Client Group'
		FROM	(SELECT	CASE WHEN VMClientId > 0 THEN VMClientId ELSE A.clientId END AS clientId,
						SUM(dataRead) AS dataRead, SUM(dataWritten) AS dataWritten
				 FROM	#AppCopySize APP
						INNER JOIN APP_Application A WITH (NOLOCK) ON APP.appId = A.id
				 GROUP BY CASE WHEN VMClientId > 0 THEN VMClientId ELSE A.clientId END
				) S
				INNER JOIN APP_Client CL WITH (NOLOCK) ON S.clientId = CL.id
				LEFT OUTER JOIN #ClientGroupsString CG ON S.clientId = CG.ClientId
		ORDER BY (CASE WHEN @OrderBy LIKE '%Application Size%' THEN S.dataRead
					WHEN @OrderBy LIKE 'Data Written' THEN S.dataWritten ELSE 0 END) DESC,
				(CASE WHEN @OrderBy = 'Client Group' THEN ISNULL(CG.ClientGroups, '') ELSE '' END),
				'Client'
ELSE
	IF @SizeUnit = 'TB'
		SELECT	CASE WHEN S.VMClientId > 0 THEN ISNULL((SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = S.VMClientId), 'VM Client ID = ' + CAST(S.VMClientId AS VARCHAR(20)))
					ELSE CL.name END AS 'Client',
				IDA.name + CASE WHEN S.VMClientId > 0 THEN (' in ' + CL.name) ELSE '' END AS 'Agent',
				dbo.FixInstanceName(INS.name, A.appTypeId) AS 'Instance',
				BS.name AS 'Backupset',
				A.subclientName AS 'Subclient',
				C.PolicyName AS 'Storage Policy',
				C.CopyName AS 'Copy',
				C.StorageType AS 'Storage Type',
				CASE WHEN AGE.retentionDays < 0 THEN 'INFINITE' ELSE CAST(AGE.retentionDays AS VARCHAR(10))+ ' day(s);' + CAST(AGE.fullCycles AS VARCHAR(10)) +' Cycle(s)' END AS 'Retention',
				CAST(S.dataRead/1024.0/1024.0/1024.0/1024.0 AS DECIMAL(20,3)) AS 'Application Size (TB)',
				CAST(S.dataWritten/1024.0/1024.0/1024.0/1024.0 AS DECIMAL(20,3)) AS 'Data Written (TB)',
				COALESCE(CG1.ClientGroups, CG2.ClientGroups, '') AS 'Client Group'
		FROM	(SELECT	VMClientId, appId, archGrpCopyId, SUM(dataRead) AS dataRead, SUM(dataWritten) AS dataWritten
				 FROM	#AppCopySize
				 GROUP BY VMClientId, appId, archGrpCopyId
				) S
				INNER JOIN #TblCopyIds C ON S.archGrpCopyId = C.CopyId
				INNER JOIN archAgingRule AGE WITH (NOLOCK) ON AGE.copyId = C.CopyId
				INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
				INNER JOIN APP_Client CL WITH (NOLOCK) ON A.clientId = CL.id
				INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON A.appTypeId = IDA.type
				INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON A.instance = INS.id
				INNER JOIN APP_BackupSetName BS WITH (NOLOCK) ON A.backupset = BS.id
				LEFT OUTER JOIN #ClientGroupsString CG1 ON (S.VMClientId > 0 AND S.VMClientId = CG1.ClientId)
				LEFT OUTER JOIN #ClientGroupsString CG2 ON (S.VMClientId = 0 AND A.clientId = CG2.ClientId)
		ORDER BY (CASE WHEN @OrderBy LIKE '%Application Size%' THEN S.dataRead
					WHEN @OrderBy LIKE '%Data Written%' THEN S.dataWritten ELSE 0 END) DESC,
				(CASE WHEN @OrderBy = 'Agent' THEN IDA.name
					WHEN @OrderBy = 'Storage Policy' THEN C.PolicyName
					WHEN @OrderBy = 'Client Group' THEN COALESCE(CG1.ClientGroups, CG2.ClientGroups, '') ELSE '' END),
				'Client', 'Agent', 'Backupset', 'Instance', 'Subclient', 'Storage Policy', 'Copy'
	ELSE
		SELECT	CASE WHEN S.VMClientId > 0 THEN ISNULL((SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = S.VMClientId), 'VM Client ID = ' + CAST(S.VMClientId AS VARCHAR(20)))
					ELSE CL.name END AS 'Client',
				IDA.name + CASE WHEN S.VMClientId > 0 THEN (' in ' + CL.name) ELSE '' END AS 'Agent',
				dbo.FixInstanceName(INS.name, A.appTypeId) AS 'Instance',
				BS.name AS 'Backupset',
				A.subclientName AS 'Subclient',
				C.PolicyName AS 'Storage Policy',
				C.CopyName AS 'Copy',
				C.StorageType AS 'Storage Type',
				CASE WHEN AGE.retentionDays < 0 THEN 'INFINITE' ELSE CAST(AGE.retentionDays AS VARCHAR(10))+ ' day(s);' + CAST(AGE.fullCycles AS VARCHAR(10)) +' Cycle(s)' END AS 'Retention',
				CAST(S.dataRead/1024.0/1024.0/1024.0 AS DECIMAL(20,3)) AS 'Application Size (GB)',
				CAST(S.dataWritten/1024.0/1024.0/1024.0 AS DECIMAL(20,3)) AS 'Data Written (GB)',
				COALESCE(CG1.ClientGroups, CG2.ClientGroups, '') AS 'Client Group'
		FROM	(SELECT	VMClientId, appId, archGrpCopyId, SUM(dataRead) AS dataRead, SUM(dataWritten) AS dataWritten
				 FROM	#AppCopySize
				 GROUP BY VMClientId, appId, archGrpCopyId
				) S
				INNER JOIN #TblCopyIds C ON S.archGrpCopyId = C.CopyId
				INNER JOIN archAgingRule AGE WITH (NOLOCK) ON AGE.copyId = C.CopyId
				INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
				INNER JOIN APP_Client CL WITH (NOLOCK) ON A.clientId = CL.id
				INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON A.appTypeId = IDA.type
				INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON A.instance = INS.id
				INNER JOIN APP_BackupSetName BS WITH (NOLOCK) ON A.backupset = BS.id
				LEFT OUTER JOIN #ClientGroupsString CG1 ON (S.VMClientId > 0 AND S.VMClientId = CG1.ClientId)
				LEFT OUTER JOIN #ClientGroupsString CG2 ON (S.VMClientId = 0 AND A.clientId = CG2.ClientId)
		ORDER BY (CASE WHEN @OrderBy LIKE '%Application Size%' THEN S.dataRead
					WHEN @OrderBy LIKE '%Data Written%' THEN S.dataWritten ELSE 0 END) DESC,
				(CASE WHEN @OrderBy = 'Agent' THEN IDA.name
					WHEN @OrderBy = 'Storage Policy' THEN C.PolicyName
					WHEN @OrderBy = 'Client Group' THEN COALESCE(CG1.ClientGroups, CG2.ClientGroups, '') ELSE '' END),
				'Client', 'Agent', 'Backupset', 'Instance', 'Subclient', 'Storage Policy', 'Copy'
DROP TABLE #AppCopySize
DROP TABLE #TblCopyIds
DROP TABLE #ClientGroupsString
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_StorageUsageBySubclients')
	delete from GxQscripts where name = 'QS_StorageUsageBySubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_StorageUsageBySubclients')
	delete from GXDBVersions where aliasname = 'QS_StorageUsageBySubclients'
GO

insert into GXDBVersions values(2, 'QS_StorageUsageBySubclients',  '00010002007200040000', 'QS_StorageUsageBySubclients', '00010002007200040000')
GO

insert into GxQscripts values(2,'QS_StorageUsageBySubclients',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn QS_StorageUsageBySubclients [-si @LastTimePeriod="''1 months''"] [-si @FromHour=''8''] [-si @FromTime=''2013/02/12''] [-si @ToTime=''2013/02/20''] [-si @IncludeAgedData=''0''] [-si @SyncVolumeSize=''0''] [-si @PolicyName=''policyName''] [-si @CopyName=''copyName''] [-si @SizeUnit=''TB''] [-si @GroupBy=''Client''] [-si @OrderBy="''Application Size''"]'
 + CHAR(10) + '  Example:
'
 + CHAR(10) + '--   qoperation execscript -sn QS_StorageUsageBySubclients -si "7 days" -si 10'
 + CHAR(10) + '--   qoperation execscript -sn QS_StorageUsageBySubclients -si @FromTime=''2013-09-01'' -si @ToTime="''2013/09/30 23:59:59''"'
 + CHAR(10) + '
'
 + CHAR(10) + '  Note: Parameter values containing white spaces should be in single quotes inside double quotes, eg. "''30 days''".
'
 + CHAR(10) + '
'
 + CHAR(10) + '  Parameters:
'
 + CHAR(10) + '    1. Time range can be specified by either LastTimePeriod and FromHour or FromTime and ToTime.
'
 + CHAR(10) + '       LastTimePeriod and FromHour will be used if LastTimePeriod is specified. Otherwise FromTime and ToTime will be used.
'
 + CHAR(10) + '       a. LastTimePeriod should be in ''N days'' or ''N months'' format. Eg. ''7 days''.
'
 + CHAR(10) + '          FromHour should an integrer between 0 and 23. Default is -1 which means the current time.
'
 + CHAR(10) + '       b. FromTime and ToTime should be in ''mm/dd/yyyy hh:mm:ss'' or ''yyyy-mm-dd hh:mm:ss'' format.
'
 + CHAR(10) + '    2. Default is IncludeAgedData = 0 for not including aged Data.
'
 + CHAR(10) + '    3. Default is SyncVolumeSize = 0 for not correcting dedup volume sizes because of backlog of updating size on disk.
'
 + CHAR(10) + '    4. If PolicyName and/or CopyName are specified, calculation only includes data in the given storage policy and/or copy.
'
 + CHAR(10) + '    5. SizeUnit can be ''GB'' or ''TB''. Default is ''GB''.
'
 + CHAR(10) + '    6. GroupBy can be set to ''Client'' for returning sizes per client. Default is returning sizes per subclient.
'
 + CHAR(10) + '    7. OrderBy can be set to ''Application Size'', ''Data Written'', ''Agent'', ''Storage Policy'' or ''Client Group''. 
'
 + CHAR(10) + '       Default order is ''Client'', ''Agent'', ''Backupset'', ''Instance'', ''Subclient'', ''Storage Policy'', ''Copy''.
'
 + CHAR(10) + '
'
 + CHAR(10) + '  Output:
'
 + CHAR(10) + '    1. The entire jobs started before the time range are counted. Jobs completed after the time range are not counted.
'
 + CHAR(10) + '    2. Data physically deleted from media are not counted. So short retention jobs may not be counted.
'
 + CHAR(10) + '    3. For VMs, results are grouped by VMs, not by the proxy clients.
'
 + CHAR(10) + '    4. Deduped storage usage is calculated using the average dedup ratio of each dedup copy. So dedup savings are counted evenly.
'
)
GO

