

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ShowTotalHoursRequiredForCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ShowTotalHoursRequiredForCopy.sp,v $ $Id: QS_ShowTotalHoursRequiredForCopy.sp,v 1.1.2.5 2018/03/22 03:05:18 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ShowTotalHoursRequiredForCopy <<<'

IF EXISTS (select * from sysobjects where name='QS_ShowTotalHoursRequiredForCopy')
	drop procedure QS_ShowTotalHoursRequiredForCopy
IF EXISTS (select * from GxQscripts where name='QS_ShowTotalHoursRequiredForCopy')
	delete from GxQscripts where name = 'QS_ShowTotalHoursRequiredForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ShowTotalHoursRequiredForCopy')
	delete from GXDBVersions where aliasname = 'QS_ShowTotalHoursRequiredForCopy'
GO
print '... Creating Procedure: QS_ShowTotalHoursRequiredForCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ShowTotalHoursRequiredForCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @totalTimeForCopy int = 0
IF (OBJECT_ID('tempdb.dbo.#tblTotalHoursToCopyDetails') IS NOT NULL) DROP TABLE #tblTotalHoursToCopyDetails
CREATE TABLE #tblTotalHoursToCopyDetails (   policyId integer,
   policyName NVARCHAR(255),
  copyId integer,
  copyName NVARCHAR(255),
  bytesNotCopied bigint,
  nMediaNotCopied integer,
  nJobsNotCopied integer,
  oldestJobEndTime integer,
  secondsForCopy integer,
  nSubClients integer,
  alertReason integer,
  onlyEvent integer
  )
exec archAuxCopyFallenBehindAlert 1
DELETE
FROM #tblTotalHoursToCopyDetails
WHERE secondsForCopy <= 0
select CASE WHEN ISNULL(SUM(secondsForCopy)/60,0) < 1 THEN convert(nvarchar(32),ISNULL(SUM(secondsForCopy),0)) + ' Seconds' WHEN ISNULL(SUM(secondsForCopy)/3600,0) < 1 THEN convert(nvarchar(32),ISNULL(SUM(secondsForCopy)/60,0)) + ' Minutes ' + convert(nvarchar(32),ISNULL(SUM(secondsForCopy)%60,0)) + ' Seconds' ELSE convert(nvarchar(32),ISNULL(SUM(secondsForCopy)/3600,0))  + ' Hours ' + convert(nvarchar(32),ISNULL((SUM(secondsForCopy)/60)%60,0)) + ' Minutes' END 'Total Time for all Storage Policies'
FROM #tblTotalHoursToCopyDetails
DECLARE @policyId int = 0
DECLARE @policyName NVARCHAR(255) = 0
DECLARE @totalTimeForCopySP int = 0
DECLARE cursor_ CURSOR FOR
	SELECT DISTINCT policyId, policyName, SUM(ISNULL(secondsForCopy,0))
	FROM #tblTotalHoursToCopyDetails
	GROUP BY policyId,policyName
OPEN cursor_
FETCH NEXT FROM cursor_ INTO @policyId ,@policyName,@totalTimeForCopySP
WHILE @@FETCH_STATUS = 0
BEGIN
	print (char(13)+char(10) + 'Total hours required for AuxCopy for Storage Policy "'+ @policyName +'":' +  CASE WHEN ISNULL(@totalTimeForCopySP/60,0) < 1 THEN convert(nvarchar(32),ISNULL(@totalTimeForCopySP,0)) + ' Seconds' WHEN ISNULL(@totalTimeForCopySP/3600,0) < 1 THEN convert(nvarchar(32),ISNULL(@totalTimeForCopySP/60,0)) + ' Minutes '  + convert(nvarchar(32),ISNULL(@totalTimeForCopySP%60,0)) + ' Seconds' ELSE convert(nvarchar(32),ISNULL(@totalTimeForCopySP/3600,0))  + ' Hours ' + convert(nvarchar(32),ISNULL((@totalTimeForCopySP/60)%60,0)) + ' Minutes' END  )
	select policyName,copyName,
	CASE WHEN ISNULL(secondsForCopy/60,0) < 1 THEN convert(nvarchar(32),ISNULL(secondsForCopy,0)) + ' Seconds' WHEN ISNULL(secondsForCopy/3600,0) < 1 THEN convert(nvarchar(32),ISNULL(secondsForCopy/60,0)) + ' Minutes '   + convert(nvarchar(32),ISNULL(secondsForCopy%60,0)) + ' Seconds'  ELSE convert(nvarchar(32),ISNULL(secondsForCopy/3600,0))  + ' Hours ' +  + convert(nvarchar(32),ISNULL((secondsForCopy/60)%60,0)) + ' Minutes' END 'Time Required for Copy'
	FROM #tblTotalHoursToCopyDetails
	WHERE policyId = @policyId
	FETCH NEXT FROM cursor_ INTO @policyId ,@policyName,@totalTimeForCopySP
END
CLOSE cursor_
DEALLOCATE cursor_
IF (OBJECT_ID('tempdb.dbo.#tblTotalHoursToCopyDetails') IS NOT NULL) DROP TABLE #tblTotalHoursToCopyDetails
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ShowTotalHoursRequiredForCopy')
	delete from GxQscripts where name = 'QS_ShowTotalHoursRequiredForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ShowTotalHoursRequiredForCopy')
	delete from GXDBVersions where aliasname = 'QS_ShowTotalHoursRequiredForCopy'
GO

insert into GXDBVersions values(2, 'QS_ShowTotalHoursRequiredForCopy',  '00010001000200050000', 'QS_ShowTotalHoursRequiredForCopy', '00010001000200050000')
GO

insert into GxQscripts values(2,'QS_ShowTotalHoursRequiredForCopy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	Command to display total time required to copy for all the storage policy copies with "Aux-Copy fallen behind alert on time required to copy" set'
 + CHAR(10) + '-- 	qoperation execscript -sn ShowTotalHoursRequiredForCopy'
)
GO

