

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetVmPolicyProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetVmPolicyProperty.sp,v $ $Id: QS_SetVmPolicyProperty.sp,v 1.1.180.3 2018/03/27 08:04:39 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetVmPolicyProperty <<<'

IF EXISTS (select * from sysobjects where name='QS_SetVmPolicyProperty')
	drop procedure QS_SetVmPolicyProperty
IF EXISTS (select * from GxQscripts where name='QS_SetVmPolicyProperty')
	delete from GxQscripts where name = 'QS_SetVmPolicyProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVmPolicyProperty')
	delete from GXDBVersions where aliasname = 'QS_SetVmPolicyProperty'
GO
print '... Creating Procedure: QS_SetVmPolicyProperty'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetVmPolicyProperty
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @policyName NVARCHAR(512),
  @attrName nvarchar(MAX),
  @attrVal nvarchar(1024)
AS
Set NOCOUNT ON
DECLARE @allocationPolicyId INT = 0
DECLARE	@noparam NVARCHAR(4)
DECLARE	@errorCode INT
DECLARE @timeNow INT
SET	@noparam = '%'
SET @noparam = @noparam + 's'
SET @errorCode = 0
------------------------------------------------
-- Input Validation
------------------------------------------------
IF @policyName = '' OR @policyName = @noparam
BEGIN
	Print 'VM Allocation Policy Name is empty'
	SET @errorCode = 1
	GOTO ERROR_EXIT
END
IF @attrName = '' OR @attrName = @noparam
BEGIN
	Print 'Invalid Attribute Name'
	SET @errorCode = 2
	GOTO ERROR_EXIT
END
IF @attrVal = '' OR @attrVal = @noparam
BEGIN
	Print 'Invalid Attribute Value'
	SET @errorCode = 3
	GOTO ERROR_EXIT
END
SELECT @allocationPolicyId = ISNULL(id, 0) FROM App_VMAllocationPolicy WHERE name = @policyName
IF (@allocationPolicyId IS NULL OR @allocationPolicyId = 0)
BEGIN
	Print 'No allocation Policy exist with given policy name'
	SET @errorCode = 4
	GOTO ERROR_EXIT
END
IF EXISTS (SELECT * FROM App_VMAllocationPolicyProp WHERE componentNameId = @allocationPolicyId AND attrName = @attrName AND modified = 0 AND attrVal = @attrVal)
BEGIN
	Print 'Property is already set to intended. No need to change anything. Come out safely.'
	SET @errorCode = 0
	GOTO ERROR_EXIT
END
SET @timeNow = dbo.GetUnixTime(GETUTCDATE())
IF EXISTS (SELECT * FROM App_VMAllocationPolicyProp WHERE componentNameId = @allocationPolicyId AND attrName = @attrName AND modified = 0)
BEGIN
	UPDATE App_VMAllocationPolicyProp SET modified = @timeNow WHERE componentNameId = @allocationPolicyId AND attrName = @attrName AND modified = 0
END
INSERT INTO App_VMAllocationPolicyProp VALUES (@allocationPolicyId, @attrName, 2, @attrVal, @timeNow, 0)
SET @errorCode = @@ERROR
IF (@errorCode <> 0)
	Print 'Failed to insert property into App_VMAllocationPolicyProp'
ERROR_EXIT:
SELECT @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetVmPolicyProperty')
	delete from GxQscripts where name = 'QS_SetVmPolicyProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVmPolicyProperty')
	delete from GXDBVersions where aliasname = 'QS_SetVmPolicyProperty'
GO

insert into GXDBVersions values(2, 'QS_SetVmPolicyProperty',  '00010001018000030000', 'QS_SetVmPolicyProperty', '00010001018000030000')
GO

insert into GxQscripts values(2,'QS_SetVmPolicyProperty',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_SetVmPolicyProperty -si @policyName=''MyPolicy'' -si @attrName=''Use VM Pool'' -si @attrVal=''1''
'
 + CHAR(10) + '	PolicyName - Name of the VM allocation policy
'
 + CHAR(10) + '	attrName  specifies the attribute name for which we need to change attrVal
'
 + CHAR(10) + '	attrVal - value to be set
'
 + CHAR(10) + '	When executed, the qscript returns one of the following output:
'
 + CHAR(10) + '-- 	0 - successful execution'
 + CHAR(10) + '-- 	Non Zero - for failed execution'
)
GO

