

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetVSAPassword.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetVSAPassword <<<'

IF EXISTS (select * from sysobjects where name='QS_SetVSAPassword')
	drop procedure QS_SetVSAPassword
IF EXISTS (select * from GxQscripts where name='QS_SetVSAPassword')
	delete from GxQscripts where name = 'QS_SetVSAPassword'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVSAPassword')
	delete from GXDBVersions where aliasname = 'QS_SetVSAPassword'
GO
print '... Creating Procedure: QS_SetVSAPassword'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetVSAPassword
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @vcHostName nvarchar(1024),
  @vcPassword nvarchar(2048)
AS
Set NOCOUNT ON
DECLARE @NoParameter	varchar(10)
SET     @NoParameter	=''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'SetVSAPassword'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
-----------------------invalid parameters------------------------------
IF(@vcHostName = @NoParameter OR @vcPassword = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
DECLARE @ComponentId INT = (SELECT TOP 1 componentNameId FROM App_InstanceProp WHERE componentNameId IN
							(SELECT instance FROM app_application WHERE appTypeId = 106 AND subclientstatus & 8 = 8) AND attrName = 'Virtual Server Host' AND attrVal=@vcHostName)
IF @ComponentId is NULL OR @ComponentId = 0
	-- check for HyperV
	select TOP 1 @ComponentId = A.instance from APP_Application A inner join APP_Client C on C.id = A.clientId
	where (C.name = @vcHostName or C.net_hostname = @vcHostName)
IF @ComponentId IS NULL OR @ComponentId = 0
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Virtual Server Host ['+ @vcHostName + '] does not exist in Commserv database. Please provide correct Virtual Server Host name.'
	GOTO SCRIPT_EXIT
END
BEGIN
	UPDATE App_InstanceProp
	SET attrVal = @vcPassword
	WHERE attrName = 'Virtual Server Password'
	AND componentNameId = @ComponentId
END
SCRIPT_EXIT:
if @errorCode <> 0
BEGIN
	PRINT @scriptName + ' failed. ErrorCode ['+	Convert(varchar(2),@errorCode) +'].'
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
			)
END
ELSE
BEGIN
	PRINT ' '
	PRINT @scriptName + ' succeeded.'
END
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetVSAPassword')
	delete from GxQscripts where name = 'QS_SetVSAPassword'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVSAPassword')
	delete from GXDBVersions where aliasname = 'QS_SetVSAPassword'
GO

insert into GXDBVersions values(2, 'QS_SetVSAPassword',  '00000000000000000000', 'QS_SetVSAPassword', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetVSAPassword',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetVSAPassword -si ''vcHostName'' -p2 ''vcPassword''
'
 + CHAR(10) + '-- 	script_name: SetVSAPassword.'
)
GO

