

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetVMOSInfo.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetVMOSInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_SetVMOSInfo')
	drop procedure QS_SetVMOSInfo
IF EXISTS (select * from GxQscripts where name='QS_SetVMOSInfo')
	delete from GxQscripts where name = 'QS_SetVMOSInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVMOSInfo')
	delete from GXDBVersions where aliasname = 'QS_SetVMOSInfo'
GO
print '... Creating Procedure: QS_SetVMOSInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetVMOSInfo
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @clientName nvarchar(2048) = N'',
  @simOSId INTEGER = 0
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_SetVMOSInfo'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
-----------------------invalid parameters------------------------------
IF(@clientName = @NoParameter )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: client name parameter is required.'
	GOTO SCRIPT_EXIT
END
IF(@simOSId = 0 )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: sim operating system Id parameter is required.'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of client---------------------
DECLARE @ClientID AS int
SET @ClientID = ISNULL((SELECT id FROM APP_Client WHERE name = @clientname),0)
IF @ClientID = 0
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid client name [' + @clientname + '] specified.'
	GOTO SCRIPT_EXIT
END
DECLARE @simOSName NVARCHAR(1024)
SET @simOSName = ISNULL((select name from simOperatingSystem where id=@simOSId),'')
IF @simOSName = ''
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid sim operating system Id [' + convert(varchar(10), @simOSId) + '] specified.'
	GOTO SCRIPT_EXIT
END
BEGIN TRAN
	BEGIN TRY
		  update app_client set simOperatingSystemId=@simOSId where id=@ClientID
		  update app_clientprop set attrval=@simOSName where componentNameId=@ClientID and attrName like 'Sim OS Info'
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
        	ROLLBACK TRAN
		GOTO SCRIPT_EXIT
	END CATCH
COMMIT TRAN
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@clientName + ','+convert(varchar(10), @simOSId)+ ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetVMOSInfo')
	delete from GxQscripts where name = 'QS_SetVMOSInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVMOSInfo')
	delete from GXDBVersions where aliasname = 'QS_SetVMOSInfo'
GO

insert into GXDBVersions values(2, 'QS_SetVMOSInfo',  '00000000000000000000', 'QS_SetVMOSInfo', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetVMOSInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_SetVMOSInfo.sql -si ''clientName'' -si ''simOSId''
'
 + CHAR(10) + '-- 	script_name: QS_SetVMOSInfo'
 + CHAR(10) + '-- 	Qscript to set the virtual machine OS information in CommServe DB'
)
GO

