

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetVMClientGroup.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetVMClientGroup')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetVMClientGroup <<<'
	drop procedure QS_SetVMClientGroup
END
IF EXISTS (select * from GxQscripts where name='QS_SetVMClientGroup')
	delete from GxQscripts where name = 'QS_SetVMClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVMClientGroup')
	delete from GXDBVersions where aliasname = 'QS_SetVMClientGroup'
GO
print '... Creating Procedure: QS_SetVMClientGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetVMClientGroup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @virtualClientName nvarchar(2048) = N'',
  @instanceName NVARCHAR(200)  = N'',
  @backupsetName NVARCHAR(200)  = N'',
  @subclientName NVARCHAR(200)  = N'',
  @clientGroupName NVARCHAR(200)  = N''
AS
  DECLARE @NoParameter nvarchar(10)
  DECLARE @scriptName NVARCHAR(100)
  DECLARE @nowTime integer
  DECLARE @errorCode int
  DECLARE @errorString NVARCHAR(1024)
  DECLARE @appName NVARCHAR(200)
  DECLARE @ClientId int
  DECLARE @AppTypeId int
  DECLARE @InstanceId int
  DECLARE @BackupsetId int
  DECLARE @subclientId int
  DECLARE @ClientGroupId integer
  DECLARE @attrValue nvarchar(MAX)
  DECLARE @existingID Integer
Set NOCOUNT ON
SET @NoParameter =N''
SET @scriptName  = N'QS_SetVMClientGroup'
SET @errorCode   = 0
SET @errorString = N'Succeeded'
SET @appName     = N'a=Q_VIRTUAL_SERVER'
sET @attrValue   = N''
SET @nowTime     = dbo.GetUnixTime (GetUTCdate())
SET @ClientId 	 = 0
SET @subclientId = 0
SET @AppTypeId   = 0
SET @InstanceId  = 0
SET @BackupsetId = 0
SET @ClientGroupId = 0
SET @existingID  = 0
SET QUOTED_IDENTIFIER ON
-----------------------invalid parameters------------------------------
IF(@virtualClientName = @NoParameter )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: client name parameter is required.'
	GOTO SCRIPT_EXIT
END
IF(@instanceName = @NoParameter )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Instance name parameter is required.'
	GOTO SCRIPT_EXIT
END
IF(@backupsetName = @NoParameter )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Backupset name parameter is required.'
	GOTO SCRIPT_EXIT
END
IF(@subclientName = @NoParameter )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Subclient name parameter is required.'
	GOTO SCRIPT_EXIT
END
IF(@clientGroupName = @NoParameter )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Client group name parameter is required.'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
BEGIN TRY
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
    SET @errorCode = 1
    SET @errorString  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
    GOTO SCRIPT_EXIT
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
		GOTO SCRIPT_EXIT
END CATCH
--Adjust parameters with required prefixes for script to get id from name
SET @virtualClientName	= N'c=' + @virtualClientName
SET @instanceName		= N'i=' + @instanceName
SET @backupsetName		= N'b=' + @backupsetName
SET @subclientName		= N's=' + @subclientName
--Get ID from name for each entity type
EXECUTE @errorCode = QscriptGetAppIdsFromNames @virtualClientName, @appName, @instanceName, @backupsetName, @subclientName,
    @subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @errorString OUTPUT
IF @errorCode != 0
BEGIN
    GOTO SCRIPT_EXIT
END
--Check if valid sub client id is available
IF @subclientId = 0
BEGIN
    SET @errorCode = 1
	SET @errorString = 'Error. Subclient ['+ @subclientName + '] does not exist'
	GOTO SCRIPT_EXIT
END
--ClientGroup Id
SELECT @ClientGroupId = id FROM APP_ClientGroup WHERE name = @ClientGroupName
IF(@ClientGroupId = 0 OR @ClientGroupId IS NULL)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+ @ClientGroupName + '] does not exist'
	GOTO SCRIPT_EXIT
END
---Setting the VMClientGroup
BEGIN TRAN
	BEGIN TRY
		--Generate Attrval to add in subclient pro table for selected client group
		SET @attrValue = CAST((SELECT id AS '@clientGroupId', name AS '@clientGroupName' from APP_ClientGroup
					 WHERE id = @ClientGroupId FOR XML PATH('CvEntities_ClientGroupEntity'), TYPE) as nvarchar(max))
		SET @attrValue = N'<?xml version="1.0" encoding="UTF-16" standalone="no" ?>' + @attrValue
		SELECT @existingID = id FROM APP_SubClientProp(NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Virtual Server VM Client Group'
		IF @existingID = null OR @existingID = 0
			INSERT into APP_SubClientProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId) values (@SubclientId,'Virtual Server VM Client Group',1,@attrValue,@nowTime,0,0)
		ELSE
			UPDATE APP_SubClientProp SET attrVal = @attrValue WHERE id = @existingID
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
		ROLLBACK TRAN
		GOTO SCRIPT_EXIT
	END CATCH
COMMIT TRAN
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
SET QUOTED_IDENTIFIER ON
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetVMClientGroup')
	delete from GxQscripts where name = 'QS_SetVMClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetVMClientGroup')
	delete from GXDBVersions where aliasname = 'QS_SetVMClientGroup'
GO

insert into GXDBVersions values(2, 'QS_SetVMClientGroup',  '00000000000000000000', 'QS_SetVMClientGroup', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetVMClientGroup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_SetVMClientGroup.sql -si ''clientName'' -si ''instanceName'' -si ''backupsetName'' -si ''subclientName'' -si ''clientGroupName''
'
 + CHAR(10) + '-- 	script_name: QS_SetVMClientGroup'
 + CHAR(10) + '-- 	Qscript to set client group for VSA subclient'
)
GO

